/*************************************************************************
 *
 *  $RCSfile: GetClasses.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.tool.javadep;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileInputStream;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StreamTokenizer;

import java.util.Vector;

public class GetClasses {
	static final private boolean DEBUG = false;
	
	static final private void DEBUG(String dbg) {
	    if (DEBUG)
	        System.err.println(">>> com.sun.star.tool.javadep.GetClasses - " + dbg);
	}

	static class InvalidMagicException extends Exception {
		InvalidMagicException(String string) {
			super(string);
		}
	};

	interface Tokenizer {
		String getToken() throws IOException;
		boolean hasMoreTokens() throws IOException;
	};

	static class StringArrayTokenizer implements Tokenizer {
		String args[];
		int index = 0;

		StringArrayTokenizer(String args[]) {
			this.args = args;
		}

		public String getToken() {
			return args[index ++];
		}

		public boolean hasMoreTokens() {
			return index < args.length;
		}
	}

	static class TStreamTokenizer implements Tokenizer {
		StringBuffer token;
		InputStream inputStream;
		int ch = (int)' ';

		TStreamTokenizer(InputStream inputStream) throws IOException {
			this.inputStream = inputStream;
			eatSpace();
		}

		void eatSpace() throws IOException {
			while(ch != -1 && (Character.isWhitespace((char)ch) || (char)ch == '"')) {
				ch = inputStream.read();
			}
		}

		public String getToken() throws IOException {
			token = new StringBuffer();

			while(ch != -1 && !Character.isWhitespace((char)ch)) {
				token.append((char)ch);
				ch = inputStream.read();
				if(ch != -1 && (char)ch == '\"') ch = inputStream.read();
			}

			eatSpace();

			return token.toString();
		}

		public boolean hasMoreTokens() {
			return ch != -1;
		}
	}

	static char separator = ';';
	static String outputFileName = null;
	static boolean verbose = false;
	static Vector depLists = new Vector();

	static private void doOptions(Tokenizer tokenizer) throws IOException, InvalidMagicException, FileNotFoundException {
		while(tokenizer.hasMoreTokens()) {
			String token = tokenizer.getToken();

			if(token.toLowerCase().equals("-i")) { // include 
				String iPath = tokenizer.getToken(); //.replace('\\', '/');
				int separatorIndex = iPath.indexOf(separator);
				while(separatorIndex > -1) {
					addToFilterList(iPath.substring(0, separatorIndex));
					iPath = iPath.substring(separatorIndex + 1);
					separatorIndex = iPath.indexOf(separator);
				}
				addToFilterList(iPath);
			}
			else if(token.toLowerCase().equals("-s")) {
				separator = tokenizer.getToken().charAt(0);
				DEBUG("separator:" + separator);
			}
			else if(token.toLowerCase().equals("-o"))
				outputFileName = tokenizer.getToken();
			else if(token.toLowerCase().equals("-v"))
				verbose = true;
			else if(token.startsWith("@")) {
				doOptions(new TStreamTokenizer(new FileInputStream(new File(token.substring(1)))));
			}
			else {
				String className = token; //.replace('\\', '/');
				if(verbose) 
					System.err.println("Processing:" + className);
				else
					System.err.print(".");
			
			
//  				try {
					GetClasses depList = new GetClasses(className);
					depList.process();
//  					if(!depList.isEmpty())
						depLists.addElement(depList);
//  				}
//  				catch(InvalidMagicException invalidMagicException) {
//  					System.err.println(invalidMagicException + " skipping:" + className);
//  				}
//  				catch(FileNotFoundException fileNotFoundException) {
//  					System.err.println(fileNotFoundException + " skipping");
//  				}
//  				catch(IOException iOException) {
//  					System.err.println(iOException + " skipping");
//  				}
			}
		}
		if(!verbose) System.err.println();
	}

	static public void main(String args[]) {
		if(args.length > 0) {
			try {
				doOptions(new StringArrayTokenizer(args));

//  			if(depLists.size() > 0) {
				if(verbose) System.err.println("#### GetClasses writing:" + outputFileName);

				PrintStream printStream = (outputFileName != null) 
					? new PrintStream(new BufferedOutputStream(new FileOutputStream(new File(outputFileName))))
					: System.out;

				for(int i = 0; i < depLists.size(); i++)
					((GetClasses)depLists.elementAt(i)).list(printStream);
				printStream.close();
//  			}
			}
			catch(InvalidMagicException invalidMagicException) {
				System.err.println(lineSeparator + "JavaDep - abort:" + invalidMagicException);
			}
			catch(FileNotFoundException fileNotFoundException) {
				System.err.println(lineSeparator + "JavaDep - abort:" + fileNotFoundException);
			}
			catch(IOException iOException) {
				System.err.println(lineSeparator + "JavaDep - abort:" + iOException);
			}
		}
		else
			System.err.println("DepList: -o <outputFile> | [-i <path<separator>path>]* | -s <separator> | [classFile]*"); 
	}

	static protected Vector filters = new Vector();

	static protected void addToFilterList(String path) throws IOException {
		if(path.charAt(path.length() - 1) != '/')
			path += "/";

		DEBUG("DepList.addToFilterList:" + path);
		filters.addElement(path);
	}

	String className;
	File classFile;
	protected Vector dependencies = new Vector();

	GetClasses(String className) {
		this.className = className;
		classFile = new File(className);
	}

	static char fileSeparator = System.getProperty("file.separator").charAt(0);

	String getPackagePrefix(String path) {
		String result = path;
		int index = path.lastIndexOf(fileSeparator);
		if(index > -1) 
			result = path.substring(0, index);

		return result;
	}

	boolean isEmpty() {
		return dependencies.size() == 0;
	}

	protected void addDepedencee(String name) throws IOException{
		if(filters.size() != 0) {
			for(int i = 0; i < filters.size(); i++) {
				String path = (String)filters.elementAt(i);
				
				File file = new File(path + name);
//  				System.err.println("#####1:"+ file.getCanonicalPath() + " " + getPackagePrefix(file.getCanonicalPath()));
//  				System.err.println("#####2:" + classFile.getCanonicalPath() + " " + getPackagePrefix(classFile.getCanonicalPath()));
				if(!getPackagePrefix(file.getCanonicalPath()).equals(getPackagePrefix(classFile.getCanonicalPath()))
				   && file.exists()) {
					DEBUG("DepList.addDepedencee - adding:" + file);
					dependencies.addElement(path + name);
				}
			}
		}
		else {
			File file = new File(name);
			if(file.exists()) {
				DEBUG("DepList.addDepedencee - adding:" + file);
				dependencies.addElement(name);
			}
		}
	}

	static String replaceChar(String string, char c, String replacement) {
		String tString = "";
		int index = string.indexOf(c);
		while(index > -1) {
			tString += string.substring(0, index) + replacement;
			string = string.substring(index + 1);
			
			index = string.indexOf(c);
		}
		tString += string;

		return tString;
	}

	static String lineSeparator = System.getProperty("line.separator");

	protected void list(PrintStream printStream) {
		printStream.print(replaceChar(className, fileSeparator, "$/") + ":");
		for(int i = 0; i < dependencies.size(); i++) {
			printStream.print("  \\" + lineSeparator + "\t" + replaceChar((String)dependencies.elementAt(i), fileSeparator, "$/"));
		}

		printStream.print(lineSeparator + lineSeparator);
	}

	protected void process() throws IOException, InvalidMagicException {
		FileInputStream fileInputStream = new FileInputStream(classFile);
		java.io.DataInputStream dataInputStream = 
			new java.io.DataInputStream(new BufferedInputStream(fileInputStream));

      // Read the magic number. It should be 0xCAFEBABE

		int magic = dataInputStream.readInt();
  		if (magic != 0xCAFEBABE) {
  			throw new InvalidMagicException("Invalid magic number in " + className);
  		}

		// Validate the version numbers

		short minor = dataInputStream.readShort();
		short major = dataInputStream.readShort();
//  		if ((minor != 3) &&
//  			(major != 45)) {
//  			// The VM specification defines 3 as the minor version
//  			// and 45 as the major version for 1.1
//  			throw new Exception("Invalid version number in " + className);
//  		}

		// Get the number of items in the constant pool

		short count = dataInputStream.readShort();

		// We'll keep a vector containing an entry for each
		// CONSTANT_Class tag in the constant pool. The value
		// in the vector will be an Integer object containing
		// the name index of the class name

		java.util.Vector classInfo = new java.util.Vector();

      // We'll also keep a HashTable containing an entry for
      // each CONSTANT_String. The key will be the index
      // of the entry (relative to 1), while the element
      // will be the String value.

		java.util.Hashtable utf8 = new java.util.Hashtable();
      
		// Now walk through the constant pool looking for class
		// constants. All other constants are ignored, but we
		// still need to understand the format so that they
		// can be skipped.

		for (int i = 1; i < count; i++) {
			// Read the tag
			byte tag = dataInputStream.readByte();

			switch (tag) {
			case 7:  // CONSTANT_Class
				// Save the constant pool index for the class name
				short nameIndex = dataInputStream.readShort();
				classInfo.addElement(new Integer(nameIndex));
				break;

			case 9:  // CONSTANT_Fieldref
			case 10: // CONSTANT_Methodref
			case 11: // CONSTANT_InterfaceMethodref
				// Skip past the structure
				dataInputStream.skipBytes(4);
				break;

			case 8:  // CONSTANT_String
				// Skip past the string index
				dataInputStream.skipBytes(2);
				break;

			case 3:  // CONSTANT_Integer
			case 4:  // CONSTANT_Float
				// Skip past the data
				dataInputStream.skipBytes(4);
				break;

			case 5:  // CONSTANT_Long
			case 6:  // CONSTANT_Double
				// Skip past the data
				dataInputStream.skipBytes(8);

				// As dictated by the Java Virtual Machine specification,
				// CONSTANT_Long and CONSTANT_Double consume two
				// constant pool entries.
				i++;
          
				break;

			case 12: // CONSTANT_NameAndType
				// Skip past the structure
				dataInputStream.skipBytes(4);
				break;

			case 1:  // CONSTANT_Utf8
				String s = dataInputStream.readUTF();
				utf8.put(new Integer(i), s);
				break;

			default:
				DEBUG("WARNING: Unknown constant tag (" +
								   tag + "@" + i + " of " + count +
								   ") in " + className);
			}
		}

		dataInputStream.close();
      
		// Now we can walk through our vector of class name
		// index values and get the actual class name

		for (int i = 0; i < classInfo.size(); i++) {
			Integer index = (Integer) classInfo.elementAt(i);
			String s = (String) utf8.get(index);

			// Look for arrays. Only process arrays of objects
			
			if (s.startsWith("[")) {
				// Strip off all of the array indicators
				while (s.startsWith("[")) {
					s = s.substring(1);
				}
				// Only use the array if it is an object. If it is,
				// the next character will be an 'L'
				
				if (!s.startsWith("L")) {
					continue;
				}
				
				// Strip off the leading 'L' and trailing ';'
				s = s.substring(1, s.length() - 1);
			}

			s += ".class";

			addDepedencee(s);
		}
	}
}

