/*************************************************************************
 *
 *  $RCSfile: Proxy.java,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: jl $ $Date: 2002/03/27 14:35:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.lib.uno.environments.java;


import java.io.IOException;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;


import com.sun.star.lib.sandbox.generic.Dispatcher;
import com.sun.star.lib.sandbox.generic.DispatcherAdapterBase;
import com.sun.star.lib.sandbox.generic.DispatcherAdapterFactory;

import com.sun.star.lib.util.WeakTable;

import com.sun.star.lib.uno.typedesc.TypeDescription;

import com.sun.star.uno.IQueryInterface;
import com.sun.star.uno.ITypeDescription;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;

/**
 * The purpose of this class is to provide a ProxyFactory.
 * Proxies are needed to integrate objects of other
 * environments seamsless into java.
 * A proxy delegates all method calls to provided object.
 * <p>
 * @version 	$Revision: 1.10 $ $ $Date: 2002/03/27 14:35:52 $
 * @author 	    Kay Ramme
 * @see         com.sun.star.uno.IQueryInterface
 * @since       UDK1.0
 */
public class Proxy extends DispatcherAdapterBase implements IQueryInterface, Dispatcher {
	/**
	 * When set to true, enables various debugging output.
	 */
	static public final boolean DEBUG = false;

	/**
	 * Count the instances created of this <code>Proxy</code> class.
	 */
	static public int __instances;

	protected Type      _type;
	protected IRequester _requester;
	protected boolean    _disposed = false;
	protected boolean    _virtual;
	protected Boolean    _forceSynchronous[];

	/**
	 * This constructor is only public due to problems
	 * with java reflection, it does not belong to the provider
	 * <code>api</code>
	 */
	public Proxy() {
		super();

		++ __instances;
	}

	final private void __init(Type type, IRequester requester, boolean virtual, boolean forceSynchronous) {
		_type      = type;
		_requester = requester;
		_virtual   = virtual;

		if(forceSynchronous)
			_forceSynchronous = new Boolean[]{new Boolean(forceSynchronous)};
	}

	// interface Dispatcher
	final public Object invoke(Object object, String methodName, Object params[]) throws Exception {
		Object result = null;

		try {
			result = _requester.sendRequest(object, _type, methodName, params, _forceSynchronous, _forceSynchronous);
		}
		catch(com.sun.star.uno.Exception exception) { // this comes from remote, so fill in stack trace
			exception.fillInStackTrace();
			throw exception;
		}
		catch(com.sun.star.uno.RuntimeException runtimeException) { // this comes from remote, so fill in stack trace
  			runtimeException.fillInStackTrace();
			throw runtimeException;
		}
		catch(java.lang.Exception exception) { // this must have happended in java, so let it fly through
			throw exception;
		}
		catch(Throwable throwable) { // unfortunately we can't let it fly through, so we wrap it
			throw new java.lang.Exception(throwable.toString());
		}

		return result;
	}

	final public void acquire() throws Throwable {
		if(!_virtual) {
			if(DEBUG) System.err.println("##### " + getClass().getName() + ".acquire:" + (String)object);

			invoke(object, "acquire", null);
		}
	}

	final public void release() throws Throwable {
		if(!_virtual) {
			if(DEBUG) System.err.println("#####"  + getClass().getName() + ".released:" + (String)object);

  			invoke(object, "release", null);
		}
	}

	final public synchronized void finalize() throws Throwable {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".finalize - " + _type);

		-- __instances;

		if(!_disposed) {
			_disposed = true;

			release();
		}
	}



	/**
	 * Returns an object implementing the desired interface.
	 *<p>
	 * @return     the desired interface if available, otherwise null.
	 * @param      type the class of the desired interface.
	 * @see        com.sun.star.uno.UnoRuntime
	 * @see        com.sun.star.uno.IQueryInterface#queryInterface
	 */
	final public Object queryInterface(Type type) {
		Object result = null;

		if(_type == type)
			result = this;

		else {
			try {
				result = invoke(object, "queryInterface", new Object[]{type});
			}
			catch(java.lang.RuntimeException runtimeException) { // let it fly through
				throw runtimeException;
			}
			catch(Throwable throwable) { // wrap it as mapping exception
				throw new com.sun.star.uno.RuntimeException(throwable.toString());
			}
		}

		if(DEBUG) System.err.println("##### " + getClass().getName() + ".queryInterface:" + type + " " + result);

		return result;
	}

	/** 
	 * Tests if the given object is an interface of the same underlying object.
	 * <p>
	 * @return     true, if the underlying object is the same, otherwise false.
	 * @param      object an object representing an interface.
	 * @see        com.sun.star.uno.UnoRuntime
	 * @see        com.sun.star.uno.IQueryInterface#isSame
	 */
	final public boolean isSame(Object object) {
		boolean result = false;

		object = WeakTable.__getObject(object);

		if((object instanceof Proxy))
			result = ((Proxy)object).object == this.object || 
            this.object.equals( ((Proxy)object).object);

		return result;
	}

	/**
	 * Get the Oid of the underlying object.
	 * <p>
	 * @return    the oid of the underlying object.
	 * @see        com.sun.star.uno.IQueryInterface#getOid
	 */
	final public String getOid() {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".getOid:" + (String)object);
		return (String)object;
	}

	/**
	 * Creates a new <code>Proxy</code> for the given interface.
	 * The newly created <code>Proxy</code> delegates all calls
	 * to the <code>sendRequest</code> method of the <code>IRequester</code>
	 * interface.
	 * <p>
	 * @return    the newly created <code>Proxy</code>
	 * @param     requester   the requester to which the calls become delegated
	 * @param     oId         the oid of the proxy.
	 * @param     type  the interface the proxy should implement
	 * @param     virtual    determines if the proxy should be virtual, e.g. does not send a release
	 */
  	static public Object create(IRequester requester, String oId, Type type, boolean virtual, boolean forceSynchronouse) {
		ITypeDescription iTypeDescription = null;

		try {
			iTypeDescription = TypeDescription.getTypeDescription(type);
		}
		catch(ClassNotFoundException classNotFoundException) {
			throw new com.sun.star.uno.RuntimeException(Proxy.class.getName() + ".create - couldn't get type - " + classNotFoundException);
		}

  		Class dispatcherClass = DispatcherAdapterFactory.createDispatcherAdapter(iTypeDescription.getZClass(), "com/sun/star/lib/uno/environments/java/Proxy");

  		Proxy javaProxy;

		try {
			javaProxy = (Proxy)dispatcherClass.newInstance();
			javaProxy.__init(type, requester, virtual, forceSynchronouse);
			javaProxy.setObject(javaProxy, oId);

			if(DEBUG) System.err.println("##### " + Proxy.class.getName() + ".create:" + oId + " " + type);
		}
		catch(java.lang.Exception exception) {
			exception.printStackTrace();

			throw new com.sun.star.uno.RuntimeException( exception.getMessage() );
		}

		return javaProxy;
	}

	static public int getInstances() {
		return __instances;
	}
}

