/*************************************************************************
#
#   $RCSfile: osl_apitest_conditn.cxx,v $
#
#   $Revision: 1.3 $
#
#   last change: $Author: ganaya $ $Date: 2001/05/25 21:39:10 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************/

#ifndef _TESTS_TRES_HXX_
#include <rtl/tres.hxx>
#endif

#ifndef _OSL_CONDITION_H_
#include <osl/conditn.h>
#endif

#ifndef _OSL_CONDITN_HXX_ 
#include <osl/conditn.hxx>
#endif


using namespace rtl;


//oslCondition SAL_CALL testing osl_createCondition(void)

extern "C" void SAL_CALL test_osl_conditn_osl_createCondition(TestResult *oRes)
{
    oslCondition cond1 = osl_createCondition();
    oRes->state( cond1 != 0 );
    osl_destroyCondition(cond1);
}


//void SAL_CALL osl_destroyCondition(oslCondition Condition); 

extern "C" void SAL_CALL test_osl_conditn_osl_destroyCondition(TestResult *oRes)
{
    oslCondition cond1 = osl_createCondition();
    osl_destroyCondition(cond1);
    oRes->state( 1 );
}


//sal_Bool SAL_CALL osl_setCondition(oslCondition Condition); 

extern "C" void SAL_CALL test_osl_conditn_osl_setCondition(TestResult *oRes)
{
    oslCondition cond1 = osl_createCondition();
    oRes->state(osl_setCondition(cond1));
    osl_destroyCondition(cond1);
}


//sal_Bool SAL_CALL osl_resetCondition(oslCondition Condition);

extern "C" void SAL_CALL test_osl_conditn_osl_resetCondition(TestResult *oRes)
{
    oslCondition cond1 = osl_createCondition();
    osl_setCondition(cond1);
    oRes->state(osl_resetCondition(cond1));
    osl_destroyCondition(cond1);
}


//oslConditionResult SAL_CALL osl_waitCondition(oslCondition Condition,
//                                              const TimeValue* pTimeout);

extern "C" void SAL_CALL test_osl_conditn_osl_waitCondition(TestResult *oRes)
{
    oslCondition cond1 = osl_createCondition();
    oslCondition cond2 = osl_createCondition();
    oslCondition cond3 = osl_createCondition();
    TimeValue *tv1 = (TimeValue *)malloc(sizeof(TimeValue));

    if (!tv1) {
        oRes->state(1);
    } else {
        tv1->Seconds=1;

        osl_setCondition(cond1);
	osl_setCondition(cond2);

        oRes->state((osl_waitCondition(cond1, tv1) == osl_cond_result_ok) &&
		    (osl_waitCondition(cond2, NULL) == osl_cond_result_ok) &&
		    (osl_waitCondition(cond3, tv1) == osl_cond_result_timeout));
    }
    
    osl_destroyCondition(cond1);
    osl_destroyCondition(cond2);
    osl_destroyCondition(cond3);
    if (tv1) {
        free(tv1);
    }
}


//sal_Bool SAL_CALL osl_checkCondition(oslCondition Condition); 

extern "C" void SAL_CALL test_osl_conditn_osl_checkCondition(TestResult *oRes)
{
    oslCondition cond1 = osl_createCondition();
    oslCondition cond2 = osl_createCondition();

    osl_setCondition(cond1);

    oRes->state((osl_checkCondition(cond1)) && (!osl_checkCondition(cond2)));

    osl_destroyCondition(cond1);
    osl_destroyCondition(cond2);
}


using namespace osl;

//Condition()

extern "C" void SAL_CALL test_osl_conditn_Condition_ctor(TestResult *oRes)
{
    Condition *cond1 = new Condition();
    oRes->state( cond1 != 0 );
    delete cond1;
}


//~Condition()

extern "C" void SAL_CALL test_osl_conditn_Condition_dtor(TestResult *oRes)
{
    Condition *cond1 = new Condition();
    delete cond1;
    oRes->state( 1 );
}


//void set()

extern "C" void SAL_CALL test_osl_conditn_Condition_set(TestResult *oRes)
{
    Condition *cond1 = new Condition();
    cond1->set();
    oRes->state(cond1->check());
    delete cond1;
}


//void reset()

extern "C" void SAL_CALL test_osl_conditn_Condition_reset(TestResult *oRes)
{
    Condition *cond1 = new Condition();

    cond1->set();
    cond1->reset();
    oRes->state(!cond1->check());

    delete cond1;
}


//Result wait(const TimeValue *pTimeout = 0)

extern "C" void SAL_CALL test_osl_conditn_Condition_wait(TestResult *oRes)
{
    Condition *cond1 = new Condition();
    Condition *cond2 = new Condition();
    Condition *cond3 = new Condition();
    TimeValue *tv1 = (TimeValue*)malloc(sizeof(TimeValue));

    if (tv1) {
        oRes->state(1);
    } else {
        cond1->set();
        cond2->set();
	tv1->Seconds = 1;

	oRes->state((cond1->wait(tv1) == osl_cond_result_ok) &&
		    (cond2->wait() == osl_cond_result_ok) &&
		    (cond3->wait(tv1) == osl_cond_result_timeout));
    }

    delete cond1;
    delete cond2;
    delete cond3;
    if (tv1) {
        free(tv1);
    }
}


//sal_Bool check()

extern "C" void SAL_CALL test_osl_conditn_Condition_check(TestResult *oRes)
{
    Condition *cond1 = new Condition();
    Condition *cond2 = new Condition();

    cond1->set();

    oRes->state((cond1->check()) && (!cond2->check()));

    delete cond1;
    delete cond2;
}
