/*************************************************************************
#
#   $RCSfile: rtl_OString.cxx,v $
#
#   $Revision: 1.48 $
#
#   last change: $Author: bmahbod $ $Date: 2001/06/29 19:37:19 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************/

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

#include <limits.h>
#include <malloc.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

#ifndef _TESTS_TRES_HXX_
	#include <rtl/tres.hxx>
#endif

#ifndef _RTL_STRING_HXX_
	#include <rtl/string.hxx>
#endif

#ifndef _RTL_TEXTENC_H
	#include <rtl/textenc.h>
#endif

#ifndef _STRING_HXX
        #include <tools/string.hxx>
#endif

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

static const sal_Int32 kCompareNAStringToUStringErr = -3;

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

static const rtl_TextEncoding kEncoding = RTL_TEXTENCODING_ASCII_US;

static const sal_uInt32 kConvertFlags = OUSTRING_TO_OSTRING_CVTFLAGS;

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

static const sal_Char *kTestStr1 = "Sun Microsystems";
static const sal_Char *kTestStr2 = "Sun Microsystems Java Technology";
static const sal_Char *kTestStr3 = "Sun microsystems";
static const sal_Char *kTestStr4 = "SUN MICROSYSTEMS";
static const sal_Char *kTestStr5 = "sun microsystems";
static const sal_Char *kTestStr6 = "Java Technology";
static const sal_Char *kTestStr7 = "Sun ";
static const sal_Char *kTestStr8 = "Microsystems";
static const sal_Char *kTestStr9 = "sun microsystems java technology";
static const sal_Char *kTestStr10 = " Sun Microsystems";
static const sal_Char *kTestStr11 = "Sun Microsystems ";
static const sal_Char *kTestStr12 = " Sun Microsystems ";
static const sal_Char *kTestStr13 = "Sun Microsystems   ";
static const sal_Char *kTestStr14 = "   Sun Microsystems";
static const sal_Char *kTestStr15 = "   Sun Microsystems ";
static const sal_Char *kTestStr16 = " Sun Microsystems   ";
static const sal_Char *kTestStr17 = "   Sun Microsystems   ";
static const sal_Char *kTestStr18 = "sUN MICROsYsTEMs"; 
static const sal_Char *kTestStr19 = "---Sun-Microsystems---";
static const sal_Char *kTestStr20 = "sun";
static const sal_Char *kTestStr21 = "SUN";
static const sal_Char *kTestStr22 = "SUN MICROSYSTEMS JAVA TECHNOLOGY";

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

static const sal_Int32 kTestStr1Len  = 16;
static const sal_Int32 kTestStr2Len  = 32;
static const sal_Int32 kTestStr6Len  = 15;
static const sal_Int32 kTestStr7Len  = 4;
static const sal_Int32 kTestStr8Len  = 12;
static const sal_Int32 kTestStr9Len  = 12;
static const sal_Int32 kTestStr22Len = 32;

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

static const sal_Int16 kRadixBinary     = 2;
static const sal_Int16 kRadixOctol      = 8;
static const sal_Int16 kRadixDecimal    = 10;
static const sal_Int16 kRadixHexdecimal = 16;
static const sal_Int16 kRadixBase36     = 36;

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

static const sal_Int8  kSInt8Max  = SCHAR_MAX;
static const sal_Int16 kUInt8Max  = UCHAR_MAX;
static const sal_Int16 kSInt16Max = SHRT_MAX;
static const sal_Int32 kUInt16Max = USHRT_MAX;
static const sal_Int32 kSInt32Max = INT_MAX;
static const sal_Int64 kUInt32Max = UINT_MAX;
static const sal_Int64 kSInt64Max = 9223372036854775807;

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

static const sal_Char *kSInt8MaxBinaryStr  = "1111111";
static const sal_Char *kUInt8MaxBinaryStr  = "11111111";
static const sal_Char *kSInt16MaxBinaryStr = "111111111111111";
static const sal_Char *kUInt16MaxBinaryStr = "1111111111111111";
static const sal_Char *kSInt32MaxBinaryStr = "1111111111111111111111111111111";
static const sal_Char *kUInt32MaxBinaryStr = "11111111111111111111111111111111";
static const sal_Char *kSInt64MaxBinaryStr = "111111111111111111111111111111111111111111111111111111111111111";

static const sal_Char *kSInt8MaxOctolStr  = "177";
static const sal_Char *kUInt8MaxOctolStr  = "377";
static const sal_Char *kSInt16MaxOctolStr = "77777";
static const sal_Char *kUInt16MaxOctolStr = "177777";
static const sal_Char *kSInt32MaxOctolStr = "17777777777";
static const sal_Char *kUInt32MaxOctolStr = "37777777777";
static const sal_Char *kSInt64MaxOctolStr = "777777777777777777777";

static const sal_Char *kSInt8MaxDecimalStr  = "127";
static const sal_Char *kUInt8MaxDecimalStr  = "255";
static const sal_Char *kSInt16MaxDecimalStr = "32767";
static const sal_Char *kUInt16MaxDecimalStr = "65535";
static const sal_Char *kSInt32MaxDecimalStr = "2147483647";
static const sal_Char *kUInt32MaxDecimalStr = "4294967295";
static const sal_Char *kSInt64MaxDecimalStr = "9223372036854775807";

static const sal_Char *kSInt8MaxHexDecimalStr  = "7f";
static const sal_Char *kUInt8MaxHexDecimalStr  = "ff";
static const sal_Char *kSInt16MaxHexDecimalStr = "7fff";
static const sal_Char *kUInt16MaxHexDecimalStr = "ffff";
static const sal_Char *kSInt32MaxHexDecimalStr = "7fffffff";
static const sal_Char *kUInt32MaxHexDecimalStr = "ffffffff";
static const sal_Char *kSInt64MaxHexDecimalStr = "7fffffffffffffff";

static const sal_Char *kSInt8MaxBase36Str  = "3j";
static const sal_Char *kUInt8MaxBase36Str  = "73";
static const sal_Char *kSInt16MaxBase36Str = "pa7";
static const sal_Char *kUInt16MaxBase36Str = "1ekf";
static const sal_Char *kSInt32MaxBase36Str = "zik0zj";
static const sal_Char *kUInt32MaxBase36Str = "1z141z3";
static const sal_Char *kSInt64MaxBase36Str = "1y2p0ij32e8e7";

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

using namespace rtl;

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

static sal_Bool AStringToFloatCompare ( const sal_Char  *pStr, 
                                        const float      nX, 
                                        const float      nEPS
                                      )
{
	sal_Bool cmp = sal_False;

	if ( pStr != NULL )
	{
		::rtl::OString aStr(pStr);

		float actNum = 0;
		float expNum = nX;
		float eps    = nEPS;
	
		actNum = aStr.toFloat();

		if ( abs( actNum - expNum ) <= eps )
		{
			cmp = sal_True;
		} // if
	} // if

	return cmp;
} // AStringToFloatCompare 

//------------------------------------------------------------------------------------------------------

static sal_Bool AStringToDoubleCompare ( const sal_Char  *pStr, 
                                         const double     nX, 
                                         const double     nEPS
                                       )
{
	sal_Bool cmp = sal_False;

	if ( pStr != NULL )
	{
		::rtl::OString aStr(pStr);

		double actNum = 0;
		double expNum = nX;
		double eps    = nEPS;
	
		actNum = aStr.toDouble();
		
		if ( abs( actNum - expNum ) <= eps )
		{
			cmp = sal_True;
		} // if
	} // if

	return cmp;
} // AStringToDoubleCompare

//------------------------------------------------------------------------------------------------------

static inline sal_Int32 ACharToUCharCompare( const sal_Unicode *pUStr, 
                                             const sal_Char    *pAStr 
                                           )
{
	sal_Int32  nCmp   = 0;
	sal_Int32  nUChar = (sal_Int32)*pUStr;
	sal_Int32  nChar  = (sal_Int32)((unsigned char)*pAStr);

	nCmp = nUChar - nChar;

	return  nCmp;
} // ACharToUCharCompare

//------------------------------------------------------------------------------------------------------

static sal_Int32 AStringToUStringNCompare( const sal_Unicode  *pUStr, 
                                           const sal_Char     *pAStr,
                                           const sal_uInt32    nAStrCount 
                                         )
{
	sal_Int32 nCmp = kCompareNAStringToUStringErr;

	if ( ( pUStr != NULL ) && ( pAStr != NULL ) )
	{
		sal_uInt32 nCount = nAStrCount;

		nCmp = ACharToUCharCompare( pUStr, pAStr );

		while ( ( nCmp == 0 ) && ( *pAStr ) && ( nCount ) )
		{	
			pUStr++;
			pAStr++;

			nCmp = ACharToUCharCompare( pUStr, pAStr );

			// Since we are dealing with unsigned integers
			// we want to make sure that the last number is
			// indeed zero.

			if ( nCount > 0 )
			{
				nCount--;
			} // if
			else
			{
				break;
			} // else
		} // while
	} // if

	return nCmp;
} // AStringToUStringNCompare

//------------------------------------------------------------------------------------------------------

static sal_Bool AStringNIsValid( const sal_Char   *pAStr, 
                                 const sal_uInt32  nStrLen 
                               )
{
	sal_uInt32 nLen  = nStrLen;
	sal_uChar  uChar = 0;

	while ( ( nLen >= 0 ) && ( *pAStr ) )
	{
		uChar = (unsigned char)*pAStr;
		
		if ( uChar > 127 )
		{
			return sal_False;
		} // if

		pAStr++;

		// Since we are dealing with unsigned integers
		// we want to make sure that the last number is
		// indeed zero.

		if ( nLen > 0 )
		{
			nLen--;
		} // if
		else
		{
			break;
		} // else
	} // while

	return sal_True;
} // AStringNIsValid

//------------------------------------------------------------------------------------------------------

static sal_Bool AStringToUStringNCopy( sal_Unicode       *pDest, 
                                       const sal_Char    *pSrc,
                                       const sal_uInt32   nSrcLen 
                                     )
{
	sal_Bool    bCopied = sal_False;
	sal_uInt32  nCount    = nSrcLen;
	sal_uInt32  nLen    = nSrcLen;

	if (    ( pDest != NULL ) 
	     && ( pSrc  != NULL ) 
	     && ( AStringNIsValid( pSrc, nLen ) )
	   )
	{
		while ( nCount >= 0 )
		{
			*pDest = (unsigned char)*pSrc;

			pDest++;
			pSrc++;
			
			// Since we are dealing with unsigned integers
			// we want to make sure that the last number is
			// indeed zero.

			if ( nCount > 0 )
			{
				nCount--;
			} // if
			else
			{
				break;
			} // else
		} // while
		
		if ( nCount == 0 )
		{
			bCopied = sal_True;
		} // if
	} // if
	
	return  bCopied;
} // AStringToUStringNCopy

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------------------
//
// testing conaStructors
//
//------------------------------------------------------------------------------------------------------

sal_Bool test_rtl_OString_ctors_001( TestResult *oRes )
{
	::rtl::OString aStr;

	sal_Bool bTCState     = false;
	sal_Bool bTCPrintName = true;

	oRes->setVerbosityLevel(eVerbose);

	bTCState = aStr == NULL;
    
	oRes->logPrintf( bTCState,
                     bTCPrintName, 
                     "New OString containing no characters.\n" 
                   );

	return bTCState;
}

//------------------------------------------------------------------------------------------------------

sal_Bool SAL_CALL test_rtl_OString_ctors_002( TestResult *oRes )
{
	::rtl::OString aStr(kTestStr1);

	sal_Bool bTCState     = false;
	sal_Bool bTCPrintName = true;

	oRes->setVerbosityLevel(eVerbose);

	bTCState = aStr == kTestStr1;
    
	oRes->logPrintf( bTCState,
                     bTCPrintName, 
                     "New OString from a character buffer array.\n" 
                   );

	return bTCState;
}

//------------------------------------------------------------------------------------------------------

sal_Bool SAL_CALL test_rtl_OString_ctors_003( TestResult *oRes )
{
	::rtl::OString aStr(kTestStr2, kTestStr1Len);
	
	const sal_Char  *kTCMessage[2] = { "New OString from the first n characters of",
	                                   "an ascii string."
	                                 };

	sal_Bool bTCState     = false;
	sal_Bool bTCPrintName = true;

	oRes->setVerbosityLevel(eVerbose);

	bTCState = aStr == kTestStr1;
    
	oRes->logPrintf( bTCState,
	                 bTCPrintName,
	                 "%s\n   %s\n",
	                 kTCMessage[0],
	                 kTCMessage[1]
	               );

	return bTCState;
}

//------------------------------------------------------------------------------------------------------

sal_Bool SAL_CALL test_rtl_OString_ctors_004( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr1);
	::rtl::OString aStr2(aStr1);
	
	sal_Bool bTCState     = false;
	sal_Bool bTCPrintName = true;

	oRes->setVerbosityLevel(eVerbose);

	bTCState = aStr1 == aStr2;
    
	oRes->logPrintf( bTCState,
                     bTCPrintName, 
                     "New OString from an OString.\n" 
                   );

	return bTCState;
}

//------------------------------------------------------------------------------------------------------

sal_Bool test_rtl_OString_ctors_005( TestResult *oRes )
{
	sal_Bool bTCState     = false;
	sal_Bool bTCPrintName = true;

	oRes->setVerbosityLevel(eVerbose);

	rtl_String *aStr1 = NULL;

	rtl_string_newFromStr( &aStr1, kTestStr1 );
	
	if ( aStr1 != NULL )
	{
		::rtl::OString aStr2(aStr1);
		
		bTCState = aStr2 == kTestStr1;
   
		oRes->logPrintf( bTCState,
	                     bTCPrintName, 
	                     "New OString from a RTL String.\n" 
	                   );

		rtl_string_release( aStr1 );
		
		aStr1 = NULL;
	} // if
	else
	{
		oRes->logPrintf( bTCState,
		                 bTCPrintName,
		                 "Copying an ascii string to a RTL String!\n"
		               );
	} // else

	return bTCState;
}

//------------------------------------------------------------------------------------------------------

sal_Bool test_rtl_OString_ctors_006( TestResult *oRes )
{
	sal_Bool bTCState     = false;
	sal_Bool bTCPrintName = true;

	sal_Unicode aStr1[kTestStr1Len+1];

	oRes->setVerbosityLevel(eVerbose);

	if ( AStringToUStringNCopy( aStr1, kTestStr1, kTestStr1Len ) )
	{
		if ( AStringToUStringNCompare( aStr1, kTestStr1, kTestStr1Len ) == 0 )
		{
			const sal_Char  *kTCMessage[2] = { "New OString from unicode character buffer",
			                                   "array."
			                                 };

			::rtl::OString aStr2( aStr1,
			                     kTestStr1Len,
			                     kEncoding,
			                     kConvertFlags
			                   );

			bTCState = aStr2 == kTestStr1;
	    
			oRes->logPrintf( bTCState,
			                 bTCPrintName,
			                 "%s\n   %s\n",
			                 kTCMessage[0],
			                 kTCMessage[1]
			               );
		} // if
		else
		{
			oRes->logPrintf( bTCState,
			                 bTCPrintName,
			                 "Comparing an ascii string with a unicode string!\n"
			               );
		} // else
	} // if
	else
	{
		oRes->logPrintf( bTCState,
		                 bTCPrintName,
		                 "Copying an ascii string to a unicode string!\n"
		               );
	} // else
	
	return bTCState;
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_ctors( TestResult *oRes )
{		
	sal_Bool bTCState = false;

	bTCState =    test_rtl_OString_ctors_001( oRes ) 
	           && test_rtl_OString_ctors_002( oRes ) 
	           && test_rtl_OString_ctors_003( oRes ) 
	           && test_rtl_OString_ctors_004( oRes ) 
	           && test_rtl_OString_ctors_005( oRes )
	           && test_rtl_OString_ctors_006( oRes );

	oRes->state( bTCState );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method getLength
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_getLength_001( TestResult *oRes )
{
    ::rtl::OString aStr(kTestStr1);
    
    oRes->state( aStr.getLength() == kTestStr1Len );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_getLength_002( TestResult *oRes )
{
    ::rtl::OString aStr("1");
    
    oRes->state( aStr.getLength() == 1 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_getLength_003( TestResult *oRes )
{
    ::rtl::OString aStr;
    
    oRes->state( aStr.getLength() == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_getLength_004( TestResult *oRes )
{
    ::rtl::OString aStr("");
    
    oRes->state( aStr.getLength() == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_getLength_005( TestResult *oRes )
{
    ::rtl::OString aStr("\0");
    
    oRes->state( aStr.getLength() == 0 );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method equals( const OString & aStr )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_equals_001( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr1);
	::rtl::OString aStr2(kTestStr1);

	oRes->state( aStr1.equals(aStr2) );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_equals_002( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr1);
	::rtl::OString aStr2(kTestStr3);

	oRes->state( !aStr1.equals(aStr2) );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_equals_003( TestResult *oRes )
{
	::rtl::OString aStr1;
	::rtl::OString aStr2;

	oRes->state( aStr1.equals(aStr2) );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_equals_004( TestResult *oRes )
{
	::rtl::OString aStr1;
	::rtl::OString aStr2(kTestStr3);

	oRes->state( !aStr1.equals(aStr2) );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_equals_005( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr1);
	::rtl::OString aStr2;

	oRes->state( !aStr1.equals(aStr2) );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method equalsIgnoreAsciiCase( const OString & aStr )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_equalsIgnoreAsciiCase_001( TestResult *oRes )
{
    ::rtl::OString aStr1(kTestStr4);
    ::rtl::OString aStr2(kTestStr5);

    oRes->state( aStr1.equalsIgnoreAsciiCase(aStr2) );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_equalsIgnoreAsciiCase_002( TestResult *oRes )
{
    ::rtl::OString aStr1(kTestStr4);
    ::rtl::OString aStr2(kTestStr4);

    oRes->state( aStr1.equalsIgnoreAsciiCase(aStr2) );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_equalsIgnoreAsciiCase_003( TestResult *oRes )
{
    ::rtl::OString aStr1;
    ::rtl::OString aStr2(kTestStr4);

    oRes->state( !aStr1.equalsIgnoreAsciiCase(aStr2) );
}

//-------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_equalsIgnoreAsciiCase_004( TestResult *oRes )
{
    ::rtl::OString aStr1(kTestStr4);
    ::rtl::OString aStr2;

    oRes->state( !aStr1.equalsIgnoreAsciiCase(aStr2) );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_equalsIgnoreAsciiCase_005( TestResult *oRes )
{
    ::rtl::OString aStr1;
    ::rtl::OString aStr2;

    oRes->state( aStr1.equalsIgnoreAsciiCase(aStr2) );
}

//------------------------------------------------------------------------------------------------------
//
//  testing the method compareTo( const OString & aStr )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_compareTo_001( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr1);
	::rtl::OString aStr2(kTestStr5);

	oRes->state( aStr1.compareTo(aStr2) < 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_compareTo_002( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr2);
        ::rtl::OString aStr2(kTestStr5);

        oRes->state( aStr1.compareTo(aStr2) < 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_compareTo_003( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2(kTestStr9);

        oRes->state( aStr1.compareTo(aStr2) < 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_compareTo_004( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2(kTestStr2);

        oRes->state( aStr1.compareTo(aStr2) < 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_compareTo_005( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr4);
        ::rtl::OString aStr2(kTestStr5);

        oRes->state( aStr1.compareTo(aStr2) < 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_compareTo_006( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr1);
	::rtl::OString aStr2(kTestStr3);

	oRes->state( aStr1.compareTo(aStr2) < 0 );
}

//------------------------------------------------------------------------------------------------------
//
//  testing the method compareTo( const OString & aStr )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_compareTo_007( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2(kTestStr5);

        oRes->state( aStr2.compareTo(aStr1) > 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_compareTo_008( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2(kTestStr2);

        oRes->state( aStr2.compareTo(aStr1) > 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_compareTo_009( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr5);
        ::rtl::OString aStr2(kTestStr9);

        oRes->state( aStr2.compareTo(aStr1) > 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_compareTo_010( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr4);
        ::rtl::OString aStr2(kTestStr5);

        oRes->state( aStr2.compareTo(aStr1) > 0 );
}

//------------------------------------------------------------------------------------------------------
//
//  testing the method compareTo( const OString & aStr )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_compareTo_011( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr1);
	::rtl::OString aStr2(kTestStr1);

	oRes->state( aStr1.compareTo(aStr2) == 0 );
}

//------------------------------------------------------------------------------------------------------
//
//  testing the method compareTo( const OString & rObj, sal_Int32 length )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_compareTo_012( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr9);
	::rtl::OString aStr2(kTestStr1);

	oRes->state( aStr2.compareTo(aStr1,16) < 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_compareTo_013( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr2);
        ::rtl::OString aStr2(kTestStr9);

        oRes->state( aStr1.compareTo(aStr2,32) < 0 );
}

//------------------------------------------------------------------------------------------------------
//
//  testing the method compareTo( const OString & rObj, sal_Int32 length )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_compareTo_014( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr9);
        ::rtl::OString aStr2(kTestStr4);

        oRes->state( aStr1.compareTo(aStr2,16) > 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_compareTo_015( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr9);
        ::rtl::OString aStr2(kTestStr22);

        oRes->state( aStr1.compareTo(aStr2,32) > 0 );
}

//------------------------------------------------------------------------------------------------------
//
//  testing the method compareTo( const OString & rObj, sal_Int32 length )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_compareTo_016( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr5);
        ::rtl::OString aStr2(kTestStr9);

        oRes->state( aStr2.compareTo(aStr1,16) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_compareTo_017( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr9);
        ::rtl::OString aStr2(kTestStr9);

        oRes->state( aStr1.compareTo(aStr2,32) == 0 );
}

//------------------------------------------------------------------------------------------------------
//
// testing the operator ==
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_cmp_001( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr3);
	::rtl::OString aStr2(kTestStr1);

	oRes->state( !( aStr1 == aStr2 ) );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_cmp_002( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr1);
	::rtl::OString aStr2(kTestStr1);

	oRes->state( aStr1 == aStr2 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_cmp_003( TestResult *oRes )
{
	::rtl::OString aStr(kTestStr1);

	oRes->state( aStr == kTestStr1 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_cmp_004( TestResult *oRes )
{        
	::rtl::OString aStr(kTestStr1);

	oRes->state( kTestStr1 == aStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_cmp_005( TestResult *oRes )
{
	::rtl::OString aStr(kTestStr1);

	oRes->state( !( aStr == kTestStr3 ) );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_cmp_006( TestResult *oRes )
{        
	::rtl::OString aStr(kTestStr1);

	oRes->state( !( kTestStr3 == aStr ) );
}

//------------------------------------------------------------------------------------------------------
//
// testing the operator !=
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_neq_001( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr1);
	::rtl::OString aStr2(kTestStr3);

	oRes->state( aStr1 != aStr2 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_neq_002( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr1);
	::rtl::OString aStr2(kTestStr1);

	oRes->state( !( aStr1 != aStr2 ) );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_neq_003( TestResult *oRes )
{
	::rtl::OString aStr(kTestStr1);

	oRes->state( aStr != kTestStr3 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_neq_004( TestResult *oRes )
{
	::rtl::OString aStr(kTestStr1);

	oRes->state( kTestStr3 != aStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_neq_005( TestResult *oRes )
{
	::rtl::OString aStr(kTestStr1);

	oRes->state( !( aStr != kTestStr1 ) );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_neq_006( TestResult *oRes )
{        
	::rtl::OString aStr(kTestStr1);

	oRes->state( !( kTestStr1 != aStr ) );
}

//------------------------------------------------------------------------------------------------------
//
// testing the operator >
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_g_001( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr3);
        ::rtl::OString aStr2(kTestStr1);

        oRes->state( aStr1 > aStr2 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_g_002( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2(kTestStr3);

        oRes->state( !( aStr1 > aStr2 ) );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_g_003( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2(kTestStr1);

        oRes->state( !( aStr1 > aStr2 ) );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_g_004( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2;

        oRes->state( aStr1 > aStr2 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_g_005( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2(kTestStr1);

        oRes->state( !( aStr1 > aStr2 ) );
}

//------------------------------------------------------------------------------------------------------
//
// testing the operator <
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_l_001( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2(kTestStr3);

        oRes->state( aStr1 < aStr2 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_l_002( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr3);
        ::rtl::OString aStr2(kTestStr1);

        oRes->state( !( aStr1 < aStr2 ) );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_l_003( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2(kTestStr1);

        oRes->state( !( aStr1 < aStr2 ) );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_l_004( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2;

        oRes->state( !( aStr1 < aStr2 ) );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_l_005( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2(kTestStr1);

        oRes->state( aStr1 < aStr2 );
}

//------------------------------------------------------------------------------------------------------
//
// testing the operator >=
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_ge_001( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr3);
        ::rtl::OString aStr2(kTestStr1);

        oRes->state( aStr1 >= aStr2 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_ge_002( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2(kTestStr3);

        oRes->state( !( aStr1 >= aStr2 ) );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_ge_003( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2(kTestStr1);

        oRes->state( aStr1 >= aStr2 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_ge_004( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2;

        oRes->state( aStr1 >= aStr2 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_ge_005( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2(kTestStr1);

        oRes->state( !( aStr1 >= aStr2 ) );
}

//------------------------------------------------------------------------------------------------------
//
// testing the operator <=
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_le_001( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2(kTestStr3);
        
	oRes->state( aStr1 <= aStr2 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_le_002( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr3);
        ::rtl::OString aStr2(kTestStr1);

        oRes->state( !( aStr1 <= aStr2 ) );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_le_003( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2(kTestStr1);

        oRes->state( aStr2 <= aStr1 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_le_004( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2;

        oRes->state( !( aStr1 <= aStr2 ) );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_le_005( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2(kTestStr1);

        oRes->state( aStr1 <= aStr2 );
}

//------------------------------------------------------------------------------------------------------
//
// testing the operator =
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_eq_001( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr1);
	::rtl::OString aStr2;
    
	aStr2 = aStr1;

	oRes->state( aStr1 == aStr2 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_eq_002( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr1);
	::rtl::OString aStr2(kTestStr6);

	aStr1 = aStr2;
    
	oRes->state( aStr1 == aStr2 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_eq_003( TestResult *oRes )
{
	::rtl::OString aStr1;
	::rtl::OString aStr2(kTestStr1);

	aStr2 = aStr1;
    
	oRes->state( aStr1 == aStr2 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_eq_004( TestResult *oRes )
{
	::rtl::OString aStr1;
   
	aStr1 = OString(kTestStr1);

	oRes->state( aStr1 == kTestStr1 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_eq_005( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr1);
   	::rtl::OString aStr2;
	::rtl::OString aStr3;

	aStr3 = aStr2 = aStr1;

	oRes->state( aStr1 == aStr3 );
}

//------------------------------------------------------------------------------------------------------
//
// testing the operator +
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_plus_001( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr7);
	::rtl::OString aStr2(kTestStr8);
	::rtl::OString aStr3(kTestStr1);
	::rtl::OString aStr4;

	aStr4 = aStr1 + aStr2;
	
	oRes->state( aStr4.compareTo( aStr3 ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_plus_002( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr1);
	::rtl::OString aStr2("");
	::rtl::OString aStr3(kTestStr1);
	::rtl::OString aStr4;

	aStr4 = aStr1 + aStr2;
	
	oRes->state( aStr4.compareTo( aStr3 ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_plus_003( TestResult *oRes )
{
	::rtl::OString aStr1("");
	::rtl::OString aStr2(kTestStr1);
	::rtl::OString aStr3(kTestStr1);
	::rtl::OString aStr4;

	aStr4 = aStr1 + aStr2;
	
	oRes->state( aStr4.compareTo( aStr3 ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_plus_004( TestResult *oRes )
{
    ::rtl::OString aStr1("");
    ::rtl::OString aStr2("");
	::rtl::OString aStr3("");
	::rtl::OString aStr4;

	aStr4 = aStr1 + aStr2;
	
	oRes->state( aStr4.compareTo( aStr3 ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_plus_005( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2;
        ::rtl::OString aStr3(kTestStr1);
        ::rtl::OString aStr4;

        aStr4 = aStr1 + aStr2;

        oRes->state( aStr4.compareTo( aStr3 ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_plus_006( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2(kTestStr1);
        ::rtl::OString aStr3(kTestStr1);
        ::rtl::OString aStr4;

        aStr4 = aStr1 + aStr2;

        oRes->state( aStr4.compareTo( aStr3 ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_plus_007( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2;
        ::rtl::OString aStr3;
        ::rtl::OString aStr4;

        aStr4 = aStr1 + aStr2;

        oRes->state( aStr4.compareTo( aStr3 ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_plus_008( TestResult *oRes )
{
	::rtl::OString aStr1;
	::rtl::OString aStr2(kTestStr1);

	aStr1 = OString(kTestStr7) + OString(kTestStr8);
	
	oRes->state( aStr1.compareTo( aStr2 ) == 0 );
}

//------------------------------------------------------------------------------------------------------
//
// testing the operator +=
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_peq_001( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr7);
 	::rtl::OString aStr2(kTestStr8);
	::rtl::OString aStr3(kTestStr1);
	::rtl::OString aStr4;

	aStr4 += aStr1;
	aStr4 += aStr2;
	
	oRes->state( aStr4.compareTo( aStr3 ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_peq_002( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr1);
	::rtl::OString aStr2("");
	::rtl::OString aStr3(kTestStr1);
	::rtl::OString aStr4;

	aStr4 += aStr1;
	aStr4 += aStr2;
	
	oRes->state( aStr4.compareTo( aStr3 ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_peq_003( TestResult *oRes )
{
	::rtl::OString aStr1("");
	::rtl::OString aStr2(kTestStr1);
	::rtl::OString aStr3(kTestStr1);
	::rtl::OString aStr4;

	aStr4 += aStr1;
	aStr4 += aStr2;
	
	oRes->state( aStr4.compareTo( aStr3 ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_peq_004( TestResult *oRes )
{
	::rtl::OString aStr1("");
	::rtl::OString aStr2("");
	::rtl::OString aStr3("");
	::rtl::OString aStr4;

	aStr4 += aStr1;
	aStr4 += aStr2;
	
	oRes->state( aStr4.compareTo( aStr3 ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_peq_005( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2;
        ::rtl::OString aStr3(kTestStr1);
        ::rtl::OString aStr4;

        aStr4 += aStr1;
        aStr4 += aStr2;

        oRes->state( aStr4.compareTo( aStr3 ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_peq_006( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2(kTestStr1);
        ::rtl::OString aStr3(kTestStr1);
        ::rtl::OString aStr4;

        aStr4 += aStr1;
        aStr4 += aStr2;

        oRes->state( aStr4.compareTo( aStr3 ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_peq_007( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2;
        ::rtl::OString aStr3;
        ::rtl::OString aStr4;

        aStr4 += aStr1;
        aStr4 += aStr2;

        oRes->state( aStr4.compareTo( aStr3 ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_peq_008( TestResult *oRes )
{
	::rtl::OString aStr1;
	::rtl::OString aStr2(kTestStr1);

	aStr1 += OString(kTestStr7);
	aStr1 += OString(kTestStr8);
	
	oRes->state( aStr1.compareTo( aStr2 ) == 0 );
}

//------------------------------------------------------------------------------------------------------
//
// testing the operator const sal_Char * (cscs for short)
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_cscs_001( TestResult *oRes )
{

	sal_Char *aStr1 = (sal_Char *)malloc(17*sizeof(sal_Char));
    
	if ( aStr1 != NULL )
	{
		::rtl::OString aStr2(kTestStr1);
		
		const sal_Char *aStr3 = (const sal_Char *)aStr2;
		
		strcpy( aStr1, (const sal_Char *)aStr2 );
		
		oRes->state( strcmp( aStr1, aStr3 ) == 0 );
		
		free( aStr1 );	
	} // if   
} 

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_cscs_002( TestResult *oRes )
{

	::rtl::OString aStr1(kTestStr1);
		
	const sal_Char *aStr2 = (const sal_Char *)aStr1;
		
	oRes->state( strcmp( kTestStr1, aStr2 ) == 0 );
} 

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_cscs_003( TestResult *oRes )
{

	const sal_Char *aStr1 = NULL;

	::rtl::OString aStr2;

	const sal_Char *aStr3 = (const sal_Char *)aStr2;

	oRes->state( aStr1 == aStr3 );
} 

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_cscs_004( TestResult *oRes )
{

	const sal_Char *aStr1 = "";

	::rtl::OString aStr2("");

	const sal_Char *aStr3 = (const sal_Char *)aStr2;

	oRes->state( aStr1 == aStr3 );
} 

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_op_cscs_005( TestResult *oRes )
{

	const sal_Char *aStr1 = "\0";

	::rtl::OString aStr2("\0");

	const sal_Char *aStr3 = (const sal_Char *)aStr2;

	oRes->state( aStr1 == aStr3 );
} 

//------------------------------------------------------------------------------------------------------
//
// testing the method getStr()
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_getStr_001( TestResult *oRes )
{
	sal_Char *aStr1 = (sal_Char *)malloc(17*sizeof(sal_Char));
    
	if ( aStr1 != NULL )
	{
		::rtl::OString aStr2(kTestStr1);
		
		const sal_Char *aStr3 = aStr2.getStr();
		
		strcpy( aStr1, aStr2.getStr() );
		
		oRes->state( strcmp( aStr1, aStr3 ) == 0 );
		
		free( aStr1 );	
	} // if   
} 

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_getStr_002( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr1);
		
	const sal_Char *aStr2 = aStr1.getStr();
		
	oRes->state( strcmp( kTestStr1, aStr2 ) == 0 );
} 

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_getStr_003( TestResult *oRes )
{
	::rtl::OString aStr1;
		
	const sal_Char *aStr2 = aStr1.getStr();
		
	oRes->state( aStr2 == NULL );
} 

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_getStr_004( TestResult *oRes )
{
	::rtl::OString aStr1("");
		
	const sal_Char *aStr2 = aStr1.getStr();
		
	oRes->state( aStr2 == "" );
} 

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_getStr_005( TestResult *oRes )
{
	::rtl::OString aStr1("\0");
		
	const sal_Char *aStr2 = aStr1.getStr();
		
	oRes->state( aStr2 == "\0" );
} 

//------------------------------------------------------------------------------------------------------
//
// testing the method copy( sal_Int32 beginIndex )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_001( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr6);
	::rtl::OString aStr2(kTestStr2);
	::rtl::OString aStr3;

	aStr3 = aStr2.copy(17);

	oRes->state( aStr1 == aStr3 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_002( TestResult *oRes )
{
 	::rtl::OString aStr1(kTestStr2);
	::rtl::OString aStr2;

	aStr2 = aStr1.copy(0);

	oRes->state( aStr2 == aStr1 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_003( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr2);
	::rtl::OString aStr2;

	aStr2 = aStr1.copy(31);

	oRes->state( strcmp( aStr2.getStr(), "y" ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_004( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr2);
	::rtl::OString aStr2;

	aStr2 = aStr1.copy(32);

	oRes->state( strcmp( aStr2.getStr(), "" ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_005( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr2);
	::rtl::OString aStr2;

	aStr2 = aStr1.copy(60);

	oRes->state( strcmp( aStr2.getStr(), "" ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_006( TestResult *oRes )
{
 	::rtl::OString aStr1(kTestStr1);
	::rtl::OString aStr2(kTestStr2);

	aStr2 = aStr1.copy(0);

	oRes->state( aStr2 == aStr1 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_007( TestResult *oRes )
{
 	::rtl::OString aStr1(kTestStr2);
	::rtl::OString aStr2(kTestStr1);

	aStr2 = aStr1.copy(0);

	oRes->state( aStr2 == aStr1 );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method copy( sal_Int32 beginIndex, sal_Int32 count )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_008( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr6);
	::rtl::OString aStr2(kTestStr2);
	::rtl::OString aStr3;

	aStr3 = aStr2.copy(17,31);

	oRes->state( aStr1 == aStr3 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_009( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr6);
	::rtl::OString aStr2(kTestStr2);
	::rtl::OString aStr3;

	aStr3 = aStr2.copy(17,31);

	oRes->state( strcmp( aStr3.getStr(), aStr1.getStr() ) == 0 );	
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_010( TestResult *oRes )
{
 	::rtl::OString aStr1(kTestStr6);
	::rtl::OString aStr2(kTestStr2);
	::rtl::OString aStr3;

	aStr3 = aStr2.copy(17,40);

	oRes->state( aStr1 == aStr3 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_011( TestResult *oRes )
{
 	::rtl::OString aStr1(kTestStr6);
	::rtl::OString aStr2(kTestStr2);
	::rtl::OString aStr3;

	aStr3 = aStr2.copy(17,40);

	oRes->state( strcmp( aStr3.getStr(), aStr1.getStr() ) == 0 );	
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_012( TestResult *oRes )
{
 	::rtl::OString aStr1(kTestStr2);
	::rtl::OString aStr2;

	aStr2 = aStr1.copy(0,31);

	oRes->state( aStr2 == aStr1 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_013( TestResult *oRes )
{
 	::rtl::OString aStr1(kTestStr2);
	::rtl::OString aStr2;

	aStr2 = aStr1.copy(0,31);

	oRes->state( strcmp( aStr1.getStr(), aStr2.getStr() ) == 0 );	
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_014( TestResult *oRes )
{
 	::rtl::OString aStr1(kTestStr2);
	::rtl::OString aStr2;

	aStr2 = aStr1.copy(0,40);

	oRes->state( aStr2 == aStr1 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_015( TestResult *oRes )
{
 	::rtl::OString aStr1(kTestStr2);
	::rtl::OString aStr2;

	aStr2 = aStr1.copy(0,40);

	oRes->state( strcmp( aStr1.getStr(), aStr2.getStr() ) == 0 );	
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_016( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr2);
	::rtl::OString aStr2;

	aStr2 = aStr1.copy(31,31);

	oRes->state( strcmp( aStr2.getStr(), "y" ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_017( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr2);
	::rtl::OString aStr2;

	aStr2 = aStr1.copy(31,40);

	oRes->state( strcmp( aStr2.getStr(), "y" ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_018( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr2);
	::rtl::OString aStr2;

	aStr2 = aStr1.copy(32,32);

	oRes->state( strcmp( aStr2.getStr(), "" ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_019( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr2);
	::rtl::OString aStr2;

	aStr2 = aStr1.copy(32,40);

	oRes->state( strcmp( aStr2.getStr(), "" ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_020( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr2);
	::rtl::OString aStr2;

	aStr2 = aStr1.copy(60,60);

	oRes->state( strcmp( aStr2.getStr(), "" ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_021( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr2);
	::rtl::OString aStr2;

	aStr2 = aStr1.copy(60,90);

	oRes->state( strcmp( aStr2.getStr(), "" ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_022( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr2);
	::rtl::OString aStr2;

	aStr2 = aStr1.copy(90,60);

	oRes->state( strcmp( aStr2.getStr(), "" ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_023( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr2);
	::rtl::OString aStr2;

	aStr2 = aStr1.copy(60,0);

	oRes->state( strcmp( aStr2.getStr(), "" ) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_copy_024( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr2);
	::rtl::OString aStr2;

	aStr2 = aStr1.copy(31,0);

	oRes->state( strcmp( aStr2.getStr(), "" ) == 0 );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method concat( const OString & aStr )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_concat_001( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr7);
        ::rtl::OString aStr2(kTestStr8);
        ::rtl::OString aStr3(kTestStr1);
        ::rtl::OString aStr4;

        aStr4 = aStr1.concat(aStr2);

        oRes->state( aStr4.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_concat_002( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2("");
        ::rtl::OString aStr3(kTestStr1);
        ::rtl::OString aStr4;

        aStr4 = aStr1.concat(aStr2);

        oRes->state( aStr4.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_concat_003( TestResult *oRes )
{
        ::rtl::OString aStr1("");
        ::rtl::OString aStr2(kTestStr1);
        ::rtl::OString aStr3(kTestStr1);
        ::rtl::OString aStr4;

        aStr4 = aStr1.concat(aStr2);

        oRes->state( aStr4.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_concat_004( TestResult *oRes )
{
        ::rtl::OString aStr1("");
        ::rtl::OString aStr2("");
        ::rtl::OString aStr3("");
        ::rtl::OString aStr4;

        aStr4 = aStr1.concat(aStr2);

        oRes->state( aStr4.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_concat_005( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2;
        ::rtl::OString aStr3(kTestStr1);
        ::rtl::OString aStr4;

        aStr4 = aStr1.concat(aStr2);

        oRes->state( aStr4.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_concat_006( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2(kTestStr1);
        ::rtl::OString aStr3(kTestStr1);
        ::rtl::OString aStr4;

        aStr4 = aStr1.concat(aStr2);

        oRes->state( aStr4.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_concat_007( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2;
        ::rtl::OString aStr3;
        ::rtl::OString aStr4;

        aStr4 = aStr1.concat(aStr2);

        oRes->state( aStr4.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toAsciiLowerCase()
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toAsciiLowerCase_001( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr4);
        ::rtl::OString aStr2;
        ::rtl::OString aStr3(kTestStr5);

        aStr2 = aStr1.toAsciiLowerCase();

        oRes->state( aStr2.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toAsciiLowerCase_002( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2;
        ::rtl::OString aStr3(kTestStr5);

        aStr2 = aStr1.toAsciiLowerCase();

        oRes->state( aStr2.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toAsciiLowerCase_003( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr3);
        ::rtl::OString aStr2;
        ::rtl::OString aStr3(kTestStr5);

        aStr2 = aStr1.toAsciiLowerCase();

        oRes->state( aStr2.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toAsciiLowerCase_004( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr5);
        ::rtl::OString aStr2;
        ::rtl::OString aStr3(kTestStr5);

        aStr2 = aStr1.toAsciiLowerCase();

        oRes->state( aStr2.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toAsciiUpperCase()
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toAsciiUpperCase_001( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr5);
        ::rtl::OString aStr2;
        ::rtl::OString aStr3(kTestStr4);

        aStr2 = aStr1.toAsciiUpperCase();

        oRes->state( aStr2.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toAsciiUpperCase_002( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr3);
        ::rtl::OString aStr2;
        ::rtl::OString aStr3(kTestStr4);

        aStr2 = aStr1.toAsciiUpperCase();

        oRes->state( aStr2.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toAsciiUpperCase_003( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr1);
        ::rtl::OString aStr2;
        ::rtl::OString aStr3(kTestStr4);

        aStr2 = aStr1.toAsciiUpperCase();

        oRes->state( aStr2.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toAsciiUpperCase_004( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr4);
        ::rtl::OString aStr2;
        ::rtl::OString aStr3(kTestStr4);

        aStr2 = aStr1.toAsciiUpperCase();

        oRes->state( aStr2.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method trim()
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_trim_001( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr10);
        ::rtl::OString aStr2;
        ::rtl::OString aStr3(kTestStr1);

        aStr2 = aStr1.trim();

        oRes->state( aStr2.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_trim_002( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr11);
        ::rtl::OString aStr2;
        ::rtl::OString aStr3(kTestStr1);

        aStr2 = aStr1.trim();

        oRes->state( aStr2.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_trim_003( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr12);
        ::rtl::OString aStr2;
        ::rtl::OString aStr3(kTestStr1);

        aStr2 = aStr1.trim();

        oRes->state( aStr2.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_trim_004( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr13);
        ::rtl::OString aStr2;
        ::rtl::OString aStr3(kTestStr1);

        aStr2 = aStr1.trim();

        oRes->state( aStr2.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_trim_005( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr14);
        ::rtl::OString aStr2;
        ::rtl::OString aStr3(kTestStr1);

        aStr2 = aStr1.trim();

        oRes->state( aStr2.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_trim_006( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr15);
        ::rtl::OString aStr2;
        ::rtl::OString aStr3(kTestStr1);

        aStr2 = aStr1.trim();

        oRes->state( aStr2.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_trim_007( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr16);
        ::rtl::OString aStr2;
        ::rtl::OString aStr3(kTestStr1);

        aStr2 = aStr1.trim();

        oRes->state( aStr2.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_trim_008( TestResult *oRes )
{
        ::rtl::OString aStr1(kTestStr17);
        ::rtl::OString aStr2;
        ::rtl::OString aStr3(kTestStr1);

        aStr2 = aStr1.trim();

        oRes->state( aStr2.compareTo(aStr3) == 0 );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method replace( sal_Char oldChar, sal_Char newChar )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_replace_001( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr4);
	::rtl::OString aStr2(kTestStr18);

	aStr1 = aStr1.replace( 'S', 's' );

	oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_replace_002( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr17);
	::rtl::OString aStr2(kTestStr19);

	aStr1 = aStr1.replace( ' ', '-' );

	oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_replace_003( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr21);
	::rtl::OString aStr2(kTestStr20);

	int i;

	for ( i = 0; i < 3; i++ )
	{
		aStr1 = aStr1.replace( kTestStr21[i], kTestStr20[i] );
	} // for 

	oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_replace_004( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr22);
	::rtl::OString aStr2(kTestStr9);

	int i;

	for ( i = 0; i < kTestStr22Len; i++ )
	{
		aStr1 = aStr1.replace( kTestStr22[i], kTestStr9[i] );
	} // for 

	oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_replace_005( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr22);
	::rtl::OString aStr2(kTestStr22);

	int i;

	for ( i = 0; i < kTestStr22Len; i++ )
	{
		aStr1 = aStr1.replace( '*', kTestStr22[i] );
	} // for 

	oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_replace_006( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr22);
	::rtl::OString aStr2;

	int i;

	for ( i = 0; i < kTestStr22Len; i++ )
	{
		aStr1 = aStr1.replace( kTestStr22[i], '\0' );
	} // for

	oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_replace_007( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr22);
	::rtl::OString aStr2;

	aStr1 = aStr1.replace( kTestStr22[0], '\0' );

	oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_replace_008( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr5);
	::rtl::OString aStr2(kTestStr20);

	aStr1 = aStr1.replace( ' ', '\0' );

	oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method replaceAt( sal_Int32 index, sal_Int32 count, const OString& newStr )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_replaceAt_001( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr22);
	::rtl::OString aStr2(kTestStr2);

	aStr1 = aStr1.replaceAt(17, kTestStr6Len, OString(kTestStr6) );
	aStr1 = aStr1.replaceAt( 0, kTestStr7Len, OString(kTestStr7) );
	aStr1 = aStr1.replaceAt( 4, kTestStr8Len, OString(kTestStr8) );

	oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_replaceAt_002( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr22);
	::rtl::OString aStr2(kTestStr2);

	aStr1 = aStr1.replaceAt(0, kTestStr22Len, aStr2 );

	oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_replaceAt_003( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr22);
	::rtl::OString aStr2(kTestStr2);

	aStr1 = aStr1.replaceAt(kTestStr22Len - 1, kTestStr22Len, aStr2 );

	oRes->state( aStr2.compareTo(aStr1) > 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_replaceAt_004( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr22);
	::rtl::OString aStr2(kTestStr2);

	aStr1 = aStr1.replaceAt(64, kTestStr22Len, aStr2 );

	oRes->state( aStr2.compareTo(aStr1) > 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_replaceAt_005( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr22);
	::rtl::OString aStr2(kTestStr2);

	aStr1 = aStr1.replaceAt(64, 64, aStr2 );

	oRes->state( aStr2.compareTo(aStr1) > 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_replaceAt_006( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr22);
	::rtl::OString aStr2(kTestStr2);

	aStr1 = aStr1.replaceAt(-64, 64, aStr2 );

	oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_replaceAt_007( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr20);
	::rtl::OString aStr2(kTestStr21);

	aStr1 = aStr1.replaceAt(0, 1, OString("S") );
	aStr1 = aStr1.replaceAt(1, 1, OString("U") );
	aStr1 = aStr1.replaceAt(2, 1, OString("N") );

	oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_replaceAt_008( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr22);
	::rtl::OString aStr2(kTestStr22);

	aStr1 = aStr1.replaceAt(0, kTestStr22Len, OString("") );

	oRes->state( aStr2.compareTo(aStr1) != 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_replaceAt_009( TestResult *oRes )
{
	::rtl::OString aStr1(kTestStr2);
	::rtl::OString aStr2(kTestStr6);

	aStr1 = aStr1.replaceAt(0, kTestStr1Len, OString("") );

	oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Bool b )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_001( TestResult *oRes )
{
	::rtl::OString aStr1;
	::rtl::OString aStr2("True");
	
	sal_Bool bValue = sal_True;
	
	aStr1 = aStr1.valueOf(bValue);
	
	oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_002( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2("False");

        sal_Bool bValue = sal_False;

        aStr1 = aStr1.valueOf(bValue);

        oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Char c )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_003( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2("A");

        aStr1 = aStr1.valueOf('A');

        oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_004( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2("a");

        aStr1 = aStr1.valueOf('a');

        oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_005( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2("0");

        aStr1 = aStr1.valueOf('0');

        oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_006( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2("-");

        aStr1 = aStr1.valueOf('-');

        oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//-------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_007( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2("_");

        aStr1 = aStr1.valueOf('_');

        oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_008( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2("");

        aStr1 = aStr1.valueOf('');

        oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_009( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2("");

        aStr1 = aStr1.valueOf('');

        oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_010( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2("");

        aStr1 = aStr1.valueOf('');

        oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_011( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2("");

        aStr1 = aStr1.valueOf('');

        oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_012( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2("\n");

        aStr1 = aStr1.valueOf('\n');

        oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_013( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2("\'");

        aStr1 = aStr1.valueOf('\'');

        oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_014( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2("\"");

        aStr1 = aStr1.valueOf('\"');

        oRes->state( aStr2.compareTo(aStr1) == 0 );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_015( TestResult *oRes )
{
        ::rtl::OString aStr1;
        ::rtl::OString aStr2("\0");

        aStr1 = aStr1.valueOf('\0');

        oRes->state( aStr1 == NULL );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int32 i, sal_Int16 radix=2 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_016( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 0;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "0" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_017( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 1;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "1" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_018( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 2;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "10" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_019( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 3;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "11" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_020( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 4;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "100" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_021( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 5;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "101" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_022( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 6;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "110" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_023( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 7;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "111" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_024( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 8;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "1000" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_025( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 9;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "1001" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_026( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 10;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "1010" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_027( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 11;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "1011" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_028( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 12;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "1100" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_029( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 13;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "1101" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_030( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 14;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "1110" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_031( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 15;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "1111" );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int32 i, sal_Int16 radix=8 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_032( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 0;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "0" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_033( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 1;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "1" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_034( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 2;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "2" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_035( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 3;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "3" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_036( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 4;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "4" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_037( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 5;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "5" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_038( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 6;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "6" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_039( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 7;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "7" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_040( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 8;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "10" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_041( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 9;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "11" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_042( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 10;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "12" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_043( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 11;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "13" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_044( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 12;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "14" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_045( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 13;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "15" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_046( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 14;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "16" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_047( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 15;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "17" );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int32 i, sal_Int16 radix=10 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_048( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 0;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "0" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_049( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 1;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "1" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_050( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 2;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "2" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_051( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 3;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "3" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_052( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 4;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "4" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_053( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 5;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "5" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_054( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 6;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "6" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_055( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 7;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "7" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_056( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 8;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "8" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_057( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 9;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "9" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_058( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 10;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "10" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_059( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 11;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "11" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_060( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 12;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "12" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_061( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 13;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "13" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_062( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 14;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "14" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_063( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 15;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "15" );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int32 i, sal_Int16 radix=16 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_064( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 0;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "0" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_065( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 1;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "1" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_066( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 2;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "2" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_067( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 3;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "3" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_068( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 4;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "4" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_069( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 5;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "5" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_070( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 6;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "6" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_071( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 7;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "7" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_072( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 8;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "8" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_073( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 9;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "9" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_074( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 10;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "a" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_075( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 11;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "b" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_076( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 12;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "c" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_077( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 13;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "d" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_078( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 14;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "e" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_079( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 15;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "f" );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int32 i, sal_Int16 radix=36 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_080( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 0;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "0" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_081( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 1;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "1" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_082( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 2;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "2" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_083( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 3;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "3" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_084( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 4;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "4" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_085( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 5;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "5" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_086( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 6;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "6" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_087( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 7;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "7" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_088( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 8;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "8" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_089( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 9;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "9" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_090( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 10;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "a" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_091( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 11;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "b" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_092( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 12;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "c" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_093( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 13;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "d" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_094( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 14;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "e" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_095( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 15;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "f" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_096( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 16;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "g" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_097( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 17;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "h" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_098( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 18;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "i" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_099( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 19;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "j" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_100( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 20;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "k" );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt64( sal_Int16 radix = 2 ) for large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_101( TestResult *oRes )
{
	::rtl::OString aStr(kSInt8MaxBinaryStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt8Max;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_102( TestResult *oRes )
{
	::rtl::OString aStr(kUInt8MaxBinaryStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt8Max;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_103( TestResult *oRes )
{
	::rtl::OString aStr(kSInt16MaxBinaryStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt16Max;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_104( TestResult *oRes )
{
	::rtl::OString aStr(kUInt16MaxBinaryStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt16Max;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_105( TestResult *oRes )
{
	::rtl::OString aStr(kSInt32MaxBinaryStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt32Max;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_106( TestResult *oRes )
{
	::rtl::OString aStr(kUInt32MaxBinaryStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt32Max;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_107( TestResult *oRes )
{
	::rtl::OString aStr(kSInt64MaxBinaryStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt64Max;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt64( sal_Int16 radix = 8 ) for large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_108( TestResult *oRes )
{
	::rtl::OString aStr(kSInt8MaxOctolStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt8Max;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_109( TestResult *oRes )
{
	::rtl::OString aStr(kUInt8MaxOctolStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt8Max;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_110( TestResult *oRes )
{
	::rtl::OString aStr(kSInt16MaxOctolStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt16Max;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_111( TestResult *oRes )
{
	::rtl::OString aStr(kUInt16MaxOctolStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt16Max;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_112( TestResult *oRes )
{
	::rtl::OString aStr(kSInt32MaxOctolStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt32Max;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_113( TestResult *oRes )
{
	::rtl::OString aStr(kUInt32MaxOctolStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt32Max;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_114( TestResult *oRes )
{
	::rtl::OString aStr(kSInt64MaxOctolStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt64Max;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt64( sal_Int16 radix = 10 ) for large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_115( TestResult *oRes )
{
	::rtl::OString aStr(kSInt8MaxDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt8Max;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_116( TestResult *oRes )
{
	::rtl::OString aStr(kUInt8MaxDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt8Max;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_117( TestResult *oRes )
{
	::rtl::OString aStr(kSInt16MaxDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt16Max;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_118( TestResult *oRes )
{
	::rtl::OString aStr(kUInt16MaxDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt16Max;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_119( TestResult *oRes )
{
	::rtl::OString aStr(kSInt32MaxDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt32Max;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_120( TestResult *oRes )
{
	::rtl::OString aStr(kUInt32MaxDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt32Max;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_121( TestResult *oRes )
{
	::rtl::OString aStr(kSInt64MaxDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt64Max;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt64( sal_Int16 radix = 16 ) for large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_122( TestResult *oRes )
{
	::rtl::OString aStr(kSInt8MaxHexDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt8Max;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_123( TestResult *oRes )
{
	::rtl::OString aStr(kUInt8MaxHexDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt8Max;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_124( TestResult *oRes )
{
	::rtl::OString aStr(kSInt16MaxHexDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt16Max;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_125( TestResult *oRes )
{
	::rtl::OString aStr(kUInt16MaxHexDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt16Max;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_126( TestResult *oRes )
{
	::rtl::OString aStr(kSInt32MaxHexDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt32Max;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_127( TestResult *oRes )
{
	::rtl::OString aStr(kUInt32MaxHexDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt32Max;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_128( TestResult *oRes )
{
	::rtl::OString aStr(kSInt64MaxHexDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt64Max;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt64( sal_Int16 radix = 36 ) for large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_129( TestResult *oRes )
{
	::rtl::OString aStr(kSInt8MaxBase36Str);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt8Max;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_130( TestResult *oRes )
{
	::rtl::OString aStr(kUInt8MaxBase36Str);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt8Max;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_131( TestResult *oRes )
{
	::rtl::OString aStr(kSInt16MaxBase36Str);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt16Max;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_132( TestResult *oRes )
{
	::rtl::OString aStr(kUInt16MaxBase36Str);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt16Max;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_133( TestResult *oRes )
{
	::rtl::OString aStr(kSInt32MaxBase36Str);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt32Max;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_134( TestResult *oRes )
{
	::rtl::OString aStr(kUInt32MaxBase36Str);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt32Max;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_135( TestResult *oRes )
{
	::rtl::OString aStr(kSInt64MaxBase36Str);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt64Max;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_101( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 21;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "l" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_102( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 22;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "m" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_103( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 23;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "n" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_104( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 24;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "o" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_105( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 25;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "p" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_106( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 26;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "q" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_107( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 27;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "r" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_108( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 28;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "s" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_109( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 29;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "t" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_110( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 30;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "u" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_111( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 31;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "v" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_112( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 32;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "w" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_113( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 33;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "x" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_114( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 34;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "y" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_115( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = 35;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "z" );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int64 l, sal_Int16 radix=2 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_116( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 0;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "0" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_117( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 1;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "1" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_118( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 2;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "10" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_119( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 3;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "11" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_120( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 4;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "100" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_121( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 5;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "101" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_122( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 6;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "110" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_123( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 7;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "111" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_124( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 8;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "1000" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_125( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 9;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "1001" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_126( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 10;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "1010" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_127( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 11;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "1011" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_128( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 12;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "1100" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_129( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 13;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "1101" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_130( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 14;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "1110" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_131( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 15;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == "1111" );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int64 l, sal_Int16 radix=8 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_132( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 0;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "0" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_133( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 1;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "1" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_134( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 2;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "2" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_135( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 3;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "3" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_136( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 4;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "4" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_137( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 5;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "5" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_138( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 6;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "6" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_139( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 7;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "7" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_140( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 8;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "10" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_141( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 9;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "11" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_142( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 10;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "12" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_143( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 11;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "13" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_144( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 12;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "14" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_145( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 13;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "15" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_146( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 14;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "16" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_147( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 15;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == "17" );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int64 l, sal_Int16 radix=10 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_148( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 0;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "0" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_149( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 1;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "1" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_150( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 2;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "2" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_151( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 3;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "3" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_152( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 4;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "4" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_153( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 5;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "5" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_154( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 6;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "6" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_155( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 7;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "7" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_156( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 8;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "8" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_157( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 9;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "9" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_158( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 10;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "10" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_159( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 11;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "11" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_160( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 12;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "12" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_161( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 13;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "13" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_162( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 14;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "14" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_163( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 15;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == "15" );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int64 l, sal_Int16 radix=16 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_164( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 0;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "0" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_165( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 1;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "1" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_166( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 2;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "2" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_167( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 3;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "3" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_168( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 4;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "4" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_169( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 5;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "5" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_170( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 6;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "6" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_171( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 7;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "7" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_172( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 8;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "8" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_173( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 9;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "9" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_174( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 10;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "a" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_175( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 11;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "b" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_176( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 12;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "c" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_177( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 13;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "d" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_178( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 14;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "e" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_179( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 15;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == "f" );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int64 l, sal_Int16 radix=36 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_180( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 0;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "0" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_181( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 1;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "1" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_182( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 2;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "2" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_183( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 3;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "3" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_184( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 4;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "4" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_185( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 5;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "5" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_186( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 6;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "6" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_187( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 7;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "7" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_188( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 8;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "8" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_189( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 9;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "9" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_190( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 10;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "a" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_191( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 11;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "b" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_192( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 12;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "c" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_193( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 13;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "d" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_194( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 14;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "e" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_195( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 15;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "f" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_196( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 16;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "g" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_197( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 17;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "h" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_198( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 18;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "i" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_199( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 19;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "j" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_200( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 20;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "k" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_201( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 21;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "l" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_202( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 22;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "m" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_203( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 23;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "n" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_204( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 24;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "o" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_205( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 25;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "p" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_206( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 26;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "q" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_207( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 27;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "r" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_208( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 28;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "s" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_209( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 29;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "t" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_210( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 30;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "u" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_211( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 31;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "v" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_212( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 32;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "w" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_213( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 33;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "x" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_214( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 34;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "y" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_215( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = 35;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == "z" );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( float f )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_216( TestResult *oRes )
{
	::rtl::OString aStr;
	
	float num = 3;
	
	aStr = aStr.valueOf(num);
	
	oRes->state( aStr == "3.0" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_217( TestResult *oRes )
{
	::rtl::OString aStr;
	
	float num = 3.1;
	
	aStr = aStr.valueOf(num);
	
	oRes->state( aStr == "3.100000" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_218( TestResult *oRes )
{
	::rtl::OString aStr;
	
	float num = 3.1415;
	
	aStr = aStr.valueOf(num);
	
	oRes->state( aStr == "3.141500" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_219( TestResult *oRes )
{
	::rtl::OString aStr;
	
	float num = 3.14159;
	
	aStr = aStr.valueOf(num);
	
	oRes->state( aStr == "3.141590" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_220( TestResult *oRes )
{
	::rtl::OString aStr;
	
	float num = 3.141592;
	
	aStr = aStr.valueOf(num);
	
	oRes->state( aStr == "3.141592" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_221( TestResult *oRes )
{
	::rtl::OString aStr;
	
	float num = 3.1415926;
	
	aStr = aStr.valueOf(num);
	
	oRes->state( aStr == "3.141593" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_222( TestResult *oRes )
{
	::rtl::OString aStr;
	
	float num = 3.14159265;
	
	aStr = aStr.valueOf(num);
	
	oRes->state( aStr == "3.141593" );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( double f )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_223( TestResult *oRes )
{
	::rtl::OString aStr;
	
	double num = 3;
	
	aStr = aStr.valueOf(num);

	oRes->state( aStr == "3.0" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_224( TestResult *oRes )
{
	::rtl::OString aStr;
	
	double num = 3.1;
	
	aStr = aStr.valueOf(num);
	
	oRes->state( aStr == "3.1" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_225( TestResult *oRes )
{
	::rtl::OString aStr;
	
	double num = 3.1415;
	
	aStr = aStr.valueOf(num);
	
	oRes->state( aStr == "3.1415" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_226( TestResult *oRes )
{
	::rtl::OString aStr;
	
	double num = 3.1415926535;
	
	aStr = aStr.valueOf(num);
	
	oRes->state( aStr == "3.1415926535" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_227( TestResult *oRes )
{
	::rtl::OString aStr;
	
	double num = 3.141592653589793;
	
	aStr = aStr.valueOf(num);
	
	oRes->state( aStr == "3.1415926535897931" );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_228( TestResult *oRes )
{
	::rtl::OString aStr;
	
	double num = 3.1415926535897932;
	
	aStr = aStr.valueOf(num);

	oRes->state( aStr == "3.1415926535897931" );	
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_229( TestResult *oRes )
{
	::rtl::OString aStr;
	
	double num = 3.14159265358979323;
	
	aStr = aStr.valueOf(num);

	oRes->state( aStr == "3.1415926535897931" );	
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_230( TestResult *oRes )
{
	::rtl::OString aStr;
	
	double num = 3.141592653589793238462643;
	
	aStr = aStr.valueOf(num);

	oRes->state( aStr == "3.1415926535897931" );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int32 l, sal_Int32 radix=2 ) where l = large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_231( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = kSInt8Max;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == kSInt8MaxBinaryStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_232( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kUInt8Max;
		
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == kUInt8MaxBinaryStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_233( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kSInt16Max;
		
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == kSInt16MaxBinaryStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_234( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kUInt16Max;
		
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == kUInt16MaxBinaryStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_235( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kSInt32Max;
		
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == kSInt32MaxBinaryStr );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int32 l, sal_Int32 radix=8 ) where l = large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_236( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = kSInt8Max;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == kSInt8MaxOctolStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_237( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kUInt8Max;
		
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == kUInt8MaxOctolStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_238( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kSInt16Max;
		
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == kSInt16MaxOctolStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_239( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kUInt16Max;
		
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == kUInt16MaxOctolStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_240( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kSInt32Max;
		
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == kSInt32MaxOctolStr  );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int32 l, sal_Int32 radix=10 ) where l = large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_241( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = kSInt8Max;
		
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == kSInt8MaxDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_242( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kUInt8Max;
		
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == kUInt8MaxDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_243( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kSInt16Max;
		
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == kSInt16MaxDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_244( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kUInt16Max;
		
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == kUInt16MaxDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_245( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kSInt32Max;
		
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == kSInt32MaxDecimalStr );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int32 l, sal_Int32 radix=16 ) where l = large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_246( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = kSInt8Max;
		
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == kSInt8MaxHexDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_247( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kUInt8Max;
		
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == kUInt8MaxHexDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_248( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kSInt16Max;
		
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == kSInt16MaxHexDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_249( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kUInt16Max;
		
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == kUInt16MaxHexDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_250( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kSInt32Max;

	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == kSInt32MaxHexDecimalStr );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int32 l, sal_Int32 radix=36 ) where l = large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_251( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int32 num = kSInt8Max;
		
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == kSInt8MaxBase36Str );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_252( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kUInt8Max;
		
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == kUInt8MaxBase36Str );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_253( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kSInt16Max;
		
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == kSInt16MaxBase36Str );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_254( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kUInt16Max;
		
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == kUInt16MaxBase36Str );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_255( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int32 num = kSInt32Max;

	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == kSInt32MaxBase36Str );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int64 l, sal_Int32 radix=2 ) where l = large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_256( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = kSInt8Max;
	
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == kSInt8MaxBinaryStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_257( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kUInt8Max;
		
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == kUInt8MaxBinaryStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_258( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kSInt16Max;
		
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == kSInt16MaxBinaryStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_259( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kUInt16Max;
		
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == kUInt16MaxBinaryStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_260( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kSInt32Max;
		
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == kSInt32MaxBinaryStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_261( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kUInt32Max;
		
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == kUInt32MaxBinaryStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_262( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kSInt64Max;
		
	aStr = aStr.valueOf(num,kRadixBinary);

	oRes->state( aStr == kSInt64MaxBinaryStr );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int64 l, sal_Int32 radix=8 ) where l = large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_263( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = kSInt8Max;
	
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == kSInt8MaxOctolStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_264( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kUInt8Max;
		
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == kUInt8MaxOctolStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_265( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kSInt16Max;
		
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == kSInt16MaxOctolStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_266( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kUInt16Max;
		
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == kUInt16MaxOctolStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_267( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kSInt32Max;
		
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == kSInt32MaxOctolStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_268( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kUInt32Max;
		
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == kUInt32MaxOctolStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_269( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kSInt64Max;
		
	aStr = aStr.valueOf(num,kRadixOctol);

	oRes->state( aStr == kSInt64MaxOctolStr );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int64 l, sal_Int32 radix=10 ) where l = large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_270( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = kSInt8Max;
	
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == kSInt8MaxDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_271( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kUInt8Max;
		
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == kUInt8MaxDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_272( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kSInt16Max;
		
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == kSInt16MaxDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_273( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kUInt16Max;
		
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == kUInt16MaxDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_274( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kSInt32Max;
		
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == kSInt32MaxDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_275( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kUInt32Max;
		
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == kUInt32MaxDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_276( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kSInt64Max;
		
	aStr = aStr.valueOf(num,kRadixDecimal);

	oRes->state( aStr == kSInt64MaxDecimalStr );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int64 l, sal_Int32 radix=16 ) where l = large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_277( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = kSInt8Max;
	
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == kSInt8MaxHexDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_278( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kUInt8Max;
		
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == kUInt8MaxHexDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_279( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kSInt16Max;
		
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == kSInt16MaxHexDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_280( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kUInt16Max;
		
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == kUInt16MaxHexDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_281( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kSInt32Max;
		
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == kSInt32MaxHexDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_282( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kUInt32Max;
		
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == kUInt32MaxHexDecimalStr );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_283( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kSInt64Max;
		
	aStr = aStr.valueOf(num,kRadixHexdecimal);

	oRes->state( aStr == kSInt64MaxHexDecimalStr );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method valueOf( sal_Int64 l, sal_Int32 radix=36 ) where l = large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_284( TestResult *oRes )
{
	::rtl::OString aStr;
	
	sal_Int64 num = kSInt8Max;
	
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == kSInt8MaxBase36Str );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_285( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kUInt8Max;
		
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == kUInt8MaxBase36Str );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_286( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kSInt16Max;
		
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == kSInt16MaxBase36Str );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_287( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kUInt16Max;
		
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == kUInt16MaxBase36Str );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_288( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kSInt32Max;
		
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == kSInt32MaxBase36Str );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_289( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kUInt32Max;
		
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == kUInt32MaxBase36Str );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_valueOf_290( TestResult *oRes )
{
	::rtl::OString aStr;
		
	sal_Int64 num = kSInt64Max;
		
	aStr = aStr.valueOf(num,kRadixBase36);

	oRes->state( aStr == kSInt64MaxBase36Str );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toFloat()
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toFloat_001( TestResult *oRes )
{
	::rtl::OString aStr("3");
	
	float actNum = 0;
	float expNum = 3;
	
	actNum = aStr.toFloat();

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toFloat_002( TestResult *oRes )
{
	::rtl::OString aStr("3.1");
	
	float actNum = 0;
	float expNum = 3.1;
	
	actNum = aStr.toFloat();

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toFloat_003( TestResult *oRes )
{
	::rtl::OString aStr("3.1415");
	
	float actNum = 0;
	float expNum = 3.1415;
	
	actNum = aStr.toFloat();

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toFloat_004( TestResult *oRes )
{
	::rtl::OString aStr("3.14159");
	
	float actNum = 0;
	float expNum = 3.14159;
	
	actNum = aStr.toFloat();

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toFloat_005( TestResult *oRes )
{
	::rtl::OString aStr("3.141592");
	
	float actNum = 0;
	float expNum = 3.141592;
	
	actNum = aStr.toFloat();

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toFloat_006( TestResult *oRes )
{
	const sal_Char  *pStr = "3.1415926";
	const float      num  = 3.141593;
	const float      eps  = 1e-6;
	
	sal_Bool state = AStringToFloatCompare ( pStr, num, eps );
	
	oRes->state( state );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toFloat_007( TestResult *oRes )
{
	const sal_Char  *pStr = "3.14159265";
	const float      num  = 3.141593;
	const float      eps  = 1e-6;
	
	sal_Bool state = AStringToFloatCompare ( pStr, num, eps );
	
	oRes->state( state );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toFloat_008( TestResult *oRes )
{
	const sal_Char  *pStr = "3.141592653589793238462643";
	const float      num  = 3.141593;
	const float      eps  = 1e-6;
	
	sal_Bool state = AStringToFloatCompare ( pStr, num, eps );
	
	oRes->state( state );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toFloat_009( TestResult *oRes )
{
	const sal_Char  *aStr = "6.5822e-16";
	const float      num = 6.5822e-16;
	const float      eps = 1e-20;
	
	sal_Bool state = AStringToFloatCompare ( aStr, num, eps );
	
	oRes->state( state );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toFloat_010( TestResult *oRes )
{
	const sal_Char  *aStr = "9.1096e-31";
	const float      num = 9.1096e-31;
	const float      eps = 1e-35;
	
	sal_Bool state = AStringToFloatCompare ( aStr, num, eps );
	
	oRes->state( state );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toFloat_011( TestResult *oRes )
{
	const sal_Char  *aStr = "2.997925e8";
	const float      num = 2.997925e8;
	const float      eps = 10;
	
	sal_Bool state = AStringToFloatCompare ( aStr, num, eps );
	
	oRes->state( state );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toFloat_012( TestResult *oRes )
{
	const sal_Char  *aStr = "6.241e18";
	const float      num = 6.241e18;
	const float      eps = 100;
	
	sal_Bool state = AStringToFloatCompare ( aStr, num, eps );
	
	oRes->state( state );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toDouble()
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toDouble_001( TestResult *oRes )
{
	::rtl::OString aStr("3");
	
	double actNum = 0;
	double expNum = 3;
	
	actNum = aStr.toDouble();

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toDouble_002( TestResult *oRes )
{
	const sal_Char  *pStr = "3.1";
	const double     num  = 3.1;
	const double     eps  = 1e-2;
	
	sal_Bool state = AStringToDoubleCompare( pStr, num, eps );
	
	oRes->state( state );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toDouble_003( TestResult *oRes )
{
	const sal_Char  *pStr = "3.1415";
	const double     num  = 3.1415;
	const double     eps  = 1e-5;
	
	sal_Bool state = AStringToDoubleCompare( pStr, num, eps );
	
	oRes->state( state );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toDouble_004( TestResult *oRes )
{
	const sal_Char  *pStr = "3.1415926535";
	const double     num  = 3.1415926535;
	const double     eps  = 1e-11;
	
	sal_Bool state = AStringToDoubleCompare( pStr, num, eps );
	
	oRes->state( state );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toDouble_005( TestResult *oRes )
{
	const sal_Char  *pStr = "3.141592653589793";
	const double     num  = 3.1415926535897932;
	const double     eps  = 1e-15;
	
	sal_Bool state = AStringToDoubleCompare( pStr, num, eps );
	
	oRes->state( state );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toDouble_006( TestResult *oRes )
{
	const sal_Char  *pStr = "3.1415926535897932";
	const double     num  = 3.1415926535897932;
	const double     eps  = 1e-16;
	
	sal_Bool state = AStringToDoubleCompare( pStr, num, eps );
	
	oRes->state( state );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toDouble_007( TestResult *oRes )
{
	const sal_Char  *pStr = "3.14159265358979323";
	const double     num  = 3.1415926535897932;
	const double     eps  = 1e-16;
	
	sal_Bool state = AStringToDoubleCompare( pStr, num, eps );
	
	oRes->state( state );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toDouble_008( TestResult *oRes )
{
	const sal_Char  *pStr = "3.141592653589793238462643";
	const double     num  = 3.1415926535897932;
	const double     eps  = 1e-16;
	
	sal_Bool state = AStringToDoubleCompare( pStr, num, eps );
	
	oRes->state( state );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toDouble_009( TestResult *oRes )
{
	const sal_Char  *aStr = "6.5822e-16";
	const double     num = 6.5822e-16;
	const double     eps = 1e-20;
	
	sal_Bool state = AStringToDoubleCompare( aStr, num, eps );
	
	oRes->state( state );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toDouble_010( TestResult *oRes )
{
	const sal_Char  *aStr = "9.1096e-31";
	const double     num = 9.1096e-31;
	const double     eps = 1e-35;
	
	sal_Bool state = AStringToDoubleCompare( aStr, num, eps );
	
	oRes->state( state );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toDouble_011( TestResult *oRes )
{
	const sal_Char  *aStr = "2.997925e8";
	const double     num = 2.997925e8;
	const double     eps = 10;
	
	sal_Bool state = AStringToDoubleCompare( aStr, num, eps );
	
	oRes->state( state );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toDouble_012( TestResult *oRes )
{
	const sal_Char  *aStr = "6.241e18";
	const double     num = 6.241e18;
	const double     eps = 100;
	
	sal_Bool state = AStringToDoubleCompare( aStr, num, eps );

	oRes->state( state );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toBoolean()
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toBoolean_001( TestResult *oRes )
{
	::rtl::OString aStr("True");
	
	sal_Bool actValue = sal_False;
	sal_Bool expValue = sal_True;
	
	actValue = aStr.toBoolean();
	
	oRes->state( actValue == expValue );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toBoolean_002( TestResult *oRes )
{
	::rtl::OString aStr("False");
	
	sal_Bool actValue = sal_True;
	sal_Bool expValue = sal_False;
	
	actValue = aStr.toBoolean();
	
	oRes->state( actValue == expValue );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toChar()
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toChar_001( TestResult *oRes )
{
	::rtl::OString aStr("A");

	sal_Char actChar = 0;
	sal_Char expChar = 'A';
		
	actChar = aStr.toChar();

	oRes->state( actChar == expChar );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toChar_002( TestResult *oRes )
{
	::rtl::OString aStr("a");

	sal_Char actChar = 0;
	sal_Char expChar = 'a';
		
	actChar = aStr.toChar();

	oRes->state( actChar == expChar );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toChar_003( TestResult *oRes )
{
	::rtl::OString aStr("0");

	sal_Char actChar = 0;
	sal_Char expChar = '0';
		
	actChar = aStr.toChar();

	oRes->state( actChar == expChar );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toChar_004( TestResult *oRes )
{
	::rtl::OString aStr("-");

	sal_Char actChar = 0;
	sal_Char expChar = '-';
		
	actChar = aStr.toChar();

	oRes->state( actChar == expChar );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toChar_005( TestResult *oRes )
{
	::rtl::OString aStr("_");

	sal_Char actChar = 0;
	sal_Char expChar = '_';
		
	actChar = aStr.toChar();

	oRes->state( actChar == expChar );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toChar_006( TestResult *oRes )
{
	::rtl::OString aStr("");

	sal_Char actChar = 0;
	sal_Char expChar = '';
		
	actChar = aStr.toChar();

	oRes->state( actChar == expChar );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toChar_007( TestResult *oRes )
{
	::rtl::OString aStr("");

	sal_Char actChar = 0;
	sal_Char expChar = '';
		
	actChar = aStr.toChar();

	oRes->state( actChar == expChar );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toChar_008( TestResult *oRes )
{
	::rtl::OString aStr("");

	sal_Char actChar = 0;
	sal_Char expChar = '';
		
	actChar = aStr.toChar();

	oRes->state( actChar == expChar );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toChar_009( TestResult *oRes )
{
	::rtl::OString aStr("");

	sal_Char actChar = 0;
	sal_Char expChar = '';
		
	actChar = aStr.toChar();

	oRes->state( actChar == expChar );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toChar_010( TestResult *oRes )
{
	::rtl::OString aStr("\n");

	sal_Char actChar = 0;
	sal_Char expChar = '\n';
		
	actChar = aStr.toChar();

	oRes->state( actChar == expChar );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toChar_011( TestResult *oRes )
{
	::rtl::OString aStr("\'");

	sal_Char actChar = 0;
	sal_Char expChar = '\'';
		
	actChar = aStr.toChar();

	oRes->state( actChar == expChar );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toChar_012( TestResult *oRes )
{
	::rtl::OString aStr("\"");

	sal_Char actChar = 0;
	sal_Char expChar = '\"';
		
	actChar = aStr.toChar();

	oRes->state( actChar == expChar );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toChar_013( TestResult *oRes )
{
	::rtl::OString aStr("\0");

	sal_Char actChar = 0;
	sal_Char expChar = '\0';
		
	actChar = aStr.toChar();

	oRes->state( actChar == expChar );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toChar_014( TestResult *oRes )
{
	::rtl::OString aStr("");

	sal_Char actChar = 0;
	sal_Char expChar = '\0';
		
	actChar = aStr.toChar();

	oRes->state( actChar == expChar );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toChar_015( TestResult *oRes )
{
	::rtl::OString aStr(kTestStr1);

	sal_Char actChar = 0;
	sal_Char expChar = 'S';
		
	actChar = aStr.toChar();

	oRes->state( actChar == expChar );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt32( sal_Int16 radix = 2 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_001( TestResult *oRes )
{
	::rtl::OString aStr("0");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_002( TestResult *oRes )
{
	::rtl::OString aStr("1");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 1;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_003( TestResult *oRes )
{
	::rtl::OString aStr("10");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 2;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_004( TestResult *oRes )
{
	::rtl::OString aStr("11");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 3;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_005( TestResult *oRes )
{
	::rtl::OString aStr("100");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 4;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_006( TestResult *oRes )
{
	::rtl::OString aStr("101");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 5;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_007( TestResult *oRes )
{
	::rtl::OString aStr("110");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 6;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_008( TestResult *oRes )
{
	::rtl::OString aStr("111");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 7;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_009( TestResult *oRes )
{
	::rtl::OString aStr("1000");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 8;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_010( TestResult *oRes )
{
	::rtl::OString aStr("1001");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 9;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_011( TestResult *oRes )
{
	::rtl::OString aStr("1010");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 10;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_012( TestResult *oRes )
{
	::rtl::OString aStr("1011");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 11;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_013( TestResult *oRes )
{
	::rtl::OString aStr("1100");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 12;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_014( TestResult *oRes )
{
	::rtl::OString aStr("1101");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 13;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_015( TestResult *oRes )
{
	::rtl::OString aStr("1110");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 14;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_016( TestResult *oRes )
{
	::rtl::OString aStr("1111");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 15;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt32( sal_Int16 radix = 8 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_017( TestResult *oRes )
{
	::rtl::OString aStr("0");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 00;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_018( TestResult *oRes )
{
	::rtl::OString aStr("1");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 01;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_019( TestResult *oRes )
{
	::rtl::OString aStr("2");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 02;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_020( TestResult *oRes )
{
	::rtl::OString aStr("3");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 03;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_021( TestResult *oRes )
{
	::rtl::OString aStr("4");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 04;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_022( TestResult *oRes )
{
	::rtl::OString aStr("5");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 05;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_023( TestResult *oRes )
{
	::rtl::OString aStr("6");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 06;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_024( TestResult *oRes )
{
	::rtl::OString aStr("7");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 07;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_025( TestResult *oRes )
{
	::rtl::OString aStr("10");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 010;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_026( TestResult *oRes )
{
	::rtl::OString aStr("11");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 011;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_027( TestResult *oRes )
{
	::rtl::OString aStr("12");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 012;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_028( TestResult *oRes )
{
	::rtl::OString aStr("13");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 013;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_029( TestResult *oRes )
{
	::rtl::OString aStr("14");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 014;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_030( TestResult *oRes )
{
	::rtl::OString aStr("15");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 015;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_031( TestResult *oRes )
{
	::rtl::OString aStr("16");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 016;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_032( TestResult *oRes )
{
	::rtl::OString aStr("17");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 017;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt32( sal_Int16 radix = 10 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_033( TestResult *oRes )
{
	::rtl::OString aStr("0");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_034( TestResult *oRes )
{
	::rtl::OString aStr("1");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 1;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_035( TestResult *oRes )
{
	::rtl::OString aStr("2");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 2;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_036( TestResult *oRes )
{
	::rtl::OString aStr("3");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 3;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_037( TestResult *oRes )
{
	::rtl::OString aStr("4");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 4;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_038( TestResult *oRes )
{
	::rtl::OString aStr("5");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 5;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_039( TestResult *oRes )
{
	::rtl::OString aStr("6");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 6;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_040( TestResult *oRes )
{
	::rtl::OString aStr("7");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 7;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_041( TestResult *oRes )
{
	::rtl::OString aStr("8");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 8;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_042( TestResult *oRes )
{
	::rtl::OString aStr("9");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 9;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_043( TestResult *oRes )
{
	::rtl::OString aStr("10");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 10;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_044( TestResult *oRes )
{
	::rtl::OString aStr("11");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 11;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_045( TestResult *oRes )
{
	::rtl::OString aStr("12");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 12;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_046( TestResult *oRes )
{
	::rtl::OString aStr("13");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 13;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_047( TestResult *oRes )
{
	::rtl::OString aStr("14");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 14;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_048( TestResult *oRes )
{
	::rtl::OString aStr("15");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 15;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt32( sal_Int16 radix = 16 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_049( TestResult *oRes )
{
	::rtl::OString aStr("0");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x0;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_050( TestResult *oRes )
{
	::rtl::OString aStr("1");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x1;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_051( TestResult *oRes )
{
	::rtl::OString aStr("2");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x2;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_052( TestResult *oRes )
{
	::rtl::OString aStr("3");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x3;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_053( TestResult *oRes )
{
	::rtl::OString aStr("4");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x4;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_054( TestResult *oRes )
{
	::rtl::OString aStr("5");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x5;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_055( TestResult *oRes )
{
	::rtl::OString aStr("6");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x6;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_056( TestResult *oRes )
{
	::rtl::OString aStr("7");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x7;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_057( TestResult *oRes )
{
	::rtl::OString aStr("8");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x8;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_058( TestResult *oRes )
{
	::rtl::OString aStr("9");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x9;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_059( TestResult *oRes )
{
	::rtl::OString aStr("a");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xa;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_060( TestResult *oRes )
{
	::rtl::OString aStr("b");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xb;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_061( TestResult *oRes )
{
	::rtl::OString aStr("c");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xc;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_062( TestResult *oRes )
{
	::rtl::OString aStr("d");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xd;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_063( TestResult *oRes )
{
	::rtl::OString aStr("e");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xe;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_064( TestResult *oRes )
{
	::rtl::OString aStr("f");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xf;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt32( sal_Int16 radix = 36 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_065( TestResult *oRes )
{
	::rtl::OString aStr("0");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x0;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_066( TestResult *oRes )
{
	::rtl::OString aStr("1");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x1;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_067( TestResult *oRes )
{
	::rtl::OString aStr("2");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x2;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_068( TestResult *oRes )
{
	::rtl::OString aStr("3");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x3;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_069( TestResult *oRes )
{
	::rtl::OString aStr("4");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x4;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_070( TestResult *oRes )
{
	::rtl::OString aStr("5");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x5;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_071( TestResult *oRes )
{
	::rtl::OString aStr("6");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x6;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_072( TestResult *oRes )
{
	::rtl::OString aStr("7");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x7;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_073( TestResult *oRes )
{
	::rtl::OString aStr("8");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x8;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_074( TestResult *oRes )
{
	::rtl::OString aStr("9");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x9;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_075( TestResult *oRes )
{
	::rtl::OString aStr("a");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xa;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_076( TestResult *oRes )
{
	::rtl::OString aStr("b");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xb;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_077( TestResult *oRes )
{
	::rtl::OString aStr("c");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xc;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_078( TestResult *oRes )
{
	::rtl::OString aStr("d");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xd;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_079( TestResult *oRes )
{
	::rtl::OString aStr("e");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xe;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_080( TestResult *oRes )
{
	::rtl::OString aStr("f");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xf;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_081( TestResult *oRes )
{
	::rtl::OString aStr("g");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x10;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_082( TestResult *oRes )
{
	::rtl::OString aStr("h");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x11;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_083( TestResult *oRes )
{
	::rtl::OString aStr("i");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x12;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_084( TestResult *oRes )
{
	::rtl::OString aStr("j");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x13;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_085( TestResult *oRes )
{
	::rtl::OString aStr("k");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x14;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_086( TestResult *oRes )
{
	::rtl::OString aStr("l");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x15;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_087( TestResult *oRes )
{
	::rtl::OString aStr("m");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x16;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_088( TestResult *oRes )
{
	::rtl::OString aStr("n");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x17;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_089( TestResult *oRes )
{
	::rtl::OString aStr("o");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x18;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_090( TestResult *oRes )
{
	::rtl::OString aStr("p");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x19;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_091( TestResult *oRes )
{
	::rtl::OString aStr("q");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x1a;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_092( TestResult *oRes )
{
	::rtl::OString aStr("r");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x1b;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_093( TestResult *oRes )
{
	::rtl::OString aStr("s");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x1c;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_094( TestResult *oRes )
{
	::rtl::OString aStr("t");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x1d;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_095( TestResult *oRes )
{
	::rtl::OString aStr("u");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x1e;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_096( TestResult *oRes )
{
	::rtl::OString aStr("v");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x1f;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_097( TestResult *oRes )
{
	::rtl::OString aStr("w");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x20;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_098( TestResult *oRes )
{
	::rtl::OString aStr("x");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x21;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_099( TestResult *oRes )
{
	::rtl::OString aStr("y");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x22;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_100( TestResult *oRes )
{
	::rtl::OString aStr("z");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x23;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt32( sal_Int16 radix = 2 ) for large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_101( TestResult *oRes )
{
	::rtl::OString aStr(kSInt8MaxBinaryStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt8Max;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_102( TestResult *oRes )
{
	::rtl::OString aStr(kUInt8MaxBinaryStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt8Max;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_103( TestResult *oRes )
{
	::rtl::OString aStr(kSInt16MaxBinaryStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt16Max;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_104( TestResult *oRes )
{
	::rtl::OString aStr(kUInt16MaxBinaryStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt16Max;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_105( TestResult *oRes )
{
	::rtl::OString aStr(kSInt32MaxBinaryStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt32Max;
		
	actNum = aStr.toInt32(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt32( sal_Int16 radix = 8 ) for large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_106( TestResult *oRes )
{
	::rtl::OString aStr(kSInt8MaxOctolStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt8Max;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_107( TestResult *oRes )
{
	::rtl::OString aStr(kUInt8MaxOctolStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt8Max;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_108( TestResult *oRes )
{
	::rtl::OString aStr(kSInt16MaxOctolStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt16Max;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_109( TestResult *oRes )
{
	::rtl::OString aStr(kUInt16MaxOctolStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt16Max;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_110( TestResult *oRes )
{
	::rtl::OString aStr(kSInt32MaxOctolStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt32Max;
		
	actNum = aStr.toInt32(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt32( sal_Int16 radix = 10 ) for large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_111( TestResult *oRes )
{
	::rtl::OString aStr(kSInt8MaxDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt8Max;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_112( TestResult *oRes )
{
	::rtl::OString aStr(kUInt8MaxDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt8Max;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_113( TestResult *oRes )
{
	::rtl::OString aStr(kSInt16MaxDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt16Max;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_114( TestResult *oRes )
{
	::rtl::OString aStr(kUInt16MaxDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt16Max;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_115( TestResult *oRes )
{
	::rtl::OString aStr(kSInt32MaxDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt32Max;
		
	actNum = aStr.toInt32(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt32( sal_Int16 radix = 16 ) for large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_116( TestResult *oRes )
{
	::rtl::OString aStr(kSInt8MaxHexDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt8Max;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_117( TestResult *oRes )
{
	::rtl::OString aStr(kUInt8MaxHexDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt8Max;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_118( TestResult *oRes )
{
	::rtl::OString aStr(kSInt16MaxHexDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt16Max;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_119( TestResult *oRes )
{
	::rtl::OString aStr(kUInt16MaxHexDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt16Max;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_120( TestResult *oRes )
{
	::rtl::OString aStr(kSInt32MaxHexDecimalStr);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt32Max;
		
	actNum = aStr.toInt32(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt32( sal_Int16 radix = 36 ) for large constants
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_121( TestResult *oRes )
{
	::rtl::OString aStr(kSInt8MaxBase36Str);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt8Max;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_122( TestResult *oRes )
{
	::rtl::OString aStr(kUInt8MaxBase36Str);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt8Max;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_123( TestResult *oRes )
{
	::rtl::OString aStr(kSInt16MaxBase36Str);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt16Max;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_124( TestResult *oRes )
{
	::rtl::OString aStr(kUInt16MaxBase36Str);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kUInt16Max;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt32_125( TestResult *oRes )
{
	::rtl::OString aStr(kSInt32MaxBase36Str);

	sal_Int32 actNum = 0;
	sal_Int32 expNum = kSInt32Max;
		
	actNum = aStr.toInt32(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt64( sal_Int16 radix = 2 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_001( TestResult *oRes )
{
	::rtl::OString aStr("0");

	sal_Int64 actNum = 0;
	sal_Int64 expNum = 0;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_002( TestResult *oRes )
{
	::rtl::OString aStr("1");

	sal_Int64 actNum = 0;
	sal_Int64 expNum = 1;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_003( TestResult *oRes )
{
	::rtl::OString aStr("10");

	sal_Int64 actNum = 0;
	sal_Int64 expNum = 2;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_004( TestResult *oRes )
{
	::rtl::OString aStr("11");

	sal_Int64 actNum = 0;
	sal_Int64 expNum = 3;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_005( TestResult *oRes )
{
	::rtl::OString aStr("100");

	sal_Int64 actNum = 0;
	sal_Int64 expNum = 4;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_006( TestResult *oRes )
{
	::rtl::OString aStr("101");

	sal_Int64 actNum = 0;
	sal_Int64 expNum = 5;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_007( TestResult *oRes )
{
	::rtl::OString aStr("110");

	sal_Int64 actNum = 0;
	sal_Int64 expNum = 6;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_008( TestResult *oRes )
{
	::rtl::OString aStr("111");

	sal_Int64 actNum = 0;
	sal_Int64 expNum = 7;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_009( TestResult *oRes )
{
	::rtl::OString aStr("1000");

	sal_Int64 actNum = 0;
	sal_Int64 expNum = 8;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_010( TestResult *oRes )
{
	::rtl::OString aStr("1001");

	sal_Int64 actNum = 0;
	sal_Int64 expNum = 9;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_011( TestResult *oRes )
{
	::rtl::OString aStr("1010");

	sal_Int64 actNum = 0;
	sal_Int64 expNum = 10;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_012( TestResult *oRes )
{
	::rtl::OString aStr("1011");

	sal_Int64 actNum = 0;
	sal_Int64 expNum = 11;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_013( TestResult *oRes )
{
	::rtl::OString aStr("1100");

	sal_Int64 actNum = 0;
	sal_Int64 expNum = 12;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_014( TestResult *oRes )
{
	::rtl::OString aStr("1101");

	sal_Int64 actNum = 0;
	sal_Int64 expNum = 13;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_015( TestResult *oRes )
{
	::rtl::OString aStr("1110");

	sal_Int64 actNum = 0;
	sal_Int64 expNum = 14;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_016( TestResult *oRes )
{
	::rtl::OString aStr("1111");

	sal_Int64 actNum = 0;
	sal_Int64 expNum = 15;
		
	actNum = aStr.toInt64(kRadixBinary);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt64( sal_Int16 radix = 8 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_017( TestResult *oRes )
{
	::rtl::OString aStr("0");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 00;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_018( TestResult *oRes )
{
	::rtl::OString aStr("1");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 01;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_019( TestResult *oRes )
{
	::rtl::OString aStr("2");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 02;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_020( TestResult *oRes )
{
	::rtl::OString aStr("3");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 03;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_021( TestResult *oRes )
{
	::rtl::OString aStr("4");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 04;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_022( TestResult *oRes )
{
	::rtl::OString aStr("5");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 05;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_023( TestResult *oRes )
{
	::rtl::OString aStr("6");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 06;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_024( TestResult *oRes )
{
	::rtl::OString aStr("7");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 07;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_025( TestResult *oRes )
{
	::rtl::OString aStr("10");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 010;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_026( TestResult *oRes )
{
	::rtl::OString aStr("11");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 011;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_027( TestResult *oRes )
{
	::rtl::OString aStr("12");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 012;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_028( TestResult *oRes )
{
	::rtl::OString aStr("13");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 013;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_029( TestResult *oRes )
{
	::rtl::OString aStr("14");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 014;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_030( TestResult *oRes )
{
	::rtl::OString aStr("15");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 015;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_031( TestResult *oRes )
{
	::rtl::OString aStr("16");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 016;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_032( TestResult *oRes )
{
	::rtl::OString aStr("17");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 017;
		
	actNum = aStr.toInt64(kRadixOctol);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt64( sal_Int16 radix = 10 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_033( TestResult *oRes )
{
	::rtl::OString aStr("0");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_034( TestResult *oRes )
{
	::rtl::OString aStr("1");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 1;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_035( TestResult *oRes )
{
	::rtl::OString aStr("2");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 2;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_036( TestResult *oRes )
{
	::rtl::OString aStr("3");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 3;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_037( TestResult *oRes )
{
	::rtl::OString aStr("4");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 4;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_038( TestResult *oRes )
{
	::rtl::OString aStr("5");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 5;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_039( TestResult *oRes )
{
	::rtl::OString aStr("6");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 6;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_040( TestResult *oRes )
{
	::rtl::OString aStr("7");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 7;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_041( TestResult *oRes )
{
	::rtl::OString aStr("8");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 8;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_042( TestResult *oRes )
{
	::rtl::OString aStr("9");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 9;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_043( TestResult *oRes )
{
	::rtl::OString aStr("10");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 10;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_044( TestResult *oRes )
{
	::rtl::OString aStr("11");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 11;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_045( TestResult *oRes )
{
	::rtl::OString aStr("12");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 12;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_046( TestResult *oRes )
{
	::rtl::OString aStr("13");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 13;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_047( TestResult *oRes )
{
	::rtl::OString aStr("14");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 14;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_048( TestResult *oRes )
{
	::rtl::OString aStr("15");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 15;
		
	actNum = aStr.toInt64(kRadixDecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt64( sal_Int16 radix = 16 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_049( TestResult *oRes )
{
	::rtl::OString aStr("0");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x0;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_050( TestResult *oRes )
{
	::rtl::OString aStr("1");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x1;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_051( TestResult *oRes )
{
	::rtl::OString aStr("2");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x2;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_052( TestResult *oRes )
{
	::rtl::OString aStr("3");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x3;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_053( TestResult *oRes )
{
	::rtl::OString aStr("4");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x4;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_054( TestResult *oRes )
{
	::rtl::OString aStr("5");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x5;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_055( TestResult *oRes )
{
	::rtl::OString aStr("6");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x6;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_056( TestResult *oRes )
{
	::rtl::OString aStr("7");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x7;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_057( TestResult *oRes )
{
	::rtl::OString aStr("8");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x8;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_058( TestResult *oRes )
{
	::rtl::OString aStr("9");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x9;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_059( TestResult *oRes )
{
	::rtl::OString aStr("a");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xa;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_060( TestResult *oRes )
{
	::rtl::OString aStr("b");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xb;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_061( TestResult *oRes )
{
	::rtl::OString aStr("c");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xc;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_062( TestResult *oRes )
{
	::rtl::OString aStr("d");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xd;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_063( TestResult *oRes )
{
	::rtl::OString aStr("e");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xe;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_064( TestResult *oRes )
{
	::rtl::OString aStr("f");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xf;
		
	actNum = aStr.toInt64(kRadixHexdecimal);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------
//
// testing the method toInt32( sal_Int16 radix = 36 )
//
//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_065( TestResult *oRes )
{
	::rtl::OString aStr("0");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x0;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_066( TestResult *oRes )
{
	::rtl::OString aStr("1");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x1;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_067( TestResult *oRes )
{
	::rtl::OString aStr("2");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x2;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_068( TestResult *oRes )
{
	::rtl::OString aStr("3");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x3;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_069( TestResult *oRes )
{
	::rtl::OString aStr("4");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x4;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_070( TestResult *oRes )
{
	::rtl::OString aStr("5");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x5;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_071( TestResult *oRes )
{
	::rtl::OString aStr("6");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x6;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_072( TestResult *oRes )
{
	::rtl::OString aStr("7");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x7;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_073( TestResult *oRes )
{
	::rtl::OString aStr("8");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x8;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_074( TestResult *oRes )
{
	::rtl::OString aStr("9");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x9;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_075( TestResult *oRes )
{
	::rtl::OString aStr("a");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xa;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_076( TestResult *oRes )
{
	::rtl::OString aStr("b");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xb;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_077( TestResult *oRes )
{
	::rtl::OString aStr("c");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xc;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_078( TestResult *oRes )
{
	::rtl::OString aStr("d");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xd;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_079( TestResult *oRes )
{
	::rtl::OString aStr("e");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xe;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_080( TestResult *oRes )
{
	::rtl::OString aStr("f");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0xf;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_081( TestResult *oRes )
{
	::rtl::OString aStr("g");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x10;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_082( TestResult *oRes )
{
	::rtl::OString aStr("h");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x11;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_083( TestResult *oRes )
{
	::rtl::OString aStr("i");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x12;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_084( TestResult *oRes )
{
	::rtl::OString aStr("j");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x13;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_085( TestResult *oRes )
{
	::rtl::OString aStr("k");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x14;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_086( TestResult *oRes )
{
	::rtl::OString aStr("l");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x15;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_087( TestResult *oRes )
{
	::rtl::OString aStr("m");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x16;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_088( TestResult *oRes )
{
	::rtl::OString aStr("n");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x17;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_089( TestResult *oRes )
{
	::rtl::OString aStr("o");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x18;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_090( TestResult *oRes )
{
	::rtl::OString aStr("p");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x19;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_091( TestResult *oRes )
{
	::rtl::OString aStr("q");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x1a;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_092( TestResult *oRes )
{
	::rtl::OString aStr("r");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x1b;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_093( TestResult *oRes )
{
	::rtl::OString aStr("s");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x1c;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_094( TestResult *oRes )
{
	::rtl::OString aStr("t");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x1d;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_095( TestResult *oRes )
{
	::rtl::OString aStr("u");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x1e;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_096( TestResult *oRes )
{
	::rtl::OString aStr("v");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x1f;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_097( TestResult *oRes )
{
	::rtl::OString aStr("w");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x20;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_098( TestResult *oRes )
{
	::rtl::OString aStr("x");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x21;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_099( TestResult *oRes )
{
	::rtl::OString aStr("y");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x22;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OString_toInt64_100( TestResult *oRes )
{
	::rtl::OString aStr("z");

	sal_Int32 actNum = 0;
	sal_Int32 expNum = 0x23;
		
	actNum = aStr.toInt64(kRadixBase36);

	oRes->state( actNum == expNum );
}

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

