/*************************************************************************
 *
 *  $RCSfile: exccomp.cxx,v $
 *
 *  $Revision: 1.23.2.2 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 16:28:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
// xl_comp.cpp : implementation file
/////////////////////////////////////////////////////////////////////////////

#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------------

#include <string.h>
#ifdef BLC
#include <ctype.h>		// BLC Extrawurst: toupper()
#endif
#ifdef MAC
#include <ctype.h>		// MAC Extrawurst: toupper()
#endif

#include <tools/debug.hxx>

#include "document.hxx"
#include "global.hxx"
#include "compiler.hxx"
#include "rangenam.hxx"
#include "dbcolect.hxx"

#include "functab.h"
#include "excupn.hxx"
#include "namebuff.hxx"
#include "root.hxx"
#include "XclAddInNameTrans.hxx"

#include "xcl97rec.hxx"

#ifndef _SC_XCLEXPEXTERNSHEET_HXX
#include "XclExpExternsheet.hxx"
#endif

const UINT8 ptgExp			= 0x01;
const UINT8 ptgTbl			= 0x02;
const UINT8 ptgAdd 			= 0x03;
const UINT8 ptgSub			= 0x04;
const UINT8 ptgMul 			= 0x05;
const UINT8 ptgDiv			= 0x06;
const UINT8 ptgPower		= 0x07;
const UINT8 ptgConcat		= 0x08;
const UINT8 ptgLT 			= 0x09;
const UINT8 ptgLE			= 0x0a;
const UINT8 ptgEQ			= 0x0b;
const UINT8 ptgGE			= 0x0c;
const UINT8 ptgGT			= 0x0d;
const UINT8 ptgNE			= 0x0e;
const UINT8 ptgIsect		= 0x0f;
const UINT8 ptgUnion		= 0x10;
const UINT8 ptgRange		= 0x11;
const UINT8 ptgUplus		= 0x12;
const UINT8 ptgUminus		= 0x13;
const UINT8 ptgPercent		= 0x14;
const UINT8 ptgParen		= 0x15;		// no more real operators from here on
const UINT8 ptgMissArg		= 0x16;
const UINT8 ptgStr			= 0x17;
const UINT8	ptgExtend		= 0x18;
const UINT8 ptgAttr			= 0x19;
const UINT8 ptgSheet		= 0x1a;
const UINT8 ptgEndSheet		= 0x1b;
const UINT8 ptgErr			= 0x1c;
const UINT8 ptgBool			= 0x1d;
const UINT8 ptgInt			= 0x1e;
const UINT8 ptgNum			= 0x1f;

const UINT8 ptgArray		= 0x20;
const UINT8 ptgFunc			= 0x21;
const UINT8 ptgFuncVar		= 0x22;
const UINT8 ptgName			= 0x23;
const UINT8 ptgRef			= 0x24;
const UINT8 ptgArea			= 0x25;
const UINT8 ptgMemArea		= 0x26;
const UINT8 ptgMemErr		= 0x27;
const UINT8 ptgMemNoMem		= 0x28;
const UINT8 ptgMemFunc		= 0x29;
const UINT8 ptgRefErr		= 0x2a;
const UINT8 ptgAreaErr		= 0x2b;
const UINT8 ptgRefN			= 0x2c;
const UINT8 ptgAreaN		= 0x2d;
const UINT8 ptgMemAreaN		= 0x2e;
const UINT8 ptgMemNoMemN	= 0x2f;
const UINT8 ptgNameX		= 0x39;
const UINT8 ptgRef3d		= 0x3a;
const UINT8 ptgArea3d		= 0x3b;
const UINT8 ptgRefErr3d		= 0x3c;
const UINT8 ptgAreaErr3d	= 0x3d;

const UINT8 ptgArrayV		= 0x40;
const UINT8 ptgFuncV		= 0x41;
const UINT8 ptgFuncVarV		= 0x42;
const UINT8 ptgNameV		= 0x43;
const UINT8 ptgRefV			= 0x44;
const UINT8 ptgAreaV		= 0x45;
const UINT8 ptgMemAreaV		= 0x46;
const UINT8 ptgMemErrV		= 0x47;
const UINT8 ptgMemNoMemV	= 0x48;
const UINT8 ptgMemFuncV		= 0x49;
const UINT8 ptgRefErrV		= 0x4a;
const UINT8 ptgAreaErrV		= 0x4b;
const UINT8 ptgRefNV		= 0x4c;
const UINT8 ptgAreaNV		= 0x4d;
const UINT8 ptgMemAreaNV	= 0x4e;
const UINT8 ptgMemNoMemNV	= 0x4f;
const UINT8 ptgFuncCEV		= 0x58;
const UINT8 ptgNameXV		= 0x59;
const UINT8 ptgRef3dV		= 0x5a;
const UINT8 ptgArea3dV		= 0x5b;
const UINT8 ptgRefErr3dV	= 0x5c;
const UINT8 ptgAreaErr3dV	= 0x5d;

const UINT8 ptgArrayA		= 0x60;
const UINT8 ptgFuncA		= 0x61;
const UINT8 ptgFuncVarA		= 0x62;
const UINT8 ptgNameA		= 0x63;
const UINT8 ptgRefA			= 0x64;
const UINT8 ptgAreaA		= 0x65;
const UINT8 ptgMemAreaA		= 0x66;
const UINT8 ptgMemErrA		= 0x67;
const UINT8 ptgMemNoMemA	= 0x68;
const UINT8 ptgMemFuncA		= 0x69;
const UINT8 ptgRefErrA		= 0x6a;
const UINT8 ptgAreaErrA		= 0x6b;
const UINT8 ptgRefNA		= 0x6c;
const UINT8 ptgAreaNA		= 0x6d;
const UINT8 ptgMemAreaNA	= 0x6e;
const UINT8 ptgMemNoMemNA	= 0x6f;
const UINT8 ptgFuncCEA		= 0x78;
const UINT8 ptgNameXA		= 0x79;
const UINT8 ptgRef3dA		= 0x7a;
const UINT8 ptgArea3dA		= 0x7b;
const UINT8 ptgRefErr3dA	= 0x7c;
const UINT8 ptgAreaErr3dA	= 0x7d;

// Dieses ptg ist kein Excel ptg sonder nur fuer den internen Gebrauch

const UINT8 ptgSep			= 0xFF;


const UINT16 nRefValueNone	= 0x00;
const UINT16 nRefValueLast	= 0x01;
const UINT16 nRefValuePrev	= 0x02;
const UINT16 nRefValueBoth	= nRefValuePrev | nRefValueLast;

struct OpTable { UINT16 cScOp, cExOp, nRefValueClass; };

//! most used operators first
static const OpTable aOpTab[] = {
	{ ocSep			, ptgSep	, nRefValueNone	},
	{ ocOpen		, ptgParen	, nRefValueNone	},
	{ ocClose		, ptgParen	, nRefValueNone	},
	{ ocAdd			, ptgAdd	, nRefValueBoth	},
	{ ocSub			, ptgSub	, nRefValueBoth	},
	{ ocMul			, ptgMul	, nRefValueBoth	},
	{ ocDiv			, ptgDiv	, nRefValueBoth	},
	{ ocPow			, ptgPower	, nRefValueBoth	},
	{ ocLess		, ptgLT		, nRefValueBoth	},
	{ ocLessEqual	, ptgLE		, nRefValueBoth	},
	{ ocEqual		, ptgEQ		, nRefValueBoth	},
	{ ocGreaterEqual, ptgGE		, nRefValueBoth	},
	{ ocGreater		, ptgGT		, nRefValueBoth	},
	{ ocNotEqual	, ptgNE		, nRefValueBoth	},
	{ ocNegSub		, ptgUminus	, nRefValueLast	},
	{ ocAmpersand	, ptgConcat	, nRefValueBoth	},
	{ ocIntersect	, ptgIsect	, nRefValueNone	},
	{ ocUnion		, ptgUnion	, nRefValueNone	},
	{ ocRange		, ptgRange	, nRefValueNone	},
    { ocPercentSign , ptgPercent, nRefValueLast },
	{ ocNone		, ptgUplus	, nRefValueLast	},
	{ ocMissing		, ptgMissArg, nRefValueNone	}
};
#define OPTABSIZE	(sizeof(aOpTab) / sizeof(OpTable))




ExcUPN* CreateExcUpnFromScRangeList( RootData& rRD, ScRangeList& rRL )
{
	ScTokenArray	aArr;
	if( rRL.Count() == 1 )
	{
		ScRange*	pR = rRL.First();
		if( pR->aStart == pR->aEnd )
		{
			SingleRefData		aRef;
			aRef.InitAddress( pR->aStart );
			aArr.AddSingleReference( aRef );
		}
		else
		{
			ComplRefData		aRef;
			aRef.InitRange( *pR );
			aArr.AddDoubleReference( aRef );
		}
	}
	else
	{
		aArr.AddOpCode( ocOpen );
		BOOL					bFirst = TRUE;
		for( ScRange* pR = rRL.First(); pR; pR = rRL.Next() )
		{
			if( bFirst )
				bFirst = FALSE;
			else
				aArr.AddOpCode( ocUnion );
			if( pR->aStart == pR->aEnd )
			{
				SingleRefData	aRef;
				aRef.InitAddress( pR->aStart );
				aArr.AddSingleReference( aRef );
			}
			else
			{
				ComplRefData	aRef;
				aRef.InitRange( *pR );
				aArr.AddDoubleReference( aRef );
			}
		}
		aArr.AddOpCode( ocClose );
	}
	// Address*==NULL => all references will have Reference-Class
//	rUL.Append( new ExcUPN( &rRD, aArr, NULL ) );
	EC_Codetype			eDummy;
	return new ExcUPN( &rRD, aArr, eDummy );
}




ExcUPNList::~ExcUPNList()
{
	ULONG		n = List::Count();
	ExcUPN*		p = ( ExcUPN* ) List::First();
	while( n )
	{
		delete p;
		p = ( ExcUPN* ) List::Next();
		n--;
	}
}




SToken::SToken( void )
{
}


SToken::SToken( const SToken& r ) :
	ptg( r.ptg ),
	aStr( r.aStr )
{
		memcpy( Data, r.Data, nMaxTokenLen );
}


// ------------------------------------------------------------- class ExcUPN -

CExcelCompiler::CExcelCompiler( RootData* pRD, const ScTokenArray& rArr, const ScAddress* pAddr, BOOL bCF ) :
	eRefClHandl( pAddr? RCH_Cell : RCH_Name ),
	pCode( &rArr ),
	ExcRoot( pRD )
{
	m_sFormulaRec.nLen = 0;
	m_sFormulaRec.nCce = 0;
	m_nError = 0;
	m_pc = 0;
	m_nParamType = nTypeVal;
    m_nFuncParamType = nTypeErr;
	m_nLastPtg = 0;
	m_pPrevRef = NULL;
	m_pLastRef = NULL;
	m_bDelCode = FALSE;

	pAddress = pAddr;
	bCondForm = bCF;

	nShrdFmla = 0;
	pShrdFmla = 0;
	bFirstShrdFmla = TRUE;

	nArrayFormId = 0xFFFFFFFF;
}


CExcelCompiler::~CExcelCompiler()
{
	if( m_bDelCode )
		delete pCode;

	if( pShrdFmla )
		delete[] pShrdFmla;
}


inline UINT8 CExcelCompiler::GetPtgBase( UINT8 nPtg )
{
	return( ( nPtg & 0x40 ) ? ( nPtg | 0x20 ) : nPtg ) & 0x3f;
}


void CExcelCompiler::SetError( UINT16 nError )
{
	if( m_nError == 0 )
		m_nError = nError;
}


UINT16 CExcelCompiler::GetOperatorValueClass( UINT8 nPtg )
{
	const OpTable* p = &aOpTab[0];
	const OpTable* pStop = p + OPTABSIZE;
	for ( ; p < pStop; p++ )
	{
		if( nPtg == p->cExOp )
			return p->nRefValueClass;
	}
	return nRefValueNone;
}


BOOL CExcelCompiler::IsOperator()
{
	UINT16 nOp = (UINT16) pCur->GetOpCode();
	const OpTable* p = &aOpTab[0];
	const OpTable* pStop = p + OPTABSIZE;
	for ( ; p < pStop; p++ )
	{
		if( nOp == p->cScOp )
		{
			m_Token.ptg = (UINT8) p->cExOp;
			return TRUE;
		}
	}
	return FALSE;
}


BOOL CExcelCompiler::IsValue()
{
	if( pCur->GetType() == svDouble )
	{
		m_Token.ptg = ptgNum;
		m_Token.Set( 0, pCur->GetDouble() );	// !ACHTUNG: nValue is'n double!
		return TRUE;
	}
	else
		return FALSE;
}


BOOL CExcelCompiler::IsString()
{
	if( pCur->GetType() == svString )
	{
		m_Token.ptg = ptgStr;
		m_Token.aStr = pCur->GetString();
		return TRUE;
	}
	else
		return FALSE;
}


BOOL CExcelCompiler::IsFunc()
{
	pFuncData = GetFuncData( pCur->GetOpCode() );
	if( pFuncData )
	{
		if (pFuncData->nFuncType == nTypeRef)
		{
			if (pFuncData->nParamCount == nVarParam)
				m_Token.ptg = ptgFuncVar;
			else
				m_Token.ptg = ptgFunc;
		}
		else if (pFuncData->nFuncType == nTypeVal)
		{
			if (pFuncData->nParamCount == nVarParam)
				m_Token.ptg = //( bRefClassInCell ? ptgFuncVarV : ptgFuncVarA );
								GetPtg( ptgFuncVarV, ptgFuncVarA, ptgFuncVarV );
			else
				m_Token.ptg = //( bRefClassInCell ? ptgFuncV : ptgFuncA );
								GetPtg( ptgFuncV, ptgFuncA, ptgFuncV );
//				m_Token.ptg = ( pAddress ? ptgFuncVarV : ptgFuncVarA );
//			else
//				m_Token.ptg = ( pAddress ? ptgFuncV : ptgFuncA );
		}
		else if (pFuncData->nFuncType == nTypeArr)
		{
			if (pFuncData->nParamCount == nVarParam)
				m_Token.ptg = ptgFuncVarA;
			else
				m_Token.ptg = ptgFuncA;
		}
		else
			SetError(nErrUnknownFuncType);
		if (pFuncData->nParamCount == nVarParam)
			m_Token.Set( 1, pFuncData->nIndex );
		else
			m_Token.Set( 0, pFuncData->nIndex );
		return TRUE;
	}
	else
		return FALSE;
}


inline BOOL CExcelCompiler::IsRefDeleted( const SingleRefData& rSRD )
{
	if ( pAddress )
		return rSRD.IsColDeleted() || rSRD.IsRowDeleted();
	return (!rSRD.IsColRel() && rSRD.IsColDeleted()) ||
		(!rSRD.IsRowRel() && rSRD.IsRowDeleted());
}


inline BOOL CExcelCompiler::IsRefExternal( const SingleRefData& rSRD )
{
    return pExcRoot->pTabBuffer->IsExternal( (UINT16) rSRD.nTab );
}


// converts Calc table numbers to Excel numbers
UINT16 CExcelCompiler::GetTabNum( const SingleRefData& rSRD )
{
	//! there are no relative table references in range names (pAddress==NULL)
	if ( rSRD.IsTabDeleted() )
		return 0xFFFF;
	return pExcRoot->pTabBuffer->GetExcTable( (UINT16) rSRD.nTab );
}


BOOL CExcelCompiler::IsReference()
{
	if ( pExcRoot->eDateiTyp >= Biff8 )
		return IsReferenceBiff8();

	if( pCur->GetType() == svDoubleRef )
	{
		const ComplRefData& rRef = pCur->GetDoubleRef();
		SingleRefData	aSRD1( rRef.Ref1 );
		SingleRefData	aSRD2( rRef.Ref2 );

		UINT16			nBitRowFirst, nBitRowLast;
		UINT8			nBitColFirst, nBitColLast;
		BOOL			bExc3D;

		m_nParamType = nTypeRef;

		if( pAddress )
		{	// in cell-formula
			CalcBitsAbs( aSRD1, nBitRowFirst, nBitColFirst );
			CalcBitsAbs( aSRD2, nBitRowLast, nBitColLast );
			// absolute Tabellen-Angabe ist nach CalcBitsAbs() auf jeden Fall gueltig!

			bExc3D = !( aSRD1.IsTabRel() && aSRD2.IsTabRel() &&
						aSRD1.nRelTab == 0 && aSRD2.nRelTab == 0 );
		}
		else
		{	// in named range
			CalcBitsRel( aSRD1, nBitRowFirst, nBitColFirst );
			CalcBitsRel( aSRD2, nBitRowLast, nBitColLast );

			if( aSRD1.IsTabRel() )
			{
				if( aSRD2.IsTabRel() )
				{
					if( aSRD1.nRelTab == 0 && aSRD2.nRelTab == 0 )
						bExc3D = FALSE;
					else
						return FALSE;	// ############ KRUECKE FUER FEHLERFALL! #########
				}
				else
					return FALSE;		// ############ KRUECKE FUER FEHLERFALL! #########
			}
			else if( aSRD2.IsTabRel() )
				return FALSE;
			else
				bExc3D = TRUE;
		}

		if( bExc3D )
		{
            m_Token.ptg = (IsRefDeleted( aSRD1 ) || IsRefDeleted( aSRD2 ) || IsRefExternal( aSRD1 ) || IsRefExternal( aSRD2 )) ?
                ptgAreaErr3d : ptgArea3d;
			m_Token.Set( 0, ( UINT16 ) 0xFFFF );
			memset( &m_Token.Data[ 2 ], 0, 8 );
			m_Token.Set( 10, GetTabNum( aSRD1 ) );
			m_Token.Set( 12, GetTabNum( aSRD2 ) );
			m_Token.Set( 14, nBitRowFirst );
			m_Token.Set( 16, nBitRowLast );
			m_Token.Set( 18, nBitColFirst );
			m_Token.Set( 19, nBitColLast );
		}
		else
		{	// Named Ranges nur OHNE Tab-Nummern, wenn Tab relativ!
			m_Token.ptg = ((IsRefDeleted( aSRD1 ) || IsRefDeleted( aSRD2 ))
				? ptgAreaErr : ptgArea);
			m_Token.Set( 0, nBitRowFirst );
			m_Token.Set( 2, nBitRowLast );
			m_Token.Data[ 4 ] = nBitColFirst;
			m_Token.Data[ 5 ] = nBitColLast;
		}

		return TRUE;
	}
	else if( pCur->GetType() == svSingleRef )
	{
		SingleRefData	aSingRef( pCur->GetSingleRef() );

		UINT16			nBitRow;
		UINT8			nBitCol;
		BOOL			bExc3D;

		m_nParamType = nTypeRef;

		if( pAddress )
		{
			// in cell-formula
			CalcBitsAbs( aSingRef, nBitRow, nBitCol );

			bExc3D = !( aSingRef.IsTabRel() && aSingRef.nRelTab == 0 );
		}
		else
		{
			// in named range
			CalcBitsRel( aSingRef, nBitRow, nBitCol );

			if( aSingRef.IsTabRel() )
			{
				if( aSingRef.nRelTab == 0 )
					bExc3D = FALSE;
				else
					return FALSE;		// ############ KRUECKE FUER FEHLERFALL! #########
			}
			else
				bExc3D = TRUE;
		}

		if( bExc3D )
		{
            m_Token.ptg = (IsRefDeleted( aSingRef ) || IsRefExternal( aSingRef )) ? ptgRefErr3d : ptgRef3d;
			m_Token.Set( 0, ( UINT16 ) 0xFFFF );
			memset( &m_Token.Data[ 2 ], 0, 8 );
			UINT16 nTab = GetTabNum( aSingRef );
			m_Token.Set( 10, nTab );
			m_Token.Set( 12, nTab );
			m_Token.Set( 14, nBitRow );
			m_Token.Data[ 16 ] = nBitCol;
		}
		else
		{
			m_Token.ptg = (IsRefDeleted( aSingRef ) ? ptgRefErr : ptgRef);
			m_Token.Set( 0, nBitRow );
			m_Token.Data[ 2 ] = nBitCol;
		}
		return TRUE;
	}
	return FALSE;
}


BOOL CExcelCompiler::IsReferenceBiff8()
{
	if( pCur->GetType() == svDoubleRef )
	{
		const ComplRefData& rRef = pCur->GetDoubleRef();
		SingleRefData	aSRD1( rRef.Ref1 );
		SingleRefData	aSRD2( rRef.Ref2 );

		UINT16			nBitRowFirst, nBitRowLast;
		UINT16			nBitColFirst, nBitColLast;
		BOOL			bExc3D;

		m_nParamType = nTypeRef;

		if( pAddress )
		{	// in cell formula
			CalcBitsAbsBiff8( aSRD1, nBitRowFirst, nBitColFirst );
			CalcBitsAbsBiff8( aSRD2, nBitRowLast, nBitColLast );
			// absolute table ref values are now valid!

			// store cell contents in CRN records
			pExcRoot->pExternsheetRecs->StoreCellRange( aSRD1, aSRD2 );

			bExc3D = !( aSRD1.IsTabRel() && aSRD2.IsTabRel() &&
						aSRD1.nRelTab == 0 && aSRD2.nRelTab == 0 );
		}
		else
		{	// in named range
			CalcBitsRelBiff8( aSRD1, nBitRowFirst, nBitColFirst );
			CalcBitsRelBiff8( aSRD2, nBitRowLast, nBitColLast );

			if( aSRD1.IsTabRel() )
			{
				if( aSRD2.IsTabRel() )
				{
					if( aSRD1.nRelTab == 0 && aSRD2.nRelTab == 0 )
						bExc3D = FALSE;
					else
						return FALSE;	// ############ KRUECKE FUER FEHLERFALL! #########
				}
				else
					return FALSE;		// ############ KRUECKE FUER FEHLERFALL! #########
			}
			else if( aSRD2.IsTabRel() )
				return FALSE;
			else
				bExc3D = TRUE;
		}

		if( bExc3D )
		{
			UINT16 nFirstTab = GetTabNum( aSRD1 );
			UINT16 nLastTab = GetTabNum( aSRD2 );
			pExcRoot->pTabBuffer->AppendTabRef( nFirstTab, nLastTab );

			m_Token.ptg = ((IsRefDeleted( aSRD1 ) || IsRefDeleted( aSRD2 ))
				? ptgAreaErr3d : ptgArea3d);
			m_Token.Set( 0, pExcRoot->pExternsheetRecs->Find( nFirstTab, nLastTab ) );
			m_Token.Set( 2, nBitRowFirst );
			m_Token.Set( 4, nBitRowLast );
			m_Token.Set( 6, nBitColFirst );
			m_Token.Set( 8, nBitColLast );
		}
		else
		{	// named ranges only without table refs if table ref is relative
			m_Token.ptg = ((IsRefDeleted( aSRD1 ) || IsRefDeleted( aSRD2 ))
				? ptgAreaErr : ( bCondForm? ptgAreaN : ptgArea ) );
			m_Token.Set( 0, nBitRowFirst );
			m_Token.Set( 2, nBitRowLast );
			m_Token.Set( 4, nBitColFirst );
			m_Token.Set( 6, nBitColLast );
		}

		return TRUE;
	}
	else if( pCur->GetType() == svSingleRef )
	{
		SingleRefData	aSingRef( pCur->GetSingleRef() );

		if( pCur->GetOpCode() == ocColRowName )
		{
            UINT8           nType = aSingRef.IsColRel() ? 0x07 : 0x06;       // just 4 testing
			UINT16			nRow = ( UINT16 ) aSingRef.nRow;
			UINT16			nCol = ( UINT16 ) aSingRef.nCol | 0x8000;

			m_Token.ptg = ptgExtend;
			m_Token.Set( 0, nType );
			m_Token.Set( 1, nRow );
			m_Token.Set( 3, nCol );
		}
		else
		{
			UINT16			nBitRow, nBitCol;
			BOOL			bExc3D;

			m_nParamType = nTypeRef;

			if( pAddress )
			{
				// in cell formula
				CalcBitsAbsBiff8( aSingRef, nBitRow, nBitCol );

				// store cell contents in CRN records
				pExcRoot->pExternsheetRecs->StoreCellCont( aSingRef );

				bExc3D = !( aSingRef.IsTabRel() && aSingRef.nRelTab == 0 );
			}
			else
			{
				// in named range
				CalcBitsRelBiff8( aSingRef, nBitRow, nBitCol );

				if( aSingRef.IsTabRel() )
				{
					if( aSingRef.nRelTab == 0 )
						bExc3D = FALSE;
					else
						return FALSE;		// ############ KRUECKE FUER FEHLERFALL! #########
				}
				else
					bExc3D = TRUE;
			}

			if( bExc3D )
			{
				UINT16 nTab = GetTabNum( aSingRef );
				pExcRoot->pTabBuffer->AppendTabRef( nTab, nTab );

				m_Token.ptg = (IsRefDeleted( aSingRef ) ? ptgRefErr3d : ptgRef3d);
				m_Token.Set( 0, pExcRoot->pExternsheetRecs->Find( nTab, nTab ) );
				m_Token.Set( 2, nBitRow );
				m_Token.Set( 4, nBitCol );
			}
			else
			{
				m_Token.ptg = (IsRefDeleted( aSingRef ) ? ptgRefErr : ( bCondForm? ptgRefN : ptgRef ) );
				m_Token.Set( 0, nBitRow );
				m_Token.Set( 2, nBitCol );
			}
		}
		return TRUE;
	}
	return FALSE;
}


BOOL CExcelCompiler::IsNamedRange()
{
	if( pCur->GetOpCode() == ocName )
	{
		ScRangeData* p =
			pExcRoot->pDoc->GetRangeName()->FindIndex( pCur->GetIndex() );
		if( !p )
			SetError( nErrIllegalToken );
		else
		{
			UINT16 nIdx = p->GetExportIndex();
			m_Token.ptg = ptgName;
			m_Token.Set( 0, nIdx );
			if ( pExcRoot->eDateiTyp >= Biff8 )
				m_Token.Set( 2, UINT16(0) );
			else
				memset(&m_Token.Data[2], 0, 12);
		}
		return TRUE;
	}
	else
		return FALSE;
}


BOOL CExcelCompiler::IsDBArea()
{
	if( pCur->GetOpCode() == ocDBArea )
	{
		ScDBData* p =
			pExcRoot->pDoc->GetDBCollection()->FindIndex( pCur->GetIndex() );
		if( !p )
			SetError( nErrIllegalToken );
		else
		{
			UINT16 nIdx = p->GetExportIndex();
			m_Token.ptg = ptgName;		//! yes, exported as named range
			m_Token.Set( 0, nIdx );
			if ( pExcRoot->eDateiTyp >= Biff8 )
				m_Token.Set( 2, UINT16(0) );
			else
				memset(&m_Token.Data[2], 0, 12);
		}
		return TRUE;
	}
	else
		return FALSE;
}


BOOL CExcelCompiler::IsDDE()
{
    if( (pCur->GetOpCode() != ocDde) || (pExcRoot->eDateiTyp < Biff8) ) // #94922# BIFF8 only!
        return FALSE;

    String aApplic, aDoc, aRef;
    enum
    {
        stBegin, stOpen, stApplic, stApplicSep, stDoc, stDocSep, stRef, stClose, stError
    } eState = stBegin; // last read token

    while( (eState != stError) && (eState != stClose) )
    {
        BOOL bOK = GetNextToken();
        if( bOK && pCur )
        {
            OpCode eOpCode = pCur->GetOpCode();
            BOOL bIsSep = (eOpCode == ocSep);
            BOOL bIsStr = (eOpCode == ocPush) && (pCur->GetType() == svString);

            if( eOpCode != ocSpaces )
            {
                switch( eState )
                {
                    case stBegin:
                        eState = (eOpCode == ocOpen) ? stOpen : stError;
                    break;
                    case stOpen:
                        eState = bIsStr ? stApplic : stError;
                        if( bIsStr )
                            aApplic = pCur->GetString();
                    break;
                    case stApplic:
                        eState = bIsSep ? stApplicSep : stError;
                    break;
                    case stApplicSep:
                        eState = bIsStr ? stDoc : stError;
                        if( bIsStr )
                            aDoc = pCur->GetString();
                    break;
                    case stDoc:
                        eState = bIsSep ? stDocSep : stError;
                    break;
                    case stDocSep:
                        eState = bIsStr ? stRef : stError;
                        if( bIsStr )
                            aRef = pCur->GetString();
                    break;
                    case stRef:
                        eState = (eOpCode == ocClose) ? stClose : stError;
                    break;
                    default:
                        eState = stError;
                }
            }
        }
        else
            eState = stError;
	}
    BOOL bRet = (eState != stError) && aApplic.Len() && aDoc.Len() && aRef.Len();
    if( bRet )
    {
        UINT16 nXti, nExtname;
        bRet = pExcRoot->pExternsheetRecs->InsertDDE( nXti, nExtname, aApplic, aDoc, aRef );
        if( bRet )
        {
            m_Token.ptg = ptgNameXV;
            m_Token.Set( 0, nXti );
            m_Token.Set( 2, nExtname );
            m_Token.Set( 4, (UINT16) 0 );
        }
    }
    return bRet;
}


BOOL CExcelCompiler::GetNextToken()
{
	BOOL bFirst = ( m_nLastPtg == 0 && m_Token.ptg == 0 );
	BOOL bFirstRef;
	if ( m_nLastPtg != 0 )
		bFirstRef = FALSE;
	else
	{
		switch ( m_Token.ptg )
		{
			case ptgRef :
			case ptgRef3d :
			case ptgArea :
			case ptgArea3d :
				bFirstRef = TRUE;
				break;
			case ptgRefN:
			case ptgAreaN:
				bFirstRef = bCondForm;
				break;
			default:
				bFirstRef = FALSE;
		}
	}
	m_nLastPtg = m_Token.ptg;
	m_Token.ptg = 0;
	m_nParamType = nTypeVal;

	do
	{
		pCur = ((ScTokenArray*) pCode)->Next();
	}
	while( pCur && pCur->GetOpCode() == ocSpaces );

	if( pCur )
	{
		if ( IsOperator() )
			return TRUE;
		if ( IsFunc() )			// vor IsValue wegen WAHR und WAHR()
			// includes also external _names_ (aka Addins!)
		{
//			if ( bFirst && pAddress )
			if ( bFirst && /*bRefClassInCell*/ eRefClHandl != RCH_Name )
			{	// convert Ref-Class to Value-Class if in cell
//2do: this does not work if parenthesized =(FUNC(...)) because it's not first token
				switch ( m_Token.ptg )
				{
					case ptgFunc :
						m_Token.ptg = ptgFuncV;
					break;
					case ptgFuncVar :
						m_Token.ptg = ptgFuncVarV;
					break;
				}
			}
			return TRUE;
		}
		if ( IsValue() )
			return TRUE;
		if ( IsString() )
			return TRUE;
		if ( IsReference() )
			return TRUE;
		if ( IsNamedRange() )
			return TRUE;
		if ( IsDBArea() )
			return TRUE;
        if ( IsDDE() )
            return TRUE;
		if ( pCur->GetOpCode() != ocStop )
			SetError( nErrIllegalToken );
		return FALSE;
	}
	else
	{
//		if ( bFirstRef && m_pLastRef && pAddress )
		if ( bFirstRef && m_pLastRef && /*bRefClassInCell*/ eRefClHandl != RCH_Name )
		{	// only one single reference (=A1) or area reference (=A1:A3) in cell
			UINT8 n = GetPtgBase( *m_pLastRef );
			switch ( n )
			{
				case ptgRef :
				case ptgRef3d :
				case ptgArea :
				case ptgArea3d :
                case ptgRefN :
                case ptgAreaN :
					*m_pLastRef = n + 0x20;		// Value-Class
			}
		}
	}
	return FALSE;
}


void CExcelCompiler::PutCodeStr( const SToken& rToken )
{
	if ( rToken.ptg != ptgStr )
		return ;

	const String&				rStr = rToken.aStr;
	const xub_StrLen			nSize = rStr.Len();

	if ( pExcRoot->eDateiTyp >= Biff8 )
	{
		XclExpUniString		aUni( rStr, (UINT8) Min( nSize, (xub_StrLen) 0xFF ) );
										// Biff8 uses 8Bit string len!
		if ( (aUni.GetBufferByteCount() + 3 + m_pc) >= nMaxCodeLen )
			SetError( nErrCodeOverflow );
		if( m_nError == 0 )
		{
			m_sFormulaRec.nCode[ m_pc++ ] = rToken.ptg;
			m_sFormulaRec.nCode[ m_pc++ ] = ( UINT8 ) aUni.GetLen();
			m_sFormulaRec.nCode[ m_pc++ ] = aUni.GetGrbit();
			aUni.WriteBuffer( &m_sFormulaRec.nCode[ m_pc ] );
			m_pc += ( UINT16 ) aUni.GetBufferByteCount();
		}
	}
	else
	{
		if ( ( m_pc + nSize + 2 ) >= nMaxCodeLen )
			SetError( nErrCodeOverflow );
		if( m_nError == 0 )
		{
			m_sFormulaRec.nCode[ m_pc++ ] = rToken.ptg;

            ByteString          aStr( rStr, *pExcRoot->pCharset );
			const UINT8			nStrLen = ( UINT8 ) aStr.Len();
			m_sFormulaRec.nCode[ m_pc++ ] = nStrLen;
			memcpy( &m_sFormulaRec.nCode[ m_pc ], aStr.GetBuffer(), nStrLen );
            m_pc +=  nStrLen;
		}
	}
}


void CExcelCompiler::PutCode( const SToken& rToken )
	{
	UINT16 nRefValueClass;
	if ( rToken.ptg < ptgParen &&
			((nRefValueClass = GetOperatorValueClass( rToken.ptg )) != nRefValueNone) )
	{	// convert Reference-Class to Value-Class if in cell or Array-Class if in name
		if ( (nRefValueClass & nRefValuePrev) && m_pPrevRef )
		{
			switch ( *m_pPrevRef )
			{
				case ptgRef :
				case ptgRef3d :
				case ptgRefN :
				case ptgArea :
				case ptgArea3d :
				case ptgAreaN :
//					*m_pPrevRef += ( pAddress ? 0x20 : 0x40 );
					//*m_pPrevRef += ( bRefClassInCell? 0x20 : 0x40 );
					IncrPtg( m_pPrevRef );
			}
		}
		if ( (nRefValueClass & nRefValueLast) && m_pLastRef )
		{
			switch ( *m_pLastRef )
			{
				case ptgRef :
				case ptgRef3d :
				case ptgRefN :
				case ptgArea :
				case ptgArea3d :
				case ptgAreaN :
//					*m_pLastRef += ( pAddress ? 0x20 : 0x40 );
					//*m_pLastRef += ( bRefClassInCell? 0x20 : 0x40 );
					IncrPtg( m_pLastRef );
			}
		}
		//! don't shift last to prev
	}
	else
	{
		switch ( rToken.ptg )
		{
			case ptgParen :		// nothing
			break;
			case ptgFunc:
			case ptgFuncV:
			case ptgFuncA:
			case ptgFuncVar:
			case ptgFuncVarV:
			case ptgFuncVarA:	// functions close any open Refs
				m_pPrevRef = NULL;
			break;
			default:			// shift last to prev
				m_pPrevRef = m_pLastRef;
		}
		m_pLastRef = NULL;
	}
	if ( rToken.ptg == ptgStr )
		{
		PutCodeStr( rToken );
		return ;
		}

	if ( ( m_pc + 64 ) >= nMaxCodeLen )
		SetError( nErrCodeOverflow );

	if( m_nError == 0 )
		{
		m_sFormulaRec.nCode[ m_pc++ ] = rToken.ptg;

		switch( rToken.ptg )
			{
			case ptgBool:
				m_sFormulaRec.nCode[ m_pc++ ] = rToken.Data[ 0 ];
				break;
			case ptgInt:
				{
				memcpy( &m_sFormulaRec.nCode[ m_pc ], &rToken.Data[ 0 ], 2 );
				m_pc += 2;
				}
				break;
			case ptgNum:
				{
				memcpy( &m_sFormulaRec.nCode[ m_pc ], &rToken.Data[ 0 ], 8 );
				m_pc += 8;
				}
				break;
			case ptgRefN:
				if( !bCondForm )
					break;
			case ptgRef:
			case ptgRefErr:
				{
				m_pLastRef = &m_sFormulaRec.nCode[ m_pc - 1 ];
				if ( rToken.ptg != ptgRefErr )
				{
#if 0
// we don't have any shared formulas yet
					if( ... )		// Cell-Reference within a shared formula
						m_sFormulaRec.nCode[ m_pc - 1 ] = ptgRefN;
#endif
					if( m_nParamType == nTypeVal )
//						m_sFormulaRec.nCode[ m_pc - 1 ] += ( pAddress ? 0x20 : 0x40 );
						//m_sFormulaRec.nCode[ m_pc - 1 ] += ( bRefClassInCell? 0x20 : 0x40 );
						IncrPtg( m_sFormulaRec.nCode[ m_pc - 1 ] );
					else if( m_nParamType == nTypeArr )
						m_sFormulaRec.nCode[ m_pc - 1 ] += 0x40;
				}
				const UINT16 nSize = ( pExcRoot->eDateiTyp >= Biff8 ? 4 : 3 );
				memcpy( &m_sFormulaRec.nCode[ m_pc ], &rToken.Data[ 0 ], nSize);
				m_pc += nSize;
				}
				break;
			case ptgAreaN:
				if( !bCondForm )
					break;
			case ptgArea:
			case ptgAreaErr:
				{
				m_pLastRef = &m_sFormulaRec.nCode[ m_pc - 1 ];
				if ( rToken.ptg != ptgAreaErr )
				{
#if 0
// we don't have any shared formulas yet
					if( ... )		// Area-Reference within a shared formula
						m_sFormulaRec.nCode[ m_pc - 1 ] = ptgAreaN;
#endif
					if( m_nParamType == nTypeVal )
//						m_sFormulaRec.nCode[ m_pc - 1 ] += ( pAddress ? 0x20 : 0x40 );
						//m_sFormulaRec.nCode[ m_pc - 1 ] += ( bRefClassInCell? 0x20 : 0x40 );
						IncrPtg( m_sFormulaRec.nCode[ m_pc - 1 ] );
					else if( m_nParamType == nTypeArr )
						m_sFormulaRec.nCode[ m_pc - 1 ] += 0x40;
				}
				const UINT16 nSize = ( pExcRoot->eDateiTyp >= Biff8 ? 8 : 6 );
				memcpy( &m_sFormulaRec.nCode[ m_pc ], &rToken.Data[ 0 ], nSize);
				m_pc += nSize;
				}
				break;
			case ptgRef3d:
			case ptgRefErr3d:
				{
				m_pLastRef = &m_sFormulaRec.nCode[ m_pc - 1 ];
				if ( rToken.ptg != ptgRefErr3d )
				{
					if( m_nParamType == nTypeVal )
//						m_sFormulaRec.nCode[ m_pc - 1 ] += ( pAddress ? 0x20 : 0x40 );
						//m_sFormulaRec.nCode[ m_pc - 1 ] += ( bRefClassInCell? 0x20 : 0x40 );
						IncrPtg( m_sFormulaRec.nCode[ m_pc - 1 ] );
					else if( m_nParamType == nTypeArr )
						m_sFormulaRec.nCode[ m_pc - 1 ] += 0x40;
				}
				const UINT16 nSize = ( pExcRoot->eDateiTyp >= Biff8 ? 6 : 17 );
				memcpy( &m_sFormulaRec.nCode[ m_pc ], &rToken.Data[ 0 ], nSize);
				m_pc += nSize;
				}
				break;
			case ptgArea3d:
			case ptgAreaErr3d:
				{
				m_pLastRef = &m_sFormulaRec.nCode[ m_pc - 1 ];
				if ( rToken.ptg != ptgAreaErr3d )
				{
					if( m_nParamType == nTypeVal )
//						m_sFormulaRec.nCode[ m_pc - 1 ] += ( pAddress ? 0x20 : 0x40 );
						//m_sFormulaRec.nCode[ m_pc - 1 ] += ( bRefClassInCell? 0x20 : 0x40 );
						IncrPtg( m_sFormulaRec.nCode[ m_pc - 1 ] );
					else if( m_nParamType == nTypeArr )
						m_sFormulaRec.nCode[ m_pc - 1 ] += 0x40;
				}
				const UINT16 nSize = ( pExcRoot->eDateiTyp >= Biff8 ? 10 : 20 );
				memcpy( &m_sFormulaRec.nCode[ m_pc ], &rToken.Data[ 0 ], nSize);
				m_pc += nSize;
				}
				break;
			case ptgExtend:
				{
				const UINT16 nSize = 5;
				memcpy( &m_sFormulaRec.nCode[ m_pc ], &rToken.Data[ 0 ], nSize );
				m_pc += nSize;
				}
				break;
			case ptgName:
				{
				if( m_nParamType == nTypeVal )
                    m_sFormulaRec.nCode[ m_pc - 1 ] += ((eRefClHandl == RCH_Array) && (m_nFuncParamType == nTypeRef)) ? 0x40 : 0x20;
                else if( m_nParamType == nTypeArr )
					m_sFormulaRec.nCode[ m_pc - 1 ] += 0x40;

				const UINT16 nSize = ( pExcRoot->eDateiTyp >= Biff8 ? 4 : 14 );
				memcpy( &m_sFormulaRec.nCode[ m_pc ], &rToken.Data[ 0 ], nSize);
				m_pc += nSize;
				}
				break;
			case ptgNameX:
            case ptgNameXV:
            case ptgNameXA:
				{
				const UINT16 nSize = 6;
				memcpy( &m_sFormulaRec.nCode[ m_pc ], &rToken.Data[ 0 ], nSize);
				m_pc += nSize;
				}
				break;
			case ptgAttr:
				{
				memcpy( &m_sFormulaRec.nCode[ m_pc ], &rToken.Data[ 0 ], 3);
				m_pc += 3;
				}
				break;
			case ptgFunc:
			case ptgFuncV:
			case ptgFuncA:
				{
                if( (rToken.ptg == ptgFunc) && (m_nFuncParamType == nTypeVal) )
                    m_sFormulaRec.nCode[ m_pc - 1 ] += (eRefClHandl == RCH_Array) ? 0x40 : 0x20;
				memcpy( &m_sFormulaRec.nCode[ m_pc ], &rToken.Data[ 0 ], 2);
				m_pc += 2;
				}
				break;
			case ptgFuncVar:
			case ptgFuncVarV:
			case ptgFuncVarA:
				{
                if( (rToken.ptg == ptgFuncVar) && (m_nFuncParamType == nTypeVal) )
                    m_sFormulaRec.nCode[ m_pc - 1 ] += (eRefClHandl == RCH_Array) ? 0x40 : 0x20;
				memcpy( &m_sFormulaRec.nCode[ m_pc ], &rToken.Data[ 0 ], 3);
				m_pc += 3;
				}
				break;
			}
		}
	}


void CExcelCompiler::InsertMove( UINT16 nAtPc, UINT16 nCount )
{
	DBG_ASSERT( m_pc + nCount <= nMaxCodeLen, "CExcelCompiler::InsertMove: overflow" );
	if ( m_pc + nCount > nMaxCodeLen )
		nCount = nMaxCodeLen - m_pc;	// rotten formula but good memory
	memmove( &m_sFormulaRec.nCode[nAtPc + nCount], &m_sFormulaRec.nCode[nAtPc], m_pc - nAtPc );
	m_pc += nCount;
	if ( m_pLastRef && m_pLastRef >= &m_sFormulaRec.nCode[nAtPc] )
		m_pLastRef += nCount;	//! UINT8 pointer
	if ( m_pPrevRef && m_pPrevRef >= &m_sFormulaRec.nCode[nAtPc] )
		m_pPrevRef += nCount;	//! UINT8 pointer
}


void CExcelCompiler::InsertJumpTable(UINT16* pJumpTable, UINT16 nJumpCount)
{
	UINT16 nPc = pJumpTable[0];
	UINT16 nCount = nJumpCount * 2;
	UINT16 nVal = nJumpCount - 1;
	m_sFormulaRec.Set( nPc, nVal );		// number of cases in CHOOSE function
	nPc += 2;
	InsertMove( nPc, nCount );	// ER 25.10.99: was move (nMaxCodeLen - nAtPc - nCount) bytes
	// bitFAttrChoose offsets
	UINT16 nOff = nPc;		// jumps are relative to start of jump table
	m_sFormulaRec.Set( nPc, nCount );		// first jump == length of table
	for (UINT16 i = 1; i < nJumpCount; i++)
	{
		nPc += 2;
		nVal = pJumpTable[i] + nCount - nOff;
		m_sFormulaRec.Set( nPc, nVal );
		// bitFAttrGoto skip bytes behind each case point behind the entire
		// CHOOSE function which is behind the last case's bitFAttrGoto
		UINT16 nSc = pJumpTable[i] + nCount - 2;
		nVal = m_pc - nSc + 1;
		m_sFormulaRec.Set( nSc, nVal );
	}
}


void CExcelCompiler::Factor()
{
	if (m_nError != 0) return;
	SToken* pFacToken = NULL;
	SToken* pAttrToken = new SToken;
	pAttrToken->ptg = ptgAttr;
	UINT16 JumpTable[30];
	UINT16 nJumpCount = 0;
	UINT16 nSavePc;
	// Werte
	if
		(		m_Token.ptg == ptgInt
			||	m_Token.ptg == ptgBool
			||	m_Token.ptg == ptgNum
			||	m_Token.ptg == ptgStr
			||	m_Token.ptg == ptgRef
			||	m_Token.ptg == ptgArea
			||	m_Token.ptg == ptgRef3d
			||	m_Token.ptg == ptgArea3d
			||	m_Token.ptg == ptgRefErr
			||	m_Token.ptg == ptgAreaErr
			||	m_Token.ptg == ptgRefErr3d
			||	m_Token.ptg == ptgAreaErr3d
			||	m_Token.ptg == ptgName
            ||  m_Token.ptg == ptgNameX
            ||  m_Token.ptg == ptgNameXV
            ||  m_Token.ptg == ptgNameXA
			||	m_Token.ptg == ptgMissArg
			||	m_Token.ptg == ptgExtend
			||	( bCondForm && ( m_Token.ptg == ptgRefN || m_Token.ptg == ptgAreaN ) )
		)
	{
		PutCode(m_Token);
		GetNextToken();
	}
	// Klammer -> Rekursion
	else if (m_Token.ptg == ptgParen)
	{
		pFacToken = new SToken( m_Token );
		GetNextToken();
		Expression();
		if ((m_Token.ptg != ptgParen))
			SetError(nErrPair);
		else
		{
			PutCode(*pFacToken);
			GetNextToken();
		}
	}
	// Funktionen
	else if ((m_Token.ptg == ptgFunc) ||
				(m_Token.ptg == ptgFuncVar) ||
				(m_Token.ptg == ptgFuncV) ||
				(m_Token.ptg == ptgFuncVarV) ||
				(m_Token.ptg == ptgFuncA) ||
				(m_Token.ptg == ptgFuncVarA))
	{
		UINT8 nSaveType = m_nParamType;
        UINT8 nSaveFuncParamType = m_nFuncParamType;
		UINT8 nScParamCount = 0;
		UINT8 nParamCount = 0;
		const SFuncData* pSave = pFuncData;

        // for ptgNameX (extern name): [0] = EXTERNSHEET index, [1] = EXTERNNAME index
        UINT16 pExtNameData[ 2 ] = { 0, 0xFFFF };

		if( pCur->GetOpCode() == ocExternal )
            pExcRoot->pExternsheetRecs->InsertAddin(
                pExtNameData[ 0 ], pExtNameData[ 1 ],
                pExcRoot->pAddInNameTranslator->GetXclName( pCur->GetExternal() ) );

		pFacToken = new SToken( m_Token );
		GetNextToken();
		if (m_Token.ptg == ptgParen)
		{
			if (pSave->bVolatile)
			{
				pAttrToken->Data[0] = 1;
				pAttrToken->Data[1] = 0;
				pAttrToken->Data[2] = 0;
				PutCode(*pAttrToken);
			}
			GetNextToken();
			if( pCur->GetOpCode() != ocClose )
			{
				nScParamCount++;
				nParamCount++;
				if (m_Token.ptg != ptgSep)
				{
					nSaveType = m_nParamType;
					if (pSave->nParamCount == nVarParam)
					{
						if ( nScParamCount <= pSave->nVarParamTypeCount  )
						{
							if ( pSave->nParamType[nScParamCount - 1] == nTypeInsert )
							{
                                InsertParameter( pSave, nScParamCount, sizeof( pExtNameData ), pExtNameData );
								nScParamCount++;
								nParamCount++;
							}
                            m_nParamType = m_nFuncParamType = pSave->nParamType[nScParamCount - 1];
						}
						else
                            m_nParamType = m_nFuncParamType = pSave->nParamType[pSave->nVarParamTypeCount - 1];
						if ( m_nParamType == nTypeIgnore )
							nParamCount--;
					}
					else if ( nScParamCount <= nMaxParamCount )
					{
						if ( pSave->nParamType[nScParamCount - 1] == nTypeInsert )
						{
                            InsertParameter( pSave, nScParamCount, sizeof( pExtNameData ), pExtNameData );
							nScParamCount++;
							nParamCount++;
						}
                        m_nParamType = m_nFuncParamType = pSave->nParamType[nScParamCount - 1];
						if ( m_nParamType == nTypeIgnore )
							nParamCount--;
						if ( nParamCount > pSave->nParamCount )
							m_nParamType = nTypeErr;
					}
					else
						m_nParamType = nTypeErr;

					if ( m_nParamType == nTypeIgnore )
						IgnoreParameter();
					else
					{
                        CheckAndChangeCurrClass();
						Expression();
					}
					m_nParamType = nSaveType;
                    m_nFuncParamType = nSaveFuncParamType;
				}
				else
					m_sFormulaRec.nCode[m_pc++] = ptgMissArg;
			}
		}
		else
			SetError(nErrPair);

		// if Code
		if (pSave->nIndex == 1)
		{
			nSavePc = m_pc;
			pAttrToken->Data[0] = 2;
			pAttrToken->Data[1] = 0;
			pAttrToken->Data[2] = 0;
			PutCode(*pAttrToken);
		}
		// choose Code
		if (pSave->nIndex == 100)
		{
			nSavePc = m_pc;
			pAttrToken->Data[0] = 4;
			pAttrToken->Data[1] = 0;
			pAttrToken->Data[2] = 0;
			JumpTable[nJumpCount++] = m_pc + 2;		// points to number of cases
			PutCode(*pAttrToken);
		}

		while ((m_Token.ptg == ptgSep) && (nParamCount < 32) && (m_nError == 0))
		{
			GetNextToken();
			while ((m_Token.ptg == ptgSep) && (nParamCount < 32) && (m_nError == 0))
			{
				nScParamCount++;
				nParamCount++;
				m_sFormulaRec.nCode[m_pc++] = ptgMissArg;
				GetNextToken();
			}
			nScParamCount++;
			nParamCount++;
			if( pCur->GetOpCode() != ocClose )
			{
				nSaveType = m_nParamType;
				if (pSave->nParamCount == nVarParam)
				{
					if ( nScParamCount <= pSave->nVarParamTypeCount  )
					{
						if ( pSave->nParamType[nScParamCount - 1] == nTypeInsert )
						{
                            InsertParameter( pSave, nScParamCount, sizeof( pExtNameData ), pExtNameData );
							nScParamCount++;
							nParamCount++;
						}
                        m_nParamType = m_nFuncParamType = pSave->nParamType[nScParamCount - 1];
					}
					else
                        m_nParamType = m_nFuncParamType = pSave->nParamType[pSave->nVarParamTypeCount - 1];
					if ( m_nParamType == nTypeIgnore )
						nParamCount--;
				}
				else if ( nScParamCount <= nMaxParamCount )
				{
					if ( pSave->nParamType[nScParamCount - 1] == nTypeInsert )
					{
                        InsertParameter( pSave, nScParamCount, sizeof( pExtNameData ), pExtNameData );
						nScParamCount++;
						nParamCount++;
					}
                    m_nParamType = m_nFuncParamType = pSave->nParamType[nScParamCount - 1];
					if ( m_nParamType == nTypeIgnore )
						nParamCount--;
					if ( nParamCount > pSave->nParamCount )
						m_nParamType = nTypeErr;
				}
				else
					m_nParamType = nTypeErr;

				if ( m_nParamType == nTypeIgnore )
					IgnoreParameter();
				else
				{
                    CheckAndChangeCurrClass();
					Expression();
				}
				m_nParamType = nSaveType;
                m_nFuncParamType = nSaveFuncParamType;
			}
			else
				m_sFormulaRec.nCode[m_pc++] = ptgMissArg;
			// if or choose Code
			if ((pSave->nIndex == 1) || (pSave->nIndex == 100))
			{
				UINT16 nJump;
				m_sFormulaRec.Get( nSavePc + 2, nJump );
				nJump += (m_pc - nSavePc);
				m_sFormulaRec.Set( nSavePc + 2, nJump );
				nSavePc = m_pc;
				pAttrToken->Data[0] = 8;
				pAttrToken->Data[1] = 3;
				pAttrToken->Data[2] = 0;
				PutCode(*pAttrToken);
				JumpTable[nJumpCount++] = m_pc;		// points to next code
			}
		}

		if (pSave->nIndex == 100)
			InsertJumpTable(JumpTable, nJumpCount);

		if ((pSave->nIndex == 1) && (nParamCount > 3))
			SetError(nErrIllegalParameter);

		if (m_Token.ptg != ptgParen)
			SetError(nErrPair);
		else
			GetNextToken();

		if (nParamCount > 30)
			SetError(nErrIllegalParameter);

		if (pSave->nParamCount == nVarParam)
		{
			if( !pFacToken )
				pFacToken = new SToken;
#if 0
//! functions with variable parameter count and 0 possible parameters DO exist,
//! see ROW() and COLUMN()
			if (nParamCount == 0)
				SetError(nErrIllegalParameter);
			else
				pFacToken->Data[0] = nParamCount;
#else
//! SUM() without parameters will be exported even if you can't enter it in
//! Excel, calculates as 0 which is correct
			pFacToken->Data[0] = nParamCount;
#endif
		}
		else
		{
			while( nParamCount < pSave->nParamCount )
			{
				m_sFormulaRec.nCode[m_pc++] = ptgMissArg;
				nParamCount++;
			}
			if (pSave->nParamCount != nParamCount)
				SetError(nErrIllegalParameter);
		}
		DBG_ASSERT( pFacToken, "CExcelCompiler::Factor(): Token doesn't exist!" );
		PutCode(*pFacToken);
	}
	// sonst Fehler
	else
		SetError(nErrIllegalSymbol);

	if( pFacToken )
		delete pFacToken;

	delete pAttrToken;
}


void CExcelCompiler::IgnoreParameter()
{
	int nLevel = 1;
	do
	{
		GetNextToken();
		if ( !pCur )
			nLevel = 0;
		else
		{
			switch ( pCur->GetOpCode() )
			{
				case ocSep :
					if ( nLevel == 1 )
						nLevel = 0;
				break;
				case ocOpen :
					nLevel++;
				break;
				case ocClose :
					nLevel--;
				break;
			}
		}
	} while ( nLevel > 0 );
}


void CExcelCompiler::InsertParameter( const SFuncData* pFuncData, UINT8 nScParam,
										UINT16 nLenAddData, const void* pAddData )
{
	SToken aToken;
	switch( pFuncData->nOp )
	{
		case ocAdress:
		{
			if( nScParam == 4 )
			{
				aToken.ptg = ptgBool;
				aToken.Data[0] = 0x01;
			}
			else
				DBG_ERROR( "CExcelCompiler::InsertParameter - wrong parameter" );
		}
		break;
		case ocExternal:
		{
			DBG_ASSERT( nScParam == 1,
				"CExcelCompiler::InsertParameter(): additional parameter only first for ocExternal!" );
            DBG_ASSERT( nLenAddData == 4,
				"CExcelCompiler::InsertParameter(): wrong additional parameter" );

            aToken.ptg = ptgNameX;
            aToken.Set( 0, *((UINT16*) pAddData) );
            aToken.Set( 2, *(((UINT16*) pAddData) + 1) );
            aToken.Set( 4, (UINT16) 0 );
		}
		break;
		default:
			DBG_ERROR( "CExcelCompiler::InsertParameter - illegal opcode" );
	}
	PutCode( aToken );
}


void CExcelCompiler::Unary()
{
	if ( m_nError != 0 ) return;
	if ( m_Token.ptg == ptgAdd )
		m_Token.ptg = ptgUplus;
	if ( m_Token.ptg == ptgUminus || m_Token.ptg == ptgUplus )
	{
		SToken* pUnaryToken = new SToken( m_Token );
		UINT8* pLastRef = m_pLastRef;
		GetNextToken();
		Factor();
		m_pPrevRef = pLastRef;
		PutCode( *pUnaryToken );
		delete pUnaryToken;
	}
	else
    {
		Factor();
        while( m_Token.ptg == ptgPercent )
        {
            PutCode( m_Token );
            GetNextToken();
        }
    }
}


void CExcelCompiler::PowLine()
{
	if (m_nError != 0) return;
	Unary();
	while (m_Token.ptg == ptgPower)
	{
		SToken* pPowToken = new SToken( m_Token );
		UINT8* pLastRef = m_pLastRef;
		GetNextToken();
		Factor();
		m_pPrevRef = pLastRef;
		PutCode(*pPowToken);
		delete pPowToken;
	}
}


void CExcelCompiler::SignLine()
{
	if (m_nError != 0) return;
	PowLine();
	while ((m_Token.ptg == ptgUminus) || (m_Token.ptg == ptgUplus))
	{
		SToken* pNegToken = new SToken( m_Token );
		UINT8* pLastRef = m_pLastRef;
		GetNextToken();
		PowLine();
		m_pPrevRef = pLastRef;
		PutCode(*pNegToken);
		delete pNegToken;
	}
}


void CExcelCompiler::UnionCutLine()
{
	if (m_nError != 0) return;
	UINT16 nPc = m_pc;
	SignLine();
	while ((m_Token.ptg == ptgUnion) || (m_Token.ptg == ptgIsect) || (m_Token.ptg == ptgRange))
	{
		SToken* pUnionCutToken = new SToken( m_Token );
		UINT8* pLastRef = m_pLastRef;
		GetNextToken();
		SignLine();
		m_pPrevRef = pLastRef;
		PutCode(*pUnionCutToken);
		// make it a Variable Reference Subexpression
		UINT16 nSize = m_pc - nPc;
		InsertMove( nPc, 3 );
		// force it to an Array-Class if in formula cell,
		// so Xcl really pushes the values and not only the reference
//		m_sFormulaRec.nCode[ nPc++ ] = ( pAddress ? ptgMemFuncA : ptgMemFunc );
		m_sFormulaRec.nCode[ nPc++ ] = //( bRefClassInCell? ptgMemFuncA : ptgMemFunc );
										GetPtg( ptgMemFuncA, ptgMemFunc, ptgMemFuncA );
// #96483# don't use this directly:  *((UINT16*) (&m_sFormulaRec.nCode[ nPc ])) = nSize;
        ShortToSVBT16( nSize, &m_sFormulaRec.nCode[ nPc ] );
		nPc = m_pc;
		delete pUnionCutToken;
	}
}


void CExcelCompiler::MulDivLine()
{
	if (m_nError != 0) return;
	UnionCutLine();
	while ((m_Token.ptg == ptgMul) || (m_Token.ptg == ptgDiv))
	{
		SToken* pMulDivToken = new SToken( m_Token );
		UINT8* pLastRef = m_pLastRef;
		GetNextToken();
		UnionCutLine();
		m_pPrevRef = pLastRef;
		PutCode(*pMulDivToken);
		delete pMulDivToken;
	}
}


void CExcelCompiler::AddSubLine()
{
	if( m_nError != 0 ) return;
	MulDivLine();
    while( ( m_Token.ptg == ptgAdd ) || ( m_Token.ptg == ptgSub ) )
	{
		SToken* pAddSubToken = new SToken( m_Token );
		UINT8* pLastRef = m_pLastRef;
		GetNextToken();
		MulDivLine();
		m_pPrevRef = pLastRef;
		PutCode( *pAddSubToken );
		delete pAddSubToken;
	}
}


void CExcelCompiler::ConcatLine()
{
	if( m_nError != 0 ) return;
	AddSubLine();
    while( m_Token.ptg == ptgConcat )
	{
        SToken* pConcatToken = new SToken( m_Token );
		UINT8* pLastRef = m_pLastRef;
		GetNextToken();
		AddSubLine();
		m_pPrevRef = pLastRef;
        PutCode( *pConcatToken );
        delete pConcatToken;
	}
}


void CExcelCompiler::CompareLine()
{
	if( m_nError != 0 ) return;
    ConcatLine();
	while( ( m_Token.ptg >= ptgLT ) && ( m_Token.ptg <= ptgNE ) )
	{
		SToken*	pCompToken = new SToken( m_Token );
		UINT8*	pLastRef = m_pLastRef;
		GetNextToken();
        ConcatLine();
		m_pPrevRef = pLastRef;
		PutCode( *pCompToken );
		delete pCompToken;
	}
}


void CExcelCompiler::Expression()
{
	if( m_nError != 0) return;
	CompareLine();
}


EC_Codetype CExcelCompiler::CreateCode( ExcArrays* pShrdFmlas )
{
	EC_Codetype	eRet = EC_StdFmla;
	m_Token.ptg = 0;
	if( pExcRoot->bBreakSharedFormula )
	{
		ScRangeData*	pRangeData = GetSharedFormula();
		if( pRangeData )
            eRet = BreakSharedFormula( pRangeData, pShrdFmlas );
	}

	if( bFirstShrdFmla )
	{	// bFirstShrdFmla == TRUE is default
		const ScAddress*	pOrgAddress = pAddress;
		if( eRet == EC_ShrdFmla )
		{
			pAddress = NULL;
			eRefClHandl = RCH_Cell;
			bCondForm = TRUE;		// forces set of refs in names (e.g. ptgRefN) as used in shared formulas!
		}

		ScTokenArray*		pScTokenArray = ( ScTokenArray* ) pCode;

		pScTokenArray->Reset();

		GetNextToken();
		Expression();
		m_sFormulaRec.nLen = 22 + m_pc;
		m_sFormulaRec.nCce = m_pc;

		pAddress = pOrgAddress;
	}

	return eRet;
}


UINT16 lcl_CreateArrayRefCode( sal_Char*& rpCode, UINT16 nRow, UINT16 nCol, UINT32& rId )
{
	if( rpCode )
		delete[] rpCode;

	rpCode = new sal_Char[ 5 ];

	rpCode[ 0 ] = 0x01;
	rpCode[ 1 ] = ( sal_Char ) nRow;
	rpCode[ 2 ] = ( sal_Char ) ( nRow >> 8 );
	rpCode[ 3 ] = ( sal_Char ) nCol;
	rpCode[ 4 ] = ( sal_Char ) ( nCol >> 8 );

	rId = nCol;
	rId <<= 16;
	rId += nRow;
	rId <<= 8;

	return 5;
}


EC_Codetype CExcelCompiler::CreateArrayCode( BOOL bCreateArrayRecCode )
{
	ScTokenArray*			pScTokenArray = ( ScTokenArray* ) pCode;

	if( pCode->GetLen() == 1 )
	{
        ScToken*            pT = pScTokenArray->First();
		if( pT && pT->GetOpCode() == ocMatRef )
		{
			const SingleRefData& rRef = pT->GetSingleRef();
			nShrdFmla = lcl_CreateArrayRefCode( pShrdFmla, rRef.nRow, rRef.nCol, nArrayFormId );
			return EC_ArrayFmla;
		}
	}
    if( bCreateArrayRecCode )
	{
		// generate code 4 array record
		RefClassHandling	eOld = eRefClHandl;
		eRefClHandl = RCH_Array;
		pScTokenArray->Reset();

		GetNextToken();
		Expression();
		m_sFormulaRec.nLen = 22 + m_pc;
		m_sFormulaRec.nCce = m_pc;

		eRefClHandl = eOld;

		if( pAddress )
		{
			nShrdFmla = lcl_CreateArrayRefCode( pShrdFmla, pAddress->Row(), pAddress->Col(), nArrayFormId );
			return EC_ArrayFmla;
		}
		else if( pShrdFmla )
		{
			delete[] pShrdFmla;
			pShrdFmla = NULL;
			nShrdFmla = 0;
		}
	}

	return EC_StdFmla;
}


const sal_Char* CExcelCompiler::GetDataWithShrdFmla( void ) const
{
	return pShrdFmla;
}


UINT16 CExcelCompiler::GetLenWithShrdFmla( void ) const
{
	return nShrdFmla;
}


BOOL CExcelCompiler::GetShrdFmla( sal_Char*& rpCode, UINT16& rLen )
{
	if( pShrdFmla )
	{
		rpCode = pShrdFmla;
		pShrdFmla = NULL;

		rLen = nShrdFmla;
		nShrdFmla = 0;

		return TRUE;
	}

	return FALSE;
}


ScRangeData* CExcelCompiler::GetSharedFormula()
{
	ScRangeData* pRangeData = NULL;
	if( pAddress && pCode->GetLen() == 1 )
	{
		ScToken* pT = ( ( ScTokenArray* ) pCode )->First();
		if( pT && pT->GetOpCode() == ocName )
		{
			ScRangeData* pData = pExcRoot->pDoc->GetRangeName()->FindIndex( pT->GetIndex() );
			if( pData && pData->HasType( RT_SHARED ) )
				pRangeData = pData;
		}
	}
	return pRangeData;
}


EC_Codetype CExcelCompiler::BreakSharedFormula( ScRangeData* pRangeData, ExcArrays* pShrdFmlas )
{
    EC_Codetype eRet = EC_StdFmla;
    if( pShrdFmla )
		delete[] pShrdFmla;
	pShrdFmla = NULL;

	ScTokenArray*	pRangeCode;
	if( pAddress && pRangeData && !pRangeData->GetErrCode() && ( pRangeCode = pRangeData->GetCode() ) )
	{
		bFirstShrdFmla = TRUE;
		ScRange		aBaseAddr;
		if( ShrfmlaBuffer::GetAddress( pRangeData->GetName(), aBaseAddr ) )
		{
			bFirstShrdFmla = pAddress? aBaseAddr.aStart == *pAddress : TRUE;

			nShrdFmla = 5;
			pShrdFmla = new sal_Char[ nShrdFmla ];

			pShrdFmla[ 0 ] = 0x01;	// OpCode
            ShortToSVBT16( aBaseAddr.aStart.Row(), (UINT8*)(pShrdFmla + 1) );
            ShortToSVBT16( aBaseAddr.aStart.Col(), (UINT8*)(pShrdFmla + 3) );

			if( pShrdFmlas )
				pShrdFmlas->Extend( ( UINT8 ) aBaseAddr.aStart.Col(), aBaseAddr.aStart.Row(),
									( UINT8 ) pAddress->Col(), pAddress->Row() );

            eRet = EC_ShrdFmla;
		}

		if( bFirstShrdFmla )
		{	// only necessary for first cell!
			if( m_bDelCode )
				delete pCode;
			m_bDelCode = TRUE;
			pCode = pRangeCode->Clone();
			ScCompiler::MoveRelWrap( ( ScTokenArray& ) *pCode, pExcRoot->pDoc, *pAddress );
		}
	}
    return eRet;
}


void CExcelCompiler::CalcBitsAbs( SingleRefData &rSRD, UINT16 &rBitRow, UINT8 &rBitCol )
{
	DBG_ASSERT( pAddress, "-CExcelCompiler::CalcBitsAbs(): keine Adresse vorhanden!" );

	rSRD.CalcAbsIfRel( *pAddress );

	rBitRow = rSRD.nRow;

	if( rSRD.IsRowRel() )
		rBitRow |= 0x8000;
	else
		rBitRow &= ~0x8000;

	if( rSRD.IsColRel() )
		rBitRow |= 0x4000;
	else
		rBitRow &= ~0x4000;

	rBitCol = ( UINT8 ) rSRD.nCol;
}


void CExcelCompiler::CalcBitsRel( SingleRefData &rSRD, UINT16 &rBitRow, UINT8 &rBitCol )
{
	BOOL			bCalced;

	if( rSRD.IsRowRel() )
	{
		bCalced = FALSE;
		rBitRow = rSRD.nRelRow | 0x8000;
	}
	else
	{
		rSRD.CalcAbsIfRel( ScAddress( 0, 0, 0 ) );
		bCalced = TRUE;
		rBitRow = rSRD.nRow & ~0x8000;
	}

	if( rSRD.IsColRel() )
	{
		rBitRow |= 0x4000;
		rBitCol = ( UINT8 ) rSRD.nRelCol;
	}
	else
	{
		if( !bCalced )
			rSRD.CalcAbsIfRel( ScAddress( 0, 0, 0 ) );
		rBitRow &= ~0x4000;
		rBitCol = ( UINT8 ) rSRD.nCol;
	}
}


void CExcelCompiler::CalcBitsAbsBiff8( SingleRefData &rSRD, UINT16 &rBitRow,
			UINT16 &rBitCol )
{
	DBG_ASSERT( pAddress, "-CExcelCompiler::CalcBitsAbsBiff8(): keine Adresse vorhanden!" );

	rSRD.CalcAbsIfRel( *pAddress );

	rBitRow = rSRD.nRow;
	rBitCol = rSRD.nCol;

	if( rSRD.IsRowRel() )
		rBitCol |= 0x8000;
	else
		rBitCol &= ~0x8000;

	if( rSRD.IsColRel() )
		rBitCol |= 0x4000;
	else
		rBitCol &= ~0x4000;
}


void CExcelCompiler::CalcBitsRelBiff8( SingleRefData &rSRD, UINT16 &rBitRow,
			UINT16 &rBitCol )
{
	BOOL			bCalced;

	if( rSRD.IsColRel() )
	{
		bCalced = FALSE;
		rBitCol = rSRD.nRelCol | 0x4000;
	}
	else
	{
		rSRD.CalcAbsIfRel( ScAddress( 0, 0, 0 ) );
		bCalced = TRUE;
		rBitCol = rSRD.nCol & ~0x4000;
	}

	if( rSRD.IsRowRel() )
	{
		rBitCol |= 0x8000;
		rBitRow = rSRD.nRelRow;
	}
	else
	{
		if( !bCalced )
			rSRD.CalcAbsIfRel( ScAddress( 0, 0, 0 ) );
		rBitCol &= ~0x8000;
		rBitRow = rSRD.nRow;
	}
	rBitCol &= 0xC0FF;
}


void CExcelCompiler::CheckAndChangeCurrClass()
{
	if ( m_nParamType == nTypeRef )
	{
		const ScToken*	p = ((ScTokenArray*) pCode)->PeekNextNoSpaces();
		if( p )
		{
			switch ( p->GetOpCode() )
			{
				case ocClose :
				case ocSep :
				case ocIntersect :
				case ocUnion :
				case ocRange :
				break;
				default:
				{
					m_nParamType = nTypeVal;
#if 0
/*
					switch( m_Token.ptg )
					{
						case ptgRef:
						case ptgRefV:
						case ptgRefA:
						case ptgArea:
						case ptgAreaV:
						case ptgAreaA:
						case ptgRef3d:
						case ptgRef3dV:
						case ptgRef3dA:
						case ptgArea3d:
						case ptgArea3dV:
						case ptgArea3dA:
						case 148:			// ocIndirect
							break;
						default:
							m_nParamType = nTypeVal;
					}
 */
#endif
				}
			}
		}
	}
}

