/*************************************************************************
 *
 *  $RCSfile: XclImpExternsheet.hxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: dr $ $Date: 2001/11/23 12:59:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _SC_XCLIMPEXTERNSHEET_HXX
#define _SC_XCLIMPEXTERNSHEET_HXX

#ifndef _SC_FILTERTOOLS_HXX
#include "FilterTools.hxx"
#endif
#ifndef _SC_XCLIMPHELPER_HXX
#include "XclImpHelper.hxx"
#endif

#ifndef _EXCDEFS_HXX
#include "excdefs.hxx"
#endif

class ScDocument;
class ScTokenArray;
class XclImpStream;
class ExcelToSc;
struct RootData;


//___________________________________________________________________
// 3D references, external references
//  --> records TABID, SUPBOOK, XCT, CRN, EXTERNNAME, EXTERNSHEET

//___________________________________________________________________

/// Contains the insertion order of all sheets inside of the workbook (record TABID).
class XclImpTabIdBuffer : protected ScfUInt16List
{
public:
                                /// Reads the record TABID.
    void                        ReadTabid8( XclImpStream& rStrm );

                                /** Searchs for a TableId in the list.
                                    @param  nTabId
                                    The value searched for.
                                    @param  nMaxTabId
                                    All values greater than this parameter are not regarded to find the index.
                                    @return  the zero-based index of the value nTabId if it is contained in the list. */
    sal_uInt16                  GetIndex( sal_uInt16 nTabId, sal_uInt16 nMaxTabId = 0xFFFF ) const;
};


//___________________________________________________________________

/// Type of an external name.
enum XclImpExtNameType
{
    xienName,                   /// An external defined name or AddIn function name.
    xienDDE,                    /// A DDE link range.
    xienOLE                     /// An OLE object link.
};

/// Stores contents of an external name (external defined names, AddIn names, DDE links or OLE objects).
class XclImpExtName
{
private:
    String                      aName;              /// Name string occuring in a formula.
    sal_uInt32                  nStorageId;         /// Storage id for OLE object storages.
    XclImpExtNameType           eType;              /// Type of the external name.

public:
                                XclImpExtName( XclImpStream& rStrm, RootData& rRootData );

    inline XclImpExtNameType    GetType() const         { return eType; }
    inline const String&        GetName() const         { return aName; }
    inline sal_uInt32           GetStorageId() const    { return nStorageId; }
};


//___________________________________________________________________

/// Buffer for all external names of one SUPBOOK (external document).
class XclImpExtNameList : public ScfObjList< XclImpExtName >
{
public:
                                /// @return  the external name specified by an index from the Excel document (one-based).
    const XclImpExtName*        GetName( sal_uInt16 nXclIndex ) const;
};


//___________________________________________________________________

/// Contains the address and value of an external referenced cell.
class XclImpCrn : public XclImpCachedValue
{
protected:
    sal_uInt16                  nCol;               /// Column index of the external cell.
    sal_uInt16                  nRow;               /// Row index of the external cell.

public:
                                /// Reads a cached value and stores it with its cell address.
                                XclImpCrn( XclImpStream& rStrm, ExcelToSc& rFmlaConv, sal_uInt16 _nCol, sal_uInt16 _nRow );
                                /// Copies the cached value to sheet nTab in the document.
    void                        SetCell( ScDocument& rDoc, sal_uInt16 nTab );
};


//___________________________________________________________________

/// Contains name and sheet index of an external referenced sheet.
class XclImpSupbookTab
{
private:
    ScfObjList< XclImpCrn >     aCrnList;           /// List of CRN records (cached cell values).
    String                      aName;              /// Name of the external sheet.
    sal_uInt16                  nScTab;             /// New sheet index in Calc document.

public:
                                /// Stores the sheet name and marks the sheet index as invalid. Has to be set with SetScTab().
    inline                      XclImpSupbookTab( const String& rName ) :
                                    aName( rName ), nScTab( EXC_TAB_INVALID ) {}

    inline const String&        GetName() const                 { return aName; }
    inline sal_uInt16           GetScTab() const                { return nScTab; }

                                /// Sets the sheet index in the Calc document.
    inline void                 SetScTab( sal_uInt16 nTab )     { nScTab = nTab; }

                                /// Stores the contents of an external referenced cell.
    inline void                 AppendCrn( XclImpCrn* pCrn )    { aCrnList.Append( pCrn ); }

                                /// Creates a new sheet and stores all external cells in it.
    void                        CreateTable( ScDocument& rDoc, const String& rURL );
};


//___________________________________________________________________

/// Contains a list of all referenced sheets inside of an external workbook (record SUPBOOK).
class XclImpSupbook
{
private:
    ScfObjList< XclImpSupbookTab > aSupbookTabList; /// All sheet names of this SUPBOOK.
    XclImpExtNameList           aExtNameList;       /// All external names of this SUPBOOK.
    String                      aFileName;          /// URL of the workbook.
    sal_uInt16                  nCurrExcTab;        /// Current Excel sheet index of external cells.
    sal_Bool                    bSelf;              /// sal_True = internal references (to other sheets).

                                /// Appends a new external referenced cell.
    void                        AppendCrn( XclImpCrn*& rpCrn );

public:
                                /// Reads the SUPBOOK record (BIFF8).
                                XclImpSupbook( XclImpStream& rStrm );

                                /// Reads and decodes an encoded document name.
    static void                 ReadDocName( XclImpStream& rStrm, String& rDocName, sal_Bool& rbSelf );
                                /// Reads an external sheet name.
    static void                 ReadTabName( XclImpStream& rStrm, String& rTabName );

                                /// Reads an XCT record (count of following CRNs and current sheet).
    void                        ReadXct8( XclImpStream& rStrm );
                                /// Reads a CRN record (external referenced cell).
    void                        ReadCrn8( XclImpStream& rStrm, ExcelToSc& rFmlaConv );
                                /// Reads an EXTERNNAME record.
    void                        ReadExternname8( XclImpStream& rStrm, RootData& rRootData );

                                /// @return  sal_True = shortened record (own workbook or AddIn).
    inline sal_Bool             IsShortened() const     { return (aFileName.Len() == 0); }
                                /// @return  sal_True = SUPBOOK is own workbook.
    inline sal_Bool             IsSelf() const          { return bSelf; }

                                /// @return  the URL of the workbook.
    inline const String&        GetName() const         { return aFileName; }
                                /// @return  the external name specified by an index from the Excel document (one-based).
    inline const XclImpExtName* GetExtName( sal_uInt16 nXclIndex ) const;
                                /** For DDE links: Decodes application and document name from URL.
                                    For OLE object links: Decodes class and document name from URL.
                                    @return  sal_True = decoding successful. */
    sal_Bool                    GetLink( String& rApplic, String& rDoc ) const;

                                /// @return  Calc sheet index from Excel sheet index.
    sal_uInt16                  GetScTabNum( sal_uInt16 nExcTabNum ) const;
                                /// @return  Calc sheet index from sheet name.
    sal_uInt16                  GetScTabNum( const String& rTabName ) const;

                                /// Creates all sheets of this external workbook.
    void                        CreateTables( RootData& rRootData, sal_uInt16 nFirst, sal_uInt16 nLast ) const;
};

inline const XclImpExtName* XclImpSupbook::GetExtName( sal_uInt16 nXclIndex ) const
{
    return aExtNameList.GetName( nXclIndex );
}


//___________________________________________________________________

/// Contains a list of all external workbooks (SUPBOOKs) referenced in this workbook.
class XclImpSupbookList : private ScfObjList< XclImpSupbook >
{
public:
                                ScfObjList< XclImpSupbook >::Count;

                                /// Reads and appends a SUPBOOK record (BIFF8).
    inline void                 ReadSupbook8( XclImpStream& rStrm )
                                    { Append( new XclImpSupbook( rStrm ) ); }

                                /// @return  the SUPBOOK specified by a list index.
    inline const XclImpSupbook* GetSupbook( sal_uInt32 nIndex ) const
                                    { return GetObject( nIndex ); }
                                /// @return  the SUPBOOK specified by its URL.
    const XclImpSupbook*        GetSupbook( const String& rDocName ) const;
                                /// @return  the current SUPBOOK (last SUPBOOK in the list).
    inline XclImpSupbook*       GetCurrSupbook() { return Last(); }
};


//___________________________________________________________________

/** Contains the SUPBOOK index and sheet indexes of an external link.
    It is possible to enter a formula like =SUM(Sheet1:Sheet3!A1),
    therefore here occurs a sheet range. */
struct XclImpXti
{
    sal_uInt16                  nSupbook;           /// Index to SUPBOOK.
    sal_uInt16                  nFirst;             /// Index of first sheet.
    sal_uInt16                  nLast;              /// Index of last sheet.
};


//___________________________________________________________________

/** Stores all EXTERNSHEET and SUPBOOK record data. This is the central class
    for import of all external references.
    File contents in BIFF8:
    - Record EXTERNSHEET: Contains indexes to URLs of external workbooks (SUPBOOKs)
    and sheet indexes for each external reference used anywhere in the workbook.
    This record follows a list of SUPBOOK records.
    - Record SUPBOOK: Contains the name of an external workbook and the names of its sheets.
    This record is followed by NAME, EXTERNNAME, XCT and CRN records.
    - Record XCT: Contains the sheet index of the following CRN records.
    - Record CRN: Contains addresses (row and column) and values of external referenced cells.
    - Record NAME: Contains defined names of the own workbook.
    - Record EXTERNNAME: Contains external defined names or DDE links or OLE object links.
*/
class XclImpExtsheetBuffer
{
private:
    ScfObjList< XclImpXti >     aXtiList;           /// Buffer of all XTI structures.
    XclImpSupbookList           aSupbookList;       /// Buffer of all external workbooks.
    sal_Bool                    bCreated;           /// sal_True = Calc sheets already created.

                                /** Finds the largest range of sheet indexes in a SUPBOOK after a start sheet index.
                                    @param  nSupb
                                    The list index of the SUPBOOK.
                                    @param  nStart
                                    The first allowed sheet index. Sheet ranges with an earlier start index are ignored.
                                    @param  rnFirst
                                    The start index of the range is returned here.
                                    @param  rnLast
                                    The end index of the range is returned here.
                                    @return  sal_True = the return values are valid, sal_False = nothing found. */
    sal_Bool                    FindNextTabRange(
                                    sal_uInt16 nSupb, sal_uInt16 nStart,
                                    sal_uInt16& rnFirst, sal_uInt16& rnLast );

public:
    inline                      XclImpExtsheetBuffer() : bCreated( sal_False ) {}

                                /// Reads the EXTERNSHEET record (BIFF8).
    void                        ReadExternsheet8( XclImpStream& rStrm );
                                /// Reads a SUPBOOK record (BIFF8).
    inline void                 ReadSupbook8( XclImpStream& rStrm )
                                    { aSupbookList.ReadSupbook8( rStrm ); }
                                /// Reads an XCT record (BIFF8) and appends it to the current SUPBOOK.
    void                        ReadXct8( XclImpStream& rStrm );
                                /// Reads a CRN record (BIFF8) and appends it to the current SUPBOOK.
    void                        ReadCrn8( XclImpStream& rStrm, ExcelToSc& rFmlaConv );
                                /// Reads an EXTERNNAME record (BIFF8) and appends it to the current SUPBOOK.
    void                        ReadExternname8( XclImpStream& rStrm, RootData& rRootData );

                                /// Creates all external sheets in the Calc document.
    void                        CreateTables( RootData& rRootData );

                                /// @return  the XTI record data (reference indexes) from position nXtiIndex.
    inline const XclImpXti*     GetXti( sal_uInt32 nXtiIndex ) const
                                    { return aXtiList.GetObject( nXtiIndex ); }

                                /// @return  the SUPBOOK (external workbook) specified by a list index.
    const XclImpSupbook*        GetSupbook( sal_uInt32 nXtiIndex ) const;
                                /// @return  the SUPBOOK (external workbook) specified by its URL.
    inline const XclImpSupbook* GetSupbook( const String& rDocName ) const
                                    { return aSupbookList.GetSupbook( rDocName ); }
};


//___________________________________________________________________

#endif

