/*************************************************************************
 *
 *  $RCSfile: XclImpPivotTables.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: dr $ $Date: 2001/11/06 15:09:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------------

#ifndef _SC_XCLIMPPIVOTTABLES_HXX
#include "XclImpPivotTables.hxx"
#endif

#ifndef _COM_SUN_STAR_SHEET_DATAPILOTFIELDORIENTATION_HPP_
#include <com/sun/star/sheet/DataPilotFieldOrientation.hpp>
#endif

#ifndef SC_DOCUMENT_HXX
#include "document.hxx"
#endif
#ifndef SC_DPSAVE_HXX
#include "dpsave.hxx"
#endif
#ifndef SC_DPOBJECT_HXX
#include "dpobject.hxx"
#endif
#ifndef SC_DPSHTTAB_HXX
#include "dpshttab.hxx"
#endif
#ifndef _SC_FLTTOOLS_HXX
#include "flttools.hxx"
#endif

#ifndef _SC_FILTERTOOLS_HXX
#include "FilterTools.hxx"
#endif
#ifndef _SC_XCLIMPSTREAM_HXX
#include "XclImpStream.hxx"
#endif

using namespace ::com::sun::star;

//_________________________________________________________

XclImpPivotCacheItem::~XclImpPivotCacheItem()
{
}

BOOL XclImpPivotCacheItem::IsString() const
{
	return FALSE;
}

BOOL XclImpPivotCacheItem::IsDouble() const
{
	return FALSE;
}

BOOL XclImpPivotCacheStringItem::IsString() const
{
	return TRUE;
}

BOOL XclImpPivotCacheDoubleItem::IsDouble() const
{
	return TRUE;
}

//_________________________________________________________

XclImpPivotCacheField::~XclImpPivotCacheField()
{
	for( XclImpPivotCacheItem* pItem = _First(); pItem; pItem = _Next() )
		delete pItem;
}

//_________________________________________________________

XclImpPivotCache::XclImpPivotCache( RootData* pExcRoot, UINT16 nStreamId )
{
	SvStorage* pSt = pExcRoot->pPivotCacheStorage;
	if( !pSt )
		return;

    SvStorageStreamRef pStIn = pSt->OpenStream( ScfTools::GetHexStr( nStreamId ), STREAM_STD_READ );
	if( !pStIn.Is() )
		return;

    XclImpStream* pImpStrm = new XclImpStream( *pStIn, pExcRoot->pCharset );
	XclImpStream& rIn = *pImpStrm;

	XclImpPivotCacheField*	pActField			= NULL;
	BOOL					bExistsReadLater	= FALSE;	// any field without items
	BOOL					bDoReadLater		= FALSE;	// read now into this fields
	BOOL					bDataItem;						// last record was data

	UINT16	nId;
	BOOL	bLoop = TRUE;

	while( bLoop && rIn.StartNextRecord() )
	{
		bDataItem = FALSE;
		nId = rIn.GetRecNum();

		switch( nId )
		{
			case 0x000A:									// EOC
				bLoop = FALSE;
			break;
			case 0x00C7:									// Pivot Field
			{
				UINT16	nFlags;
				rIn >> nFlags;
				rIn.Ignore( 12 );
				if( rIn.GetRecLeft() >= 3 )
				{
                    pActField = new XclImpPivotCacheField( rIn.ReadUniString() );
					pActField->SetReadState( TRUEBOOL( nFlags & EXC_SXFIELD_READLATER ) );
					bExistsReadLater |= pActField->GetReadState();
					Append( pActField );
				}
			}
			break;
			case 0x00C8:									// index array
			{
				bDoReadLater = bExistsReadLater;
				if( bDoReadLater )
					pActField = GetFirstReadLater();
			}
			break;
			case 0x00C9:									// double
			{
				bDataItem = TRUE;
				if( rIn.GetRecLeft() >= 8 )
				{
					double fVal;
					rIn >> fVal;
					if( pActField )
						pActField->Append( new XclImpPivotCacheDoubleItem( fVal ) );
				}
			}
			break;
			case 0x00CD:									// String
			{
				bDataItem = TRUE;
				if( pActField && (rIn.GetRecLeft() >= 3) )
                    pActField->Append( new XclImpPivotCacheStringItem( rIn.ReadUniString() ) );
			}
			break;
			case 0x00CE:									// alternative date/time
			{
				bDataItem = TRUE;
				if( pActField )
					pActField->Append( new XclImpPivotCacheDoubleItem( 0 ) );
			}
			break;
		}
		if( bDoReadLater && bDataItem )
			pActField = GetNextReadLater();
	}
}

XclImpPivotCache::~XclImpPivotCache()
{
	for( XclImpPivotCacheField* pField = _First(); pField; pField = _Next() )
		delete pField;
}

void XclImpPivotCache::SetSourceType( UINT16 nType )
{
	switch( nType )
	{
		case EXC_SXVS_EXCEL:		eSrcType = PTST_ExcelOrDB;			break;
		case EXC_SXVS_EXTERN:		eSrcType = PTST_extern;				break;
		case EXC_SXVS_MULTICONSR:	eSrcType = PTST_MultConsoldRngs;	break;
		case EXC_SXVS_PIVOTTAB:		eSrcType = PTST_PivTab;				break;
		case EXC_SXVS_SCENMAN:		eSrcType = PTST_ScenMan;			break;
		default:					eSrcType = PTST_unknown;
	}
}

void XclImpPivotCache::SetSource( UINT8 nC1, UINT16 nR1, UINT8 nC2, UINT16 nR2,
							const String& rFName, const String& rTName, BOOL bSelfRef )
{
	aFileName = rFName;
	aTabName = rTName;
	bSelf = bSelfRef;
	aSrcRange.aStart.Set( nC1, nR1, 0xFFFF );
	aSrcRange.aEnd.Set( nC2, nR2, 0xFFFF );
}

XclImpPivotCacheField* XclImpPivotCache::GetFirstReadLater()
{
	XclImpPivotCacheField*	pField = (XclImpPivotCacheField*) List::First();
	if( pField )
		if( !pField->GetReadState() )
			pField = GetNextReadLater();
	return pField;
}

XclImpPivotCacheField* XclImpPivotCache::GetNextReadLater()
{
	XclImpPivotCacheField* pField = _Next();
	while( pField )
	{
		if( pField->GetReadState() )
			return pField;
		pField = _Next();
	}
	return NULL;
}

const XclImpPivotCacheItem* XclImpPivotCache::GetItem( UINT16 nFieldId, UINT16 nItemId ) const
{
	const XclImpPivotCacheField* pField = (const XclImpPivotCacheField*) List::GetObject( nFieldId );
	return pField ? pField->Get( nItemId ) : NULL;
}


const String* XclImpPivotCache::GetFieldName( UINT16 nFieldId ) const
{
	const XclImpPivotCacheField* pField = (const XclImpPivotCacheField*) List::GetObject( nFieldId );
	return pField ? pField->GetName() : NULL;
}

//_________________________________________________________

XclImpPivotCacheList::~XclImpPivotCacheList()
{
	for( XclImpPivotCache* pCache = _First(); pCache; pCache = _Next() )
		delete pCache;
}

//_________________________________________________________

XclImpPivotDataItem::XclImpPivotDataItem( UINT16 nI, UINT16 nFunc, UINT16 nD,
								UINT16 nF, String* pName ) :
		nIndex( nI ),
		nFunction( nFunc ),
		nDisplay( nD ),
		nFormat( nF )
{
	pLayoutName = pName ? new String( *pName ) : NULL;
}

XclImpPivotDataItem::~XclImpPivotDataItem()
{
	if( pLayoutName )
		delete pLayoutName;
}

//_________________________________________________________

XclImpPivotDataItemList::~XclImpPivotDataItemList()
{
	for( XclImpPivotDataItem* pItem = _First(); pItem; pItem = _Next() )
		delete pItem;
}

//_________________________________________________________

XclImpPivotFieldItem::XclImpPivotFieldItem( UINT16 nT, UINT16 nC, UINT16 nGrBit ) :
		nType( nT ),
		nCache( nC ),
		bHidden( TRUEBOOL( nGrBit & EXC_SXVI_HIDDEN ) ),
		bHideDetail( TRUEBOOL( nGrBit & EXC_SXVI_HIDEDETAIL ) ),
		bFormula( TRUEBOOL( nGrBit & EXC_SXVI_FORMULA ) ),
		bMissing( TRUEBOOL( nGrBit & EXC_SXVI_MISSING ) )
{
}

XclImpPivotFieldItem::XclImpPivotFieldItem( XclImpPivotFieldItem& r ) :
		nType( r.nType ),
		nCache( r.nCache ),
		bHidden( r.bHidden ),
		bHideDetail( r.bHideDetail ),
		bFormula( r.bFormula ),
		bMissing( r.bMissing )
{
}

//_________________________________________________________

XclImpPivotFieldItemList::XclImpPivotFieldItemList( XclImpPivotFieldItemList& r )
{
	for( XclImpPivotFieldItem* pItem = _First(); pItem; pItem = _Next() )
		Append( new XclImpPivotFieldItem( *pItem ) );
}

XclImpPivotFieldItemList::~XclImpPivotFieldItemList()
{
	for( XclImpPivotFieldItem* pItem = _First(); pItem; pItem = _Next() )
		delete pItem;
}

//_________________________________________________________

XclImpPivotTabField::XclImpPivotTabField( UINT16 nAx, UINT16 nNOSubt, UINT16 nSType,
								UINT16 nNOItems, UINT16 nCI, const String* pName ) :
		nCacheIndex( nCI ),
		nIndex( 0xFFFF ),
		nNumOfSubtotals( nNOSubt ),
		nNumOfItems( nNOItems ),
		nSubType( nSType )
{
	pLayoutName = pName ? new String( *pName ) : NULL;
	switch( nAx )
	{
		case EXC_PIVOT_AXIS_ROW:	nAxis = sheet::DataPilotFieldOrientation_ROW;		break;
		case EXC_PIVOT_AXIS_COL:	nAxis = sheet::DataPilotFieldOrientation_COLUMN;	break;
		case EXC_PIVOT_AXIS_PAGE:	nAxis = sheet::DataPilotFieldOrientation_PAGE;		break;
		case EXC_PIVOT_AXIS_DATA:	nAxis = sheet::DataPilotFieldOrientation_DATA;		break;
		default:					nAxis = sheet::DataPilotFieldOrientation_HIDDEN;
	}
}

XclImpPivotTabField::XclImpPivotTabField( XclImpPivotTabField& r, UINT16 nSubT, const String* pName ) :
		aItemList( r.aItemList ),
		nCacheIndex( r.nCacheIndex ),
		nIndex( r.nIndex ),
		nNumOfSubtotals( r.nNumOfSubtotals ),
		nNumOfItems( r.nNumOfItems ),
		nAxis( r.nAxis ),
		nSubType( nSubT )
{
	pLayoutName = pName ? new String( *pName ) : NULL;
}

XclImpPivotTabField::~XclImpPivotTabField()
{
	if( pLayoutName )
		delete pLayoutName;
}

//_________________________________________________________

XclImpPivotTabFieldList::~XclImpPivotTabFieldList()
{
	for( XclImpPivotTabField* pField = _First(); pField; pField = _Next() )
		delete pField;
	if( pIndexList )
		delete pIndexList;
}

void XclImpPivotTabFieldList::AddIndex( UINT16 nIndex )
{
	if( !pIndexList )
        pIndexList = new ScfUInt16List;
	pIndexList->Append( nIndex );
}

XclImpPivotTabField* XclImpPivotTabFieldList::_FindIndex( UINT16 nIndex )
{
	XclImpPivotTabField*	pField = _First();
	while( pField )
	{
		if( pField->GetCacheIndex() == nIndex )
			return pField;
		pField = _Next();
	}
	return NULL;
}

const XclImpPivotTabField* XclImpPivotTabFieldList::FirstInOrder()
{
	nIndexCnt = 0;
	if( pIndexList )
        return _FindIndex( pIndexList->GetValue( 0 ) );
	return (const XclImpPivotTabField*) List::First();
}

const XclImpPivotTabField* XclImpPivotTabFieldList::NextInOrder()
{
	if( pIndexList )
	{
		nIndexCnt++;
		if( nIndexCnt < pIndexList->Count() )
            return _FindIndex( pIndexList->GetValue( nIndexCnt ) );
		return NULL;
	}
	return (const XclImpPivotTabField*) List::Next();
}

XclImpPivotTabField* XclImpPivotTabFieldList::CreateDuplicate( UINT16 nCache, UINT16 nSubT,
												const String* pName )
{
	XclImpPivotTabField* pNew = NULL;
	XclImpPivotTabField* pOld = _FindIndex( nCache );
	if( pOld )
		pNew = new XclImpPivotTabField( *pOld, nSubT, pName );
	return pNew;
}

//_________________________________________________________

XclImpPivotTable::XclImpPivotTable( XclImpStream& rIn, RootData* pRD, UINT8 nTab ) :
		ExcRoot( pRD )
{
	nSxIvdTurn = nSxLiInd = 0;
	pActField = pActDataField = NULL;
	pColFieldList = pRowFieldList = pPageFieldList = NULL;
	pDataFieldList = pFullDataList = NULL;
	pDataItemList = NULL;
	pCache = NULL;
	nCacheIndexCnt = 0;

	UINT16 nRowFirst, nRowLast, nColFirst, nColLast;
	UINT16 nRowFirstHead, nRowFirstData, nColFirstData;
	UINT16 nICache, nDummy, nDefAxis4Data, nDefPos4Data, nDim;
	UINT16 nNumDataRow, nNumDataCol, nIndTabAutoFmt;
	UINT16 nTabNameLen, nDtaFldNameLen;

	rIn	>> nRowFirst >> nRowLast >> nColFirst >> nColLast
		>> nRowFirstHead >> nRowFirstData >> nColFirstData
		>> nICache >> nDummy >> nDefAxis4Data >> nDefPos4Data >> nDim
		>> nDimRow >> nDimCol >> nDimPage >> nDimData
		>> nNumDataRow >> nNumDataCol >> nFlags >> nIndTabAutoFmt
		>> nTabNameLen >> nDtaFldNameLen;

	if( pExcRoot->pImpPivotCacheList )
		pCache = pExcRoot->pImpPivotCacheList->Get( nICache );

	aViewRange.aStart.Set( nColFirst & 0xFF, nRowFirst, nTab );
	aViewRange.aEnd.Set( nColLast & 0xFF, nRowLast, nTab );
	aOutputRange = aViewRange;
	if( aOutputRange.aStart.Row() )
		aOutputRange.aStart.IncRow( -1 );

// *** unused ***
//	String	aPivTabName;
//	if( nTabNameLen )
//      rIn.AppendUniString( aPivTabName, nTabNameLen );
//	String	aDataFieldName;
//	if( nDtaFldNameLen )
//      rIn.AppendUniString( aDataFieldName, nDtaFldNameLen );
}

XclImpPivotTable::~XclImpPivotTable()
{
	if( pColFieldList )
		delete pColFieldList;
	if( pRowFieldList )
		delete pRowFieldList;
	if( pPageFieldList )
		delete pPageFieldList;
	if( pDataFieldList )
		delete pDataFieldList;
	if( pFullDataList )
		delete pFullDataList;
	if( pDataItemList )
		delete pDataItemList;
}

void XclImpPivotTable::DecodeSubTotals( long& rCount, USHORT* pFuncs, UINT16 nFlags )
{
	rCount = 0;
	if( !nFlags )
		return;
	UINT16	nMask = 0x0001;
	for( USHORT nBitNum = 1; nBitNum <= 16; nBitNum++ )
	{
		if( nFlags & nMask )
		{
			pFuncs[ rCount ] = nBitNum;
			rCount++;
		}
		nMask <<= 1;
	}
}

void XclImpPivotTable::AddViewField( XclImpStream& rIn )
{
	XclImpPivotTabFieldList**	ppList;
	UINT16						nAxis, nSubTotals, nSubType, nItems, nStrLen;
	String*						pName		= NULL;

	rIn >> nAxis >> nSubTotals >> nSubType >> nItems >> nStrLen;
	if( nStrLen < 0xFFFF )
        pName = new String( rIn.ReadUniString( nStrLen ) );

	pActField = pActDataField = NULL;

	for( UINT16 nAxisMask = 0x0001; nAxisMask <= 0x0008; nAxisMask <<= 1 )
	{
		if( nAxis & nAxisMask )
		{
			XclImpPivotTabField*& rpAct = (nAxisMask == EXC_PIVOT_AXIS_DATA) ? pActDataField : pActField;
			switch( nAxisMask )
			{
				case EXC_PIVOT_AXIS_ROW:	ppList = &pRowFieldList;	break;
				case EXC_PIVOT_AXIS_COL:	ppList = &pColFieldList;	break;
				case EXC_PIVOT_AXIS_PAGE:	ppList = &pPageFieldList;	break;
				case EXC_PIVOT_AXIS_DATA:	ppList = &pDataFieldList;	break;
				default:					ppList = NULL;
			}
			if( ppList )
			{
				if( !*ppList )
					*ppList = new XclImpPivotTabFieldList;
				rpAct = new XclImpPivotTabField( nAxisMask, nSubTotals, nSubType, nItems, nCacheIndexCnt, pName );
				(*ppList)->Append( rpAct );
			}
		}
	}

	if( pName )
		delete pName;
	nCacheIndexCnt++;
}

void XclImpPivotTable::AddViewItem( UINT16 nItemType, UINT16 nCache, UINT16 nGrBit )
{
	if( pActField )
		pActField->AppendItem( nItemType, nCache, nGrBit );
	if( pActDataField )
		pActDataField->AppendItem( nItemType, nCache, nGrBit );
}

void XclImpPivotTable::ReadRCFieldIDs( XclImpStream& rIn )
{
	if( nSxIvdTurn > 1 )
		return;

	if( !nSxIvdTurn && !nDimRow ) nSxIvdTurn++;	// row-SXIVD doesn't exist if no row fields

	XclImpPivotTabFieldList*& rpFL = nSxIvdTurn ? pColFieldList : pRowFieldList;
	if( !rpFL )
		return;

	UINT16	nArrayCnt = (UINT16)(rIn.GetRecLen() >> 1);
	UINT16	nIndex;

	for( UINT16 iCnt = 0; iCnt < nArrayCnt; iCnt++ )
	{
		rIn >> nIndex;
		if( nIndex == EXC_SXIVD_IDDATA )
			rpFL->Append( new XclImpPivotTabField( nSxIvdTurn + 1, 1, 1, 0, EXC_SXIVD_IDDATA, NULL ) );
		rpFL->SetIndex( iCnt, nIndex );
		rpFL->AddIndex( nIndex );
	}
	nSxIvdTurn++;
}

void XclImpPivotTable::AddPageItemInfo( UINT16 nSXVD, UINT16 nSXVI )
{
	if( !pPageFieldList )
		return;

	pPageFieldList->SetIndex( nSXVD, nSXVI );
	pPageFieldList->AddIndex( nSXVD );
	if( aOutputRange.aStart.Row() )
		aOutputRange.aStart.IncRow( -1 );
}

void XclImpPivotTable::AddDataItem( XclImpStream& rIn )
{
	String*			pName	= NULL;
	UINT16			nIndex, nFunc, nD, nSXVD, nSXVI, nF, nStrLen;

	rIn >> nIndex >> nFunc >> nD >> nSXVD >> nSXVI >> nF >> nStrLen;
	if( nStrLen < 0xFFFF )
        pName = new String( rIn.ReadUniString( nStrLen ) );

	if( !pDataItemList )
		pDataItemList = new XclImpPivotDataItemList;
	pDataItemList->Append( new XclImpPivotDataItem( nIndex, nFunc, nD, nF, pName ) );

	if( pName )
		delete pName;
}

void XclImpPivotTable::CreateFullDataList()
{
	if( !pDataFieldList || !pDataItemList )
		return;

	for( const XclImpPivotDataItem* pDI = pDataItemList->First(); pDI; pDI = pDataItemList->Next() )
	{
		XclImpPivotTabField* pField =	pDataFieldList->CreateDuplicate(
			pDI->GetIndex(), pDI->GetFunction(), pDI->GetLayoutName() );

		if( pField )
		{
			if( !pFullDataList )
				pFullDataList = new XclImpPivotTabFieldList;
			pFullDataList->Append( pField );
		}
	}
}

void XclImpPivotTable::SetFields( XclImpPivotTabFieldList& rList, USHORT nOrient, ScDPSaveData& rSaveData )
{
	ScDPSaveDimension*			pDim;
	const String*				pFieldName;
	const XclImpPivotCacheItem*	pCI;
	const XclImpPivotTabField*	pPF = rList.FirstInOrder();

	while( pPF )
	{
		if( pPF->GetIndex() == EXC_SXIVD_IDDATA )
		{
			pDim = rSaveData.GetDataLayoutDimension();
			pDim->SetOrientation( nOrient );
		}
		else
		{
			pFieldName = pPF->GetCacheName( pCache );
			if( pFieldName )
				pDim = rSaveData.GetNewDimensionByName( *pFieldName );
			else
			{
				String aDummy( RTL_CONSTASCII_USTRINGPARAM( "<INVALID CACHE INDEX #" ) );
				aDummy += String::CreateFromInt32( pPF->GetCacheIndex() );
				aDummy.AppendAscii( ">" );
				pDim = rSaveData.GetDimensionByName( aDummy );
			}

			pDim->SetOrientation( nOrient );
			pDim->SetLayoutName( pPF->GetLayoutName() );
			pDim->SetShowEmpty( pPF->GetShowEmpty() );

			// subtotal type
			UINT16	nSubType = pPF->GetSubType();
			if( nOrient == sheet::DataPilotFieldOrientation_DATA )
				pDim->SetFunction( nSubType + 2 );
			else
			{
				long	nCount;
				USHORT	nFuncs[16];
				DecodeSubTotals( nCount, nFuncs, nSubType );
				pDim->SetSubTotals( nCount, nFuncs );
			}

			if( !pCache )
				return;

			// view items
			const XclImpPivotFieldItemList&	rItemList = pPF->GetItemList();
			UINT32							nNumItems = rItemList.Count();
			UINT32							nItemCnt;
			const XclImpPivotFieldItem*		pItem;
			ScDPSaveMember*					pMember;
			for( nItemCnt = 0; nItemCnt < nNumItems; nItemCnt++ )
			{
				pItem = rItemList.Get( nItemCnt );
				if( pItem )
				{
					pCI = pCache->GetItem( pPF->GetCacheIndex(), pItem->GetCacheIndex() );
					if( pCI )
					{
						if( pCI->IsString() )
							pMember = pDim->GetMemberByName(
								((XclImpPivotCacheStringItem*) pCI)->GetCont() );
						else if( pCI->IsDouble() )
							pMember = NULL;
//							pMember = pDim->GetMemberByValue(
//								((XclImpPivotCacheDoubleItem*) pCI)->GetCont() );
						else
							pMember = NULL;

						if( pMember )
						{
							pMember->SetIsVisible( !pItem->IsHidden() );
							pMember->SetShowDetails( !pItem->IsHideDetail() );
						}
					}
				}
			}
		}
		pPF = rList.NextInOrder();
	}
}

void XclImpPivotTable::Apply()
{
	if( !pCache )
		return;

	if( !pCache->IsSelfRef() || pCache->GetSourceType() != PTST_ExcelOrDB )
		return;

	UINT16	nTabNum = 0xFFFF;
	ScRange aSrcRange( pCache->GetSourceRange() );

	if( aSrcRange.aStart.Tab() >= 0xFF && !pExcRoot->pDoc->GetTable( pCache->GetTabName(), nTabNum ) )
		return;

	ScDPSaveData aSaveData;

	aSaveData.SetRowGrand( TRUEBOOL( nFlags & EXC_SXVIEW_ROWGRAND ) );
	aSaveData.SetColumnGrand( TRUEBOOL( nFlags & EXC_SXVIEW_COLGRAND ) );

	if( pRowFieldList )
		SetFields( *pRowFieldList, sheet::DataPilotFieldOrientation_ROW, aSaveData );
	if( pColFieldList )
		SetFields( *pColFieldList, sheet::DataPilotFieldOrientation_COLUMN, aSaveData);
	if( pPageFieldList )
		SetFields( *pPageFieldList, sheet::DataPilotFieldOrientation_PAGE, aSaveData );
	if( pDataFieldList )
	{
		CreateFullDataList();
		if( pFullDataList )
			SetFields( *pFullDataList, sheet::DataPilotFieldOrientation_DATA, aSaveData );
	}

	ScDPCollection*		pColl = pExcRoot->pDoc->GetDPCollection();
	ScDPObject*			pNew = new ScDPObject( pExcRoot->pDoc );
	ScSheetSourceDesc	aDesc;

	aSrcRange.aStart.SetTab( nTabNum );
	aSrcRange.aEnd.SetTab( nTabNum );
	aDesc.aSourceRange = aSrcRange;
	pNew->SetSaveData( aSaveData );
	pNew->SetSheetDesc( aDesc );
	pNew->SetOutRange( aViewRange );
	pNew->SetAlive( TRUE );
	pColl->Insert( pNew );
}

//_________________________________________________________

XclImpPivotTableList::~XclImpPivotTableList()
{
	for( XclImpPivotTable* pTable = First(); pTable; pTable = Next() )
		delete pTable;
}

BOOL XclImpPivotTableList::IsInPivotRange( UINT16 nCol, UINT16 nRow, UINT16 nTab ) const
{
	const ScAddress aRef( nCol, nRow, nTab );

	for( UINT32 nCnt = 0; nCnt < List::Count(); nCnt++ )
	{
		XclImpPivotTable* pTable = Get( nCnt );
		if( pTable && pTable->IsInPivotRange( aRef ) )
			return TRUE;
	}
	return FALSE;
}

void XclImpPivotTableList::Apply()
{
	for( XclImpPivotTable* pTable = First(); pTable; pTable = Next() )
		pTable->Apply();
}

