/*************************************************************************
 *
 *  $RCSfile: datagrid.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: dr $ $Date: 2001/05/30 13:49:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PCH
#include "ui_pch.hxx"
#endif

#pragma hdrstop

#include "datagrid.hxx"

#include "scitems.hxx"
#include <svx/eeitem.hxx>
#include <svx/colritem.hxx>
#include <svx/fhgtitem.hxx>
#include <svx/fontitem.hxx>
#include <svtools/itemset.hxx>

#include "editutil.hxx"

#define _SVSTDARR_STRINGS
#include <svtools/svstdarr.hxx>

#ifndef _GEN_HXX //autogen
#include <tools/gen.hxx>
#endif

#ifndef _SV_MAPMOD_HXX //autogen
#include <vcl/mapmod.hxx>
#endif

// ------------------------------------------------------------------------

void lcl_CopyBackAndSetFill( OutputDevice& rParent, OutputDevice& rChild1,
							 OutputDevice& rChild2, OutputDevice& rChild3 )
{
	//	set background from Parent to Parent's fill and children's background

	if ( rParent.IsBackground() )
	{
		Wallpaper aBack = rParent.GetBackground();
		rParent.SetFillColor( aBack.GetColor() );
		rChild1.SetBackground( aBack );
		rChild2.SetBackground( aBack );
		rChild3.SetBackground( aBack );
	}
	else
	{
		rParent.SetFillColor();
		rChild1.SetBackground();
		rChild2.SetBackground();
		rChild3.SetBackground();
	}
}

void lcl_Draw3DRect( OutputDevice& rDev, const Point& rPos, const Size& rSize )
{
    rDev.SetLineColor();
    rDev.DrawRect( Rectangle( rPos, rSize ) );
    Point aBR( rPos.X() + rSize.Width() - 1, rPos.Y() + rSize.Height() - 1 );
    rDev.SetLineColor( COL_WHITE );
    rDev.DrawLine( rPos, Point( rPos.X(), aBR.Y() - 1 ) );
    rDev.DrawLine( rPos, Point( aBR.X() - 1, rPos.Y() ) );
    rDev.SetLineColor( COL_BLACK );
    rDev.DrawLine( Point( rPos.X() + 1, aBR.Y() ), aBR );
    rDev.DrawLine( Point( aBR.X(), rPos.Y() + 1 ), aBR );
}


/*************************************************************************
#*	Member:		ScDataGrid									Datum:10.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Konstruktor der Klasse ScDataGrid
#*
#*  Input:		Fenster, Resource
#*
#*	Output:		---
#*
#************************************************************************/

void ScDataGrid::Construct()
{
	Point aPos(0,0);
	aTopWinPos=aPos;
	aLeftWinPos=aPos;
	aDataWinPos=aPos;
	aSelectedCell.A()=-1;
	nSelectedRow=-1;
	aSelectedCell.B()=-1;
	nSelectedCol=-1;
	bMouseAktiv=FALSE;
	nMouseXPos=0;

	aTopWinDev.Erase();
	aLeftWinDev.Erase();
	aDataWinDev.Erase();

	Size aPSize=GetOutputSizePixel();
	aTopWinDev.SetOutputSizePixel(aPSize);
	aLeftWinDev.SetOutputSizePixel(aPSize);
	aDataWinDev.SetOutputSizePixel(aPSize);

	lcl_CopyBackAndSetFill( *this, aTopWinDev, aLeftWinDev, aDataWinDev );

	nNumberOfRows=0;
	nNumberOfCols=0;
	nContextSelPos=-1;
	SetBackground();
	aOffsetPoint.X()=0;
	aOffsetPoint.Y()=0;

	pEditEngine = new ScEditEngineDefaulter( EditEngine::CreatePool(), TRUE );
	pEditEngine->SetRefDevice( &aDataWinDev );

	aDefaultFont = GetFont();		// before SetLatinFont
}

ScDataGrid::ScDataGrid( Window* pParent, const ResId& rResId )
:Control(pParent,rResId),
		aTopWinDev(),
		aLeftWinDev(),
		aDataWinDev()
{
	Construct();
}

/*************************************************************************
#*	Member:		ScDataGrid									Datum:10.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Konstruktor der Klasse ScDataGrid
#*
#*  Input:		Fenster, Style-Bits
#*
#*	Output:		---
#*
#************************************************************************/

ScDataGrid::ScDataGrid( Window* pParent, WinBits nWinStyle)
:Control(pParent,nWinStyle),
		aTopWinDev(),
		aLeftWinDev(),
		aDataWinDev()
{
	Construct();
}


/*************************************************************************
#*	Member:	~ScDataGrid										Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Destruktor. Gibt den Speicher wieder frei.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
ScDataGrid::~ScDataGrid()
{
	ClearTable();
	delete pEditEngine;
}

//------------------------------------------------------------------------

void ScDataGrid::SetLatinFont( const Font& rLatinFont )
{
	SetFont( rLatinFont );

	//	set edit engine defaults:
	//	passed font (monospaced) for latin script,
	//	smaller default font for asian / complex

	SvxFontItem aLatinItem(EE_CHAR_FONTINFO);
	SvxFontItem aAsianItem(EE_CHAR_FONTINFO_CJK);
	SvxFontItem aComplexItem(EE_CHAR_FONTINFO_CTL);
	GetDefaultFonts( aLatinItem, aAsianItem, aComplexItem );

	SfxItemSet aDefaults( pEditEngine->GetEmptyItemSet() );
	EditEngine::SetFontInfoInItemSet( aDefaults, rLatinFont );
	aDefaults.Put( aAsianItem );
	aDefaults.Put( aComplexItem );

	//	set asian font height to width of character in latin font

	long nSmall = GetTextWidth(String('X'));
	aDefaults.Put( SvxFontHeightItem( nSmall, 100, EE_CHAR_FONTHEIGHT_CJK ) );
	aDefaults.Put( SvxFontHeightItem( nSmall, 100, EE_CHAR_FONTHEIGHT_CTL ) );

	//	copy other items from default (latin) font

	const SfxPoolItem& rWeightItem = aDefaults.Get( EE_CHAR_WEIGHT );
	aDefaults.Put( rWeightItem, EE_CHAR_WEIGHT_CJK );
	aDefaults.Put( rWeightItem, EE_CHAR_WEIGHT_CTL );
	const SfxPoolItem& rItalicItem = aDefaults.Get( EE_CHAR_ITALIC );
	aDefaults.Put( rItalicItem, EE_CHAR_ITALIC_CJK );
	aDefaults.Put( rItalicItem, EE_CHAR_ITALIC_CTL );
	const SfxPoolItem& rLangItem = aDefaults.Get( EE_CHAR_LANGUAGE );
	aDefaults.Put( rLangItem, EE_CHAR_LANGUAGE_CJK );
	aDefaults.Put( rLangItem, EE_CHAR_LANGUAGE_CTL );

	pEditEngine->SetDefaults( aDefaults );
}

/*************************************************************************
#*	Member:		DeleteRow									Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Loescht, ab der Zeile nAt, die angegebene
#*				Anzahl nNum von Zeilen
#*
#*  Input:		ab Zeile, Anzahl
#*
#*	Output:		---
#*
#************************************************************************/
void ScDataGrid::DeleteRow(USHORT nAt,USHORT nNum)
{
	if(nSelectedRow>=nAt && nSelectedRow<nAt+nNum)
	{
		aSelectedCell.A()=-1;
		nSelectedRow=-1;
		aSelectedCell.B()=-1;
		nSelectedCol=-1;
	}

	ScStringsPtr pStrings;
	int nTarget=nAt+nNum;
	if(nTarget>aScStringsArray.Count()) nTarget=aScStringsArray.Count();

	for(int j=nAt;j<nTarget;j++)
	{
			pStrings=aScStringsArray[j];
			pStrings->DeleteAndDestroy(0,pStrings->Count());
			delete pStrings;
	}
	aHeightOfRows.Remove(nAt,nNum);
	aScStringsArray.Remove(nAt,nNum);
	nNumberOfRows=aScStringsArray.Count();
}

/*************************************************************************
#*	Member:		DeleteCol									Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Loescht, ab der Spalte nAt, die angegebene
#*				Anzahl nNum von Spalten.
#*
#*  Input:		ab Spalte, Anzahl
#*
#*	Output:		---
#*
#************************************************************************/
void ScDataGrid::DeleteCol(USHORT nAt,USHORT nNum)
{
	if(nSelectedCol>=nAt && nSelectedCol<nAt+nNum)
	{
		aSelectedCell.A()=-1;
		nSelectedRow=-1;
		aSelectedCell.B()=-1;
		nSelectedCol=-1;
	}

	ScStringsPtr pStrings;
	for(int j=0;j<nNumberOfRows;j++)
	{
			pStrings=aScStringsArray[j];
			pStrings->DeleteAndDestroy(nAt,nNum);
	}
	aWidthOfCols.Remove(nAt,nNum);
	nNumberOfCols-=nNum;
}

/*************************************************************************
#*	Member:		ClearTable									Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Loescht die gesamte Tabelle, sowie alle
#*				Seperatoren im Lineal
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void ScDataGrid::ClearTable()
{
	aSelectedCell.A()=-1;
	nSelectedRow=-1;
	aSelectedCell.B()=-1;
	nSelectedCol=-1;

	DeleteRow(0,nNumberOfRows);
	DeleteCol(0,nNumberOfCols);
}
/*************************************************************************
#*	Member:		UpdateArray									Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Fuehrt ein Update durch.
#*
#*  Input:		Zeilen, Spalten
#*
#*	Output:		---
#*
#************************************************************************/
void ScDataGrid::UpdateArray(USHORT Rows,USHORT Cols)
{
	 // Wird momentan nicht verwendet.
}
/*************************************************************************
#*	Member:		InsertRow									Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Fuegt an der Position nAt, die angegebene
#*				Anzahl von Zeilen nNum ein.
#*
#*  Input:		Position, Anzahl
#*
#*	Output:		---
#*
#************************************************************************/

void ScDataGrid::InsertRow(USHORT nAt,USHORT nNum)
{
	USHORT	aNewHeight=nStdHeight;
	for(USHORT i=nAt;i<nAt+nNum;i++)
	{
		aHeightOfRows.Insert(aNewHeight,i);
		ScStringsPtr pStrings=new SvStrings;
		if(pStrings!=NULL)
		{
			for(USHORT j=0;j<nNumberOfCols;j++)
			{
				pStrings->Insert(new String,j);
			}

		}
		aScStringsArray.Insert(pStrings,i);
	}
	nNumberOfRows=aScStringsArray.Count();
}

/*************************************************************************
#*	Member:		InsertCol									Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Fuegt an der Position nAt, die angegebene
#*				Anzahl von Spalten nNum ein.
#*
#*  Input:		Position, Anzahl
#*
#*	Output:		---
#*
#************************************************************************/

void ScDataGrid::InsertCol(USHORT nAt,USHORT nNum)
{
	ScStringsPtr pStrings;
	USHORT	nNewWidth=nStdWidth;
	for(int i=nAt;i<nAt+nNum;i++)
	{
		aWidthOfCols.Insert(nNewWidth,i);
		for(int j=0;j<nNumberOfRows;j++)
		{
			pStrings=aScStringsArray[j];
			pStrings->Insert(new String,i);
		}
	}
	nNumberOfCols+=nNum;
}


/*************************************************************************
#*	Member:		SetWidthOfAllCols							Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Stellt die Breite fuer alle Spalten ein.
#*
#*  Input:		neue Breite
#*
#*	Output:		---
#*
#************************************************************************/

void ScDataGrid::SetWidthOfAllCols(USHORT nWidth)
{
	for(USHORT i=0;i<nNumberOfCols;i++)
	{
		SetWidthOfCol(i,nWidth);
	}
	nStdWidth=nWidth;
}

/*************************************************************************
#*	Member:		SetStdHeight								Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Stellt die Standardhoehe ein.
#*
#*  Input:		Hoehe
#*
#*	Output:		---
#*
#************************************************************************/

void ScDataGrid::SetStdHeight(USHORT val)
{
	nStdHeight=val;
}

/*************************************************************************
#*	Member:		SetStdWidth									Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Stellt die Standardbreite ein.
#*
#*  Input:		Breite
#*
#*	Output:		---
#*
#************************************************************************/

void ScDataGrid::SetStdWidth(USHORT val)
{
	nStdWidth=val;
}



/*************************************************************************
#*	Member:		ScDataGrid									Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void ScDataGrid::SetWidthOfCol(USHORT nCol, USHORT nWidth)
{
	if(nCol==0)
	{
		aTopWinPos.X()=nWidth;
		aDataWinPos.X()=nWidth;
		Size aPSize=GetOutputSizePixel();
		aTopWinSize=aTopWinDev.GetOutputSizePixel();
		aLeftWinSize=aLeftWinDev.GetOutputSizePixel();
		aDataWinSize=aDataWinDev.GetOutputSizePixel();

		aLeftWinSize.Width()=nWidth;
		aDataWinSize.Width()=aPSize.Width()-nWidth;
		aTopWinSize.Width()=aPSize.Width()-nWidth;


		aTopWinDev.SetOutputSizePixel(aTopWinSize);
		aDataWinDev.SetOutputSizePixel(aDataWinSize);
		aLeftWinDev.SetOutputSizePixel(aLeftWinSize);
	}

	if(nCol<nNumberOfCols) aWidthOfCols.Replace(nWidth,nCol);
	Invalidate();
}


/*************************************************************************
#*	Member:		GetWidthOfCol								Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Liefert die Breite einer Spalte zurueck.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

USHORT ScDataGrid::GetWidthOfCol(USHORT nCol)
{
	if(nCol<nNumberOfCols)
		return aWidthOfCols[nCol];
	return 0;
}

/*************************************************************************
#*	Member:		GetHeightOfRow								Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Liefert die Hoehe einer Zeile zurueck
#*
#*  Input:		Zeile
#*
#*	Output:		Hoehe
#*
#************************************************************************/

USHORT ScDataGrid::GetHeightOfRow(USHORT nRow)
{
	if(nRow<nNumberOfRows)
		return aHeightOfRows[nRow];
	return 0;
}

/*************************************************************************
#*	Member:		SetHeightOfAllRows							Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Stellt die Hoehe fuer alle Zeilen ein.
#*
#*  Input:		Hoehe
#*
#*	Output:		---
#*
#************************************************************************/

void ScDataGrid::SetHeightOfAllRows(USHORT nHeight)
{
	for(USHORT i=0;i<nNumberOfRows;i++)
	{
		SetHeightOfRow(i,nHeight);
	}
	nStdHeight=nHeight;
}

/*************************************************************************
#*	Member: SetHeightOfRow									Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Stellt die Hoehe fuer eine Zeile ein
#*
#*  Input:		Zeile, Hoehe
#*
#*	Output:		---
#*
#************************************************************************/

void ScDataGrid::SetHeightOfRow(USHORT nRow, USHORT nHeight)
{
	if(nRow==0)
	{
		aLeftWinPos.Y()=nHeight;
		aDataWinPos.Y()=nHeight;

		Size aPSize=GetOutputSizePixel();

		aTopWinSize=aTopWinDev.GetOutputSizePixel();
		aLeftWinSize=aLeftWinDev.GetOutputSizePixel();
		aDataWinSize=aDataWinDev.GetOutputSizePixel();

		aTopWinSize.Height()=nHeight;
		aLeftWinSize.Height()=aPSize.Height()-nHeight;
		aDataWinSize.Height()=aPSize.Height()-nHeight;

		aTopWinDev.SetOutputSizePixel(aTopWinSize);
		aDataWinDev.SetOutputSizePixel(aDataWinSize);
		aLeftWinDev.SetOutputSizePixel(aLeftWinSize);
	}

	if(nRow<nNumberOfRows) aHeightOfRows.Replace(nHeight,nRow);
	Invalidate();
}

/*************************************************************************
#*	Member:		SetDataAtRowCol								Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Setzt an der Position [nRow,nCol] den String aDataStr.
#*				Wenn diese Position nicht vorhanden ist, werden die
#*				entsprechenden Zeilen oder Spalten eingefuegt!!!
#*
#*  Input:		Position [nRow,nCol], Text
#*
#*	Output:		---
#*
#************************************************************************/

void ScDataGrid::SetDataAtRowCol(USHORT nRow,USHORT nCol,String aDataStr)
{
	ScStringsPtr pStrings;
	StringPtr	pDatString;
	if(nRow<nNumberOfRows && nCol<nNumberOfCols)
	{
		pStrings=aScStringsArray[nRow];
		if(pStrings!=NULL)
		{
			pDatString=(*pStrings)[nCol];
			if(pDatString!=NULL) *pDatString=aDataStr;
		}
	}
	else
	{
		if(nRow>=nNumberOfRows) InsertRow(nNumberOfRows,nRow-nNumberOfRows+1);
		if(nCol>=nNumberOfCols) InsertCol(nNumberOfCols,nCol-nNumberOfCols+1);
		SetDataAtRowCol(nRow,nCol,aDataStr);
	}
	Invalidate();
}


/*************************************************************************
#*	Member:		GetDataAtRowCol								Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Liefert den Tabellenwert fuer die Position [nRow,nCol]
#*				zurueck
#*
#*  Input:		Position [nRow,nCol]
#*
#*	Output:		Text
#*
#************************************************************************/

String ScDataGrid::GetDataAtRowCol(USHORT nRow,USHORT nCol)
{
	ScStringsPtr pStrings;
	StringPtr	pDatString;
	if(nRow<nNumberOfRows && nCol<nNumberOfCols)
	{
		pStrings=aScStringsArray[nRow];
		if(pStrings!=NULL)
		{
			pDatString=(*pStrings)[nCol];
			return *pDatString;
		}
	}
	return String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("NULL Pointer!"));
}

/*************************************************************************
#*	Member:		SetXTablePos								Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Setzt den Nullpunkt zum Zeichnen der Tabelle in
#*				X-Richtung
#*
#*  Input:		neuer X-Nullpunkt
#*
#*	Output:		---
#*
#************************************************************************/
void ScDataGrid::SetXTablePos(short nX)
{
	aOffsetPoint.X()=nX;
}

/*************************************************************************
#*	Member:		SetYTablePos								Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Setzt den Nullpunkt zum Zeichnen der Tabelle in
#*				Y-Richtung
#*
#*  Input:		neuer Y-Nullpunkt
#*
#*	Output:		---
#*
#************************************************************************/
void ScDataGrid::SetYTablePos(short nY)
{
	aOffsetPoint.Y()=nY;
}


/*************************************************************************
#*	Member:		GetXTablePos								Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Liefert den X-Nullpunkt zurueck.
#*
#*  Input:		---
#*
#*	Output:		X-Nullpunkt
#*
#************************************************************************/
short ScDataGrid::GetXTablePos()
{
	return (short) aOffsetPoint.X();
}

/*************************************************************************
#*	Member:		GetYTablePos								Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Liefert den Y-Nullpunkt zurueck.
#*
#*  Input:		---
#*
#*	Output:		Y-Nullpunkt
#*
#************************************************************************/
short ScDataGrid::GetYTablePos()
{
	return (short)aOffsetPoint.Y();
}

/*************************************************************************
#*	Member:		GetXMaxTableSize							Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Liefert die Gesamtgroesse der Tabelle in X-Richtung
#*				zurueck
#*
#*  Input:		---
#*
#*	Output:		groesster X-Wert
#*
#************************************************************************/
short ScDataGrid::GetXMaxTableSize()
{
	short nXMax=0;
	for(int j=0;j<nNumberOfCols;j++)
	{
		nXMax+=aWidthOfCols[j];
	}
	return nXMax;
}

/*************************************************************************
#*	Member:		GetYMaxTableSize							Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Liefert die Gesamtgroesse der Tabelle in Y-Richtung
#*				zurueck
#*
#*  Input:		groesster Y-Wert
#*
#*	Output:		---
#*
#************************************************************************/
short ScDataGrid::GetYMaxTableSize()
{
	short nYMax=0;
	for(int j=0;j<nNumberOfRows;j++)
	{
		nYMax+=aHeightOfRows[j];
	}
	return nYMax;
}

/*************************************************************************
#*	Member:		GetNumberOfCols								Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Liefert die Anzahl an Spalten zurueck
#*
#*  Input:		---
#*
#*	Output:		Anzahl
#*
#************************************************************************/
USHORT ScDataGrid::GetNumberOfCols()
{
	return nNumberOfCols;
}

/*************************************************************************
#*	Member:		GetNumberOfRows								Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Liefert die Anzahl an Zeilen zurueck
#*
#*  Input:		---
#*
#*	Output:		Anzahl
#*
#************************************************************************/
USHORT ScDataGrid::GetNumberOfRows()
{
	return nNumberOfRows;
}

/*************************************************************************
#*	Member:		GetSelectedCell								Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Liefert die Position einer selektierten Zelle zurueck
#*
#*  Input:		---
#*
#*	Output:		Position
#*
#************************************************************************/
Pair ScDataGrid::GetSelectedCell()
{
	return aSelectedCell;
}

/*************************************************************************
#*	Member:	SetSelectedCell									Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Selektiert eine Zelle an der Position aPos.
#*
#*  Input:		Position
#*
#*	Output:		---
#*
#************************************************************************/
void ScDataGrid::SetSelectedCell(Pair aPos)
{
	aSelectedCell=aPos;
	Invalidate();
}

/*************************************************************************
#*	Member:		GetSelectedCell								Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Selektiert eine Zelle an der Position aPos.
#*
#*  Input:		Position
#*
#*	Output:		---
#*
#************************************************************************/
long ScDataGrid::GetSelectedRow()
{
	return nSelectedRow;
}

/*************************************************************************
#*	Member:		GetSelectedCell								Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Selektiert eine Zelle an der Position aPos.
#*
#*  Input:		Position
#*
#*	Output:		---
#*
#************************************************************************/
void ScDataGrid::SetSelectedRow(long nVal)
{
	nSelectedRow=nVal;
	aSelectedCell.A()=nVal;
	Invalidate();
}

/*************************************************************************
#*	Member:		GetSelectedCol								Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Liefert die Position einer selektierten Spalte zurueck
#*
#*  Input:		---
#*
#*	Output:		Position
#*
#************************************************************************/
long ScDataGrid::GetSelectedCol()
{
	return nSelectedCol;
}

/*************************************************************************
#*	Member:		SetSelectedCol								Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Selektiert eine Zeile an der Position aPos.
#*
#*  Input:		Position
#*
#*	Output:		---
#*
#************************************************************************/
void ScDataGrid::SetSelectedCol(long nVal)
{
	nSelectedCol=nVal;
	aSelectedCell.B()=nVal;
	Invalidate();
}

/*************************************************************************
#*	Member:	MouseButtonDown									Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Funktion die ausgeloest wird, wenn die Maustaste gedrueckt
#*				wird. Ermittelt ob ein Zelle selektiert wurde und stellt
#*				die Selektion ein. Loest zusaetzlich einen installierten
#*				Handler aus.
#*
#*  Input:		MouseEvent
#*
#*	Output:		---
#*
#************************************************************************/

void ScDataGrid::MouseButtonDown( const MouseEvent& rMEvt)
{
	if(rMEvt.GetButtons()==MOUSE_LEFT)
	{
		bMouseAktiv=TRUE;
		CaptureMouse();
		Point aMPos=rMEvt.GetPosPixel();
		ActionForButtonDown(aMPos);
	}
	Control::MouseButtonDown(rMEvt);
}

/*************************************************************************
#*	Member:		ActionForButtonDown							Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Ermittelt welche Zelle selektiert wurde und stellt
#*				die Selektion ein.
#*
#*  Input:		Position
#*
#*	Output:		---
#*
#************************************************************************/

void ScDataGrid::ActionForButtonDown( Point aMPos)
{
	if(nNumberOfCols <1 || nNumberOfRows< 1) return;
	USHORT i=0;
	USHORT j=0;
	Point aTopPoint;
	Point aBottomPoint;
	BOOL bFlag=FALSE;
	USHORT nMyWidth=aWidthOfCols[0];
	USHORT nMyHeight=aHeightOfRows[0];

	aTopPoint.X()=nMyWidth;
	aTopPoint.Y()=nMyHeight;

	aTopPoint.Y()-=aOffsetPoint.Y();
	aBottomPoint.Y()=aTopPoint.Y()+aHeightOfRows[1];
	aTopPoint.X()-=aOffsetPoint.X();
	aBottomPoint.X()=aTopPoint.X()+aWidthOfCols[1];

	Rectangle aClipRect(aTopPoint,aBottomPoint);

	aClipRect.Top()=aTopPoint.Y();
	aClipRect.Left()=0;
	aClipRect.Right()=nMyWidth;
	nSelectedRow=-1;
	nSelectedCol=-1;


	for(j=1;j<nNumberOfRows;j++)
	{
		aClipRect.Bottom()=aClipRect.Top()+aHeightOfRows[j];
		if(aClipRect.IsInside(aMPos))
		{
			bFlag=TRUE;
			aClipRect=Rectangle(aLeftWinPos,aLeftWinSize);
			nSelectedRow=j;
			break;
		}
		aClipRect.Top()+=aHeightOfRows[j];
	}

	if(!bFlag)
	{
		aClipRect=Rectangle(aTopPoint,aBottomPoint);
		//aClipRect.Left()=nMyWidth;				  //@ ???
		aClipRect.Top()=aTopWinPos.Y();
		aClipRect.Bottom()=aClipRect.Top()+aHeightOfRows[0];
		for(i=1;i<nNumberOfCols;i++)
		{
			aClipRect.Right()=aClipRect.Left()+aWidthOfCols[i];
			if(aClipRect.IsInside(aMPos))
			{
				bFlag=TRUE;
				aClipRect=Rectangle(aTopWinPos,aTopWinSize);
				nSelectedCol=i;
				break;
			}
			aClipRect.Left()+=aWidthOfCols[i];
		}
	}

	if(!bFlag)
	{
		aClipRect=Rectangle(aTopPoint,aBottomPoint);
		for(i=1;i<nNumberOfCols;i++)
		{
			aClipRect.Right()=aClipRect.Left()+aWidthOfCols[i];
			aClipRect.Top()=aTopPoint.Y();
			for(j=1;j<nNumberOfRows;j++)
			{
				aClipRect.Bottom()=aClipRect.Top()+aHeightOfRows[j];
				if(aClipRect.IsInside(aMPos))
				{
					bFlag=TRUE;
					break;
				}
				aClipRect.Top()+=aHeightOfRows[j];
			}
			if(bFlag) break;
			aClipRect.Left()+=aWidthOfCols[i];
		}
	}

	if(bFlag)
	{
		aSelectedCell.A()=j;
		aSelectedCell.B()=i;
	}

	Invalidate(aClipRect);
	CtrMouseDown();
}

/*************************************************************************
#*	Member:	GetFirstVisibleCell								Datum:11.12.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Liefert die Position der ersten sichtbaren Zelle zurueck.
#*
#*  Input:		---
#*
#*	Output:		Position
#*
#************************************************************************/

Pair ScDataGrid::GetFirstVisibleCell()
{
	if(nNumberOfCols <1 || nNumberOfRows< 1) return Pair(0,0);
	USHORT i=0;
	USHORT j=0;
	Point aPos=aDataWinPos;
	aPos.X()+=1;
	aPos.Y()+=1;
	Point aTopPoint;
	Point aBottomPoint;
	BOOL bFlag=FALSE;
	USHORT nMyWidth=aWidthOfCols[0];
	USHORT nMyHeight=aHeightOfRows[0];

	aTopPoint.X()=nMyWidth;
	aTopPoint.Y()=nMyHeight;

	aTopPoint.Y()-=aOffsetPoint.Y();
	aBottomPoint.Y()=aTopPoint.Y()+aHeightOfRows[1];
	aTopPoint.X()-=aOffsetPoint.X();
	aBottomPoint.X()=aTopPoint.X()+aWidthOfCols[1];

	Rectangle aClipRect(aTopPoint,aBottomPoint);

	for(i=1;i<nNumberOfCols;i++)
	{
		aClipRect.Right()=aClipRect.Left()+aWidthOfCols[i];
		aClipRect.Top()=aTopPoint.Y();
		for(j=1;j<nNumberOfRows;j++)
		{
			aClipRect.Bottom()=aClipRect.Top()+aHeightOfRows[j];
			if(aClipRect.IsInside(aPos))
			{
				bFlag=TRUE;
				break;
			}
			aClipRect.Top()+=aHeightOfRows[j];
		}
		if(bFlag) break;
		aClipRect.Left()+=aWidthOfCols[i];
	}
	return Pair(j,i);
}

/*************************************************************************
#*	Member:	MouseMove										Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Funktion die ausgeloest wird, wenn die Maus bewegt
#*				wird.  Loest zusaetzlich einen installierten
#*				Handler aus.
#*
#*  Input:		MouseEvent
#*
#*	Output:		---
#*
#************************************************************************/

void ScDataGrid::MouseMove( const MouseEvent& rMEvt)
{
	if(rMEvt.GetButtons()==MOUSE_LEFT && bMouseAktiv)
	{
		Point aMPos=rMEvt.GetPosPixel();
		nMouseXPos=(USHORT)aMPos.X();
		CtrMouseMove();
	}
}


/*************************************************************************
#*	Member:	MouseButtonUp									Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Funktion die ausgeloest wird, wenn die Maustaste losge-
#*				lassen wird. Loest zusaetzlich einen installierten
#*				Handler aus.
#*
#*  Input:		MouseEvent
#*
#*	Output:		---
#*
#************************************************************************/

void ScDataGrid::MouseButtonUp( const MouseEvent& rMEvt)
{
	if(rMEvt.GetButtons()==MOUSE_LEFT)
	{
		ReleaseMouse();
		bMouseAktiv=FALSE;

		if(rMEvt.GetClicks()==1)
		{
			Point aMPos=rMEvt.GetPosPixel();
			Invalidate();
			CtrMouseUp();
		}
		else
			MouseDblClick(rMEvt);
	}

	Control::MouseButtonUp(rMEvt);

}

/*************************************************************************
#*	Member:	MouseDblClick									Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Fuer DblClick
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void ScDataGrid::MouseDblClick( const MouseEvent& rMEvt)
{

}

/*************************************************************************
#*	Member:		Command										Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Funktion zum anzeigen und auswerten des Context-
#*				Menues
#*
#*  Input:		CommandEvent
#*
#*	Output:		---
#*
#************************************************************************/
void ScDataGrid::Command( const CommandEvent& rCEvt )
{
	if(rCEvt.GetCommand()==COMMAND_CONTEXTMENU)
	{
		Point aMPos=rCEvt.GetMousePosPixel();
		ActionForButtonDown(aMPos);
		ScPopupMenu aPop=aContextMenu;
		aPop.SetMenuFlags( aPop.GetMenuFlags() | MENU_FLAG_NOAUTOMNEMONICS );
		aPop.Execute( this, aMPos );
		GrabFocus();
		if ( aPop.WasHit() )
		{
			USHORT nContextId=aPop.GetSelected();
			nContextSelPos=(long)aPop.GetItemPos(nContextId);
			aSelectedContextText=aPop.GetItemText(nContextId);
			CtrCommand();
		}
		else
		{
			nContextSelPos=-1;
			aSelectedContextText.Erase();
		}
	}
	Control::Command(rCEvt);
}




/*************************************************************************
#*	Member:		InsertContextEntry							Datum:09.12.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Fuegt Eintraege fuer das Context-Menu ein.
#*
#*  Input:		Id, Text, Eigenschaften, Pos
#*
#*	Output:		---
#*
#************************************************************************/
void ScDataGrid::InsertContextEntry(USHORT nItemId,const String& rStr,
								MenuItemBits nItemBits,
								USHORT nPos)
{
	aContextMenu.InsertItem(nItemId,rStr,nItemBits,nPos);
}

/*************************************************************************
#*	Member:		ScRuler						Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Liefert den selektierten Eintrag im Contextmenu
#*				zurueck.
#*
#*  Input:		---
#*
#*	Output:		Selektierte Position
#*
#************************************************************************/
long ScDataGrid::GetSelectedContextCmd()
{
	return nContextSelPos;
}


/*************************************************************************
#*	Member:		ScRuler						Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Liefert den selektierten Eintrag im Contextmenu
#*				zurueck.
#*
#*  Input:		---
#*
#*	Output:		Selektierter Text
#*
#************************************************************************/
String ScDataGrid::GetSelectedContextText()
{
	return aSelectedContextText;
}


/*************************************************************************
#*	Member:		ScDataGrid						Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Zeichnet die Tabelle
#*
#*  Input:		zuzeichender Bereich.
#*
#*	Output:		---
#*
#************************************************************************/

void ScDataGrid::Paint( const Rectangle& rRect )
{
	aTopWinDev.Erase();
	aLeftWinDev.Erase();
	aDataWinDev.Erase();

	Font aPrivFont=GetFont();
	aTopWinDev.SetFont(aPrivFont);
	aLeftWinDev.SetFont(aPrivFont);
	aDataWinDev.SetFont(aPrivFont);

	SetClipRegion(Region(rRect));
    Point aZeroPt;

    DrawTop();
	DrawLeft();
    DrawData();
    SetFillColor( GetParent()->GetBackground().GetColor() );
    lcl_Draw3DRect( *this, Point(), Size( aWidthOfCols[0], aHeightOfRows[0] ) );
    DrawBitmap( aTopWinPos, aTopWinDev.GetBitmap( aZeroPt, aTopWinSize ) );
    DrawBitmap( aLeftWinPos, aLeftWinDev.GetBitmap( aZeroPt, aLeftWinSize ) );
    DrawBitmap( aDataWinPos, aDataWinDev.GetBitmap( aZeroPt, aDataWinSize ) );
}

/*************************************************************************
#*	Member:		DrawTop										Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Zeichnet den Kopfteil der Tabelle.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void ScDataGrid::DrawTop()
{
	int i;
	ScStringsPtr pStrings;
	StringPtr	pDatString;

	aTopWinDev.Erase();
    aTopWinDev.SetFillColor();

	//	top part uses normal app font
	aTopWinDev.SetFont(aDefaultFont);

    Point aPt1( -aOffsetPoint.X(), 0 );
    Size aSize( 0, aHeightOfRows[0] );

	for(i=1;i<nNumberOfCols;i++)
	{
		pStrings=aScStringsArray[0];
		pDatString=(*pStrings)[i];
        aSize.Width() = aWidthOfCols[i];
        if( aSize.Width() > 1 )
		{
            lcl_Draw3DRect( aTopWinDev, aPt1, aSize );
            Point aTextPt( aPt1.X() + 1, aPt1.Y() );
            aTopWinDev.SetClipRegion( Region( Rectangle( aPt1, aSize ) ) );
            aTopWinDev.DrawText( aTextPt, *pDatString );
            aPt1.X() += aSize.Width();
			aTopWinDev.SetClipRegion();
		}
	}
    aSize.Width() = aTopWinSize.Width() - aPt1.X();
    if( aSize.Width() > 2 )
        lcl_Draw3DRect( aTopWinDev, aPt1, aSize );
}

/*************************************************************************
#*	Member:		DrawLeft									Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Zeichnet die Zeilen- Nummerierung der Tabelle.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void ScDataGrid::DrawLeft()
{
	int i;
	ScStringsPtr pStrings;
	StringPtr	pDatString;

	aLeftWinDev.Erase();
    aLeftWinDev.SetFillColor();

	Font aPrivFont=GetFont();
	aLeftWinDev.SetFont(aPrivFont);

    Point aPt1( 0, -aOffsetPoint.Y() );
    Size aSize( aWidthOfCols[0], 0 );

	for(i=1;i<nNumberOfRows;i++)
	{
		pStrings=aScStringsArray[i];
		pDatString=(*pStrings)[0];
        aSize.Height() = aHeightOfRows[i];
        lcl_Draw3DRect( aLeftWinDev, aPt1, aSize );
        Point aTextPt( aPt1.X() + aSize.Width() - aLeftWinDev.GetTextWidth( *pDatString ) - 1, aPt1.Y() );
        aLeftWinDev.SetClipRegion( Region( Rectangle( aPt1, aSize ) ) );
		aLeftWinDev.DrawText(aTextPt,*pDatString);
		aLeftWinDev.SetClipRegion();
        aPt1.Y() += aSize.Height();
	}
}

/*************************************************************************
#*	Member:		DrawData									Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Zeichnet den Datenbereich der Tabelle.
#*
#*  Input:		---
#*
#*	Output:		maximal gezeichnete Position
#*
#************************************************************************/

void lcl_DoDrawText( OutputDevice& rDev, const Point& rPos, const String& rText,
					ScEditEngineDefaulter* pEditEngine, BOOL bWhite )
{
	Color aColor( bWhite ? COL_WHITE : COL_BLACK );
	pEditEngine->SetDefaultItem( SvxColorItem( aColor, EE_CHAR_COLOR ) );

	pEditEngine->SetText( rText );
	pEditEngine->Draw( &rDev, rPos );
}

void ScDataGrid::DrawData()
{
	int i,j;
	ScStringsPtr pStrings;
	StringPtr	pDatString;

	aDataWinDev.Erase();
    aDataWinDev.SetFillColor();

	Font aPrivFont=GetFont();
	aDataWinDev.SetFont(aPrivFont);

	SetLineColor(Color(COL_BLACK));
    Point aPoint( -aOffsetPoint.X(), -aOffsetPoint.Y() );
    Size aSize( 0, aDataWinDev.GetOutputSizePixel().Height() );
	for(i=1;i<nNumberOfCols;i++)
	{
        aSize.Width() = aWidthOfCols[i];
        lcl_Draw3DRect( aDataWinDev, aPoint, aSize );

        aDataWinDev.SetClipRegion( Region( Rectangle( aPoint, aSize ) ) );

        Point aTxtPoint( aPoint );
        Size aTxtSize( aSize.Width(), 0 );
        for(j=1;j<nNumberOfRows;j++)
		{
			pStrings=aScStringsArray[j];
			pDatString=(*pStrings)[i];
            aTxtSize.Height() = aHeightOfRows[j];
            Rectangle aRect( aTxtPoint, aTxtSize );
            aRect.Left()++; aRect.Right()--;
            if( j == 1 ) aRect.Top()++;

			if((aSelectedCell.A()==j && aSelectedCell.B()==i)||
				nSelectedCol==i || nSelectedRow==j)
			{
				BOOL bHadFill = aDataWinDev.IsFillColor();
				Color aOldFill = aDataWinDev.GetFillColor();
                aDataWinDev.SetFillColor( Color( COL_BLACK ) );
                aDataWinDev.DrawRect( aRect );

                lcl_DoDrawText( aDataWinDev, aTxtPoint, *pDatString, pEditEngine, TRUE );

				if (bHadFill)
					aDataWinDev.SetFillColor(aOldFill);
				else
					aDataWinDev.SetFillColor();
			}
			else
                lcl_DoDrawText( aDataWinDev, aTxtPoint, *pDatString, pEditEngine, FALSE );

            aTxtPoint.Y() += aTxtSize.Height();
		}
        aPoint.X() += aSize.Width();
		aDataWinDev.SetClipRegion();
	}
    aSize.Width() = aDataWinDev.GetOutputSizePixel().Width() - aPoint.X();
    if( aSize.Width() > 2 )
        lcl_Draw3DRect( aDataWinDev, aPoint, aSize );
}

/*************************************************************************
#*	Member:		CtrMouseUp									Datum:11.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Teilt einem installierten Handler mit, dass
#*				die Maus losgelassen wurde.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void ScDataGrid::CtrMouseUp()
{
	aMouseUpLink.Call( this );
}

/*************************************************************************
#*	Member:		CtrMouseMove								Datum:11.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Teilt einem installierten Handler mit, dass
#*				die Maus bewegt wird.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void ScDataGrid::CtrMouseMove()
{
	aMouseMoveLink.Call( this );
}

/*************************************************************************
#*	Member:		CtrMouseDown								Datum:11.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Teilt einem installierten Handler mit, dass
#*				die Maus gedrueckt wird.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void ScDataGrid::CtrMouseDown()
{
	aMouseDownLink.Call( this );
}


/*************************************************************************
#*	Member:		CtrCommand									Datum:10.12.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScDataGrid
#*
#*  Funktion:	Teilt einem installierten Handler mit, dass
#*				das ContextMenu aufgerufen wurde
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void ScDataGrid::CtrCommand()
{
	aContextMenuLink.Call( this );
}


void ScDataGrid::ImplInitSettings( BOOL bFont, BOOL bForeground, BOOL bBackground )
{
	const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();

	/*
	if ( bFont )
	{
		Font aFont = rStyleSettings.GetAppFont();
		if ( IsControlFont() )
			aFont.Merge( GetControlFont() );
		SetFont( aFont );
	}
	*/
	if ( bFont || bForeground )
	{
		Color aTextColor = rStyleSettings.GetButtonTextColor();
		if ( IsControlForeground() )
			aTextColor = GetControlForeground();
		SetTextColor( aTextColor );
		aTopWinDev. SetTextColor( aTextColor );
		aLeftWinDev.SetTextColor( aTextColor );
		aDataWinDev.SetTextColor( rStyleSettings.GetWindowTextColor());
	}

	if ( bBackground )
	{
		SetBackground( rStyleSettings.GetFaceColor() );
	}

	lcl_CopyBackAndSetFill( *this, aTopWinDev, aLeftWinDev, aDataWinDev );

	SetBackground();
	Invalidate();
}

// -----------------------------------------------------------------------

void ScDataGrid::StateChanged( StateChangedType nType )
{
	if ( (nType == STATE_CHANGE_ZOOM) ||
		 (nType == STATE_CHANGE_CONTROLFONT) )
	{
		ImplInitSettings( TRUE, FALSE, FALSE );
		Invalidate();
	}
	if ( nType == STATE_CHANGE_CONTROLFOREGROUND )
	{
		ImplInitSettings( FALSE, TRUE, FALSE );
		Invalidate();
	}
	else if ( nType == STATE_CHANGE_CONTROLBACKGROUND )
	{
		ImplInitSettings( FALSE, FALSE, TRUE );
		Invalidate();
	}

	Control::StateChanged( nType );
}

// -----------------------------------------------------------------------

void ScDataGrid::DataChanged( const DataChangedEvent& rDCEvt )
{
	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
		 (rDCEvt.GetFlags() & SETTINGS_STYLE) )
	{
		ImplInitSettings( TRUE, TRUE, TRUE );
		Invalidate();
	}
	else
		Window::DataChanged( rDCEvt );
}


