/*************************************************************************
 *
 *  $RCSfile: calculat.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: af $ $Date: 2001/06/22 08:24:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// header for Point, Rectangle
#ifndef _SV_GEN_HXX
#include <tools/gen.hxx>
#endif
// header for Polygon
#ifndef _SV_POLY_HXX
#include <vcl/poly.hxx>
#endif
// header for DBG_ASSERT
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
// header for XPolygon, XPolyPolygon
#ifndef _XPOLY_HXX
#include <svx/xpoly.hxx>
#endif
// header for Line
#ifndef _SV_LINE_HXX
#include <vcl/line.hxx>
#endif

#include "calculat.hxx"

/*
BOOL SchCalculationHelper::IsPointInsideRectangle( const Point& rPoint, const Rectangle& rRect )
{
	BOOL bResult = rRect.IsInside( rPoint );

	if( bResult )
	{
		if( rPoint.X() == rRect.Left() ||
			rPoint.X() == rRect.Right() ||
			rPoint.Y() == rRect.Top() ||
			rPoint.Y() == rRect.Bottom() )
			return FALSE;
	}

	return bResult;
}
*/

void SchCalculationHelper::IntersectPolygonWithRectangle( const XPolygon& rPolygon, const Rectangle& rRectangle, XPolyPolygon& aResult )
{
	aResult.Clear();

	if( rRectangle.IsInside( rPolygon.GetBoundRect() ) )
	{
		aResult.Insert( rPolygon );
		return;
	}

	//	For now simply call clip2d for every line of the given polygon an store the visible
	//	parts into aResult.  This does not exploit the fact that the given polygon is a
	//	sequence of lines without gaps.
	Point	aPoint0;
	Point	aPoint1;
	XPolygon aVisibleLine (2);
	USHORT nCount = rPolygon.GetPointCount();
	for (USHORT i=1; i<nCount; i++)
	{
		aVisibleLine[0] = rPolygon[i-1];
		aVisibleLine[1] = rPolygon[i];
		if (clip2d (aVisibleLine[0], aVisibleLine[1], rRectangle))
		{
			//	Insert the visible part of the (i-1)-th part of the given polygon into
			//	the resulting poly-polygon.
			//	This does not join lines with adjacent start/end points together.  This remains
			//	as an exercise to the reader.
			aResult.Insert (aVisibleLine);
		}
	}
	return;
/*	
	Point	aPoint1 = rPolygon[0];
	
	XPolygon aRectPoly( rRectangle );
	Line aRectLines[ 4 ];

	aRectLines[ 0 ] = Line( aRectPoly[ 0 ], aRectPoly[ 1 ] );
	aRectLines[ 1 ] = Line( aRectPoly[ 1 ], aRectPoly[ 2 ] );
	aRectLines[ 2 ] = Line( aRectPoly[ 2 ], aRectPoly[ 3 ] );
	aRectLines[ 3 ] = Line( aRectPoly[ 3 ], aRectPoly[ 0 ] );

	const Point* pStart = &(rPolygon[ 0 ]);
	const Point* pEnd;

	Point aIntersection, aIntersection2;
	XPolygon aSubPoly;
	BOOL bStartInside, bEndInside;
	USHORT i;
	USHORT nLast = rPolygon.GetPointCount() - 1;

	for( i = 1; i <= nLast; i++ )
	{
		pEnd = &(rPolygon[ i ]);

		bStartInside = IsPointInsideRectangle( *pStart, rRectangle );
		bEndInside	 = IsPointInsideRectangle( *pEnd, rRectangle );

		if( bStartInside != bEndInside )		// => one intersection
		{
			Line aLine( *pStart, *pEnd );
			if( aLine.Intersection( aRectLines[ 0 ], aIntersection ) ||
				aLine.Intersection( aRectLines[ 1 ], aIntersection ) ||
				aLine.Intersection( aRectLines[ 2 ], aIntersection ) ||
				aLine.Intersection( aRectLines[ 3 ], aIntersection ) )
			{
				if( bStartInside )
				{
					aSubPoly[ aSubPoly.GetPointCount() ] = *pStart;
					aSubPoly[ aSubPoly.GetPointCount() ] = aIntersection;
					aResult.Insert( aSubPoly );
					aSubPoly.SetPointCount( 0 );		// clear polygon
				}
				else
				{
					aSubPoly[ aSubPoly.GetPointCount() ] = aIntersection;

					if( i == nLast )
					{
						aSubPoly[ aSubPoly.GetPointCount() ] = *pEnd;
						aResult.Insert( aSubPoly );
					}
				}
			}
			else
				DBG_TRACE( "SchCalculationHelper::IntersectPolygonWithRectangle: "
							"No intersection where one was expected" );
		}
		else if( !bStartInside )				// => both are outside => 0 or 2 intersections
		{
			long nLine = -1;
			Line aLine( *pStart, *pEnd );

			if( aLine.Intersection( aRectLines[ ++nLine ], aIntersection ) ||
				aLine.Intersection( aRectLines[ ++nLine ], aIntersection ) ||
				aLine.Intersection( aRectLines[ ++nLine ], aIntersection ) ||
				aLine.Intersection( aRectLines[ ++nLine ], aIntersection ) )
			{
				if( nLine < 3 && aLine.Intersection( aRectLines[ ++nLine ], aIntersection2 ) ||
					nLine < 3 && aLine.Intersection( aRectLines[ ++nLine ], aIntersection2 ) ||
					nLine < 3 && aLine.Intersection( aRectLines[ ++nLine ], aIntersection2 ) )
				{
					aSubPoly[ aSubPoly.GetPointCount() ] = aIntersection;
					aSubPoly[ aSubPoly.GetPointCount() ] = aIntersection2;

					aResult.Insert( aSubPoly );
					aSubPoly.SetPointCount( 0 );
				}
				else
				{
					DBG_TRACE( "SchCalculationHelper::IntersectPolygonWithRectangle: "
								"Only one intersection where two were expected" );
				}
			}
			// else no intersection
		}
		else 									// both are inside => no intersection
		{
			aSubPoly[ aSubPoly.GetPointCount() ] = *pStart;
			if( i == nLast )
			{
				aSubPoly[ aSubPoly.GetPointCount() ] = *pEnd;
				aResult.Insert( aSubPoly );
			}
		}

		pStart = pEnd;
	}
*/
}

BOOL SchCalculationHelper::ClipLineAtRectangle( Line& aLine, const Rectangle& rRectangle )
{
	Point	aPoint0 = aLine.GetStart ();
	Point	aPoint1 = aLine.GetEnd ();
	BOOL	bVisible = clip2d (aPoint0, aPoint1, rRectangle);
	if (bVisible)
	{
		aLine.SetStart (aPoint0);
		aLine.SetEnd (aPoint1);
	}
	return bVisible;
/*
	BOOL bStartInside = IsPointInsideRectangle( aLine.GetStart(), rRectangle ),
		bEndInside = IsPointInsideRectangle( aLine.GetEnd(), rRectangle );

	if( bStartInside && bEndInside )		 // line stays unclipped
		return TRUE;

	Polygon aRectPoly( rRectangle );
	Line aRectLines[ 4 ];

	aRectLines[ 0 ] = Line( aRectPoly[ 0 ], aRectPoly[ 1 ] );
	aRectLines[ 1 ] = Line( aRectPoly[ 1 ], aRectPoly[ 2 ] );
	aRectLines[ 2 ] = Line( aRectPoly[ 2 ], aRectPoly[ 3 ] );
	aRectLines[ 3 ] = Line( aRectPoly[ 3 ], aRectPoly[ 0 ] );

	Point aIntersection, aIntersection2;

	if( bStartInside != bEndInside )	// => one intersection
	{
		if( aLine.Intersection( aRectLines[ 0 ], aIntersection ) ||
			aLine.Intersection( aRectLines[ 1 ], aIntersection ) ||
			aLine.Intersection( aRectLines[ 2 ], aIntersection ) ||
			aLine.Intersection( aRectLines[ 3 ], aIntersection ) )
		{
			if( bStartInside )
				aLine.SetEnd( aIntersection );
			else
				aLine.SetStart( aIntersection );
		}
		else
		{
			DBG_TRACE( "SchCalculationHelper::ClipLineAtRectangle: "
						"No intersection where one was expected" );
		}
	}
	else		// bStartInside == bEndInside == FALSE  =>  0 or 2 intersections
	{
		long nLine = -1;

		if( aLine.Intersection( aRectLines[ ++nLine ], aIntersection ) ||
			aLine.Intersection( aRectLines[ ++nLine ], aIntersection ) ||
			aLine.Intersection( aRectLines[ ++nLine ], aIntersection ) ||
			aLine.Intersection( aRectLines[ ++nLine ], aIntersection ) )
		{
			if( nLine < 3 && aLine.Intersection( aRectLines[ ++nLine ], aIntersection2 ) ||
				nLine < 3 && aLine.Intersection( aRectLines[ ++nLine ], aIntersection2 ) ||
				nLine < 3 && aLine.Intersection( aRectLines[ ++nLine ], aIntersection2 ) )
			{
				aLine.SetStart( aIntersection );
				aLine.SetEnd( aIntersection2 );
			}
			else
			{
				DBG_TRACE( "SchCalculationHelper::ClipLineAtRectangle: "
							"Only one intersection where two were expected" );
			}
		}
		else
			return FALSE;		// result is empty
	}

	return TRUE;
*/
}




BOOL	SchCalculationHelper::clip2d	(Point & rPoint0, 
										Point & rPoint1,
										const Rectangle & rRectangle)
{
	//	Direction vector of the line.						
	Point	aD = rPoint1 - rPoint0;

	//	Flag wether (a part of) the line is visible.
	BOOL	visible = FALSE;
	
	if (aD.X()==0 && aD.Y()==0 && rRectangle.IsInside (rPoint0))
	{
		//	Degenerate case of a zero length line.
		return TRUE;
	}
	else
	{
		//	Values of the line parameter where the line enters resp. leaves the rectangle.
		double	fTE = 0,
				fTL = 1;
				
		//	Test wether at least a part lies in the four half-planes with respect to 
		//	the rectangles four edges.
		if (CLIPt (aD.X(), rRectangle.Left() - rPoint0.X(), fTE, fTL))
			if (CLIPt (-aD.X(), rPoint0.X() - rRectangle.Right(), fTE, fTL))
				if (CLIPt (aD.Y(), rRectangle.Top() - rPoint0.Y(), fTE, fTL))
					if (CLIPt (-aD.Y(), rPoint0.Y() - rRectangle.Bottom(), fTE, fTL))
					{
						//	At least a part is visible.
						if (fTL < 1)
						{
							//	Compute the new end point.
							rPoint1.X() = (long)(rPoint0.X() + fTL * aD.X() + 0.5);
							rPoint1.Y() = (long)(rPoint0.Y() + fTL * aD.Y() + 0.5);
						}
						if (fTE > 0)
						{
							//	Compute the new starting point.
							rPoint0.X() = (long)(rPoint0.X() + fTE * aD.X() + 0.5);
							rPoint0.Y() = (long)(rPoint0.Y() + fTE * aD.Y() + 0.5);
						}
						return TRUE;
					}
					
		//	Line is not visible.
		return FALSE;
	}
}




BOOL	SchCalculationHelper::CLIPt	(double fDenom, 
									double fNum, 
									double & fTE, 
									double & fTL)
{
	double	fT;
	
	if (fDenom > 0)				//	Intersection enters: PE
	{
		fT = fNum / fDenom;		//	Parametric value at the intersection.
		if (fT > fTL)			//	fTE and fTL crossover
			return FALSE;		//	  therefore reject the line.
		else if (fT > fTE)		//	A new fTE has been found.
			fTE = fT;
	}
	else if (fDenom < 0)		//	Intersection leaves: PL
	{
		fT = fNum / fDenom;		//	Parametric Value at the intersection.
		if (fT < fTE)			//	fTE and fTL crossover
			return FALSE;		//	  therefore reject the line.
		else if (fT < fTL)		//	A new fTL has been found.
			fTL = fT;
	}
	else if (fNum > 0)
		return FALSE;			//	Line lies on the outside of the edge.
	
	return TRUE;
}

