/*************************************************************************
 *
 *  $RCSfile: AccessibleDocumentView.hxx,v $
 *
 *  $Revision: 1.4.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 14:39:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SCH_ACCESSIBLEDOCUMENTVIEW_HXX
#define _SCH_ACCESSIBLEDOCUMENTVIEW_HXX

#include "AccessibleBase.hxx"

#ifndef _COM_SUN_STAR_VIEW_XSELECTIONCHANGELISTENER_HPP_
#include <com/sun/star/view/XSelectionChangeListener.hpp>
#endif

#ifndef _SFXLSTNER_HXX 
#include <svtools/lstner.hxx>
#endif

// forward declarations
// --------------------

namespace com { namespace sun { namespace star {
	namespace frame {
		class XModel;
        class XController;
	}
	namespace awt {
		class XWindow;
	}
}}}

namespace accessibility {


/** This is the main entry point for chart accessibility.  It is created by the
    window (SchWindow).

    This class is also an SfxListener to get events from the core.  (E.g.  the
    SchReBuildHint)
*/
class AccessibleDocumentView :
        public AccessibleBase,
        public ::com::sun::star::view::XSelectionChangeListener,
        public SfxListener
{
public:
	//=====  internal  ========================================================
	AccessibleDocumentView
        ( SchWindow* pWindow,
          ChartModel* pChartModel,
          const ::com::sun::star::uno::Reference<
          ::com::sun::star::frame::XController>& rxController,
          const ::com::sun::star::uno::Reference<
          ::drafts::com::sun::star::accessibility::XAccessible>& rxParent );

	virtual ~AccessibleDocumentView	(void);

    /** This method must be called after creating the document view.

        @descr The reason for that is that registering as listener in the
               constructor is highly unsafe.  It may result in a call to the
               destructor (while releasing the last and only Reference to this).
     */
    void StartUNOListening();

    // ________ XInterface (overloaded) ________
    virtual ::com::sun::star::uno::Any SAL_CALL queryInterface( const ::com::sun::star::uno::Type& aType ) throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL acquire() throw ();
    virtual void SAL_CALL release() throw ();

    // ________ XTypeProvider (overloaded) ________
    virtual ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Type > SAL_CALL getTypes() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL getImplementationId() throw (::com::sun::star::uno::RuntimeException);

    // ________ XServiceInfo (overloaded) ________
    virtual ::rtl::OUString SAL_CALL getImplementationName() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL getSupportedServiceNames() throw (::com::sun::star::uno::RuntimeException);

    // ________ XAccessibleContext (overloaded) ________
    virtual ::rtl::OUString SAL_CALL getAccessibleDescription() throw (::com::sun::star::uno::RuntimeException);

    // ________ XAccessibleContext ________
    virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::accessibility::XAccessible > SAL_CALL getAccessibleParent() throw (::com::sun::star::uno::RuntimeException);

    // ________ XAccessibleComponent ________
    virtual ::com::sun::star::awt::Rectangle SAL_CALL getBounds() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::awt::Point SAL_CALL getLocation() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::awt::Point SAL_CALL getLocationOnScreen() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::awt::Size SAL_CALL getSize() throw (::com::sun::star::uno::RuntimeException);

    // ________ XSelectionChangeListener ________
    virtual void SAL_CALL selectionChanged( const ::com::sun::star::lang::EventObject& aEvent ) throw (::com::sun::star::uno::RuntimeException);

    // ________ XEventListener ________
    virtual void SAL_CALL disposing( const ::com::sun::star::lang::EventObject& Source ) throw (::com::sun::star::uno::RuntimeException);

    // SfxListener
    virtual void Notify( SfxBroadcaster& rBC, const SfxHint& rHint );

protected:
    virtual bool UpdateChildren();
    virtual void KillAllChildren();
    virtual ::com::sun::star::awt::Point   GetUpperLeftOnScreen() const;

private:
    ::com::sun::star::uno::Reference< ::com::sun::star::frame::XController >
        m_xController;
    ::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindow >
        m_xWindow;
    ::com::sun::star::uno::Reference< ::drafts::com::sun::star::accessibility::XAccessible >
        m_xParent;

    bool m_bHasLegend;
    bool m_bHasMainTitle;
    bool m_bHasSubTitle;
    bool m_bHasXAxisTitle;
    bool m_bHasYAxisTitle;
    bool m_bHasZAxisTitle;
    // this should always be true except before first update call
    bool m_bHasDiagram;

    AccessibleUniqueId  m_aLastSelectedId;
};

} // end of namespace accessibility

// _SCH_ACCESSIBLEDOCUMENTVIEW_HXX
#endif
