/*************************************************************************
 *
 *  $RCSfile: lex.cxx,v $
 *
 *  $Revision: 1.1.1.1.26.2 $
 *
 *  last change: $Author: khendricks $ $Date: 2003/01/07 13:44:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <string.h>

#include "parser.hxx"
#include "yyparser.hxx"

int line;

int yylex()
{
	static ByteString aToken;
	aToken.Erase();
	BOOL bQuoting = FALSE;
	BOOL bParenQuoting = FALSE;
	BOOL bFollowingBackslash = FALSE;
	while( !feof( pSrcFile ) )
	{
		int c = getc( pSrcFile );
		if( c == '\n'  ) line++;

		if( bQuoting || bParenQuoting )
		{
			switch( c )
			{
				case '"':
				case '}':
					if( !bFollowingBackslash &&
						( c == '"' && bQuoting ||
						  c == '}' && bParenQuoting ) )
					{
						aToken += char( c );
						yylval._pString = strdup( (const char*) aToken.GetBuffer() );
						bQuoting = bParenQuoting = FALSE;
//						fprintf( stderr, "%s\n", yylval._pString );
						return aToken == "End" ? END : WORD;
					}
				default:
				{
					bFollowingBackslash = FALSE;
					aToken += char(c);
					break;
				}
				case '\\':
				{
					bFollowingBackslash = TRUE;
					aToken += char(c);
					break;
				}
			}
		}
		else
		{
			switch( c )
			{
				case '=':
				case '(':
				case ')':
				case ',':
				case ';':
					if( !aToken.Len() )
					{
//						fprintf( stderr, "Char: %c\n", char( c ) );
						return c;
					}
					else ungetc( c, pSrcFile );
				case EOF:
				case ' ':
				case '\t':
				case '\n':
				case '\r':
					if( aToken.Len() )
					{
						yylval._pString = strdup( (const char*) aToken.GetBuffer() );
//						fprintf( stderr, "%s\n", yylval._pString );
						return aToken == "End" ? END : WORD;
					}
					break;
				case '"':
					if( !aToken.Len() ) bQuoting = TRUE;
					aToken += char( c );
					break;
				case '{':
					if( !aToken.Len() ) bParenQuoting = TRUE;
					aToken += char( c );
					break;
				default:
					aToken += char(c);
			}
		}
	}
	return 0;
}

