/*************************************************************************
 *
 *  $RCSfile: fuexp2.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: thb $ $Date: 2001/07/05 12:31:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SFXAPP_HXX
#include <sfx2/app.hxx>
#endif
#ifndef _PRESENTATION_HXX
#include <pres.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#include "drawdoc.hxx"
#include "sdattr.hxx"
#include "fuexport.hxx"
#include "fuhtmlex.hxx"
#include "pubdlg.hxx"
#include "docshell.hxx"
#include "strings.hrc"
#include "sdresid.hxx"


void FuExport::ExportHTML( const SfxItemSet* pArgs, const String& rPath, const BOOL bAutoExtension ) const
{
	SfxItemSet aArgs( pDoc->GetPool(), ATTR_PUBLISH_START, ATTR_PUBLISH_END );

	// Fall keine Parameter -> Autopilot starten
	if( !pArgs )
	{
		SdPublishingDlg aDlg( pDocSh->GetWindow(), pDoc->GetDocumentType() );

		if(!aDlg.Execute())
			return;

		aDlg.FillItemSet( aArgs );
	}
	else
		aArgs.Set(*pArgs);

	INetURLObject aURL;
	aURL.SetURL( rPath );
	
	DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
	
	if( bAutoExtension && !aURL.getExtension().Len()  )
	{
		String aExt(SdResId(STR_HTMLEXP_DEFAULT_EXTENSION));

		// remove leading dot
		aExt.Erase(0,1);
		aURL.setExtension( aExt );
	}

	aArgs.Put(SfxStringItem(ATTR_PUBLISH_LOCATION, aURL.GetMainURL(INetURLObject::NO_DECODE) ));
	HtmlExport aExporter( pDoc, pView, pDocSh, &aArgs );
}

