/*************************************************************************
 *
 *  $RCSfile: fugrfflt.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: thb $ $Date: 2001/06/15 18:16:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif
#ifndef _SVX_SVDOGRAF_HXX //autogen
#include <svx/svdograf.hxx>
#endif
#ifndef _SVX_SVDEDTV_HXX //autogen
#include <svx/svdedtv.hxx>
#endif

#pragma hdrstop

#include "sdview.hxx"
#include "sdwindow.hxx"
#include "viewshel.hxx"
#include "strings.hrc"
#include "sdresid.hxx"
#include "app.hrc"
#include "fugrfflt.hxx"
//#include "dlgflt.hxx"
#include "docshell.hxx"

// ----------------
// - FuGrafFilter -
// ----------------

TYPEINIT1( FuGrafFilter, FuPoor );

// -----------------------------------------------------------------------------

FuGrafFilter::FuGrafFilter( SdViewShell* pViewSh, SdWindow* pWin, SdView* pView,
							SdDrawDocument* pDoc, SfxRequest& rReq ) :
			FuPoor( pViewSh, pWin, pView, pDoc, rReq )
{
	const SdrMarkList& rMarkList = pView->GetMarkList();

	if( rMarkList.GetMarkCount() == 1 )
	{
		SdrObject* pObj = rMarkList.GetMark( 0 )->GetObj();

		if( pObj && pObj->ISA( SdrGrafObj ) && ( (SdrGrafObj*) pObj )->GetGraphicType() == GRAPHIC_BITMAP )
		{
			const Graphic&	rGraphic = ( (SdrGrafObj*) pObj )->GetGraphic();
			Graphic			aGraphic;

			switch( GetSlotID() )
			{
				case( SID_GRAFFILTER_INVERT ):
				{
					pDocSh->SetWaitCursor( TRUE );

					if( rGraphic.IsAnimated() )
					{
						Animation aAnimation( rGraphic.GetAnimation() );

						if( aAnimation.Invert() )
							aGraphic = aAnimation;
					}
					else
					{
						BitmapEx aBmpEx( rGraphic.GetBitmapEx() );

						if( aBmpEx.Invert() )
							aGraphic = aBmpEx;
					}

					pDocSh->SetWaitCursor( FALSE );
				}
				break;

				case( SID_GRAFFILTER_SMOOTH ):
				{
					pDocSh->SetWaitCursor( TRUE );

					if( rGraphic.IsAnimated() )
					{
						Animation aAnimation( rGraphic.GetAnimation() );

						if( aAnimation.Filter( BMP_FILTER_SMOOTH ) )
							aGraphic = aAnimation;
					}
					else
					{
						BitmapEx aBmpEx( rGraphic.GetBitmapEx() );

						if( aBmpEx.Filter( BMP_FILTER_SMOOTH ) )
							aGraphic = aBmpEx;
					}

					pDocSh->SetWaitCursor( FALSE );
				}
				break;

				case( SID_GRAFFILTER_SHARPEN ):
				{
					pDocSh->SetWaitCursor( TRUE );

					if( rGraphic.IsAnimated() )
					{
						Animation aAnimation( rGraphic.GetAnimation() );

						if( aAnimation.Filter( BMP_FILTER_SHARPEN ) )
							aGraphic = aAnimation;
					}
					else
					{
						BitmapEx aBmpEx( rGraphic.GetBitmapEx() );

						if( aBmpEx.Filter( BMP_FILTER_SHARPEN ) )
							aGraphic = aBmpEx;
					}

					pDocSh->SetWaitCursor( FALSE );
				}
				break;

				case( SID_GRAFFILTER_REMOVENOISE ):
				{
					pDocSh->SetWaitCursor( TRUE );

					if( rGraphic.IsAnimated() )
					{
						Animation aAnimation( rGraphic.GetAnimation() );

						if( aAnimation.Filter( BMP_FILTER_REMOVENOISE ) )
							aGraphic = aAnimation;
					}
					else
					{
						BitmapEx aBmpEx( rGraphic.GetBitmapEx() );

						if( aBmpEx.Filter( BMP_FILTER_REMOVENOISE ) )
							aGraphic = aBmpEx;
					}

					pDocSh->SetWaitCursor( FALSE );
				}
				break;

				case( SID_GRAFFILTER_SOBEL ):
				{
					pDocSh->SetWaitCursor( TRUE );

					if( rGraphic.IsAnimated() )
					{
						Animation aAnimation( rGraphic.GetAnimation() );

						if( aAnimation.Filter( BMP_FILTER_SOBEL_GREY ) )
							aGraphic = aAnimation;
					}
					else
					{
						BitmapEx aBmpEx( rGraphic.GetBitmapEx() );

						if( aBmpEx.Filter( BMP_FILTER_SOBEL_GREY ) )
							aGraphic = aBmpEx;
					}

					pDocSh->SetWaitCursor( FALSE );
				}
				break;

				case( SID_GRAFFILTER_MOSAIC ):
				{
					FilterMosaic aDlg( pWindow, rGraphic, 4, 4, FALSE );

					if( aDlg.Execute() == RET_OK )
						aGraphic = aDlg.GetFilteredGraphic( rGraphic, 1.0, 1.0 );
				}
				break;

				case( SID_GRAFFILTER_EMBOSS	):
				{
					FilterEmboss aDlg( pWindow, rGraphic, RP_MM );

					if( aDlg.Execute() == RET_OK )
						aGraphic = aDlg.GetFilteredGraphic( rGraphic, 1.0, 1.0 );
				}
				break;

				case( SID_GRAFFILTER_POSTER	):
				{
					FilterPoster aDlg( pWindow, rGraphic, 16 );

					if( aDlg.Execute() == RET_OK )
						aGraphic = aDlg.GetFilteredGraphic( rGraphic, 1.0, 1.0 );
				}
				break;

				case( SID_GRAFFILTER_POPART	):
					DBG_ERROR( "FuGrafFilter: Popart => NYI" );
				break;

				case( SID_GRAFFILTER_SEPIA ):
				{
					FilterSepia aDlg( pWindow, rGraphic, 10 );

					if( aDlg.Execute() == RET_OK )
						aGraphic = aDlg.GetFilteredGraphic( rGraphic, 1.0, 1.0 );
				}
				break;

				case( SID_GRAFFILTER_SOLARIZE ):
				{
					FilterSolarize aDlg( pWindow, rGraphic, 128, FALSE );

					if( aDlg.Execute() == RET_OK )
						aGraphic = aDlg.GetFilteredGraphic( rGraphic, 1.0, 1.0 );
				}
				break;

				default:
					DBG_ERROR( "FuGrafFilter: => NYI" );
				break;
			}

			if( aGraphic.GetType() != GRAPHIC_NONE )
			{
				SdrPageView* pPageView = pView->GetPageViewPvNum( 0 );

				if( pPageView )
				{
					SdrGrafObj*	pFilteredObj = (SdrGrafObj*) pObj->Clone();
					String		aStr( pView->GetMarkDescription() );

					aStr.Append( sal_Unicode(' ') );
					aStr.Append( String( SdResId( STR_UNDO_GRAFFILTER ) ) );
					pView->BegUndo( aStr );
					pFilteredObj->SetGraphic( aGraphic );
					pView->ReplaceObject( pObj, *pPageView, pFilteredObj );
					pView->EndUndo();
				}
			}
		}
	}
}
