/*************************************************************************
 *
 *  $RCSfile: sdwindow.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ka $ $Date: 2001/03/08 11:11:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SD_SDWINDOW_HXX
#define _SD_SDWINDOW_HXX

class SdViewShell;

#ifndef _GEN_HXX //autogen
#include <tools/gen.hxx>
#endif
#ifndef _WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif
#ifndef _TRANSFER_HXX //autogen
#include <svtools/transfer.hxx>
#endif

// Since we removed all old SV-stuff, there is no brush any more
// and so there is no BRUSH_SIZE defined in VCL.
// So I define it here
#define BRUSH_SIZE		8

/*************************************************************************
|*
|* SdWindow beinhaltet den eigentlichen Arbeitsbereich von
|* SdViewShell
|*
\************************************************************************/

class SdWindow : public Window, public DropTargetHelper
{
 protected:
	SdWindow*	pShareWin;
	Point		aWinPos;
	Point		aViewOrigin;
	Size		aViewSize;
	USHORT		nMinZoom;
	USHORT		nMaxZoom;
	BOOL		bMinZoomAutoCalc;
	BOOL		bCalcMinZoomByMinSide;
	BOOL		bCenterAllowed;
	long		nTicks;
	BOOL		bDraggedFrom;

	SdViewShell* pViewShell;

	virtual void Resize();
	virtual void Paint(const Rectangle& rRect);
	virtual void KeyInput(const KeyEvent& rKEvt);
	virtual void MouseMove(const MouseEvent& rMEvt);
	virtual void MouseButtonUp(const MouseEvent& rMEvt);
	virtual void MouseButtonDown(const MouseEvent& rMEvt);
	virtual void Command(const CommandEvent& rCEvt);
	virtual void RequestHelp( const HelpEvent& rEvt );
	virtual void LoseFocus();

 public:
	 SdWindow(Window* pParent);
	~SdWindow();

	void	SetViewShell(SdViewShell* pViewSh) { pViewShell=pViewSh; };

	void	ShareViewArea(SdWindow* pOtherWin);

	void	SetZoom(long nZoom);
	long	SetZoomRect(const Rectangle& rZoomRect);
	long	SetZoomFactor(long nZoom);

	void	SetMinZoomAutoCalc(BOOL bAuto) { bMinZoomAutoCalc = bAuto; }
	void	SetCalcMinZoomByMinSide(BOOL bMin) { bCalcMinZoomByMinSide = bMin; }
	void	CalcMinZoom();
	void	SetMinZoom(long nMin) { nMinZoom = (USHORT) nMin; }
	long	GetMinZoom() const { return nMinZoom; }
	void	SetMaxZoom(long nMax) { nMaxZoom = (USHORT) nMax; }
	long	GetMaxZoom() const { return nMaxZoom; }

	long	GetZoom() const
		{ return GetMapMode().GetScaleX().GetNumerator() * 100L /
				 GetMapMode().GetScaleX().GetDenominator(); }

	Point	GetWinViewPos() { return aWinPos; }
	Point	GetViewOrigin() { return aViewOrigin; }
	Size	GetViewSize()	{ return aViewSize; }
	void	SetWinViewPos(const Point& rPnt);
	void	SetViewOrigin(const Point& rPnt);
	void	SetViewSize(const Size& rSize);
	void	SetCenterAllowed(BOOL bIsAllowed) { bCenterAllowed = bIsAllowed; }

	void	UpdateMapOrigin(BOOL bInvalidate = TRUE);
	double	GetVisibleX();			// Interface fuer ScrollBars
	double	GetVisibleY();
	void	SetVisibleXY(double fX, double fY);
	double	GetVisibleWidth();
	double	GetVisibleHeight();
	double	GetScrlLineWidth();
	double	GetScrlLineHeight();
	double	GetScrlPageWidth();
	double	GetScrlPageHeight();
	void	DropScroll(const Point& rMousePos);
	virtual void GrabFocus();
	virtual void DataChanged( const DataChangedEvent& rDCEvt );

	// DropTargetHelper
	virtual sal_Int8	AcceptDrop( const AcceptDropEvent& rEvt );
	virtual sal_Int8	ExecuteDrop( const ExecuteDropEvent& rEvt );
};



#endif		// _SD_SDWINDOW_HXX
