/*************************************************************************
 *
 *  $RCSfile: jsnative.cxx,v $
 *
 *  $Revision: 1.18 $
 *
 *  last change: $Author: hr $ $Date: 2001/10/10 16:30:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef WNT
#include <tools/presys.h>
#include <windows.h>
#include <tools/postsys.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <cstdarg>
#include <string.h>

#ifndef _JSNATIVE_HXX
#include "jsnative.hxx"
#endif

#ifdef WNT
#include "nwinos.hxx"
#elif UNX
#include "nunxos.hxx"
#include <unistd.h>
#endif

#include "profile.hxx"

// ----------------------------------------------------------------------------

int 	nLastError 		= RETURN_ERROR_NONE;
BOOL 	bDebug			= FALSE;

#define ARG_OPEN	'('
#define ARG_CLOSE	')'
#define ARG_DELIM	','
#define ARG_STRING	'"'
#define ARG_ESC		'\\'

static const char* Commands[] =
{
	"getJSNVersion",			/* void										*/
	"setDebugMode",				/* void 									*/
	"exit",						/* void 									*/
	"getSVersion",				/* void										*/
	"makeDir",				    /* path, rights								*/
	"setDateTime",			    /* filename, hour, min, sec, day, month, year */
	"setRights",			    /* filename, rights							*/
	"getFreeDriveSize",			/* drive									*/
	"getClusterSize",			/* drive									*/
	"getOSDir",					/* void										*/
	"getOSSystemDir",			/* void										*/
	"getOSsystemFontDir",		/* void										*/
	"getHomeDir",				/* void										*/
	"getConfigDir",				/* void										*/
	"getServiceDir",			/* void										*/
	"getOSShellnewDir",			/* void										*/
	"getAutoStartDir",			/* void										*/
	"getOSDesktopDir",			/* void										*/
	"getBookmarkDir",			/* void										*/
	"getPersonalDir",			/* void										*/
	"setProfileString",			/* filename, section ,key, value			*/
	"getProfileString",			/* filename, section ,key					*/
	"removeProfileString",		/* filename, section ,key					*/
	"createProgramFolder",		/* foldername, user		  					*/
	"createProgramFolderItem",	/* foldername, itemname, destpath, destexec, param */
	"winRegistry",		    	/* key, subkey, name, value, bcreate, bhex, bdeleteall */
	"addFont",		    		/* fontfilename, fontname */
	"removeFont",		    	/* fontfilename, fontname */
	"deleteFile",		    	/* path, pattern, testdate, hour, min, sec, day, month, year */
	"copyFile",		    		/* sourcefilename, destinationfilename		*/
	"removeProgramFolder",		/* foldername, user							*/
	"removeProgramFolderItem",	/* foldername, itemname						*/
	"removeDir",				/* dirname									*/
	"getIEPluginDir",			/* void										*/
	"getNSPluginDir",			/* void										*/
	"getIEDir",		   			/* void										*/
	"unzipFile",		   		/* source, pattern, destination				*/
	"getNS6PluginDir",			/* void										*/
	"createShortcut",			/* source, destination, path, desc.			*/
	"getDriveList",				/* void										*/
	"getLastError", 			/* void										*/
	"moveFileAfterReboot",		/* source, destination						*/
	"ping",						/* void 									*/
	"prepareCleanupAfterReboot",/* sourceLocationOfExecuteable, destinationWorkingDirectory	*/
	"removeCleanupAfterRebootPreparation",  /* destinationWorkingDirectory */
	"isFileRegisteredForRemoveAfterReboot", /* filename						*/
	"removeLineFromAfterRebootList",/* line (e.g. NUL=filename)				*/
	"getUserProgramFilesFolder", /* void									*/
	"registerActiveX"			/* path, register(boolean 1==TRUE )			*/
};

// ----------------------------------------------------------------------------

void Submit(int Error, const char* pFormat, ...)
{
	va_list	marker;

	if (Error >= (sizeof(Errors) / sizeof(Errors[0])))
		Error = RETURN_ERROR_GENERIC;

	fwrite(Errors[Error], sizeof(char), strlen(Errors[Error]), stdout);

	if (pFormat != NULL)
	{
		fputc('\t', stdout);

		va_start(marker, pFormat);
		vfprintf(stdout, pFormat, marker);
		va_end(marker);
	}

	fputc('\n', stdout);
	fflush(stdout);

	if( bDebug ) fprintf( stderr, "\n" );
}

// ----------------------------------------------------------------------------

void Trim( char* str, char c )
{
	char	cBuf[16*1024];

	char*	pStart	= NULL;
	char*	pEnd	= NULL;
	int		nPos	= 0;

	strcpy( cBuf, str );

	while( cBuf[nPos] != 0x00 && cBuf[nPos] == c )
	{
		nPos++;
		pStart = &(cBuf[nPos]);
	}

	nPos = strlen(cBuf) - 1;
	while( nPos && cBuf[nPos] == c )
	{
		pEnd = &(cBuf[nPos]);
		nPos--;
	}

	if( !pStart )
		pStart = cBuf;
	if( !pEnd )
		pEnd = &(cBuf[strlen(cBuf)]);

	strcpy( str, pStart );
	str[pEnd-pStart] = 0x00;
}

// ----------------------------------------------------------------------------

#ifdef UNX
int main(int argc, char* argv[])
#else
int _cdecl main(int argc, char* argv[])
#endif
{
	#ifdef WNT
	WinOS* pOS = new WinOS( argc, argv );
	#elif  UNX
	UnxOS* pOS = new UnxOS( argc, argv );
	#endif

	#ifdef WNT
	//necessary for old windows(95,98) with files longer than 8.3 notation and
	//necessary if more than one file has to be removed aftrer reboot (windows system resp. wininit.ini just offers key based entries, so that a second deletion overwrites a first one)
	if( pOS->isStartedForCleanupAfterReboot( argc, argv ) )
	{
		int nReturn = pOS->cleanupAfterReboot( argc, argv );
		exit( nReturn );
	}
	#endif
	
	if( pOS->Startup(argc, argv) != 0 ) {
		delete pOS;
		exit( -1 );
	}

	char buffer[16 * 1024];
#ifdef WNT
	char rbuf[2];
	HANDLE hstdin = GetStdHandle(STD_INPUT_HANDLE);
	DWORD dwRead;
	while (ReadFile(hstdin, rbuf, 1, &dwRead, NULL) )
	{
		//read one line
		rbuf[1] = 0x00;
		strcat( buffer, rbuf );
		if( rbuf[0] != '\n' ) continue;

#else
	while (fgets(buffer, sizeof(buffer) - 1, stdin) != NULL)
	{
#endif
		//parse this single line for the command 'pCmd' and its arguments 'pArgs' with count nArgs
		int		nArgs = 0;
		char*	pArgs[MAX_ARGS];
		char	pCmd[100];
		char*	ptr = strchr( buffer, ARG_OPEN );

		//read the command name
		memset( pCmd, 0, 100 );
		strncpy( pCmd, buffer, ptr - buffer );
		Trim( pCmd, ' ' );

		if( bDebug )
			fprintf( stderr, "> %s\n", pCmd );

		if (pCmd != NULL)
		{
			//////////////////////////////////////
			// parse arguments
			ptr++;
			char* ptrLast = ptr;

			BOOL  bInStr  = FALSE;
			BOOL  bInEsc  = FALSE;
			BOOL  bStop   = FALSE;
			int   nNested = 0;

			while( !bStop || ptr[0] != 0x00 )
			{
				if( ptr[0] == ARG_OPEN )
					nNested++;

				if( ptr[0] == ARG_CLOSE )
					if( nNested )
						nNested--;
					else
						bStop = TRUE;

				if( ptr[0] == ARG_STRING )
					if( bInStr )
						bInStr = FALSE;
					else
						bInStr = TRUE;

				if( !bInStr && (ptr[0] == ARG_DELIM || bStop) )
				{
					if( (ptr - ptrLast) > 0 )
					{
						char* cBuf = new char[16*1024];

						memset( cBuf,0, 16*1024);

						strcpy( cBuf, ptrLast );
						cBuf[ptr-ptrLast] = 0x00;

						Trim( cBuf, ' ' );
						Trim( cBuf, '"' );

						pArgs[nArgs] = new char [16 * 1024];
						strcpy( pArgs[nArgs++] , cBuf );

						delete [] cBuf;
					}
					ptrLast = ptr + 1;
				}

				if( bInEsc ) bInEsc = FALSE;
				if( ptr[0] == ARG_ESC )
					bInEsc = TRUE;
				ptr++;
			}

			// -----------------------------------------------
			// getJSNVersion
			if( strcmp(pCmd, Commands[0]) == 0 )
			{
				Submit( RETURN_ERROR_NONE, JSNATIVE_VERSION, NULL );
			}
			// -----------------------------------------------
			// setDebugMode
			else if( strcmp(pCmd, Commands[1]) == 0 )
			{
				bDebug = TRUE;
				#ifdef WNT
				pOS->ShowCMDWindow();
				#endif
			}
			// -----------------------------------------------
			// exit
			else if( strcmp(pCmd, Commands[2]) == 0 )
			{
				pOS->Terminate();
				delete pOS;
				return 0;
			}
			// -----------------------------------------------
			// getSVersion
			else if( strcmp(pCmd, Commands[3]) == 0 )
			{
				char cBuf[500];
				pOS->GetSVersion( cBuf, 500 );
				Submit( RETURN_ERROR_NONE, cBuf, NULL );
			}
			// -----------------------------------------------
			// makeDir
			else if( strcmp(pCmd, Commands[4]) == 0 )
			{
				pOS->makeDir(pArgs[0], atoi(pArgs[1]));
				Submit( RETURN_ERROR_NONE, NULL );
			}
			// -----------------------------------------------
			// setDateTime
			else if( strcmp(pCmd, Commands[5]) == 0 )
			{
				pOS->setDateTime( pArgs[0], atoi(pArgs[1]), atoi(pArgs[2]), atoi(pArgs[3]),
								  atoi(pArgs[4]), atoi(pArgs[5]), atoi(pArgs[6]) );
			}
			// -----------------------------------------------
			// setRights
			else if( strcmp(pCmd, Commands[6]) == 0 )
			{
				pOS->setRights( pArgs[0], atoi(pArgs[1]) );
			}
			// -----------------------------------------------
			// getFreeDriveSize
			else if( strcmp(pCmd, Commands[7]) == 0 )
			{
				if( nArgs < 1 )
					Submit( RETURN_ERROR_INVALIDPARAMETERS, NULL );
				else
				{
					unsigned long n = pOS->GetFreeDriveSize( pArgs[0] );
					char cBuf[50];
					sprintf( cBuf, "%ld", n );
					Submit( RETURN_ERROR_NONE, cBuf, NULL );
				}
			}
			// -----------------------------------------------
			// getClusterSize
			else if( strcmp(pCmd, Commands[8]) == 0 )
			{
				if( nArgs < 1 )
					Submit( RETURN_ERROR_INVALIDPARAMETERS, NULL );
				else
				{
					unsigned long n = pOS->GetClusterSize( pArgs[0] );
					char cBuf[50];
					sprintf( cBuf, "%ld", n );
					Submit( RETURN_ERROR_NONE, cBuf, NULL );
				}
			}
			// -----------------------------------------------
			// getOSDir
			else if( strcmp(pCmd, Commands[9]) == 0 )
			{
				char cBuf[500];
				pOS->getOSDir( cBuf );
				Submit( RETURN_ERROR_NONE, cBuf, NULL );
			}
			// -----------------------------------------------
			// getOSSystemDir
			else if( strcmp(pCmd, Commands[10]) == 0 )
			{
				char cBuf[500];
				pOS->getOSSystemDir( cBuf );
				Submit( RETURN_ERROR_NONE, cBuf, NULL );
			}
			// -----------------------------------------------
			// getOSsystemFontDir
			else if( strcmp(pCmd, Commands[11]) == 0 )
			{
				char cBuf[500];
				pOS->getOSsystemFontDir( cBuf );
				Submit( RETURN_ERROR_NONE, cBuf, NULL );
			}
			// -----------------------------------------------
			// getHomeDir
			else if( strcmp(pCmd, Commands[12]) == 0 )
			{
				char cBuf[500];
				pOS->getHomeDir( cBuf );
				Submit( RETURN_ERROR_NONE, cBuf, NULL );
			}
			// -----------------------------------------------
			// getConfigDir
			else if( strcmp(pCmd, Commands[13]) == 0 )
			{
				char cBuf[500];
				pOS->getConfigDir( cBuf );
				Submit( RETURN_ERROR_NONE, cBuf, NULL );
			}
			// -----------------------------------------------
			// getServiceDir
			else if( strcmp(pCmd, Commands[14]) == 0 )
			{
				char cBuf[500];
				pOS->getServiceDir( cBuf );
				Submit( RETURN_ERROR_NONE, cBuf, NULL );
			}
			// -----------------------------------------------
			// getOSShellnewDir
			else if( strcmp(pCmd, Commands[15]) == 0 )
			{
				char cBuf[500];
				pOS->getOSShellnewDir( cBuf );
				Submit( RETURN_ERROR_NONE, cBuf, NULL );
			}
			// -----------------------------------------------
			// getAutoStart
			else if( strcmp(pCmd, Commands[16]) == 0 )
			{
				char cBuf[500];
				pOS->getAutoStart( cBuf );
				Submit( RETURN_ERROR_NONE, cBuf, NULL );
			}
			// -----------------------------------------------
			// getOSDesktopDir
			else if( strcmp(pCmd, Commands[17]) == 0 )
			{
				char cBuf[500];
				pOS->getOSDesktopDir( cBuf );
				Submit( RETURN_ERROR_NONE, cBuf, NULL );
			}
			// -----------------------------------------------
			// getBookmarkDir
			else if( strcmp(pCmd, Commands[18]) == 0 )
			{
				char cBuf[500];
				pOS->getBookmarkDir( cBuf );
				Submit( RETURN_ERROR_NONE, cBuf, NULL );
			}
			// -----------------------------------------------
			// getPersonalDir
			else if( strcmp(pCmd, Commands[19]) == 0 )
			{
				char cBuf[500];
				pOS->getPersonalDir( cBuf );
				Submit( RETURN_ERROR_NONE, cBuf, NULL );
			}
			// -----------------------------------------------
			//	setProfileString
			else if( strcmp(pCmd, Commands[20]) == 0 )
			{
				pOS->setProfileString( pArgs[0], pArgs[1], pArgs[2],
				strlen(pArgs[3])? pArgs[3] : const_cast<char*>("") );
			}
			// -----------------------------------------------
			//	getProfileString
			else if( strcmp(pCmd, Commands[21]) == 0 )
			{
				char ret[16*1024];
				pOS->getProfileString( pArgs[0], pArgs[1], pArgs[2], ret );
				Submit( RETURN_ERROR_NONE, ret, NULL );
			}
			// -----------------------------------------------
			//	removeProfileString
			else if( strcmp(pCmd, Commands[22]) == 0 )
			{
				pOS->removeProfileString( pArgs[0], pArgs[1], pArgs[2] );
			}
			// -----------------------------------------------
			//	createProgramFolder
			else if( strcmp(pCmd, Commands[23]) == 0 )
			{
				pOS->createProgramFolder( pArgs[0], strcmp(pArgs[1], "1") == 0? TRUE : FALSE );
			}
			// -----------------------------------------------
			//	createProgramFolderItem
			else if( strcmp(pCmd, Commands[24]) == 0 )
			{
				pOS->createProgramFolderItem( pArgs[0], pArgs[1], pArgs[2], pArgs[3], pArgs[4], TRUE );
			}
			// -----------------------------------------------
			//	winRegistry
			else if( strcmp(pCmd, Commands[25]) == 0 )
			{
				pOS->winRegistry( pArgs[0], pArgs[1], pArgs[2], pArgs[3],
						strcmp(pArgs[4], "1") == 0? TRUE : FALSE,
						strcmp(pArgs[5], "1") == 0? TRUE : FALSE,
						strcmp(pArgs[6], "1") == 0? TRUE : FALSE,
						FALSE );
			}
			// -----------------------------------------------
			//	addFont
			else if( strcmp(pCmd, Commands[26]) == 0 )
			{
				pOS->addFont( pArgs[0], pArgs[1] );
			}
			// -----------------------------------------------
			//	removeFont
			else if( strcmp(pCmd, Commands[27]) == 0 )
			{
				pOS->removeFont( pArgs[0], pArgs[1] );
			}
    		// -----------------------------------------------
			//	deleteFile
			else if( strcmp(pCmd, Commands[28]) == 0 )
			{
				pOS->deleteFile( pArgs[0], pArgs[1],
						strcmp(pArgs[2], "1") == 0? TRUE : FALSE,
						atoi(pArgs[3]), atoi(pArgs[4]), atoi(pArgs[5]),
						atoi(pArgs[6]), atoi(pArgs[7]), atoi(pArgs[8]) );
			}
	   		// -----------------------------------------------
			//	copyFile
			else if( strcmp(pCmd, Commands[29]) == 0 )
			{
				pOS->copyFile( pArgs[0], pArgs[1] );
			}
	   		// -----------------------------------------------
			//	removeProgramFolder
			else if( strcmp(pCmd, Commands[30]) == 0 )
			{
				pOS->removeProgramFolder( pArgs[0], strcmp(pArgs[1], "1") == 0? TRUE : FALSE );
			}
	   		// -----------------------------------------------
			//	removeProgramFolderItem
			else if( strcmp(pCmd, Commands[31]) == 0 )
			{
				pOS->removeProgramFolderItem( pArgs[0], pArgs[1], TRUE );
			}
	   		// -----------------------------------------------
			//	removeDir
			else if( strcmp(pCmd, Commands[32]) == 0 )
			{
				pOS->removeDir( pArgs[0] );
			}
	   		// -----------------------------------------------
			//	getIEPluginDir
			else if( strcmp(pCmd, Commands[33]) == 0 )
			{
				char cBuf[500];
				pOS->getIEPluginDir( cBuf );
				Submit( RETURN_ERROR_NONE, cBuf, NULL );
			}
	   		// -----------------------------------------------
			//	getNSPluginDir
			else if( strcmp(pCmd, Commands[34]) == 0 )
			{
				char cBuf[500];
				pOS->getNSPluginDir( cBuf );
				Submit( RETURN_ERROR_NONE, cBuf, NULL );
			}
	   		// -----------------------------------------------
			//	getIEDir
			else if( strcmp(pCmd, Commands[35]) == 0 )
			{
				char cBuf[500];
				pOS->getIEDir( cBuf );
				Submit( RETURN_ERROR_NONE, cBuf, NULL );
			}
	   		// -----------------------------------------------
			//	unzipFile
			else if( strcmp(pCmd, Commands[36]) == 0 )
			{
				pOS->unzipFile( pArgs[0], pArgs[1], pArgs[2] );
			}
	   		// -----------------------------------------------
			//	getNS6PluginDir
			else if( strcmp(pCmd, Commands[37]) == 0 )
			{
				char cBuf[500];
				pOS->getNS6PluginDir( cBuf );
				Submit( RETURN_ERROR_NONE, cBuf, NULL );
			}
	   		// -----------------------------------------------
			//	createShortcut
			else if( strcmp(pCmd, Commands[38]) == 0 )
			{
				pOS->createShortcut( pArgs[0], pArgs[1], pArgs[2], pArgs[3], pArgs[4] );
			}
	   		// -----------------------------------------------
			//	getDriveList
			else if( strcmp(pCmd, Commands[39]) == 0 )
			{
				char cBuf[500];
				pOS->getDriveList( cBuf );
				Submit( RETURN_ERROR_NONE, cBuf, NULL );
			}
	   		// -----------------------------------------------
			//	getLastError
			else if( strcmp(pCmd, Commands[40]) == 0 )
			{
				char cBuf[50];
				sprintf( cBuf, "%04ld", nLastError );
				Submit( RETURN_ERROR_NONE, cBuf, NULL );
			}
	   		// -----------------------------------------------
			//	moveFileAfterReboot
			else if( strcmp(pCmd, Commands[41]) == 0 )
			{
				pOS->moveFileAfterReboot( pArgs[0], pArgs[1] );
			}
			// -----------------------------------------------
			//	ping
			else if( strcmp(pCmd, Commands[42]) == 0 )
			{
				pOS->ping();
			}
			// -----------------------------------------------
			//	prepareCleanupAfterReboot
			else if( strcmp(pCmd, Commands[43]) == 0 )
			{
				#ifdef WNT
					pOS->prepareCleanupAfterReboot( pArgs[0], pArgs[1] );
				#endif
			}
			// -----------------------------------------------
			//	removeCleanupAfterRebootPreparation
			else if( strcmp(pCmd, Commands[44]) == 0 )
			{
				#ifdef WNT
					pOS->removeCleanupAfterRebootPreparation( pArgs[0] );
				#endif
			}
			// -----------------------------------------------
			// isFileRegisteredForRemoveAfterReboot
			else if( strcmp(pCmd, Commands[45]) == 0 )
			{
				#ifdef WNT
					if( pOS->isFileRegisteredForRemoveAfterReboot( pArgs[0] ) )
						Submit( RETURN_ERROR_NONE, "1", NULL );
					else
						Submit( RETURN_ERROR_NONE, "0", NULL );
				#else
					Submit( RETURN_ERROR_NONE, "0", NULL );
				#endif
			}
			// -----------------------------------------------
			// removeLineFromAfterRebootList
			else if( strcmp(pCmd, Commands[46]) == 0 )
			{
				#ifdef WNT
					pOS->removeLineFromAfterRebootList( pArgs[0] );
				#endif
			}
			// -----------------------------------------------
			//	getUserProgramFilesFolder
			else if( strcmp(pCmd, Commands[47]) == 0 )
			{
				#ifdef WNT
					char cBuf[500];
					pOS->getUserProgramFilesFolder( cBuf );
					Submit( RETURN_ERROR_NONE, cBuf, NULL );
				#else
					Submit( RETURN_ERROR_NONE, "", NULL );
				#endif
			}
			// -----------------------------------------------
			//	registerActiveX
			else if( strcmp(pCmd, Commands[48]) == 0 )
			{
				#ifdef WNT
					pOS->registerActiveX( pArgs[0], strcmp(pArgs[1], "1") == 0? TRUE : FALSE );
				#endif
			}
			
			for( int i = 0; i < nArgs; ++i )
				delete pArgs[i];
		}
		memset( buffer, 0, sizeof(buffer) );
	}

	return 0;
}

// ============================================================================
// ============================================================================
// ============================================================================

void OS::setProfileString(char* filename, char* section, char* key, char* value)
{
	oslProfile hProfile;
	if( hProfile = osl_openProfile(filename, 0) )
	{
		osl_writeProfileString( hProfile, section, key, value );
		osl_closeProfile( hProfile );
	}
}

void OS::getProfileString(char* filename, char* section, char* key, char* buf)
{
	oslProfile hProfile;
	if( hProfile = osl_openProfile(filename, 0) )
	{
		osl_readProfileString( hProfile, section, key, buf, 16*1024, "" );
		osl_closeProfile( hProfile );
	}
}

void OS::removeProfileString(char* filename, char* section, char* key)
{
	oslProfile hProfile;
	if( hProfile = osl_openProfile(filename, 0) )
	{
		osl_removeProfileEntry( hProfile, section, key );
		unsigned long n = getSectionCount( hProfile );
		osl_closeProfile( hProfile );

		if( n == 0 ) unlink(filename);
	}
}
