#!/bin/sh
#*************************************************************************
#
#   $RCSfile: sopatchlevel.sh,v $
#
#   $Revision: 1.4 $
#
#   last change: $Author: ok $ $Date: 2001/11/05 10:30:59 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc..
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

sd_inst="`dirname "$0"`"
sd_platform=`uname -s`

if [ "$sd_platform"="SunOS" ]; then
	#
	# check required patchid
	#

	sd_hardware=`uname -p`
	sd_release=`uname -r`
	required_patch=

	case $sd_hardware in
    i386)
        case $sd_release in
	        5.6)
            required_patch=104678
	        	required_minor=7
            ;;
        	5.7)
        		required_patch=106328
	      		required_minor=8
        		;;
					5.8)
        		required_patch=108436
						required_minor=1
						;;
        esac
        ;;
    sparc)
        case $sd_release in
	        5.6)
            required_patch=105591
	  	      required_minor=9
						;;
          5.7)
            required_patch=106327
	    	    required_minor=8
          	;;
					5.8)
            required_patch=108434
	    	    required_minor=1
						;;
        esac
    esac

	if [ "$ignore_patch_check" != "" ]; then
		echo WARNING! overriding patch check!
		required_patch=
	fi

	#
	# if no patch is required we are done
	#

	if [ "$required_patch" = "" ]; then
		exit 0
	fi

	#
	# check prerequesites
	#

	if [ ! -x /usr/bin/awk ]; then
		exit 0
	fi

	#
	# check installed patches
	#
    patch_installed=`"$sd_inst"/sorev -l SUNWlibC | /usr/bin/awk \
		'{ \
			if ($1 == "Patch:") { \
				split($2, inst_patch, "-"); \
				if (inst_patch[1] == required_patch) { \
					if ((inst_patch[2]+1) >= (1+required_minor)){ \
						print "done"; exit 0; \
					} \
				} \
		 	} \
			if ($3 == "Obsoletes:") { \
				split($4, inst_patch, "-"); \
				if (inst_patch[1] == required_patch) { \
					if ((inst_patch[2]+1) >= (1+required_minor)){ \
						print "done"; exit 0; \
					} \
				} \
		 	} \
		}' required_patch=$required_patch required_minor=$required_minor `

	if [ "$patch_installed" = "done" ]; then
		exit 0
	else
		case $sd_hardware in
  	  i386)
				echo "Operating system update required. Please install the following patches.  Solaris 7: 106328-08; Solaris 8: 108436-01, 108774-12"
        ;;
	    sparc)
				echo "Operating system update required. Please install the following patches. Solaris 7: 106327-08, 106300-09 (64 bit only); Solaris 8: 108434-01, 108773-12, 108435-01 (64 bit only)"
				;;
    esac
		exit 1
	fi
fi

exit 0
