/*************************************************************************
 *
 *  $RCSfile: querytemplate.cxx,v $
 *
 *  $Revision: 1.8.6.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/10/31 20:46:58 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#define ENABLE_BYTESTRING_STREAM_OPERATORS	1

#include "agenda.hxx"

#define DEF_DELIM	'|'

// ----------------------------------------------------------------------------

QueryTemplateResult SiAgenda::_QueryTemplateValue( const ByteString& rTpl )
{
	const SiReplacementList& rLst = m_pEnv->GetReplacementList();
	for( ULONG i = 0; i < rLst.Count(); ++i )
	{
		ReplacementEntry* pEntry = rLst.GetObject(i);
		if( rTpl.CompareIgnoreCaseToAscii(pEntry->aTag) == COMPARE_EQUAL )
			return QueryTemplateResult(pEntry->aValue, pEntry->nEncoding);
	}

	if (rTpl.CompareIgnoreCaseToAscii("<datetime>") == COMPARE_EQUAL)
	{
		DateTime aDt;
		ByteString aDtStr( ByteString::CreateFromInt32(aDt.GetYear()) );
		aDtStr += ByteString(";"); aDtStr += ByteString::CreateFromInt32(aDt.GetMonth());
		aDtStr += ByteString(";"); aDtStr += ByteString::CreateFromInt32(aDt.GetDay());
		aDtStr += ByteString(";"); aDtStr += ByteString::CreateFromInt32(aDt.GetHour());
		aDtStr += ByteString(";"); aDtStr += ByteString::CreateFromInt32(aDt.GetMin());
		aDtStr += ByteString(";"); aDtStr += ByteString::CreateFromInt32(aDt.GetSec());
		return QueryTemplateResult(aDtStr);
	}
	return QueryTemplateResult(rTpl);
}

// ----------------------------------------------------------------------------

QueryTemplateResult SiAgenda::QueryTemplateValue( ByteString const& rTpl )
{
	if( rTpl.Search(DEF_DELIM) == STRING_NOTFOUND )
		return _QueryTemplateValue( rTpl );

	ByteString aTpl( rTpl );
	aTpl.Erase(0,1);
	aTpl.Erase(aTpl.Len()-1,1);

	ByteString aReturn;
	USHORT nDelimTok = 0;
	USHORT nTokCount = aTpl.GetTokenCount( DEF_DELIM );

	for( USHORT x = 0; x < nTokCount; ++x )
	{
		ByteString aActValue( aTpl.GetToken(0, DEF_DELIM, nDelimTok) );
		USHORT nEndTpl, nBeginTpl = aActValue.Search('<');

		if( nBeginTpl != STRING_NOTFOUND )
		{
			for( USHORT i = nBeginTpl + 1; i <= aActValue.Len(); ++i )
			{
				if( aActValue.GetChar(i) == '>' )
				{
					nEndTpl = i;
					break;
				}
			}
		}
		else
		{
			nBeginTpl = 0;
			nEndTpl = aActValue.Len();
		}

		ByteString aTpl = aActValue.Copy( nBeginTpl, nEndTpl-nBeginTpl+1 );
		QueryTemplateResult aResult = _QueryTemplateValue( aTpl );
		if( aResult.sValue.Len() )
		{
			aActValue.SearchAndReplace( aTpl, aResult.sValue );
			return QueryTemplateResult(aActValue);
		}
	}
	return QueryTemplateResult(aReturn);
}

