/*************************************************************************
 *
 *  $RCSfile: siexec.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: dv $ $Date: 2001/11/20 11:31:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "decltor.hxx"
#include "compiler.hxx"
#include "fields.hxx"
#include "instdb.hxx"
#include "script.hxx"

TYPEINIT1(SiProcedure,SiDeclarator)
TYPEINIT1(SiCustom,SiDeclarator)

///////////////////////////////////////////////////////////////////////////////
//
//		SiProcedure
//

SiProcedure::SiProcedure(SiIdentifier const& ID, SiCompiler *pCompiler) :
		SiDeclarator(ID,pCompiler)
{
	INIT_MULTI_LANG_MEMBER( aProcName );
	INIT_MULTI_LANG_MEMBER( aCode );
	INIT_MULTI_LANG_MEMBER( bIsPreSelectProc );
	INIT_MULTI_LANG_MEMBER( bIsLanguageSelectProc );
	INIT_MULTI_LANG_MEMBER( bExecuteBefore );
	INIT_MULTI_LANG_MEMBER( Styles );

	m_Styles.bStandalone	= FALSE;
	m_Styles.bNetwork	 	= FALSE;
	m_Styles.bWorkstation	= FALSE;
	m_Styles.bInstall	  	= FALSE;
	m_Styles.bUninstall	  	= FALSE;
	m_Styles.bRepairable  	= FALSE;

	m_bIsPreSelectProc		= FALSE;
	m_bIsLanguageSelectProc	= FALSE;
	m_bExecuteBefore	 	= FALSE;
}

// ----------------------------------------------------------------------------

void SiProcedure::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiProcedure* pParent = (SiProcedure*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER( aProcName );
	JOIN_MULTI_LANG_MEMBER( aCode );
	JOIN_MULTI_LANG_MEMBER( bIsPreSelectProc );
	JOIN_MULTI_LANG_MEMBER( bIsLanguageSelectProc );
	JOIN_MULTI_LANG_MEMBER( bExecuteBefore );
	JOIN_MULTI_LANG_MEMBER( Styles );
}

// ----------------------------------------------------------------------------

BOOL SiProcedure::SetProperty(ByteString const& aProperty, ByteString const& aValue)
{
	if( aProperty == PROPERTY_PROCNAME )
	{
		SET_MULTI_LANG_MEMBER( aProcName, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_CODE )
	{
		ByteString aTemp( m_aCode );
		aTemp += aValue;
		aTemp += '\n';
		SET_MULTI_LANG_MEMBER( aCode, aTemp );
		return TRUE;
	}
	if( aProperty == PROPERTY_FLAGS )
	{
		if(aValue == VALUE_REPAIRABLE)
		{
			m_IsStyles = m_Styles.bRepairable = TRUE;
			return TRUE;
		}
		if(aValue == VALUE_STANDALONE)
		{
			m_IsStyles = m_Styles.bStandalone = TRUE;
			return TRUE;
		}
		if(aValue == VALUE_NETWORK)
		{
			m_IsStyles = m_Styles.bNetwork = TRUE;
			return TRUE;
		}
		if(aValue == VALUE_WORKSTATION)
		{
			m_IsStyles = m_Styles.bWorkstation = TRUE;
			return TRUE;
		}
		if(aValue == VALUE_INSTALL)
		{
			m_IsStyles = m_Styles.bInstall = TRUE;
			return TRUE;
		}
		if(aValue == VALUE_UNINSTALL)
		{
			m_IsStyles = m_Styles.bUninstall = TRUE;
			return TRUE;
		}

		if(aValue == VALUE_PRE_SELECT_MODULES)
		{
			SET_MULTI_LANG_MEMBER( bIsPreSelectProc, TRUE );
			return TRUE;
		}
		if(aValue == VALUE_LANGUAGE_SELECT_MODULES)
		{
			SET_MULTI_LANG_MEMBER( bIsLanguageSelectProc, TRUE );
			return TRUE;
		}
		if(aValue == VALUE_BEFORE)
		{
			SET_MULTI_LANG_MEMBER( bExecuteBefore, TRUE );
			return TRUE;
		}
		if(aValue == VALUE_AFTERWARDS)
		{
			SET_MULTI_LANG_MEMBER( bExecuteBefore, FALSE );
			return TRUE;
		}

		ByteString aMsg( aValue );
		aMsg += " is an illegal value";
		Error( aMsg );
		return FALSE;
	}

	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiProcedure::Check()
{
	BOOL bOk = TRUE;

	bOk = bOk && CheckField(m_aProcName, PROPERTY_PROCNAME);
	bOk = bOk && CheckField(m_aCode,	 PROPERTY_CODE);

	if( m_bIsPreSelectProc || m_bIsLanguageSelectProc )
		return bOk;

	BOOL bIsUiProc = FALSE;
	if( GetCompiler()->GetCScript()->GetInstallation() )
		bIsUiProc = GetCompiler()->GetCScript()->GetInstallation()->GetUiProcName() ==
					m_aProcName;

	if(	!bIsUiProc &&
		(!m_Styles.bStandalone && !m_Styles.bNetwork && !m_Styles.bWorkstation) )
	{
		Error ("missing install mode");
		bOk = FALSE;
	}

	if( !bIsUiProc &&
		(!m_Styles.bInstall && !m_Styles.bUninstall) )
	{
		Error ("missing INSTALL or UNINSTALL");
		bOk = FALSE;
	}

	return bOk ? SiDeclarator::Check() : FALSE;
}

// ----------------------------------------------------------------------------

BOOL SiProcedure::WriteTo(SiDatabase& aStream) const
{
	if( !IsLangRef() )
		aStream.BeginDeclaration("Procedure", this);

	// PROPERTY_PROCNAME
	WRITE_MULTI_LANG_MEMBER( PROPERTY_PROCNAME, aProcName );

	if( m_IsStyles || m_IsbExecuteBefore || m_IsbIsPreSelectProc )
	{
		aStream.BeginProperty( PROPERTY_FLAGS, m_nLanguage );
		aStream.BeginList();

		if( m_Styles.bStandalone )	aStream.AddListValue(SiIdentifier(VALUE_STANDALONE));
		if( m_Styles.bNetwork )		aStream.AddListValue(SiIdentifier(VALUE_NETWORK));
		if( m_Styles.bWorkstation )	aStream.AddListValue(SiIdentifier(VALUE_WORKSTATION));
		if( m_Styles.bInstall )		aStream.AddListValue(SiIdentifier(VALUE_INSTALL));
		if( m_Styles.bUninstall )	aStream.AddListValue(SiIdentifier(VALUE_UNINSTALL));
		if( m_Styles.bRepairable )	aStream.AddListValue(SiIdentifier(VALUE_REPAIRABLE));

		if( m_bExecuteBefore )
			aStream.AddListValue(SiIdentifier(VALUE_BEFORE));
		else
			aStream.AddListValue(SiIdentifier(VALUE_AFTERWARDS));

		if( m_bIsPreSelectProc )
			aStream.AddListValue(SiIdentifier(VALUE_PRE_SELECT_MODULES));

		if( m_bIsLanguageSelectProc )
			aStream.AddListValue(SiIdentifier(VALUE_LANGUAGE_SELECT_MODULES));

		aStream.EndList();
		aStream.EndProperty();
	}

	for( USHORT nIdx = 0; nIdx < m_aLangRefs.Count(); ++nIdx )
	{
		SiProcedure* pProc = (SiProcedure*) m_aLangRefs.GetObject(nIdx);
		pProc->WriteTo( aStream );
	}

	if( !IsLangRef() )
	{
		// Code darf an keiner LanguageRef hngen.
		aStream.BeginProperty( PROPERTY_CODE );
		aStream.WriteFreeStyle( m_aCode );
		aStream.EndProperty();

		aStream.EndDeclaration();
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

ByteString SiProcedure::GetNaturalID() const
{
	ByteString aNatID(GetID());
	if( IsLangRef() ) {
		aNatID += "__";
		aNatID += m_nLanguage;
	}
	return aNatID;
}

///////////////////////////////////////////////////////////////////////////////
//
//		SiCustom
//

SiCustom::SiCustom(SiIdentifier const& ID, SiCompiler *pCompiler) :
		SiDeclarator(ID,pCompiler)
{
	INIT_MULTI_LANG_MEMBER( DllName );
	INIT_MULTI_LANG_MEMBER( aCode );

	INIT_MULTI_LANG_MEMBER( bStandalone );
	INIT_MULTI_LANG_MEMBER( bNetwork );
	INIT_MULTI_LANG_MEMBER( bWorkstation );
	INIT_MULTI_LANG_MEMBER( bMigration );
	INIT_MULTI_LANG_MEMBER( bResponsefileWizard );

	INIT_MULTI_LANG_MEMBER( bExecInstBefore );
	INIT_MULTI_LANG_MEMBER( bExecInstAfter );
	INIT_MULTI_LANG_MEMBER( bExecDeInstBefore );
	INIT_MULTI_LANG_MEMBER( bExecDeInstAfter );
	INIT_MULTI_LANG_MEMBER( bExecModifyBefore );
	INIT_MULTI_LANG_MEMBER( bExecModifyAfter );
	INIT_MULTI_LANG_MEMBER( bExecRepair );
	INIT_MULTI_LANG_MEMBER( bKeepAlive );

	m_bStandalone		= FALSE;
	m_bNetwork			= FALSE;
	m_bWorkstation		= FALSE;
	m_bMigration		= FALSE;
	m_bResponsefileWizard = FALSE;

	m_bExecInstBefore 	= FALSE;
	m_bExecInstAfter   	= FALSE;
	m_bExecDeInstBefore	= FALSE;
	m_bExecDeInstAfter 	= FALSE;
	m_bExecModifyBefore = FALSE;
	m_bExecModifyAfter  = FALSE;
	m_bExecRepair       = FALSE;
	m_bKeepAlive        = FALSE;
}

// ----------------------------------------------------------------------------

void SiCustom::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiCustom* pParent = (SiCustom*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER( aCode );

	JOIN_MULTI_LANG_MEMBER( bStandalone );
	JOIN_MULTI_LANG_MEMBER( bNetwork );
	JOIN_MULTI_LANG_MEMBER( bWorkstation );
	JOIN_MULTI_LANG_MEMBER( bMigration );
	JOIN_MULTI_LANG_MEMBER( bResponsefileWizard );

	JOIN_MULTI_LANG_MEMBER( bExecInstBefore );
	JOIN_MULTI_LANG_MEMBER( bExecInstAfter );
	JOIN_MULTI_LANG_MEMBER( bExecDeInstBefore );
	JOIN_MULTI_LANG_MEMBER( bExecDeInstAfter );
	JOIN_MULTI_LANG_MEMBER( bExecModifyBefore );
	JOIN_MULTI_LANG_MEMBER( bExecModifyAfter );
	JOIN_MULTI_LANG_MEMBER( bExecRepair );
	JOIN_MULTI_LANG_MEMBER( bKeepAlive );
}

// ----------------------------------------------------------------------------

BOOL SiCustom::SetProperty(ByteString const& aProperty, ByteString const& aValue)
{
	if( aProperty == PROPERTY_FILENAME )
	{
		SET_MULTI_LANG_MEMBER( DllName, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_CODE )
	{
		SET_MULTI_LANG_MEMBER( aCode, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_FLAGS )
	{
		if(aValue == VALUE_RESPONSEFILEWIZARD)
		{
			SET_MULTI_LANG_MEMBER( bResponsefileWizard, TRUE );
			return TRUE;
		}
		if(aValue == VALUE_STANDALONE)
		{
			SET_MULTI_LANG_MEMBER( bStandalone, TRUE );
			return TRUE;
		}
		if(aValue == VALUE_NETWORK)
		{
			SET_MULTI_LANG_MEMBER( bNetwork, TRUE );
			return TRUE;
		}
		if(aValue == VALUE_WORKSTATION)
		{
			SET_MULTI_LANG_MEMBER( bWorkstation, TRUE );
			return TRUE;
		}

		if( aValue == VALUE_EXECINST_BEFORE )
		{
			SET_MULTI_LANG_MEMBER( bExecInstBefore, TRUE );
			return TRUE;
		}
		if( aValue == VALUE_EXECDEINST_BEFORE )
		{
			SET_MULTI_LANG_MEMBER( bExecDeInstBefore, TRUE );
			return TRUE;
		}
		if( aValue == VALUE_EXECINST_AFTER )
		{
			SET_MULTI_LANG_MEMBER( bExecInstAfter, TRUE );
			return TRUE;
		}
		if( aValue == VALUE_EXECDEINST_AFTER )
		{
			SET_MULTI_LANG_MEMBER( bExecDeInstAfter, TRUE );
			return TRUE;
		}
		if( aValue == VALUE_EXECMODIFY_BEFORE )
		{
			SET_MULTI_LANG_MEMBER( bExecModifyBefore, TRUE );
			return TRUE;
		}
		if( aValue == VALUE_EXECMODIFY_AFTER )
		{
			SET_MULTI_LANG_MEMBER( bExecModifyAfter, TRUE );
			return TRUE;
		}
		if( aValue == VALUE_REPAIRABLE )
		{
			SET_MULTI_LANG_MEMBER( bExecRepair, TRUE );
			return TRUE;
		}
		if( aValue == VALUE_KEEP_ALIVE )
		{
			SET_MULTI_LANG_MEMBER( bKeepAlive, TRUE );
			return TRUE;
		}

		if( aValue == VALUE_MIGRATION )
		{
			SET_MULTI_LANG_MEMBER( bMigration, TRUE );
			return TRUE;
		}
	}
	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiCustom::SetProperty(ByteString const& aProperty, SiDeclarator* aValue)
{
	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiCustom::Check()
{
	BOOL bOk = TRUE;
	bOk = bOk && CheckField( m_DllName, PROPERTY_FILENAME );
	return bOk ? SiDeclarator::Check() : FALSE;
}

// ----------------------------------------------------------------------------

BOOL SiCustom::WriteTo(SiDatabase& aStream) const
{
	if( !IsLangRef() )
		aStream.BeginDeclaration("Custom", this);

	// PROPERTY_FILENAME
	WRITE_MULTI_LANG_MEMBER( PROPERTY_FILENAME, DllName );

	if( m_bMigration || m_bStandalone || m_bNetwork || m_bWorkstation ||
		m_bExecInstBefore || m_bExecInstAfter || m_bExecDeInstBefore || m_bExecDeInstAfter ||
		m_bExecModifyBefore || m_bExecModifyAfter || m_bExecRepair || m_bResponsefileWizard ||
        m_bKeepAlive )
	{
		aStream.BeginProperty(PROPERTY_FLAGS, m_nLanguage);
		aStream.BeginList();

		if( m_bMigration )
			aStream.AddListValue( SiIdentifier(VALUE_MIGRATION) );
		if( m_bStandalone )
			aStream.AddListValue( SiIdentifier(VALUE_STANDALONE) );
		if( m_bNetwork )
			aStream.AddListValue( SiIdentifier(VALUE_NETWORK) );
		if( m_bWorkstation )
			aStream.AddListValue( SiIdentifier(VALUE_WORKSTATION) );
		if( m_bResponsefileWizard )
			aStream.AddListValue( SiIdentifier(VALUE_RESPONSEFILEWIZARD) );

		if( m_bExecInstBefore )
			aStream.AddListValue( SiIdentifier(VALUE_EXECINST_BEFORE) );
		if( m_bExecInstAfter )
			aStream.AddListValue( SiIdentifier(VALUE_EXECINST_AFTER) );
		if( m_bExecDeInstBefore )
			aStream.AddListValue( SiIdentifier(VALUE_EXECDEINST_BEFORE) );
		if( m_bExecDeInstAfter )
			aStream.AddListValue( SiIdentifier(VALUE_EXECDEINST_AFTER) );
		if( m_bExecModifyBefore )
			aStream.AddListValue( SiIdentifier(VALUE_EXECMODIFY_BEFORE) );
		if( m_bExecModifyAfter )
			aStream.AddListValue( SiIdentifier(VALUE_EXECMODIFY_AFTER) );
		if( m_bExecRepair )
			aStream.AddListValue( SiIdentifier(VALUE_REPAIRABLE) );
		if( m_bKeepAlive )
			aStream.AddListValue( SiIdentifier(VALUE_KEEP_ALIVE) );

		aStream.EndList();
		aStream.EndProperty();
	}

	for( USHORT nIdx = 0; nIdx < m_aLangRefs.Count(); ++nIdx )
	{
		SiCustom* pCustom = (SiCustom*) m_aLangRefs.GetObject(nIdx);
		pCustom->WriteTo( aStream );
	}

	if( !IsLangRef() )
	{
		if( m_aCode.Len() )
		{	// Code darf an keiner LanguageRef hngen.
			aStream.BeginProperty( PROPERTY_CODE );
			aStream.WriteFreeStyle( m_aCode );
			aStream.EndProperty();
		}
		aStream.EndDeclaration();
	}

	return TRUE;
}

// ----------------------------------------------------------------------------

ByteString SiCustom::GetNaturalID() const
{
	ByteString aNatID(GetID());
	if( IsLangRef() ) {
		aNatID += "__";
		aNatID += m_nLanguage;
	}
	return aNatID;
}

