/*************************************************************************
 *
 *  $RCSfile: sifile.cxx,v $
 *
 *  $Revision: 1.19.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/10/31 20:47:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "decltor.hxx"
#include "compiler.hxx"
#include "fields.hxx"
#include "script.hxx"
#include "instdb.hxx"

TYPEINIT1(SiFile,SiDeclarator)
TYPEINIT1(SiShortcut,SiDeclarator);

///////////////////////////////////////////////////////////////////////////////
//
//		SiFile
//
SiFileFlags::SiFileFlags()
{
	bPacked				= FALSE;
	bArchive			= FALSE;
	bFont				= FALSE;
	bFontWarnIfExists	= FALSE;
	bWorkstation		= FALSE;
	bWorkstationOnly	= FALSE;
	bCheckVersion  		= FALSE;
	bCheckTimestamp		= FALSE;
	bDeleteOnly	   		= FALSE;
	bDontDelete	   		= FALSE;
	bDontInstall		= FALSE;
	bDontOverwrite 		= FALSE;
	bOverwrite 	 		= FALSE;
	bOverwriteOnly 		= FALSE;
	bUnixSoftLink		= FALSE;
	bReadMe		   		= FALSE;
	bSetup		   		= FALSE;
	bSetupZip	   		= FALSE;
	bDontRecover   		= FALSE;
	bBind		   		= FALSE;
	bIsHelp		   		= FALSE;
	bIsCompHelp	   		= FALSE;
	bIsAgentLoader 		= FALSE;
	bIsProcessGuard		= FALSE;
	bDoMigration   		= FALSE;
	bSubstitute	   		= FALSE;
	bUnoComponent 		= FALSE;
	bIsDocLang			= FALSE;
	bWebOnly			= FALSE;
	bNoWeb				= FALSE;
	bNoTimeStamp		= FALSE;
	bNoUpdate			= FALSE;
	bNoWarnIfNotExists	= FALSE;
	bActiveX  			= FALSE;
    bPatchSOName        = FALSE;
    bForceRepair        = FALSE;
}

// ----------------------------------------------------------------------------

SiFile::SiFile( SiIdentifier const& ID, SiCompiler *pCompiler ) :
	SiDeclarator( ID,pCompiler ),
	m_Date( 0 ),
	m_Time( 0 )
{
	INIT_MULTI_LANG_MEMBER(	Name			);
	INIT_MULTI_LANG_MEMBER(	PackedName 		);
	INIT_MULTI_LANG_MEMBER(	ScpExtSearchName );
	INIT_MULTI_LANG_MEMBER(	FontName		);
	INIT_MULTI_LANG_MEMBER(	Date			);
	INIT_MULTI_LANG_MEMBER(	Time			);
	INIT_MULTI_LANG_MEMBER(	Flags			);
	INIT_MULTI_LANG_MEMBER(	lSize			);
	INIT_MULTI_LANG_MEMBER(	nDownloadSize 	);
	INIT_MULTI_LANG_MEMBER(	nArchiveSize	);
	INIT_MULTI_LANG_MEMBER(	nArchiveFiles	);
	INIT_MULTI_LANG_MEMBER(	pDirectory		);
	INIT_MULTI_LANG_MEMBER(	pNetDirectory	);
	INIT_MULTI_LANG_MEMBER(	pDataCarrier	);
	INIT_MULTI_LANG_MEMBER(	aOverwriteMsg	);
	INIT_MULTI_LANG_MEMBER(	nParts			);
	INIT_MULTI_LANG_MEMBER(	nPart			);
	INIT_MULTI_LANG_MEMBER(	pPartOf			);
	INIT_MULTI_LANG_MEMBER(	RegistryList	);
	INIT_MULTI_LANG_MEMBER(	SubfileList		);
	INIT_MULTI_LANG_MEMBER(	PartList		);
	INIT_MULTI_LANG_MEMBER(	pOs2Creator		);
	INIT_MULTI_LANG_MEMBER(	pOs2EAFile		);
	INIT_MULTI_LANG_MEMBER(	nUnixRights		);
	INIT_MULTI_LANG_MEMBER(	nScpUnixRights	);
	INIT_MULTI_LANG_MEMBER(	ShortcutList	);
	INIT_MULTI_LANG_MEMBER(	MacCreator		);
	INIT_MULTI_LANG_MEMBER(	nRefCount		);
	INIT_MULTI_LANG_MEMBER(	nCRC			);

	m_lSize				= 0;
	m_nDownloadSize		= 0;
	m_nArchiveSize		= 0;
	m_nArchiveFiles		= 0;
	m_pDirectory		= NULL;
	m_pNetDirectory		= NULL;
	m_pDataCarrier		= NULL;
	m_nParts			= 0;
	m_nPart       		= 0;
	m_pPartOf     		= NULL;
	m_nRefCount   		= 0;
	m_pOs2Creator 		= NULL;
	m_pOs2EAFile  		= NULL;
	m_nUnixRights 		= 644;
	m_nScpUnixRights	= 644;
	m_nCRC				= 0;
}

// ----------------------------------------------------------------------------

SiFile::~SiFile()
{
	for( ULONG i = 0; i < m_SubfileList.Count(); i++ )
		delete m_SubfileList.GetObject(i);
}

// ----------------------------------------------------------------------------

void SiFile::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiFile* pParent = (SiFile*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER(	Name			);
	JOIN_MULTI_LANG_MEMBER(	PackedName 		);
	JOIN_MULTI_LANG_MEMBER(	ScpExtSearchName );
	JOIN_MULTI_LANG_MEMBER(	FontName		);
	JOIN_MULTI_LANG_MEMBER(	Date			);
	JOIN_MULTI_LANG_MEMBER(	Time			);
	JOIN_MULTI_LANG_MEMBER(	Flags			);
	JOIN_MULTI_LANG_MEMBER(	lSize			);
	JOIN_MULTI_LANG_MEMBER(	nDownloadSize 	);
	JOIN_MULTI_LANG_MEMBER(	nArchiveSize	);
	JOIN_MULTI_LANG_MEMBER(	nArchiveFiles	);
	JOIN_MULTI_LANG_MEMBER(	pDirectory		);
	JOIN_MULTI_LANG_MEMBER(	pNetDirectory	);
	JOIN_MULTI_LANG_MEMBER(	pDataCarrier	);
	JOIN_MULTI_LANG_MEMBER(	aOverwriteMsg	);
	JOIN_MULTI_LANG_MEMBER(	nParts			);
	JOIN_MULTI_LANG_MEMBER(	nPart			);
	JOIN_MULTI_LANG_MEMBER(	pPartOf			);
	JOIN_MULTI_LANG_MEMBER(	RegistryList	);
//	JOIN_MULTI_LANG_MEMBER(	SubfileList		);
	JOIN_MULTI_LANG_MEMBER(	PartList		);
	JOIN_MULTI_LANG_MEMBER(	pOs2Creator		);
	JOIN_MULTI_LANG_MEMBER(	pOs2EAFile		);
	JOIN_MULTI_LANG_MEMBER(	nUnixRights		);
	JOIN_MULTI_LANG_MEMBER(	nScpUnixRights	);
	JOIN_MULTI_LANG_MEMBER(	ShortcutList	);
	JOIN_MULTI_LANG_MEMBER(	MacCreator		);
	JOIN_MULTI_LANG_MEMBER(	nRefCount		);
	JOIN_MULTI_LANG_MEMBER(	nCRC			);
}

// ----------------------------------------------------------------------------

BOOL SiFile::SetProperty(ByteString const& aProperty, ByteString const& aValue)
{
	if( aProperty == PROPERTY_NAME )
	{
		SET_MULTI_LANG_MEMBER(Name, aValue);
		return TRUE;
	}
	if( aProperty == PROPERTY_PACKEDNAME )
	{
		SET_MULTI_LANG_MEMBER(PackedName, aValue);
		return TRUE;
	}
	if( aProperty == PROPERTY_FONTNAME )
	{
		SET_MULTI_LANG_MEMBER(FontName, aValue);
		return TRUE;
	}
	if( aProperty == PROPERTY_DATE )
	{
		BOOL b = SetDate( m_Date , aValue );
		m_IsDate = TRUE;
		return b;
	}
	if( aProperty == PROPERTY_TIME )
	{
		BOOL b = SetTime(m_Time,aValue);
		m_IsTime = TRUE;
		return b;
	}
	if( aProperty == PROPERTY_CONTAINS )
	{
		USHORT		nDelimTok = 0;
		ByteString	aName( aValue.GetToken(0, ':', nDelimTok) );
		ULONG		nSize = aValue.GetToken(0, ':', nDelimTok).ToInt32();
		AddSubfile(aName, nSize);
		return TRUE;
	}
	if( aProperty == PROPERTY_OVERWRITEMSG )
	{
		SET_MULTI_LANG_MEMBER(aOverwriteMsg, aValue);
		return TRUE;
	}
	if( aProperty == PROPERTY_FLAGS )
	{
		m_IsFlags = TRUE;

		if (aValue == VALUE_PACKED)				{ m_Flags.bPacked  			= TRUE;  return TRUE; }
		if (aValue == VALUE_UNPACKED)	 		{ m_Flags.bPacked			= FALSE; return TRUE; }
		if (aValue == VALUE_ARCHIVE)	   		{ m_Flags.bArchive			= TRUE;  return TRUE; }
		if (aValue == VALUE_FONT)		   		{ m_Flags.bFont	  			= TRUE;  return TRUE; }
		if (aValue == VALUE_FONT_WARN_IF_EXISTS){ m_Flags.bFontWarnIfExists	= TRUE;  return TRUE; }
		if (aValue == VALUE_WORKSTATION)   		{ m_Flags.bWorkstation 		= TRUE;  return TRUE; }
		if (aValue == VALUE_WORKSTATION_ONLY)	{ m_Flags.bWorkstationOnly	= TRUE;  return TRUE; }
		if (aValue == VALUE_CHECK_TIMESTAMP)  	{ m_Flags.bCheckTimestamp	= TRUE;  return TRUE; }
		if (aValue == VALUE_CHECK_VERSION)		{ m_Flags.bCheckVersion		= TRUE;  return TRUE; }
		if (aValue == VALUE_DELETE_ONLY)   		{ m_Flags.bDeleteOnly		= TRUE;  return TRUE; }
		if (aValue == VALUE_DONT_DELETE)		{ m_Flags.bDontDelete		= TRUE;  return TRUE; }
		if (aValue == VALUE_DONT_INSTALL)		{ m_Flags.bDontInstall		= TRUE;  return TRUE; }
		if (aValue == VALUE_DONT_OVERWRITE)		{ m_Flags.bDontOverwrite	= TRUE;  return TRUE; }
		if (aValue == VALUE_OVERWRITE_ONLY)		{ m_Flags.bOverwriteOnly	= TRUE;  return TRUE; }
		if (aValue == VALUE_OVERWRITE) 			{ m_Flags.bOverwrite		= TRUE;  return TRUE; }
		if (aValue == VALUE_README)				{ m_Flags.bReadMe		 	= TRUE;  return TRUE; }
		if (aValue == VALUE_SD_HELP)  	   		{ m_Flags.bIsHelp 		 	= TRUE;  return TRUE; }
		if (aValue == VALUE_COMP_BY_SETUP) 		{ m_Flags.bIsCompHelp 	 	= TRUE;  return TRUE; }
		if (aValue == VALUE_SETUP)		   		{ m_Flags.bSetup		 	= TRUE;  return TRUE; }
		if (aValue == VALUE_SETUPZIP)	   		{ m_Flags.bSetupZip		 	= TRUE;  return TRUE; }
		if (aValue == VALUE_DONT_RECOVER)  		{ m_Flags.bDontRecover	 	= TRUE;  return TRUE; }
		if (aValue == VALUE_BIND_DLL)  	   		{ m_Flags.bBind			 	= TRUE;  return TRUE; }
		if (aValue == VALUE_AGENTLOADER)   		{ m_Flags.bIsAgentLoader 	= TRUE;  return TRUE; }
		if (aValue == VALUE_PROCESSGUARD)  		{ m_Flags.bIsProcessGuard	= TRUE;  return TRUE; }
		if (aValue == VALUE_INI_MIGRATION) 		{ m_Flags.bDoMigration	 	= TRUE;  return TRUE; }
		if (aValue == VALUE_SUBSTITUTE)	   		{ m_Flags.bSubstitute	 	= TRUE;  return TRUE; }
		if (aValue == VALUE_UNOCOMPONENT)  		{ m_Flags.bUnoComponent	 	= TRUE;  return TRUE; }
		if (aValue == VALUE_DOCLANG)  			{ m_Flags.bIsDocLang		= TRUE;  return TRUE; }
		if (aValue == VALUE_UNIX_SOFTLINK)		{ m_Flags.bUnixSoftLink		= TRUE;  return TRUE; }
		if (aValue == VALUE_WEB_ONLY)	  		{ m_Flags.bWebOnly			= TRUE;  return TRUE; }
		if (aValue == VALUE_NOWEB)	  			{ m_Flags.bNoWeb			= TRUE;  return TRUE; }
		if (aValue == VALUE_NOTIMESTAMP)  		{ m_Flags.bNoTimeStamp		= TRUE;  return TRUE; }
		if (aValue == VALUE_NOUPDATE)	  	 	{ m_Flags.bNoUpdate			= TRUE;  return TRUE; }
		if (aValue == VALUE_NOWARNIFNOTEXISTS)	{ m_Flags.bNoWarnIfNotExists= TRUE;  return TRUE; }
		if (aValue == VALUE_ACTIVEX)			{ m_Flags.bActiveX			= TRUE;  return TRUE; }
		if (aValue == VALUE_PATCH_SO_NAME)		{ m_Flags.bPatchSOName		= TRUE;  return TRUE; }
		if (aValue == VALUE_FORCE_REPAIR)		{ m_Flags.bForceRepair		= TRUE;  return TRUE; }

		Error("illegal value");
		return FALSE;
	}

	if( aProperty == PROPERTY_MAC_CREATOR )
	{
		if( IsMac() )
		{
			if( aValue.Len() == 4 )
			{
				SET_MULTI_LANG_MEMBER( MacCreator, aValue );
			}
			else
			{
				Error("MacCreator must be 4 characters long (i.e. SVsd)");
				return FALSE;
			}
		}
		else
			OsWarning(PROPERTY_MAC_CREATOR);
		return TRUE;
	}

	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiFile::SetProperty( ByteString const& aProperty, sal_uInt32 nValue )
{
	if( aProperty == PROPERTY_CRC )
	{
		SET_MULTI_LANG_MEMBER( nCRC, nValue );
		return TRUE;
	}

	return SiDeclarator::SetProperty( aProperty, nValue );
}

// ----------------------------------------------------------------------------

BOOL SiFile::SetProperty(ByteString const& aProperty, long aValue)
{
	if( aProperty == PROPERTY_SIZE )
	{
		SET_MULTI_LANG_MEMBER( lSize, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_DOWNLOAD_SIZE )
	{
		SET_MULTI_LANG_MEMBER( nDownloadSize, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_ARCHIVESIZE )
	{
		SET_MULTI_LANG_MEMBER( nArchiveSize, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_ARCHIVEFILES )
	{
		SET_MULTI_LANG_MEMBER( nArchiveFiles, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_PARTS )
	{
		SET_MULTI_LANG_MEMBER( nParts, (int)aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_PART )
	{
		SET_MULTI_LANG_MEMBER( nPart, (int)aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_UNIX_RIGHTS )
	{
		SET_MULTI_LANG_MEMBER( nUnixRights, (int)aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_SCPUNIX_RIGHTS )
	{
		SET_MULTI_LANG_MEMBER( nScpUnixRights, (int)aValue );
		return TRUE;
	}

	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiFile::SetProperty(ByteString const& aProperty, SiDeclarator* aValue)
{
	if( aProperty == PROPERTY_REGISTRYID )
	{
		SiStarRegistry* pRegistry = PTR_CAST(SiStarRegistry,aValue);
		if( pRegistry == NULL )
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a StarRegistry";
			Error( aMsg );
			return FALSE;
		}
		if( !m_RegistryList.Seek(pRegistry) )
		{
			m_RegistryList.Insert(pRegistry, LIST_APPEND);
			m_IsRegistryList = TRUE;
		}
		return TRUE;
	}
	if( aProperty == PROPERTY_DIR )
	{
		m_pDirectory = PTR_CAST(SiDirectory,aValue);
		if (m_pDirectory == NULL)
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a directory";
			Error( aMsg );
			return FALSE;
		}
		else
			m_pDirectory->AddRefCount();
		m_IspDirectory = TRUE;
		return TRUE;
	}
	if( aProperty == PROPERTY_NETDIR )
	{
		m_pNetDirectory = PTR_CAST(SiDirectory,aValue);

		if (m_pNetDirectory == NULL)
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a directory";
			Error( aMsg );
			return FALSE;
		}
		else
			m_pNetDirectory->AddRefCount();
		m_IspNetDirectory = TRUE;
		return TRUE;
	}
	if( aProperty == PROPERTY_CARRIER )
	{
		m_pDataCarrier = PTR_CAST(SiDataCarrier,aValue);

		if (m_pDataCarrier == NULL)
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a data carrier";
			Error( aMsg );
			return FALSE;
		}
		m_IspDataCarrier = TRUE;
		return TRUE;
	}
	if( aProperty == PROPERTY_PARTOF )
	{
		m_pPartOf = PTR_CAST(SiFile,aValue);
		if (m_pPartOf == NULL)
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a file";
			Error( aMsg );
			return FALSE;
		}
		m_IspPartOf = TRUE;
		return TRUE;
	}
	if( aProperty == PROPERTY_OS2_CREATORID )
	{
		if( IsOs2() )
		{
			m_pOs2Creator = PTR_CAST(SiOs2Creator,aValue);
			if (m_pOs2Creator == NULL)
			{
				ByteString aMsg( aValue->GetID() );
				aMsg += " is not an OS/2 creator ";
				Error( aMsg );
				return FALSE;
			}
			m_IspOs2Creator = TRUE;
			return TRUE;
		}
		else
			OsWarning( aProperty.GetBuffer() );
	}
	if( aProperty == PROPERTY_OS2_EAFILE )
	{
		if( IsOs2() )
		{
			m_pOs2EAFile = PTR_CAST(SiFile,aValue);
			if (m_pOs2EAFile == NULL)
			{
				ByteString aMsg( aValue->GetID() );
				aMsg += " is not a file";
				Error( aMsg );
				return FALSE;
			}
			m_IspOs2EAFile = TRUE;
			return TRUE;
		}
		else
			OsWarning( aProperty.GetBuffer() );
	}

	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiFile::Check()
{
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiFile::WriteTo(SiDatabase& aStream) const
{
	if( !IsLangRef() )
		aStream.BeginDeclaration( "File", this );

	// PROPERTY_NAME
	WRITE_MULTI_LANG_MEMBER( PROPERTY_NAME, Name );

	// PROPERTY_PACKEDNAME
	WRITE_MULTI_LANG_MEMBER( PROPERTY_PACKEDNAME, PackedName );

	// PROPERTY_FONTNAME
	WRITE_MULTI_LANG_MEMBER( PROPERTY_FONTNAME, FontName );

	// PROPERTY_SIZE
	WRITE_MULTI_LANG_MEMBER( PROPERTY_SIZE, lSize );

	// PROPERTY_DOWNLOAD_SIZE
	if( m_nDownloadSize )
		WRITE_MULTI_LANG_MEMBER( PROPERTY_DOWNLOAD_SIZE, nDownloadSize );

	// PROPERTY_ARCHIVEFILES
	if( m_nArchiveFiles != 0 )
	{
		WRITE_MULTI_LANG_MEMBER( PROPERTY_ARCHIVEFILES, nArchiveFiles );
	}

	// PROPERTY_ARCHIVESIZE
	if( m_nArchiveSize != 0 )
	{
		WRITE_MULTI_LANG_MEMBER( PROPERTY_ARCHIVESIZE, nArchiveSize );
	}

	// PROPERTY_DIR
	WRITE_MULTI_LANG_MEMBER( PROPERTY_DIR, pDirectory );

	// PROPERTY_NETDIR
	WRITE_MULTI_LANG_MEMBER( PROPERTY_NETDIR, pNetDirectory );

	// PROPERTY_REGISTRYID
	if( m_IsRegistryList )
	{
		for( USHORT i = 0; i< m_RegistryList.Count(); ++i )
		{
			SiStarRegistry* pObj = m_RegistryList.GetObject(i);
			aStream.WriteProperty( PROPERTY_REGISTRYID, pObj, m_nLanguage );
		}
	}

	// PROPERTY_CARRIER
	WRITE_MULTI_LANG_MEMBER( PROPERTY_CARRIER, pDataCarrier );

	// PROPERTY_PARTS
	if( m_nParts )
	{
		WRITE_MULTI_LANG_MEMBER( PROPERTY_PARTS, nParts );
	}

	// PROPERTY_CRC
	if( m_nCRC )
	{
		WRITE_MULTI_LANG_MEMBER( PROPERTY_CRC, nCRC );
	}

	// PROPERTY_OVERWRITEMSG
	if( m_aOverwriteMsg.Len() )
		WRITE_MULTI_LANG_MEMBER( PROPERTY_OVERWRITEMSG, aOverwriteMsg );

	// PROPERTY_PART
	WRITE_MULTI_LANG_MEMBER( PROPERTY_PART, nPart );

	// PROPERTY_PARTOF
	WRITE_MULTI_LANG_MEMBER( PROPERTY_PARTOF, pPartOf );

	// PROPERTY_OS2_CREATORID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_OS2_CREATORID, pOs2Creator );

	// PROPERTY_OS2_EAFILE
	WRITE_MULTI_LANG_MEMBER( PROPERTY_OS2_EAFILE, pOs2EAFile );

	// PROPERTY_UNIX_RIGHTS
	WRITE_MULTI_LANG_MEMBER( PROPERTY_UNIX_RIGHTS, nUnixRights );

	// PROPERTY_SCPUNIX_RIGHTS
	if(  GetCompiler()->GetCScript()->DoWriteScpAction() )
		WRITE_MULTI_LANG_MEMBER( PROPERTY_SCPUNIX_RIGHTS, nScpUnixRights );

	// PROPERTY_MAC_CREATOR
	WRITE_MULTI_LANG_MEMBER( PROPERTY_MAC_CREATOR, MacCreator );

	// PROPERTY_DATE, PROPERTY_TIME
	if( m_Date.GetYear() != 0 )
	{
		WRITE_MULTI_LANG_MEMBER( PROPERTY_DATE, Date );
		WRITE_MULTI_LANG_MEMBER( PROPERTY_TIME, Time );
	}

	if( m_IsFlags )
	{
		aStream.BeginProperty(PROPERTY_FLAGS, m_nLanguage);
			aStream.BeginList();
				if (m_Flags.bPacked)
					aStream.AddListValue(SiIdentifier(VALUE_PACKED));
				if (m_Flags.bArchive)
					aStream.AddListValue(SiIdentifier(VALUE_ARCHIVE));
				if (m_Flags.bFont)
					aStream.AddListValue(SiIdentifier(VALUE_FONT));
				if (m_Flags.bFontWarnIfExists)
					aStream.AddListValue(SiIdentifier(VALUE_FONT_WARN_IF_EXISTS));
				if (m_Flags.bWorkstation)
					aStream.AddListValue(SiIdentifier(VALUE_WORKSTATION));
				if (m_Flags.bWorkstationOnly)
					aStream.AddListValue(SiIdentifier(VALUE_WORKSTATION_ONLY));
				if (m_Flags.bCheckTimestamp)
					aStream.AddListValue(SiIdentifier(VALUE_CHECK_TIMESTAMP));
				if (m_Flags.bCheckVersion)
					aStream.AddListValue(SiIdentifier(VALUE_CHECK_VERSION));
				if (m_Flags.bDeleteOnly)
					aStream.AddListValue(SiIdentifier(VALUE_DELETE_ONLY));
				if (m_Flags.bDontDelete)
					aStream.AddListValue(SiIdentifier(VALUE_DONT_DELETE));
				if (m_Flags.bDontInstall)
					aStream.AddListValue(SiIdentifier(VALUE_DONT_INSTALL));
				if (m_Flags.bDontOverwrite)
					aStream.AddListValue(SiIdentifier(VALUE_DONT_OVERWRITE));
				if (m_Flags.bOverwrite)
					aStream.AddListValue(SiIdentifier(VALUE_OVERWRITE));
				if (m_Flags.bOverwriteOnly)
					aStream.AddListValue(SiIdentifier(VALUE_OVERWRITE_ONLY));
				if (m_Flags.bUnixSoftLink)
					aStream.AddListValue(SiIdentifier(VALUE_UNIX_SOFTLINK));
				if (m_Flags.bReadMe)
					aStream.AddListValue(SiIdentifier(VALUE_README));
				if (m_Flags.bSetup)
					aStream.AddListValue(SiIdentifier(VALUE_SETUP));
				if (m_Flags.bSetupZip)
					aStream.AddListValue(SiIdentifier(VALUE_SETUPZIP));
				if (m_Flags.bDontRecover)
					aStream.AddListValue(SiIdentifier(VALUE_DONT_RECOVER));
				if (m_Flags.bBind)
					aStream.AddListValue(SiIdentifier(VALUE_BIND_DLL));
				if (m_Flags.bIsHelp)
					aStream.AddListValue(SiIdentifier(VALUE_SD_HELP));
				if (m_Flags.bIsCompHelp)
					aStream.AddListValue(SiIdentifier(VALUE_COMP_BY_SETUP));
				if (m_Flags.bIsAgentLoader)
					aStream.AddListValue(SiIdentifier(VALUE_AGENTLOADER));
				if (m_Flags.bIsProcessGuard)
					aStream.AddListValue(SiIdentifier(VALUE_PROCESSGUARD));
				if (m_Flags.bDoMigration)
					aStream.AddListValue(SiIdentifier(VALUE_INI_MIGRATION));
				if (m_Flags.bSubstitute)
					aStream.AddListValue(SiIdentifier(VALUE_SUBSTITUTE));
				if (m_Flags.bUnoComponent)
					aStream.AddListValue(SiIdentifier(VALUE_UNOCOMPONENT));
				if (m_Flags.bIsDocLang)
					aStream.AddListValue(SiIdentifier(VALUE_DOCLANG));
				if (m_Flags.bWebOnly)
					aStream.AddListValue(SiIdentifier(VALUE_WEB_ONLY));
				if (m_Flags.bNoWeb)
					aStream.AddListValue(SiIdentifier(VALUE_NOWEB));
				if (m_Flags.bNoTimeStamp)
					aStream.AddListValue(SiIdentifier(VALUE_NOTIMESTAMP));
				if (m_Flags.bNoUpdate)
					aStream.AddListValue(SiIdentifier(VALUE_NOUPDATE));
				if (m_Flags.bNoWarnIfNotExists)
					aStream.AddListValue(SiIdentifier(VALUE_NOWARNIFNOTEXISTS));
				if (m_Flags.bActiveX)
					aStream.AddListValue(SiIdentifier(VALUE_ACTIVEX));
				if (m_Flags.bPatchSOName)
					aStream.AddListValue(SiIdentifier(VALUE_PATCH_SO_NAME));
				if (m_Flags.bForceRepair)
					aStream.AddListValue(SiIdentifier(VALUE_FORCE_REPAIR));
			aStream.EndList();
		aStream.EndProperty();
	}

	// PROPERTY_CONTAINS
	if( m_SubfileList.Count() != 0 )
	{
		aStream.BeginProperty( PROPERTY_CONTAINS, m_nLanguage );
			aStream.BeginList();
				for( USHORT i=0; i < m_SubfileList.Count(); i++ )
				{
					SiSubfile* pSubFile = m_SubfileList.GetObject(i);
					ByteString aEntry( pSubFile->aFilename );
					aEntry += ":";
					aEntry += ByteString::CreateFromInt32( pSubFile->nSize );
					aStream.AddListValue( aEntry );
				}
			aStream.EndList();
		aStream.EndProperty();
	}

	for( USHORT nIdx = 0; nIdx < m_aLangRefs.Count(); ++nIdx )
	{
		SiFile* pFile = (SiFile*) m_aLangRefs.GetObject(nIdx);
		pFile->WriteTo( aStream );
	}

	if( !IsLangRef() )
		aStream.EndDeclaration();

	return TRUE;
}

// ----------------------------------------------------------------------------

ByteString SiFile::GetNaturalID() const
{
	ByteString aNatID;
	if( m_Flags.bIsAgentLoader || m_Flags.bIsProcessGuard )
		aNatID  = ByteString("SETUP_INTERN" );
	else
		aNatID  = GetDirectory()->GetNaturalID();

	aNatID += NSEP;
	aNatID += m_Name;

	if( IsLangRef() ) {
		aNatID += "__";
		aNatID += ByteString::CreateFromInt32( m_nLanguage );
	}

	return aNatID;
}

// ----------------------------------------------------------------------------

void SiFile::AddSubfile(ByteString const& aFilename, ULONG nSize)
{
	SiSubfile* pNew = new SiSubfile;
	pNew->aFilename = aFilename;
	pNew->nSize = nSize;

	m_SubfileList.Insert( pNew, LIST_APPEND );
	m_IsSubfileList = TRUE;
}

void SiFile::RemoveAllSubfiles()
{
	for( ULONG i = 0; i < m_SubfileList.Count(); i++ )
		delete m_SubfileList.GetObject(i);
	m_SubfileList.Clear();
}

void SiFile::RemoveSubfile(ByteString *pName)
{
	for( ULONG i = 0; i < m_SubfileList.Count(); i++ )
	{
		SiSubfile* pSubfile = m_SubfileList.GetObject(i);
		if( pSubfile->aFilename.CompareIgnoreCaseToAscii(*pName) == COMPARE_EQUAL )
		{
			m_SubfileList.Remove(pSubfile);
			delete pSubfile;
			return ;
		}
	}
}

// ----------------------------------------------------------------------------

void SiFile::AddPart(SiFile *pFile)
{
	DBG_ASSERT(GetPartOf() == NULL, "SiFile::AddPart() must not be a part itself");
	m_PartList.Insert( pFile, LIST_APPEND );
}

///////////////////////////////////////////////////////////////////////////////
//
//		SiShortcut
//

SiShortcut::SiShortcut(SiIdentifier const& ID, SiCompiler *pCompiler) :
		SiDeclarator( ID, pCompiler, FALSE )
{
	INIT_MULTI_LANG_MEMBER( pFile );
	INIT_MULTI_LANG_MEMBER( pShortcut );
	INIT_MULTI_LANG_MEMBER( pDir );
	INIT_MULTI_LANG_MEMBER( aName );
	INIT_MULTI_LANG_MEMBER( bRelative );
	INIT_MULTI_LANG_MEMBER( bNetwork );
	INIT_MULTI_LANG_MEMBER( bStandalone );
	INIT_MULTI_LANG_MEMBER( bWorkstation );

	m_pFile			= NULL;
	m_pShortcut		= NULL;

	m_bNetwork      = FALSE;
	m_bStandalone   = TRUE;
	m_bWorkstation  = FALSE;
	m_bRelative     = FALSE;
}

void SiShortcut::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiShortcut* pParent = (SiShortcut*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER( pFile );
	JOIN_MULTI_LANG_MEMBER( pShortcut );
	JOIN_MULTI_LANG_MEMBER( pDir );
	JOIN_MULTI_LANG_MEMBER( aName );
	JOIN_MULTI_LANG_MEMBER( bRelative );
	JOIN_MULTI_LANG_MEMBER( bNetwork );
	JOIN_MULTI_LANG_MEMBER( bStandalone );
	JOIN_MULTI_LANG_MEMBER( bWorkstation );
}

BOOL SiShortcut::SetProperty(ByteString const& aProperty, ByteString const& aValue)
{
	if (aProperty == PROPERTY_NAME)
	{
		SET_MULTI_LANG_MEMBER( aName, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_FLAGS )
	{
		if (aValue == VALUE_RELATIVE)       { SET_MULTI_LANG_MEMBER( bRelative, TRUE ); return TRUE; }
		if (aValue == VALUE_NETWORK)        { SET_MULTI_LANG_MEMBER( bNetwork, TRUE ); return TRUE; }
		if (aValue == VALUE_STANDALONE)     { SET_MULTI_LANG_MEMBER( bStandalone, TRUE ); return TRUE; }
		if (aValue == VALUE_WORKSTATION)    { SET_MULTI_LANG_MEMBER( bWorkstation, TRUE ); return TRUE; }
	}

	return SiDeclarator::SetProperty(aProperty,aValue);
}

BOOL SiShortcut::SetProperty(ByteString const& aProperty, SiDeclarator* aValue)
{
	if( aProperty == PROPERTY_SHORTCUTID )
	{
		m_pShortcut = PTR_CAST( SiShortcut, aValue );
		if (m_pShortcut == NULL)
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a shortcut";
			Error( aMsg );
			return FALSE;
		}
		m_IspShortcut = TRUE;
		return TRUE;
	}

	if( aProperty == PROPERTY_FILEID )
	{
		m_pFile = PTR_CAST( SiFile, aValue );
		if (m_pFile == NULL)
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a file";
			Error( aMsg );
			return FALSE;
		}
		m_IspFile = TRUE;
		return TRUE;
	}
	if( aProperty == PROPERTY_DIR )
	{
		m_pDir = PTR_CAST(SiDirectory,aValue);
		if (m_pDir == NULL)
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a directory";
			Error( aMsg );
			return FALSE;
		}
		else
			m_pDir->AddRefCount();
		m_IspDir = TRUE;
		return TRUE;
	}
	return SiDeclarator::SetProperty( aProperty, aValue );
}

BOOL SiShortcut::Check()
{
	BOOL bOk = TRUE;
	bOk = bOk && CheckField(m_aName, PROPERTY_NAME);

	return bOk ? SiDeclarator::Check() : FALSE;
}

BOOL SiShortcut::WriteTo(SiDatabase& aStream) const
{
	if( !IsLangRef() )
		aStream.BeginDeclaration("Shortcut", this);

	// PROPERTY_NAME
	WRITE_MULTI_LANG_MEMBER( PROPERTY_NAME, aName );

	// PROPERTY_FILEID
	// PROPERTY_SHORTCUTID
	if( m_pFile )
	{
		WRITE_MULTI_LANG_MEMBER( PROPERTY_FILEID, pFile );
	}
	else if( m_pShortcut )
	{
		WRITE_MULTI_LANG_MEMBER( PROPERTY_SHORTCUTID, pShortcut );
	}

	// PROPERTY_DIR
	WRITE_MULTI_LANG_MEMBER( PROPERTY_DIR, pDir );

	if( m_bNetwork || m_bRelative || m_bStandalone || m_bWorkstation )
	{
		aStream.BeginProperty(PROPERTY_FLAGS, m_nLanguage);
		aStream.BeginList();

		if( m_bRelative )    aStream.AddListValue(SiIdentifier(VALUE_RELATIVE));
		if( m_bNetwork )     aStream.AddListValue(SiIdentifier(VALUE_NETWORK));
		if( m_bStandalone && m_IsbStandalone ) aStream.AddListValue(SiIdentifier(VALUE_STANDALONE));
		if( m_bWorkstation ) aStream.AddListValue(SiIdentifier(VALUE_WORKSTATION));

		aStream.EndList();
		aStream.EndProperty();
	}

	for( USHORT nIdx = 0; nIdx < m_aLangRefs.Count(); ++nIdx )
	{
		SiShortcut* pSiShortcut = (SiShortcut*) m_aLangRefs.GetObject(nIdx);
		pSiShortcut->WriteTo( aStream );
	}

	if( !IsLangRef() )
		aStream.EndDeclaration();
	return TRUE;
}

ByteString SiShortcut::GetNaturalID() const
{
    ByteString aNatID   = GetFile()->GetNaturalID();
                aNatID += NSEP;
                aNatID += m_aName;

    if( IsLangRef() )
    {
        aNatID += "__";
        aNatID += ByteString::CreateFromInt32( m_nLanguage );
    }
    return aNatID;
}

