/*************************************************************************
 *
 *  $RCSfile: sireg.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:51:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "decltor.hxx"
#include "compiler.hxx"
#include "fields.hxx"
#include "instdb.hxx"

TYPEINIT1(SiRegistryItem,SiDeclarator)
TYPEINIT1(SiRegistryArea,SiDeclarator)

///////////////////////////////////////////////////////////////////////////////
//
//		SiRegistryItem
//

SiRegistryItem::SiRegistryItem( SiIdentifier const& ID, SiCompiler *pCompiler, BOOL bSysObj ) :
		SiDeclarator(ID,pCompiler,bSysObj)
{
	INIT_MULTI_LANG_MEMBER( pModule );
	INIT_MULTI_LANG_MEMBER( pParent );
	INIT_MULTI_LANG_MEMBER( Key );
	INIT_MULTI_LANG_MEMBER( Subkey );
	INIT_MULTI_LANG_MEMBER( Name );
	INIT_MULTI_LANG_MEMBER( Value );
	INIT_MULTI_LANG_MEMBER( bHexValue );
	INIT_MULTI_LANG_MEMBER( bDontDelete );
	INIT_MULTI_LANG_MEMBER( bDeleteAll );

	m_pModule	  = NULL;
	m_pParent	  = NULL;
	m_bHexValue	  = FALSE;
	m_bDontDelete = FALSE;
	m_bDeleteAll  = FALSE;
}

// ----------------------------------------------------------------------------

void SiRegistryItem::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiRegistryItem* pParent = (SiRegistryItem*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER( pModule );
	JOIN_MULTI_LANG_MEMBER( pParent );
	JOIN_MULTI_LANG_MEMBER( Key );
	JOIN_MULTI_LANG_MEMBER( Subkey );
	JOIN_MULTI_LANG_MEMBER( Name );
	JOIN_MULTI_LANG_MEMBER( Value );
	JOIN_MULTI_LANG_MEMBER( bHexValue );
	JOIN_MULTI_LANG_MEMBER( bDontDelete );
	JOIN_MULTI_LANG_MEMBER( bDeleteAll );
}

// ----------------------------------------------------------------------------

BOOL SiRegistryItem::SetProperty(ByteString const& aProperty, ByteString const& aValue)
{
	if( aProperty == PROPERTY_SUBKEY )
	{
		SET_MULTI_LANG_MEMBER( Subkey, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_NAME )
	{
		SET_MULTI_LANG_MEMBER( Name, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_VALUE )
	{
		SET_MULTI_LANG_MEMBER( Value, aValue );
		return TRUE;
	}

	if (aProperty == PROPERTY_FLAGS)
	{
		if( aValue == VALUE_DONT_DELETE )
		{
			SET_MULTI_LANG_MEMBER( bDontDelete, TRUE );
			return TRUE;
		}
		if( aValue == VALUE_DELETE_ALL )
		{
			SET_MULTI_LANG_MEMBER( bDeleteAll, TRUE );
			return TRUE;
		}
		if( aValue == VALUE_HEX_VALUE )
		{
			SET_MULTI_LANG_MEMBER( bHexValue, TRUE );
			return TRUE;
		}
		ByteString aMsg( aValue );
		aMsg += "is an illegal value";
		Error( aMsg );

		return FALSE;
	}

	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiRegistryItem::SetProperty(ByteString const& aProperty, SiDeclarator* aValue)
{
	if( aProperty == PROPERTY_MODULEID )
	{
		m_pModule = PTR_CAST(SiModule,aValue);
		if( m_pModule == NULL )
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a module";
			Error( aMsg );
			return FALSE;
		}

		// SiRegistryItem in die Liste des Modules haengen.
		// Achtung: Selbst wenn Check() FALSE zurueckliefert
		//          (siehe SiCompiler::OnDeclarationEnd()) mu
		//          sichergestellt werden, dass das Objekt nicht
		//          zerstoert wird.
		m_pModule->Add(this);
		m_IspModule = TRUE;
		return TRUE;
	}
	if( aProperty == PROPERTY_PARENTID )
	{
		m_pParent = PTR_CAST(SiRegistryItem,aValue);
		if( m_pParent == NULL )
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a registry item";
			Error( aMsg );
			return FALSE;
		}
		m_IspParent = TRUE;
		return TRUE;
	}
	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiRegistryItem::Check()
{
	BOOL bOk = TRUE;
	bOk = bOk && CheckField(m_pParent, PROPERTY_PARENTID);

	if (IsHexValue())
	{
		bOk = bOk && CheckField(m_Name, PROPERTY_NAME);

		ByteString HexDigits = "0123456789aAbBcCdDeEfF";

		for (USHORT i=0; i<m_Value.Len() && bOk; i++)
		{
			if (HexDigits.Search(m_Value.GetChar(i)) == STRING_NOTFOUND)
			{
				Error("Value contains illegal digits, digits can be 0-9, a-f and A-F");
				bOk = FALSE;
			}
		}

		if (bOk
		&&  m_Value.Len() > 4)
		{
			Error("A hex value cannot be longer than 4 digits");
			bOk = FALSE;
		}
	}

	return bOk ? SiDeclarator::Check() : FALSE;
}

// ----------------------------------------------------------------------------

BOOL SiRegistryItem::WriteTo(SiDatabase& aStream) const
{
	if( !IsLangRef() )
		aStream.BeginDeclaration("RegistryItem", this);

	// PROPERTY_PARENTID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_PARENTID, pParent );

	// PROPERTY_MODULEID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_MODULEID, pModule );

	// PROPERTY_SUBKEY
	WRITE_MULTI_LANG_MEMBER( PROPERTY_SUBKEY, Subkey );

	// PROPERTY_NAME
	WRITE_MULTI_LANG_MEMBER( PROPERTY_NAME, Name );

	// PROPERTY_VALUE
	WRITE_MULTI_LANG_MEMBER( PROPERTY_VALUE, Value );

	if( IsHexValue() || DontDelete() || DeleteAll() )
	{
		aStream.BeginProperty(PROPERTY_FLAGS, m_nLanguage );
		aStream.BeginList();

		if( IsHexValue() )
			aStream.AddListValue(SiIdentifier(VALUE_HEX_VALUE));
		if( DontDelete() )
			aStream.AddListValue(SiIdentifier(VALUE_DONT_DELETE));
		if( DeleteAll() )
			aStream.AddListValue(SiIdentifier(VALUE_DELETE_ALL));

		aStream.EndList();
		aStream.EndProperty();
	}

	for( USHORT nIdx = 0; nIdx < m_aLangRefs.Count(); ++nIdx )
	{
		SiRegistryItem* pRegItem = (SiRegistryItem*) m_aLangRefs.GetObject(nIdx);
		pRegItem->WriteTo( aStream );
	}

	if( !IsLangRef() )
		aStream.EndDeclaration();
	return TRUE;
}

// ----------------------------------------------------------------------------

ByteString SiRegistryItem::GetNaturalID() const
{
	ByteString aNatID  = GetKey();
		   aNatID += NSEP;
		   aNatID += GetSubkey();
	if( IsLangRef() ) {
		aNatID += "__";
		aNatID += m_nLanguage;
	}
	return aNatID;
}

// ----------------------------------------------------------------------------

ByteString const& SiRegistryItem::GetKey() const
{
	// Nur das oberste Element hat den Key
	// (z.B. HKEY_LOCAL_MACHINE)
	if (m_pParent == NULL)
	{
		DBG_ASSERT(m_Key.Len() != 0, "SiRegistryItem::GetKey() is empty");
		return m_Key;
	}

	return m_pParent->GetKey();
}

// ----------------------------------------------------------------------------

ByteString SiRegistryItem::GetSubkey() const
{
	ByteString aKey;
	if (m_pParent != NULL)
		aKey = m_pParent->GetSubkey();
	if (aKey.Len() != 0
	&&  m_Subkey.Len() != 0)
		aKey += '\\';
	aKey += m_Subkey;
	return aKey;
}

///////////////////////////////////////////////////////////////////////////////
//
//		SiRegistryArea
//

SiRegistryArea::SiRegistryArea( SiIdentifier const& ID, SiCompiler *pCompiler ) :
		SiDeclarator(ID,pCompiler)
{
	INIT_MULTI_LANG_MEMBER( pModule );
	INIT_MULTI_LANG_MEMBER( SubKey );
	INIT_MULTI_LANG_MEMBER( FromKey );
	INIT_MULTI_LANG_MEMBER( ToKey );

	m_pModule = NULL;
}

// ----------------------------------------------------------------------------

void SiRegistryArea::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiRegistryArea* pParent = (SiRegistryArea*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER( pModule );
	JOIN_MULTI_LANG_MEMBER( SubKey );
	JOIN_MULTI_LANG_MEMBER( FromKey );
	JOIN_MULTI_LANG_MEMBER( ToKey );
}

// ----------------------------------------------------------------------------

BOOL SiRegistryArea::SetProperty(ByteString const& aProperty, ByteString const& aValue)
{
	if (aProperty == PROPERTY_SUBKEY)
	{
		SET_MULTI_LANG_MEMBER( SubKey, aValue );
		return TRUE;
	}

	if (aProperty == PROPERTY_FROMKEY)
	{
		SET_MULTI_LANG_MEMBER( FromKey, aValue );
		return TRUE;
	}

	if (aProperty == PROPERTY_TOKEY)
	{
		SET_MULTI_LANG_MEMBER( ToKey, aValue );
		return TRUE;
	}

	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiRegistryArea::SetProperty(ByteString const& aProperty, SiDeclarator* aValue)
{
	if (aProperty == PROPERTY_MODULEID)
	{
		m_pModule = PTR_CAST(SiModule,aValue);
		if (m_pModule == NULL)
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a module";
			Error( aMsg );
			return FALSE;
		}
		// SiRegistryArea in die Liste des Modules haengen.
		// Achtung: Selbst wenn Check() FALSE zurueckliefert
		//          (siehe SiCompiler::OnDeclarationEnd()) mu
		//          sichergestellt werden, dass das Objekt nicht
		//          zerstoert wird.
		m_pModule->Add(this);
		m_IspModule = TRUE;
		return TRUE;
	}

	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiRegistryArea::Check()
{
	BOOL bOk = TRUE;

	bOk = bOk && CheckField(m_pModule, PROPERTY_MODULEID);
	bOk = bOk && CheckField(m_SubKey,  PROPERTY_SUBKEY);
	bOk = bOk && CheckField(m_FromKey, PROPERTY_FROMKEY);
	bOk = bOk && CheckField(m_ToKey,   PROPERTY_TOKEY);

	return bOk ? SiDeclarator::Check() : FALSE;
}

// ----------------------------------------------------------------------------

BOOL SiRegistryArea::WriteTo(SiDatabase& aStream) const
{
	if( !IsLangRef() )
		aStream.BeginDeclaration("RegistryArea", this);

	// PROPERTY_MODULEID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_MODULEID, pModule );

	// PROPERTY_SUBKEY
	WRITE_MULTI_LANG_MEMBER( PROPERTY_SUBKEY, SubKey );

	// PROPERTY_FROMKEY
	WRITE_MULTI_LANG_MEMBER( PROPERTY_FROMKEY, FromKey );

	// PROPERTY_TOKEY
	WRITE_MULTI_LANG_MEMBER( PROPERTY_TOKEY, ToKey );

	for( USHORT nIdx = 0; nIdx < m_aLangRefs.Count(); ++nIdx )
	{
		SiRegistryArea* pRegArea = (SiRegistryArea*) m_aLangRefs.GetObject(nIdx);
		pRegArea->WriteTo( aStream );
	}

	if( !IsLangRef() )
		aStream.EndDeclaration();
	return TRUE;
}

// ----------------------------------------------------------------------------

ByteString SiRegistryArea::GetNaturalID() const
{
	ByteString aNatID  = m_FromKey;
		   aNatID += NSEP;
		   aNatID += m_ToKey;
	if( IsLangRef() ) {
		aNatID += "__";
		aNatID += m_nLanguage;
	}
	return aNatID;
}

