/*************************************************************************
 *
 *  $RCSfile: appserv2.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:51:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _APPSERV_HXX_
#define _APPSERV_HXX_


#include <vcl/resmgr.hxx>
#include <vos/security.hxx>
#include "aservdlg2.hxx"

/************************************************************************/

#ifdef _USE_NAMESPACE
using namespace vos;
#endif

/************************************************************************/

class PlugInServerSetUp
{
  public:
						PlugInServerSetUp		( BOOL			bBatchMode,
												  const char*	sNameOfIniFile );
	virtual			   ~PlugInServerSetUp		( );

	virtual BOOL		mainPreInstallation		( const char*	sPathToSetUpExec,
												  const char*	sPathToInstRoot,
												  BOOL			bIsInstallation );
	virtual BOOL		mainPostInstallation	( const char*	sPathToSetUpExec,
												  const char*	sPathToInstRoot,
												  BOOL			bIsInstallation );
  protected:

	virtual BOOL		batchModeEnabled		( );

	virtual void		readResourceFile		( const char*	sPathToSetUpExec );
	virtual BOOL		couldReadRscFile		( );

	virtual void		findScript				( const char*	sPathToSetUpExec );
	virtual BOOL		scriptHasBeenFound		( );
	virtual void		openScript				( );

	virtual BOOL		userIsAdministrator		( );
	virtual BOOL		userIsAbleToBecomeAdministrator ( );
	virtual void		becomeAdministrator		( );

	virtual void		openDialog				( );
	virtual short		executeDialog			( );
	virtual void		closeDialog				( );

	virtual BOOL		setUpIsForScheduleServer ( );

	virtual BOOL		portIsInUse				( short			nPort );

	virtual BOOL		installServer			( const char*	sPathToInstRoot,
												  const char*	sAdminPort,
												  const char*	sHttpPort,
												  BOOL			bStartDaemons );
	virtual BOOL		uninstallServer			( const char*	sPathToInstRoot );

	virtual void		evaluateNameOfSection	( char*			sByteString,
												  const char*	sGenericName );

	virtual void		executeSectionOfScript	( const char*	sNameOfSection,
												  const char*	sPathToInst );

	virtual void		executeProcess			( const char*	sNameOfExecutable,
												  const char*	sArguments );

	virtual void		executeProcess			( const char*	sNameOfExecutable,
												  int			nArgC,
												  const char*	sArgV[] );
  private:

	BOOL				m_bBatchMode;
	ByteString				m_sNameOfIniFile;

	BOOL				m_bPlatformIsUnix;
	BOOL				m_bPlatformIsWin32;
	BOOL				m_bPlatformIsOS2;

	ResMgr*				m_pRscMgr;

	OSecurity			m_security;

	BOOL				m_bSetUpIsForScheduleServer;
	BOOL				m_bScriptHasBeenFound;
	ByteString				m_sNameOfScriptFile;
	OProfile			m_script;

	ServerSetupDialog*	m_pDialog;
};


#endif

/************************************************************************/
