/*************************************************************************
 *
 *  $RCSfile: jvmscan.cxx,v $
 *
 *  $Revision: 1.9.6.5 $
 *
 *  last change: $Author: armin $ $Date: 2002/10/29 16:58:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "../jvmscan.hxx"

#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/utsname.h>
#include <unistd.h>
#include <pwd.h>
#include <dirent.h>
#ifdef SCO
#define _IBCS2
#endif
#include <limits.h>
#include <stdarg.h>

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

/*
 * definitions and declarations
 */

#ifndef Bool
#define Bool int
#endif

#ifndef Bool
#define Bool int
#endif

#ifndef True
#define True  (1==1)
#endif

#ifndef False
#define False (!True)
#endif

#if defined (SPARC)
#define ARCH "sparc"
#elif defined (INTEL)
#define ARCH "i386"
#elif defined (POWERPC)
#define ARCH "ppc"
#elif defined (MIPS)
#define ARCH "mips"
#elif defined (X86_64)
#define ARCH "x86_64"
#else
#error unknown plattform
#endif

/* some platforms have no hotspot yet even under jdk 1.3 */
/*  so treat them like classic in JDK 1.2.x  */
#if (defined(POWERPC) && defined(LINUX)) || (defined(INTEL) && defined(FREEBSD))
#define NO_HOTSPOT_USE_CLASSIC 1
#else 
#undef NO_HOTSPOT_USE_CLASSIC
#endif


#define members_of( arg ) (sizeof(arg) / sizeof(arg[0]))

#ifdef SOLARIS
#define _DIRENT_HAVE_D_RECLEN
#endif

#ifdef _DIRENT_HAVE_D_NAMLEN
# define _D_EXACT_NAMLEN(d) ((d)->d_namlen)
# define _D_ALLOC_NAMLEN(d) (_D_EXACT_NAMLEN (d) + 1)
#else
# define _D_EXACT_NAMLEN(d) (strlen ((d)->d_name))
# ifdef _DIRENT_HAVE_D_RECLEN
#  define _D_ALLOC_NAMLEN(d) (((char *) (d) + (d)->d_reclen) - &(d)->d_name[0])
# else
#  define _D_ALLOC_NAMLEN(d) (sizeof (d)->d_name > 1 ? sizeof (d)->d_name : \
                  _D_EXACT_NAMLEN (d) + 1)
# endif
#endif

/* create a debug log */
static void AppendDebugMessage( char* pFormat, ... )
{
#if defined DEBUG
	char pDebugLog[ PATH_MAX ];
	FILE* fp;
	va_list ap;

	strcpy( pDebugLog, getenv( "HOME" ) );
	strcat( pDebugLog, "/unix.log" );
	if( fp = fopen( pDebugLog, "a" ) )
	{
		va_start( ap, pFormat );
		vfprintf( fp, pFormat, ap );
		va_end( ap );
		fclose( fp );
	}
#endif
}

typedef enum {
	jvm_unknown = 0,
	jvm_jre,
	jvm_jdk,
	jvm_java
} jvm_vendor_t;

int scanforjava ( const char *dir, struct dirent ***namelist,
    int (*select) (struct dirent *) )
{

    DIR             *dp;
    struct dirent   **v = NULL;
    size_t          vsize = 0, i;
    struct dirent   *d;
    int             save;

    dp = opendir( dir );

    if (dp == NULL)
        return -1;

    i = 0;
    while ((d = readdir (dp)) != NULL)
    {

        if (select == NULL || (*select) (d))
        {
            size_t dsize;

            if (i == vsize)
            {
                if (vsize == 0)
                    vsize = 10;
                else
                    vsize *= 2;
                v = (struct dirent **) realloc (v, vsize * sizeof (*v));
            }


            dsize = &d->d_name[_D_ALLOC_NAMLEN (d)] - (char *) d;
            v[i] = (struct dirent *) malloc (dsize);
            memcpy (v[i++], d, dsize);
        }
    }

    (void) closedir (dp);

    *namelist = v;
    return i;
}

typedef struct  {
	jvm_vendor_t	Vendor;
	char 			VendorByteString [ 64 ];
	char 			Version      [ 32 ];
	char 			Home         [ PATH_MAX ];
	char 			Executable   [ PATH_MAX ];
	char			RuntimeLib	 [ PATH_MAX ];
	char 			Classpath	 [ 2048 ];
} jvm_t;

jvm_vendor_t JavaVendor ( const char *name );

/*
 * implementation
 */
/* string convenience routine */

typedef struct {
	char *buffer;
	int   len;
	int   size;
} string_t;

typedef enum {
    JDK11,
    JDK12,
    JDK13,
    UNKNOW
} java_version;

java_version extractVersion(ByteString versionstr)
{
    switch ( versionstr.GetChar(2) ) {
        case '1' : return JDK11;
        case '2' : return JDK12;
        case '3' : return JDK13;
        default  : return UNKNOW;
    };
}

string_t* newstring( int size )
{
	string_t* s;
	s = (string_t*) malloc( sizeof(string_t) );
	s->buffer = (char*) malloc( size );
	s->size   = size;
	s->len    = 0;

	return s;
}

string_t* renewstring( string_t *s )
{
	s->size *= 2;
	s->buffer = (char*) realloc( s->buffer, s->size );

	return s;
}

void delstring( string_t *s )
{
	if ( s == NULL )
		return;
	if ( s->size && s->buffer )
		free( s->buffer );
	free( s );
}

string_t* appstring ( string_t* dst, char* src )
{
	int srclen = strlen( src );

	if ( dst == NULL )
		dst = newstring( 1024 );
	while ( (dst->len + srclen + 1) >= dst->size )
		dst = renewstring ( dst );

	memcpy ( dst->buffer + dst->len, src, srclen + 1 );
	dst->len += srclen;
	return dst;
}

ByteString appendPath(ByteString path1, ByteString path2)
{
    SiDirEntry entry( path1 );
    entry += SiDirEntry( path2 );

    return entry.GetFull();
}

BOOL appendArch(ByteString &path)
{
    SiDirEntry entry( path );

#if defined (LINUX)
    entry += SiDirEntry("linux");

    if ( entry.Exists() )
    {
        path = entry.GetFull();
        return TRUE;
    }
    else
    {
        entry = SiDirEntry( path );
    }
#endif

    entry += SiDirEntry( ARCH );

    if ( !entry.Exists() )
        return FALSE;

    path = entry.GetFull();

    return TRUE;
}


int IsJavaDir ( struct dirent *dir )
{
	return JavaVendor( dir->d_name ) == jvm_unknown ? 0 : 1;
}

/* maintain a list of the java-machines we have already tested.
   This is usefull, since running 'java -version' is by far the
   most time consuming portion of GetJavaVirtualMachine().
   Unfortunately this ill-designed function plays two roles, to
   initialize itself and to perform checks */

jvm_vendor_t JavaVendor ( const char *name )
{
	if ( strncasecmp (name, "java",   sizeof("java") - 1)   == 0 )
		return jvm_jdk;
	if ( strncasecmp (name, "jdk",    sizeof("jdk") - 1)    == 0 )
		return jvm_jdk;
	if ( strncasecmp (name, "jre",    sizeof("jre") - 1)    == 0 )
		return jvm_jre;
	if ( strncasecmp (name, "j2re",    sizeof("j2re") - 1)    == 0 )
		return jvm_jre;
	if ( strncasecmp (name, "j2dk",    sizeof("j2dk") - 1)    == 0 )
		return jvm_jdk;
	if ( strncasecmp (name, "j2se",    sizeof("j2se") - 1)    == 0 )
		return jvm_jdk;
	return jvm_unknown;
}

Bool already_checked ( const char* java_executable, Bool reset )
{
	static char*  list[ 1024 ];
	static char   real_executable [ PATH_MAX ];
	static int    num_entries = 0;
	int i;

	/* init: reset counter, reuse list structure */
	if ( reset )
	{
		for ( i = 0; i < num_entries; i++ )
			free( list[i] );
		num_entries = 0;
		return True;
	}
	/* check whether java_executable is already in list
	   simple linear search, since i expect not to much vms on a system */
	realpath( java_executable, real_executable );
	for ( i = 0; i < num_entries; i++ )
	{
		if ( strncmp( real_executable, list[ i ], PATH_MAX ) == 0 )
			return True;
	}
	/* a new one, store it in the list */
	if ( num_entries < members_of(list) )
		list[ num_entries++ ] = strdup( real_executable );
	return False;
}

/* check whether two files compare equal or not */

Bool equal_files( struct stat* a, struct stat* b)
{
	return     (a->st_ino   == b->st_ino  )
			&& (a->st_size  == b->st_size )
			&& (a->st_ctime == b->st_ctime);
}

BOOL GetVersion( ByteString execstr, ByteString& version )
{
	FILE	*pFile;
	char	java_output[ 256 ];
	USHORT  nIndex;
	ByteString exec;
// fprintf(stdout, "check version for %s\n", exec.GetBuffer());
	if (! SiDirEntry(exec).Exists() )
		return FALSE;
//fprintf(stdout, "check version for %s\n", execstr.GetBuffer());
    // add "" for command lines which containing blanks
	exec = "\"";
	exec += execstr;
	exec += "\"";
//fprintf(stdout, "try to exec command %s\n", exec.GetBuffer());
	if ( exec.Search("/bin/java", exec.Len() - ByteString("/bin/java\"").Len()) != STRING_NOTFOUND )
		exec += " -version";

	exec += " 2>&1";

//fprintf(stdout, "try to exec command %s\n", exec.GetBuffer());

	if ( (pFile = popen ( exec.GetBuffer(), "r" )) == NULL )
		return FALSE;

	/* read the output from pipe and parse for a version string */

	java_output[ 0 ] = '\0';
	fgets  ( java_output, sizeof(java_output)-1, pFile );


	ByteString aOutLine( java_output );
	aOutLine.ToLowerAscii();

	if ( (nIndex = aOutLine.Search( "version" )) == STRING_NOTFOUND )
	{
		// fprintf(stderr, "can't get version for %s\n", exec.GetBuffer());
		return FALSE;
	}
	else
	{
		aOutLine.Erase(0, nIndex + ByteString("version").Len() );
		aOutLine.EraseAllChars( );		// remove all spaces
		aOutLine.EraseAllChars('\"' );	// remove all "
		aOutLine.EraseAllChars('\n' );
		aOutLine.EraseAllChars('\r' );

		version = aOutLine;
	}

	/* read what java writes (just to prevent broken pipe) */
	while ( fgets( java_output, sizeof( java_output ) - 1, pFile ) )
		;

	pclose ( pFile );

	return TRUE;
}

BOOL GetRuntimeLib( ByteString home, ByteString version, BOOL isJRE, ByteString vmType, ByteString& runtime )
{
	if ( !(home.Len() && version.Len()) )
		return FALSE;

	runtime = home;

	if ( ( !(version < "1.2") ) && !isJRE )
		runtime += "/jre/lib/";
	else
		runtime += "/lib/";

// do not find IBM JDK / JRE
// #if defined (LINUX)
// 	ByteString runTimeDir = runtime;
// 	runTimeDir+= "linux";
//
//	if (  SiDirEntry(runTimeDir).Exists() )
//		runtime += "linux";
//	else
//		runtime += ARCH;
// #else
	runtime += ARCH;
// #endif

	if ( version < "1.2" )
		runtime += "/native_threads/libjava.so";

#if defined(NO_HOTSPOT_USE_CLASSIC)
        else if (1)
#else
	else if( version < "1.3")
#endif
	{
		// test for classic directory
		ByteString classicDir = runtime;
		classicDir += "/";
		classicDir += vmType;

		if ( SiDirEntry(classicDir).Exists() )
		{
			runtime += "/";
			runtime += vmType;
			runtime += "/libjvm.so";
		}
		else
			runtime += "/libjvm.so";
	}
	else // version 1.3 and higher
	{
		runtime += "/client/libjvm.so";
	}


	return SiDirEntry(runtime).Exists();
}

BOOL GetLibPath( ByteString home, java_version version, BOOL isJRE, ByteString vmType, ByteString& libpath )
{
	BOOL retval= FALSE;
	ByteString tmplibpath;

	if ( !home.Len() )
		return FALSE;

	libpath     = "";
	tmplibpath  = home;

#if defined(NO_HOTSPOT_USE_CLASSIC)
        if (1 == 0)
#else
	if( version >= JDK13)
#endif
	{
		if( ! isJRE)
			tmplibpath= appendPath( home, "jre");
		tmplibpath= appendPath( tmplibpath, "lib");
		if( appendArch( tmplibpath))
		{
			// path: <home>/jre/lib/sparc, or <home>/lib/sparc
			libpath += tmplibpath;
			libpath += ":";
		}
		else
			return FALSE;
		ByteString clientPath( tmplibpath);
		clientPath = appendPath( clientPath, "client");
		// additional path: <home>/jre/lib/sparc/client or <home>/lib/sparc/client
		libpath += clientPath;
		libpath += ":";

		ByteString nativeThreadPath( tmplibpath);
		nativeThreadPath= appendPath( nativeThreadPath, "native_threads");
		// additional path: <home>/jre/lib/sparc/native_threads or
		// <home>/lib/sparc/native_threads
		libpath += nativeThreadPath;
		retval= TRUE;
	}

#if defined(NO_HOTSPOT_USE_CLASSIC)
    else if (1)
#else
    else if ( version == JDK12 )
#endif
    {
	    if ( ! isJRE )
	    {
	        tmplibpath = appendPath( tmplibpath, "lib" );

	        if ( appendArch(tmplibpath) )
	        {
	            libpath = tmplibpath;
	            libpath += ":";
	        }

	        home = appendPath( home, "jre" );
	    }

	    tmplibpath = home;
	    tmplibpath = appendPath(tmplibpath, "lib");

        if ( !appendArch( tmplibpath ) )
            return FALSE;

        libpath += tmplibpath;
        libpath += ":";

        home = tmplibpath;

        tmplibpath = appendPath( tmplibpath,"native_threads" );

        if ( SiDirEntry(tmplibpath).Exists() )
        {
            libpath += tmplibpath;
            libpath += ":";
        }

        tmplibpath = home;
        tmplibpath = appendPath( tmplibpath, vmType );

        if ( SiDirEntry(tmplibpath).Exists() )
        {
            libpath += tmplibpath;
            libpath += ":";
        }
		retval=TRUE;
	}
	else // seems to be a JDK version 1.1
	{
	    tmplibpath = appendPath( tmplibpath, "lib");

	    if ( !appendArch(tmplibpath) )
	        return FALSE;

	    tmplibpath = appendPath( tmplibpath, "native_threads");

	    if ( !SiDirEntry(tmplibpath).Exists() )
	        return FALSE;

	    libpath = tmplibpath;
	    libpath += ":";

	    retval= TRUE;
	}

	return retval;
}

BOOL GetClasspath( ByteString home, ByteString version, BOOL isJRE, ByteString& classpath )
{
	if ( !(home.Len() && version.Len()) )
		return FALSE;

	if ( isJRE )
	{
		//JRE 1.1.x and JRE 1.2.x
		ByteString classes = home;
		classes += "/lib/rt.jar";

		if ( !SiDirEntry(classes).Exists() )
			return FALSE;

		classpath = classes;
		classpath += ":";

		classpath += home;
		classpath += "/lib/javaplugin.jar:";

		classes = home;
		classes += "/lib/i18n.jar";

		if ( SiDirEntry(classes).Exists() )
		{
				classpath += classes;
				classpath += ":";
		}

		classpath += home;
		classpath += "/lib";
	}
	else
	if ( version < "1.2" )	// JDK 1.1.X
	{
		ByteString classes = home;
		classes += "/lib/classes.zip";

		if ( !SiDirEntry(classes).Exists() )
			return FALSE;

		classpath = classes;
		classpath += ":";
		classpath += home;
		classpath += "/lib";
	}
	else // JDK 1.2.X
	{
		ByteString classes = home;
		classes += "/jre/lib/rt.jar";

		if ( !SiDirEntry(classes).Exists() )
			return FALSE;

		classpath = classes;
		classpath += ":";

		classpath += home;
		classpath += "/jre/lib/javaplugin.jar:";

		classes = home;
		classes += "/jre/lib/i18n.jar";

		if ( SiDirEntry(classes).Exists() )
		{
				classpath += classes;
				classpath += ":";
		}

		// the additional classes for the JDK are optional, so we don't check them

		classpath += home;
		classpath += "/lib/tools.jar:";
		classpath += home;
		classpath += "/lib/dt.jar:";
		classpath += home;
		classpath += "/lib";
	}
	return TRUE;
}

/* check wether dir_name is an existing, writable directory */
BOOL GetClasspath ( JVMEntry& entry )
{
	if (entry.mName == "Java Runtime Environment" )
	{
		entry.mClasspath =	entry.mHome;
		entry.mClasspath += "/lib/rt.jar:" ;
		entry.mClasspath += entry.mHome;
		entry.mClasspath += "/lib/javaplugin.jar:" ;
		entry.mClasspath += entry.mHome;
		entry.mClasspath += "/lib/i18n.jar:";
		entry.mClasspath += entry.mHome;
		entry.mClasspath += "/lib";

		return TRUE;
	}
	else if (entry.mName == "Java Developer Toolkit" )
	{
		if (entry.mVersion < "1.2") // JDK 1.1
		{
			entry.mClasspath =	entry.mHome;
			entry.mClasspath += "/lib/classes.zip:";
			entry.mClasspath += entry.mHome;
			entry.mClasspath += "/lib/rt.jar:";
			entry.mClasspath += entry.mHome;
			entry.mClasspath += "/lib/i18n.jar:";
			entry.mClasspath += entry.mHome;
			entry.mClasspath += "/lib";
		}
		else	// JDK 1.2
		{
			entry.mClasspath =	entry.mHome;
			entry.mClasspath += "/jre/lib/rt.jar:";
			entry.mClasspath += entry.mHome;
			entry.mClasspath += "/jre/lib/javaplugin.jar:" ;
			entry.mClasspath += entry.mHome;
			entry.mClasspath += "/jre/lib/i18n.jar:";
			entry.mClasspath += entry.mHome;
			entry.mClasspath += "/lib/tools.jar";
			entry.mClasspath += entry.mHome;
			entry.mClasspath += "/lib/dt.jar";
			entry.mClasspath += entry.mHome;
			entry.mClasspath += "/lib";
		}

		return TRUE;
	}

	return FALSE;
}

USHORT GetJavaVirtualMachine( JVMEntry* pJVM )
{
	char 	 	*pJavaHome, *pShellPath;
	string_t 	*Path = NULL;

	const char  *pRootDirList[] = { "/usr/", "/usr/local/", "/", "/usr/lib/" };
	int			 nRootDir;

	char 		*pPathBuffer;
	char 		*pPathElement;

	char 		pBuffer[ 1024 ];
	USHORT		nEntries = 0;

	/* check for ${JAVA_HOME} resp. for ${JAVA_HOME}/bin/java */

	pJavaHome = getenv ( "JAVA_HOME" );
	if ( pJavaHome != NULL  )
	{
		Path = appstring( Path, pJavaHome );
		Path = appstring( Path, ":/bin:" );

		putenv ( strdup( "JAVA_HOME=") );
	}

	if ( aJavaInstProps.find(ADDITIONAL_SEARCH_PATH) != aJavaInstProps.end() )
	{
		char *pAddSearchPath = strdup( aJavaInstProps[ADDITIONAL_SEARCH_PATH].GetBuffer() );
		Path = appstring( Path, pAddSearchPath );
		Path = appstring( Path, ":" );
	}

#ifdef LINUX
	if ( getenv( "THREADS_FLAG" ) == NULL )
		putenv( strdup( "THREADS_FLAG=native"));
#endif

	/* check for an executable java, i.e. out of the ${PATH} */

	pShellPath = getenv ( "PATH" );
	if ( pShellPath == NULL )
	{
		Path = appstring( Path, ":/bin:/usr/bin:" );
	}
	else
	{
		Path = appstring( Path, pShellPath );
		Path = appstring( Path, ":/bin:" );
	}

	/* check some default directories
	   ( /usr[/local]/[jre|java|jdk]/bin ) */

	for ( nRootDir = 0; nRootDir <  members_of( pRootDirList ); nRootDir++ )
	{
		struct dirent **pJavaDirs = NULL;
		int  			nJavaDir;
		int			    nJavaDirCount = 0;

		nJavaDirCount = scanforjava(pRootDirList[ nRootDir ],
			&pJavaDirs, IsJavaDir);

		for ( nJavaDir = 0; nJavaDir < nJavaDirCount; nJavaDir++ )
		{
			Path = appstring ( Path, const_cast<char*>(pRootDirList[ nRootDir ] ));
			Path = appstring ( Path, pJavaDirs[ nJavaDir ]->d_name );
			Path = appstring ( Path, "/bin:" );

			free ( pJavaDirs[ nJavaDir ] );
		}
		free ( pJavaDirs );
	}

	/* ok, now we have a colon (:) separated directory path, with candidates.
	   validate it */

	pPathBuffer = strdup( Path->buffer );
	pPathElement = strtok (pPathBuffer, ":");
	already_checked ( NULL, True ); 		/* reset the list of visited vms */
//fprintf(stdout, "search list %s\n", pPathElement);
	ByteString aBestVersion;
	USHORT nBestVersion = 0;
	int  nBestVerifiedVersion = -1;

	while ( pPathElement != NULL)
	{
		int  i, len = strlen( pPathElement );

		BOOL bJavaFound = FALSE;

		ByteString aExec = pPathElement;
		aExec += "/java";

		bJavaFound = SiDirEntry(aExec).Exists();

		if ( !bJavaFound )
		{
			aExec = pPathElement;
			aExec += "/jre";
			bJavaFound = SiDirEntry(aExec).Exists();
		}

		if ( bJavaFound )
		{
			SiDirEntry  executable(aExec);
			executable = executable.GetPath();
			executable.ToAbs();

			ByteString aHomePath = executable.GetFull();
//fprintf(stdout, "homepath %s\n", aHomePath.GetBuffer() );
			USHORT nIndex;
			if ( (nIndex = aHomePath.Search("/bin", aHomePath.Len() - ByteString("/bin").Len() )) != STRING_NOTFOUND )
				aHomePath.Erase( nIndex );
//fprintf(stdout, "homepath %s\n", aHomePath.GetBuffer() );
			pJVM[nEntries].mHome = aHomePath;

			if ( ! already_checked( pJVM[nEntries].mHome.GetBuffer(), False ) )
			{
				JavaInstProps props;
				if ( CheckJava( pJVM[nEntries] ) )
				{
					if ( pJVM[nEntries].bIsVerified )
						if (nBestVerifiedVersion == -1)
							nBestVerifiedVersion = nEntries;
						else
							nBestVerifiedVersion =  pJVM[nEntries].mVersion > pJVM[nBestVerifiedVersion].mVersion?
													nEntries : nBestVerifiedVersion;

					nBestVersion = pJVM[nEntries].mVersion > pJVM[nBestVersion].mVersion? nEntries : nBestVersion;

				   nEntries++;
				}
			}
		}
		pPathElement = strtok (NULL, ":");
	}

	if ( nEntries )
		if (nBestVerifiedVersion != -1)
			pJVM[nBestVerifiedVersion].bIsBestVersion = TRUE;
		else
		   pJVM[nBestVersion].bIsBestVersion = TRUE;

	/* cleanup */
	already_checked ( NULL, True );
	free ( pPathBuffer );
	delstring ( Path );

	return nEntries;
}


BOOL GetInstalledVM( JVMEntry& entry, const ByteString destPath )
{
    if ( aJavaInstProps.find( PACKAGE_INSTALL_DIR ) != aJavaInstProps.end()  )
    {
    	entry.mHome	= destPath;
    	entry.mHome	+= "/";
    	entry.mHome	+= aJavaInstProps[ PACKAGE_INSTALL_DIR ];

		//fprintf( stderr, "GetInstalledVM in %s\n", entry.mHome.GetBuffer() );

        return CheckJava( entry );
    }
    return FALSE;
/*
    	ByteString javaInstVersion = aJavaInstProps[INSTALLATION_VERSION];

    	entry.mRuntimeLib = entry.mHome;
    	entry.mRuntimeLib += "/lib/";
    	entry.mRuntimeLib += ARCH;
    	entry.mRuntimeLib += "/native_threads/libjava.so";

    	ByteString libPath;
    	libPath += entry.mHome;
    	libPath += "/lib/";

    	ByteString tmpPath = libPath;
    	tmpPath += ARCH;

    	SiDirEntry tmpPath( libPath );
    	//tmpPath  += SiDirEntry( ARCH );

    	if ( (tmpPath += SiDirEntry( ARCH )).Exists() )
    	{
    		libPath += ARCH;
    		tmpPath += SiDirEntry( "native_threads" );

    		if (tmpPath.Exists()
    	}

    	if ( SiDirEntry(tmpPath).Exists() )
    	{
    		libPath = tmpPath;
    		tmpPath += "/native_threads/";
    	}

    	if ( !SiDirEntry(entry.mRuntimeLib).Exists() )
    	{
    		entry.mRuntimeLib = entry.mHome;
    		entry.mRuntimeLib += "/lib/";
    		entry.mRuntimeLib += ARCH;
    		entry.mRuntimeLib += "/native_threads/libjvm.so";

    		if ( !SiDirEntry(entry.mRuntimeLib).Exists() )
    			return FALSE;
    	}

    	ByteString exec = entry.mHome;
    	exec += "/bin/jre";

    	if ( GetVersion( exec, entry.mVersion ) )
    		if ( GetClasspath (entry) )
    			return TRUE;
*/

}

BOOL CheckJava( JVMEntry& entry )
{
	BOOL bResult = FALSE;
	BOOL bIsJRE  = FALSE;
	java_version jversion;

	if (entry.mHome.Len())
	{
		ByteString exec = entry.mHome;
		exec += "/bin/java";

		if ( GetVersion(exec, entry.mVersion ) )
		{
			jversion = extractVersion( entry.mVersion );

			if ( jversion >= JDK12 )
			{
				ByteString classes = entry.mHome;
				classes += "/lib/tools.jar";

				bIsJRE = ! SiDirEntry( classes ).Exists();
			}
			else
				bIsJRE = FALSE;
		}
		else
		{
			exec = entry.mHome;
			exec += "/bin/jre";
			if ( GetVersion(exec, entry.mVersion ) )
			{
				jversion = extractVersion( entry.mVersion );
				bIsJRE = TRUE;
			}
			else
				return FALSE;
		}

		if ( entry.mVersion < aJavaInstProps[REQUIRED_VERSION] )
			return FALSE;


		if ( aJavaInstProps.find(EXCLUDE_VERSION) != aJavaInstProps.end() )
		{
	     	     	ByteString aExVersions = aJavaInstProps[EXCLUDE_VERSION];
			xub_StrLen nCount = aExVersions.GetTokenCount(' ');

			for (xub_StrLen i=0; i<nCount; i++)
				if (entry.mVersion == aExVersions.GetToken(i, ' ') )
					return FALSE;
		}

		if ( bIsJRE )
		{
			entry.mName = "Java Runtime Environment";
			entry.mEnvType = JRE_TYPE;
		}
		else
		{
		   entry.mName = "Java Development Kit";
		   entry.mEnvType = JDK_TYPE;
		}

		entry.mJVMType = "classic";

		bResult = GetRuntimeLib( entry.mHome, entry.mVersion, bIsJRE, entry.mJVMType, entry.mRuntimeLib ) &&
				  GetClasspath( entry.mHome, entry.mVersion, bIsJRE, entry.mClasspath );

		if ( bResult )
			GetLibPath( entry.mHome, jversion, bIsJRE, entry.mJVMType, entry.mLibPath );

		entry.bIsVerified = aJavaInstProps[VERIFIED_VERSION].Search(entry.mVersion) != STRING_NOTFOUND;
	}

	return bResult;
}



