/*************************************************************************
 *
 *  $RCSfile: preg4msdoc.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: tra $ $Date: 2001/11/23 15:05:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _HEADBAR_HXX //autogen
#include <svtools/headbar.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _L2TXTENC_HXX
#include <tools/l2txtenc.hxx>
#endif

#include "maindlg.hxx"
#include "environ.hxx"
#include "decltor.hxx"
#include "script.hxx"
#include "sibasic.hxx"
#include "sihelp.hxx"

#include "preg4msdoc.hxx"
#include "preg4msdoc.hrc"

#include "reg4msdocmaindlg.hxx"

//---------------------------------------
// defines
//---------------------------------------

inline Reg4MsDocMainDialog* PageReg4MSDoc::GetDlg()
{
    return ((Reg4MsDocMainDialog*)GetAgentDlg());
}

//#define GETDLG() ((Reg4MsDocMainDialog*)GetAgentDlg())

//---------------------------------------
//
//---------------------------------------

PageReg4MSDoc::PageReg4MSDoc( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	m_aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),	
    m_aFLFileTypes( this, ResId( FL_FILETYPES, rResId.GetResMgr()) ),
    m_aFLDefHtmlEdt( this, ResId( FL_DEFAULTHTMLEDT, rResId.GetResMgr()) ),
	m_aCBReg4MsWord	( this, ResId(CB_REG4MSWORD, rResId.GetResMgr()) ),
	m_aCBReg4MsExcel	( this, ResId(CB_REG4MSEXCEL, rResId.GetResMgr()) ),
    m_aCBReg4MsPowerPoint( this, ResId(CB_REG4MSPOWERPOINT, rResId.GetResMgr()) ),
    m_aCBReg4DefHtmlEdt	( this, ResId(CB_REG4DEFAULTHTMLEDT, rResId.GetResMgr()) )
{
	String aTitle( ResId( STR_TITLE, rResId.GetResMgr() ) );
	pParent->SetTitleStr( aTitle );
	FreeResource();

    // set the defaults

    m_aCBReg4MsWord.Check( GetDlg()->Reg4MsWord() );
    m_aCBReg4MsWord.Enable( GetDlg()->EnableReg4MsWord() );
        
    m_aCBReg4MsExcel.Check( GetDlg()->Reg4MsExcel() );
    m_aCBReg4MsExcel.Enable( GetDlg()->Reg4MsExcel() );

    m_aCBReg4MsPowerPoint.Check( GetDlg()->Reg4MsPowerPoint() );
    m_aCBReg4MsPowerPoint.Enable( GetDlg()->Reg4MsPowerPoint() );

    m_aCBReg4DefHtmlEdt.Check( GetDlg()->Reg4DefHtmlEdt( ) );
    m_aCBReg4DefHtmlEdt.Enable( GetDlg()->Reg4DefHtmlEdt() );

    String aBtnTxt( ResId( STR_OK_BUTTON, rResId.GetResMgr() ) );
    GetDlg()->SetNextText( aBtnTxt );    
}

//---------------------------------------
//
//---------------------------------------

SvAgentPage* PageReg4MSDoc::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageReg4MSDoc( pParent, rResId );
}

//---------------------------------------
//
//---------------------------------------

USHORT PageReg4MSDoc::GetReturnVal()
{
    USHORT nRet = 0;
    
	if ( m_aCBReg4MsWord.IsChecked() )
        nRet |= 1;
    
    if ( m_aCBReg4MsExcel.IsChecked() )
        nRet |= 2;

    if ( m_aCBReg4MsPowerPoint.IsChecked() )
        nRet |= 4;

    if ( m_aCBReg4DefHtmlEdt.IsChecked() )
        nRet |= 8;

    return nRet;
}



