/*************************************************************************
 *
 *  $RCSfile: registry.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: tra $ $Date: 2001/11/22 17:07:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _REGISTRY_HXX_
#include "registry.hxx"
#endif

#include "registryw9x.hxx"
#include "registrywnt.hxx"

//---------------------------------------
//
//---------------------------------------

using rtl::OUString;

//---------------------------------------
// helper function
//---------------------------------------

bool IsWinNT( )
{
    OSVERSIONINFOA osverinfo;

    ZeroMemory(&osverinfo, sizeof(osverinfo));

    osverinfo.dwOSVersionInfoSize = sizeof(osverinfo);

    BOOL bRet = GetVersionExA(&osverinfo);

    OSL_ASSERT( bRet );

    return (osverinfo.dwPlatformId == VER_PLATFORM_WIN32_NT);
}

//---------------------------------------
// factory method
//---------------------------------------

CRegistryKey* CRegistryKey::CreateInstance( HKEY hRootKey, const OUString& aSubKeyName, REGSAM samDesired )
{
    CRegistryKey* pRegKey;

    if ( IsWinNT() )
        pRegKey = new CRegistryKeyWNt( hRootKey, aSubKeyName, samDesired );
    else
        pRegKey = new CRegistryKeyW9x( hRootKey, aSubKeyName, samDesired );

    return pRegKey;
}

//---------------------------------------
// 
//---------------------------------------

CRegistryKey* CRegistryKey::Create( HKEY hRootKey, const OUString& aSubKeyName, REGSAM samDesired, LONG* pErrorCode )
{    
    CRegistryKey* pRegKey = CreateInstance( hRootKey, aSubKeyName, samDesired );

    LONG rc = ERROR_OUTOFMEMORY;

    if ( pRegKey )
        rc = pRegKey->Create();

    if ( pErrorCode )
        *pErrorCode = rc;

    return pRegKey;
}

//---------------------------------------
// 
//---------------------------------------

CRegistryKey* CRegistryKey::Open( HKEY hRootKey, const OUString& aSubKeyName, REGSAM samDesired, LONG* pErrorCode )
{    
    CRegistryKey* pRegKey = CreateInstance( hRootKey, aSubKeyName, samDesired );
    
    LONG rc = ERROR_OUTOFMEMORY;

    if ( pRegKey )
        rc = pRegKey->Open();

    if ( pErrorCode )
        *pErrorCode = rc;

    return pRegKey;
}

//---------------------------------------
// 
//---------------------------------------

CRegistryKey::CRegistryKey( HKEY hRootKey, const rtl::OUString& aSubKeyName, REGSAM samDesired ) :
    m_hRootKey( hRootKey ),
    m_hSubKey( 0 ),
    m_SubKeyName( aSubKeyName ),
    m_samDesired( samDesired )
{
    OSL_ASSERT( m_hRootKey );    
}

//---------------------------------------
// 
//---------------------------------------

CRegistryKey::~CRegistryKey()
{
    if ( IsOpen() )
        Close();
}

//---------------------------------------
// 
//---------------------------------------

LONG CRegistryKey::Close()
{
    OSL_PRECOND( IsOpen(), "key not open" );

    LONG rc = RegCloseKey( m_hSubKey );
    
    m_hSubKey = 0;

    return rc;
}

//---------------------------------------
// 
//---------------------------------------

bool CRegistryKey::IsOpen() const
{
    return (0 != m_hSubKey);
}

//---------------------------------------
// 
//---------------------------------------

CRegistryKey::operator HKEY() const
{
    return GetHKEY();
}

//---------------------------------------
// 
//---------------------------------------

HKEY CRegistryKey::GetHKEY() const
{
    return m_hSubKey;
}