/*************************************************************************
 *
 *  $RCSfile: registryw9x.cxx,v $
 *
 *  $Revision: 1.1.2.3 $
 *
 *  last change: $Author: mh $ $Date: 2002/10/31 20:47:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//---------------------------------------
//
//---------------------------------------

#include "registryw9x.hxx"
 
#ifndef _RTL_USTRING_HXX
#include <rtl/ustring.hxx>
#endif

#include <osl/thread.h>
#include <malloc.h>

//---------------------------------------
//
//---------------------------------------

using rtl::OUString;
using rtl::OString;
using rtl::OUStringToOString;
using rtl::OStringToOUString;

//---------------------------------------
// 
//---------------------------------------

const sal_Int32 MAX_TMP_BUFF_SIZE = 1024;
const int MAX_REGKEY_LENGTH_WIN9X = 16300;

//---------------------------------------
// 
//---------------------------------------

bool IsConvertableToAnsi(const OUString& aString)
{    
    char* pBuff = reinterpret_cast<char*>(
		_alloca(MAX_REGKEY_LENGTH_WIN9X));

	BOOL bUsedDefChar = FALSE;

	if (aString.getLength() > 0)
	{
		int rc = WideCharToMultiByte(
			CP_ACP,
			WC_COMPOSITECHECK | WC_DEFAULTCHAR,
			aString.getStr(),
			aString.getLength(),
			pBuff,
			MAX_REGKEY_LENGTH_WIN9X,
			NULL,
			&bUsedDefChar);        

        OSL_POSTCOND(rc, "WideCharToMultiByte failed");
	}

    return !bUsedDefChar;
}

//---------------------------------------
// 
//---------------------------------------

CRegistryKeyW9x::CRegistryKeyW9x( HKEY hRootKey, const OUString& aSubKeyName, REGSAM samDesired ) :
    CRegistryKey( hRootKey, aSubKeyName, samDesired )
{
}

//---------------------------------------
// 
//---------------------------------------

LONG CRegistryKeyW9x::Create( )
{
    OSL_PRECOND( m_hRootKey, "invalid root key" );

    DWORD dwDisp;

    OString aSubKeyName = OUStringToOString( m_SubKeyName, osl_getThreadTextEncoding() );

    LONG rc = RegCreateKeyExA(
        m_hRootKey,
        aSubKeyName.getStr(),
        0,
        "",
        REG_OPTION_NON_VOLATILE,
        m_samDesired,
        NULL,
        &m_hSubKey,
        &dwDisp );

    return rc;
}

//---------------------------------------
// 
//---------------------------------------

LONG CRegistryKeyW9x::Open( )
{
    OSL_PRECOND( m_hRootKey, "invalid root key" );
    OSL_PRECOND( !IsOpen(), "key already open" );
    
    LONG rc;
    
    OString aSubKeyName = OUStringToOString( m_SubKeyName, osl_getThreadTextEncoding() );

    if ( !IsOpen() )
        rc = RegOpenKeyExA( 
            m_hRootKey,
            aSubKeyName.getStr(),
            0,
            m_samDesired,
            &m_hSubKey );

    return rc;
}

//---------------------------------------
// RegDeleteKey works recursively under 
// Win9x
//---------------------------------------

LONG CRegistryKeyW9x::Delete()
{
	if (IsOpen())
		Close();

    OString aSubKeyName = OUStringToOString(m_SubKeyName, osl_getThreadTextEncoding());  
	LONG rc = RegDeleteKeyA(m_hRootKey, aSubKeyName.getStr());
	m_hSubKey = 0;
	
	return rc;
}

//---------------------------------------
// 
//---------------------------------------

LONG CRegistryKeyW9x::SetValue( const OUString& aValueName, const OUString& aValue )
{
    OSL_PRECOND( IsOpen(), "key not open or doesn't exist" );

    OString aValNameA = OUStringToOString( aValueName, osl_getThreadTextEncoding() );
    OString aValA     = OUStringToOString( aValue, osl_getThreadTextEncoding() );

    LONG rc = RegSetValueExA(
        m_hSubKey,
        aValNameA.getStr(),
        0,
        REG_SZ,
        (BYTE*)aValA.getStr(),
        aValA.getLength() + 1 );

    return rc;
}

//---------------------------------------
// 
//---------------------------------------

LONG CRegistryKeyW9x::SetValue( const OUString& aValueName, const OUString& aValue, const OUString& aFallbackValue )
{
    return IsConvertableToAnsi( aValue ) ? SetValue( aValueName, aValue ) : SetValue( aValueName, aFallbackValue );
}

//---------------------------------------
// 
//---------------------------------------

LONG CRegistryKeyW9x::GetValue( const rtl::OUString& aValueName, rtl::OUString& aValue )
{
    OSL_PRECOND( IsOpen(), "key not open or doesn't exist" );

    char* pBuff = reinterpret_cast<char*>(_alloca(MAX_TMP_BUFF_SIZE));
    DWORD dwSizeData = MAX_TMP_BUFF_SIZE;
    
    DWORD dwType;

    OString aValNameA = OUStringToOString( aValueName, osl_getThreadTextEncoding() );

    LONG rc = RegQueryValueExA(
        m_hSubKey,
        aValNameA.getStr(),
        0,
        &dwType,
        (BYTE*)pBuff,
        &dwSizeData );

    if (ERROR_SUCCESS == rc)
    {
        if (dwSizeData > 0)
        {
            OString aVal;
            if (0 == pBuff[dwSizeData-1])
                aVal = OString(pBuff);
            else
                aVal = OString(pBuff, dwSizeData);
            
            aValue = OStringToOUString(aVal, osl_getThreadTextEncoding());
        }
        else
        {
            aValue = OUString();
        }
    }

    return rc;
}

//---------------------------------------
// 
//---------------------------------------

LONG CRegistryKeyW9x::SetValue( const OUString& aValueName, const sal_Int32 aValue )
{
    OSL_PRECOND( IsOpen(), "key not open or doesn't exist" );

    OString aValNameA = OUStringToOString( aValueName, osl_getThreadTextEncoding() );

    LONG rc = RegSetValueExA(
        m_hSubKey,
        aValNameA.getStr(),
        0,
        REG_DWORD,
        (BYTE*)&aValue,
        sizeof(sal_Int32) );

    return rc;
}

//---------------------------------------
// 
//---------------------------------------

LONG CRegistryKeyW9x::GetValue( const OUString& aValueName, int* pValue )
{
    OSL_PRECOND( pValue, "invalid parameter" );
    OSL_PRECOND( IsOpen(), "key not open or doesn't exist" );

    DWORD dwType;
    DWORD dwDataSize = sizeof(sal_Int32);

    OString aValNameA = OUStringToOString( aValueName, osl_getThreadTextEncoding() );

    LONG rc = RegQueryValueExA(
        m_hSubKey,
        aValNameA.getStr(),
        0,
        &dwType,
        (BYTE*)pValue,
        &dwDataSize );

    return rc;
}

//---------------------------------------
// 
//---------------------------------------

LONG CRegistryKeyW9x::DeleteValue( const OUString& aValueName )
{
    OSL_PRECOND( IsOpen(), "key not open or doesn't exist" );
    
    OString aValNameA = OUStringToOString( aValueName, osl_getThreadTextEncoding() );

    LONG rc = RegDeleteValueA(
        m_hSubKey,
        aValNameA.getStr() );

    if ( ERROR_SUCCESS == rc )
        m_hSubKey = 0;

    return rc;
}
