/*************************************************************************
 *
 *  $RCSfile: installer.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: dv $ $Date: 2001/09/24 15:16:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <com/sun/star/uno/Reference.h>
#include <com/sun/star/lang/XComponent.hpp>

#include <cppuhelper/servicefactory.hxx>
#include <cppuhelper/bootstrap.hxx>

#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HPP_
#include <com/sun/star/registry/XSimpleRegistry.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XCHANGESBATCH_HPP_
#include <com/sun/star/util/XChangesBatch.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMEREPLACE_HPP_
#include <com/sun/star/container/XNameReplace.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif

#include <comphelper/regpathhelper.hxx>

#ifndef _UNOTOOLS_PROCESSFACTORY_HXX
#include <comphelper/processfactory.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _SV_CONFIG_HXX
#include <tools/config.hxx>
#endif
#include <vcl/svapp.hxx>

#include <svtools/solar.hrc>

#include "decltor.hxx"
#include "action.hxx"
#include "agenda.hxx"
#include "environ.hxx"
#include "fields.hxx"
#include "installer.hxx"
#include "sifsys.hxx"
#include "sihelp.hxx"

#include "progressdlg.hxx"

using namespace osl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::registry;
using namespace ::cppu;

#define DEFINE_CONST_UNICODE(CONSTASCII)        UniString(RTL_CONSTASCII_USTRINGPARAM(CONSTASCII##))

char const INSTALLER_INITFILENAME[]				= "initialize.ini";
char const INSTALLER_SECTION_UNOCOMPONENTS[]	= "UnoComponents";
char const INSTALLER_SECTION_CONFIGURATION[]	= "Configuration";

//////////////////////////////////////////////////////////////////////////////

Installer::Installer()
{
}

Installer::~Installer()
{
}

//////////////////////////////////////////////////////////////////////////////

::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > createApplicationServiceManager()
{
	try
	{
        ::rtl::OUString localRegistry = ::comphelper::getPathToUserRegistry();
        ::rtl::OUString systemRegistry = ::comphelper::getPathToSystemRegistry();
        
        Reference< XSimpleRegistry > xLocalRegistry( ::cppu::createSimpleRegistry() );
        Reference< XSimpleRegistry > xSystemRegistry( ::cppu::createSimpleRegistry() );
        if ( xLocalRegistry.is() && (localRegistry.getLength() > 0) )
        {
            try
            {
                xLocalRegistry->open( localRegistry, sal_False, sal_True);
            }
            catch ( InvalidRegistryException& )
            {
            }
            
            if ( !xLocalRegistry->isValid() )
                xLocalRegistry->open(localRegistry, sal_True, sal_True);
        }
        
        if ( xSystemRegistry.is() && (systemRegistry.getLength() > 0) )
            xSystemRegistry->open( systemRegistry, sal_True, sal_False);
        
        if ( (xLocalRegistry.is() && xLocalRegistry->isValid()) &&
             (xSystemRegistry.is() && xSystemRegistry->isValid()) )
        {
            Reference < XSimpleRegistry > xReg( ::cppu::createNestedRegistry() );
            Sequence< Any > seqAnys(2);
            seqAnys[0] <<= xLocalRegistry ;
            seqAnys[1] <<= xSystemRegistry ;
            Reference< XInitialization > xInit( xReg, UNO_QUERY );
            xInit->initialize( seqAnys );
            
            Reference< XComponentContext > xContext( ::cppu::bootstrap_InitialComponentContext( xReg ) );
            return Reference< XMultiServiceFactory >( xContext->getServiceManager(), UNO_QUERY );
        }
	}
	catch( ::com::sun::star::uno::Exception& )
	{
	}
    
	return ::cppu::createServiceFactory();
}

BOOL Installer::InitializeInstallation( const UniString& rAppFilename )
{
	UniString aAppPath( rAppFilename );
	rtl::OUString aFinishInstallation;
	FileBase::getFileURLFromSystemPath( aAppPath, aFinishInstallation );
	aAppPath = UniString( aFinishInstallation );

	xub_StrLen nPos = aAppPath.SearchBackward( '/' );
	aAppPath.Erase( nPos );
	aAppPath += '/';
	aAppPath += DEFINE_CONST_UNICODE( INSTALLER_INITFILENAME );

	DirectoryItem aDI;
	if( DirectoryItem::get(aAppPath, aDI) == osl_File_E_None )
	{
		ByteString aMgrName( "set" );
		aMgrName += ByteString::CreateFromInt32( SOLARUPD );
		ResMgr* pResMgr = ResMgr::CreateResMgr(aMgrName.GetBuffer());
		Resource::SetResManager( pResMgr );

		ProgressDialog* pDlg = new ProgressDialog();
		pDlg->Activate( ProgressDialog::ACTIVATE_REGISTER );
		pDlg->Show();
		pDlg->Update();
		pDlg->Flush();
        
        // try to dispose component context
        Reference< beans::XPropertySet > xProps( ::comphelper::getProcessServiceFactory(), UNO_QUERY );
        if (xProps.is())
        {
            try
            {
                Reference< lang::XComponent > xComp;
                if (xProps->getPropertyValue( OUString( RTL_CONSTASCII_USTRINGPARAM("DefaultContext") ) ) >>= xComp)
                {
                    xComp->dispose();
                }
            }
            catch (beans::UnknownPropertyException &)
            {
            }
        }
        
		/////////////////////////////////////////////////////
		//	INSTALLER_SECTION_UNOCOMPONENTS
		Config aCfg( aAppPath );
		aCfg.SetGroup( ByteString(INSTALLER_SECTION_UNOCOMPONENTS) );

		for( USHORT i = 0; i < aCfg.GetKeyCount(); ++i )
		{
			Application::Reschedule();
			ByteString aFilename( aCfg.GetKeyName(i) );
			BOOL bRegister = aCfg.ReadKey(i) == "1" ? TRUE : FALSE;
			SiHelp::RegisterUnoComponent( aFilename, bRegister );
		}
		SiHelp::DisposeUNOImpl();

		/////////////////////////////////////////////////////
		//	CONFIGURATION
		pDlg->Activate( ProgressDialog::ACTIVATE_CONFIG );

		SiEnvironment aEnv;
		aCfg.SetGroup( ByteString(INSTALLER_SECTION_CONFIGURATION) );
		if( aCfg.GetKeyCount() )
		{
			SiDirEntry aLogfile(".");
			aLogfile += ByteString("setup.log");
			aLogfile.ToAbs();

			SiAgenda aAgenda;
			aAgenda.OpenLogfile( aLogfile.GetFull() );

			SiDirEntry aApplicat( "." );
			aApplicat += ByteString("applicat.rdb");
			aApplicat.ToAbs();

			SiDirEntry aInstPath( "." );
			aInstPath.ToAbs();
			aInstPath = aInstPath[1];

			Reference< XMultiServiceFactory > xORB = createRegistryServiceFactory(
													 aApplicat.GetFullUni(), ::rtl::OUString() );

			if( xORB.is() )
			{
				Reference< XMultiServiceFactory > xCfgProvider;
				try
				{
		   			Sequence< Any > aCPArgs(3);
					Any aAny;

					aAny <<= ::rtl::OUString::createFromAscii( "local" );
					PropertyValue aPropertyUser( ::rtl::OUString::createFromAscii("servertype"), -1, aAny, PropertyState_DIRECT_VALUE );
					aCPArgs[0] <<= aPropertyUser;

					SiDirEntry aRootPath( aInstPath );
					aRootPath += ByteString( "user" );
					aRootPath += ByteString( "config" );
					aRootPath += ByteString( "registry" );
					aRootPath.ToAbs();

					aAny <<= ::rtl::OUString::createFromAscii( aRootPath.GetFull().GetBuffer() );
					aPropertyUser = PropertyValue( ::rtl::OUString::createFromAscii( "updatepath" ), -1, aAny, PropertyState_DIRECT_VALUE );
					aCPArgs[1] <<= aPropertyUser;

					aRootPath =  aInstPath;
					aRootPath += ByteString( "share" );
					aRootPath += ByteString( "config" );
					aRootPath += ByteString( "registry" );
					aRootPath.ToAbs();

					aAny <<= ::rtl::OUString::createFromAscii( aRootPath.GetFull().GetBuffer() );
					aPropertyUser = PropertyValue( ::rtl::OUString::createFromAscii( "sourcepath" ), -1, aAny, PropertyState_DIRECT_VALUE );
					aCPArgs[2] <<= aPropertyUser;

					xCfgProvider =	Reference< XMultiServiceFactory >(
									Reference< XMultiServiceFactory >(
								   		xORB->createInstanceWithArguments( ::rtl::OUString::createFromAscii("com.sun.star.configuration.ConfigurationProvider"),
										aCPArgs), UNO_QUERY ) );
				}
				catch(RuntimeException& e) {
					aAgenda.GetLogfile().Success(FALSE) << ByteString(UniString(e.Message), osl_getThreadTextEncoding());
					return TRUE;
				}
				catch(Exception& e) {
					aAgenda.GetLogfile().Success(FALSE) << ByteString(UniString(e.Message), osl_getThreadTextEncoding());
					return TRUE;
				}

				if( xCfgProvider.is() )
				{
					for( i = 0; i < aCfg.GetKeyCount(); ++i )
					{
						Application::Reschedule();

						ByteString aReadKey( aCfg.GetKeyName(i) );
						ByteString aReadValue( aCfg.ReadKey(i) );

						SiConfigurationItem aCfgItem( SiIdentifier("NULL"), NULL );

						aCfgItem.SetProperty( PROPERTY_PATH, aReadKey.GetToken(0, '|') );
						aCfgItem.SetProperty( PROPERTY_KEY, aReadKey.GetToken(1, '|') );
						aCfgItem.SetProperty( PROPERTY_VALUE, aReadValue );

						ByteString aType( aReadKey.GetToken(2, '|') );
						if( aType == "BOOLEAN" )
							aCfgItem.SetProperty( PROPERTY_FLAGS, VALUE_BOOLEAN );
						else if( aType == "NUMERIC" )
							aCfgItem.SetProperty( PROPERTY_FLAGS, VALUE_NUMERIC );
						else if( aType == "STRING" )
							aCfgItem.SetProperty( PROPERTY_FLAGS, VALUE_STRING );
						else if( aType == "STRINGLIST" )
							aCfgItem.SetProperty( PROPERTY_FLAGS, VALUE_STRINGLIST );
						else if( aType == "BINARY" )
							aCfgItem.SetProperty( PROPERTY_FLAGS, VALUE_BINARY );

						SiConfigurationAction aAction( &aAgenda, PIA_CREATE, &aCfgItem );
						aAction.setUNO( xORB, xCfgProvider );
						aAction.Execute( aEnv );
					}
				}

				Reference< XComponent > xComponent ( xORB, UNO_QUERY );
				if( xComponent.is() ) xComponent->dispose();
			}
		}

		Resource::SetResManager( 0 );
		delete pDlg;
		delete pResMgr;

 		::comphelper::setProcessServiceFactory( createApplicationServiceManager() );

		SiDirEntry a(aAppPath);
		a.Kill();
		return TRUE;
	}
	return FALSE;
}

// C helper function to load Installer::InitializeInstallation code only on demand.
// We can now create application executable without linking with setup2/basic/java/svtools!!!!
extern "C" void InstallerInitializeInstallation( const sal_Unicode* pAppFileName )
{
	Installer	aInstaller;
	UniString	aAppFileName( pAppFileName );
	aInstaller.InitializeInstallation( aAppFileName );
}
