/*************************************************************************
 *
 *  $RCSfile: interface.cxx,v $
 *
 *  $Revision: 1.40.4.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 10:05:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _SV_CONFIG_HXX
#include <tools/config.hxx>
#endif

#include "agenda.hxx"
#include "webaction.hxx"
#include "decltor.hxx"
#include "script.hxx"
#include "environ.hxx"
#include "sistream.hxx"

#include "tools/l2txtenc.hxx"

#include <com/sun/star/setup/OSType.hpp>
#include <com/sun/star/setup/ModuleInfo.hpp>
#include <com/sun/star/setup/MirrorEntry.hpp>

#include "service.hxx"
#include "sihelp.hxx"

//=============================================================================
//	Configuration
//=============================================================================
CachedConfiguration::CachedConfiguration()
{
	pCS = NULL;
}

CachedConfiguration::~CachedConfiguration()
{
	if( pCS ) delete pCS;
	for( USHORT i = 0; i < aMirrorList.Count(); ++i )
		delete aMirrorList.GetObject(i);
	aMirrorList.Clear();
}

void _outDateTime( const DateTime& dt )
{
	fprintf( stdout, "%d:%02d:%02d %02d/%02d/%d",
		dt.GetHour(), dt.GetMin(), dt.GetSec(),
		dt.GetMonth(), dt.GetDay(), dt.GetYear() );
}

ByteString _getExtension4OS( OSType eType )
{
	ByteString aExtension;

	if( eType == OSType_WIN )
		aExtension = "WIN";
	else if( eType == OSType_OS2 )
		aExtension = "OS2";
	else if( eType == OSType_MAC )
		aExtension = "MAC";
	else if( eType == OSType_UNIX_SOLS )
		aExtension = "UNIX_SOLS";
	else if( eType == OSType_UNIX_SOLI )
		aExtension = "UNIX_SOLI";
	else if( eType == OSType_UNIX_SOLSG )
		aExtension = "UNIX_SOLSG";
	else if( eType == OSType_UNIX_SOLIG )
		aExtension = "UNIX_SOLIG";
	else if( eType == OSType_UNIX_LINUX )
		aExtension = "UNIX_LINUX";
	else if( eType == OSType_UNIX_HP )
		aExtension = "UNIX_HP";
	else if( eType == OSType_UNIX_SCO )
		aExtension = "UNIX_SCO";
	return aExtension;
}

ByteString _getETCPath( const ByteString& rAppPath )
{
	SiDirEntry aETCPath( rAppPath );
	aETCPath += ByteString("..");
	aETCPath += ByteString("share");
	aETCPath += ByteString("etc");
	aETCPath.ToAbs();

	if( !aETCPath.Exists() ) return ByteString(rAppPath);

	SiDirEntry aConfigRC( aETCPath );
	aConfigRC += ByteString("configrc");

	if( aConfigRC.Exists() )
	{
		Config aCfg( aConfigRC.GetFullUni() );
		ByteString a = aCfg.ReadKey( "SharedPath", "" );
		if( a.Len() ) return a;
	}

	return aETCPath.GetFull();
}

void SAL_CALL SetupServiceImpl::readOSConfiguration( OSType eType )
{
	ByteString aFilename( "setupserver_" );
	aFilename += _getExtension4OS( eType );
	aFilename += ".ini";

	SiDirEntry aEntry( _getETCPath(m_aAppPath) );
	aEntry += aFilename;

	if( !aEntry.Exists() ) return;

	Config aCfg( aEntry.GetFullUni() );
	FileStat aFileStat( aEntry );
	DateTime aDt( aFileStat.DateModified(), aFileStat.TimeModified() );

	fprintf( stdout, "read configuration %s\n", _getExtension4OS(eType).GetBuffer() );
	fprintf( stdout, "  last modified : " );
	_outDateTime( aDt );
	fprintf( stdout, "\n  entries       : " );

	USHORT xx;
	for( xx = 0; xx < aCfg.GetGroupCount(); ++xx )
	{
		ByteString aGroupname = aCfg.GetGroupName(xx);

		ByteString aProductKey	= aGroupname.GetToken( 0, '-' );
		ByteString aBuildnumber	= aGroupname.GetToken( 1, '-' );
		ByteString aMinor		= aGroupname.GetToken( 2, '-' );
		ByteString aLanguages	= aGroupname.GetToken( 3, '-' );

		CachedConfiguration* pCCfg = new CachedConfiguration();

		pCCfg->aIdentifier.eOSType			= eType;
		pCCfg->aIdentifier.strProductKey	= UniString(aProductKey, osl_getThreadTextEncoding());
 		pCCfg->aIdentifier.nBuildnumber		= aBuildnumber.ToInt32();
		pCCfg->aIdentifier.strInstLanguages	= UniString(aLanguages, osl_getThreadTextEncoding());
		pCCfg->aIdentifier.strInstMinor		= UniString(aMinor, osl_getThreadTextEncoding());
		pCCfg->aLastValidation				= aDt;

		aCfg.SetGroup( aGroupname );

		for( USHORT i = 0; i < aCfg.GetKeyCount(); ++i )
		{
			ByteString aKey = aCfg.GetKeyName(i);
			if( aKey.CompareIgnoreCaseToAscii("script") == COMPARE_EQUAL )
			{
				pCCfg->aScriptLocation = aCfg.ReadKey(i);
			}
			else if( aKey.CompareIgnoreCaseToAscii("native") == COMPARE_EQUAL )
			{
				pCCfg->aNativeLocation = aCfg.ReadKey(i);
			}
			else if( aKey.CompareIgnoreCaseToAscii("mirror") == COMPARE_EQUAL )
			{
				pCCfg->aMirrorList.Insert( new UniString(aCfg.ReadKey(i), osl_getThreadTextEncoding()), LIST_APPEND );
			}
			else if( aKey.CompareIgnoreCaseToAscii("hiddenmodules") == COMPARE_EQUAL )
			{
				pCCfg->aHiddenModules = aCfg.ReadKey(i);
			}
			else if( aKey.CompareIgnoreCaseToAscii("visiblemodules") == COMPARE_EQUAL )
			{
				pCCfg->aVisibleModules = aCfg.ReadKey(i);
			}
		}
		m_ConfigCache.Insert( pCCfg, LIST_APPEND );
	}

	fprintf( stdout, "%d entrys\n", xx );
}

void SAL_CALL SetupServiceImpl::readAllOSConfiguration()
{
	fprintf( stdout, "\n\n" );
	readOSConfiguration( OSType_WIN );
	readOSConfiguration( OSType_OS2 );
	readOSConfiguration( OSType_MAC );
	readOSConfiguration( OSType_UNIX_SOLS );
	readOSConfiguration( OSType_UNIX_SOLI );
	readOSConfiguration( OSType_UNIX_SOLSG );
	readOSConfiguration( OSType_UNIX_SOLIG );
	readOSConfiguration( OSType_UNIX_LINUX );
	readOSConfiguration( OSType_UNIX_HP );
	readOSConfiguration( OSType_UNIX_SCO );
	fprintf( stdout, "\n" );
}

//=============================================================================
//	getCachedScript
//=============================================================================
BOOL _isEqual( const VersionIdentifier& aIdent1, const VersionIdentifier& aIdent2 )
{
	if( aIdent1.eOSType				== aIdent2.eOSType &&
		aIdent1.nBuildnumber		== aIdent2.nBuildnumber &&
		aIdent1.strProductKey		== aIdent2.strProductKey &&
		aIdent1.strInstLanguages	== aIdent2.strInstLanguages &&
		aIdent1.strInstMinor		== aIdent2.strInstMinor )
		return TRUE;
	return FALSE;
}

void _CompileScript( CachedConfiguration* pCache )
{
	SiAnsiFileStream aStream;
	aStream.Open( UniString(pCache->aScriptLocation, osl_getThreadTextEncoding()), STREAM_READ );
	if( aStream.IsOpen() )
	{
		SiCompiledScript* cs = new SiCompiledScript;

		SiCompilerRef xCompiler = new SiCompiler( aStream, pCache->aIdentifier.eOSType, TRUE );
		xCompiler->NoApplication();
		xCompiler->CompileTo( cs );

		pCache->pCS = cs;

		if( pCache->aHiddenModules.Len() )
		{
			USHORT nDelimTok = 0;
			USHORT nTokCount = pCache->aHiddenModules.GetTokenCount(',');
			for( USHORT x = 0; x < nTokCount; ++x )
			{
				ByteString aModID = pCache->aHiddenModules.GetToken(0, ',', nDelimTok);
				SiModule* pMod = SiHelp::FindModuleByID( pCache->pCS->GetRootModule(), aModID );
				if( pMod ) pMod->SetHiddenRecursive( TRUE );
			}
		}

		if( pCache->aVisibleModules.Len() )
		{
			USHORT nDelimTok = 0;
			USHORT nTokCount = pCache->aVisibleModules.GetTokenCount(',');
			for( USHORT x = 0; x < nTokCount; ++x )
			{
				ByteString aModID = pCache->aVisibleModules.GetToken(0, ',', nDelimTok);
				SiModule* pMod = SiHelp::FindModuleByID( pCache->pCS->GetRootModule(), aModID );
				if( pMod ) pMod->SetHiddenRecursive( FALSE );
			}
		}
	}
}

CachedConfiguration* SAL_CALL SetupServiceImpl::getCachedConfig( const VersionIdentifier& aVerIdentifier )
{
	CachedConfiguration* pReturn = NULL;

	for( USHORT i = 0; i < m_ConfigCache.Count(); ++i )
	{
		CachedConfiguration* pCCfg = m_ConfigCache.GetObject(i);
		if( _isEqual(aVerIdentifier, pCCfg->aIdentifier) )
		{
			pReturn = pCCfg;
			break;
		}
	}

	if( !pReturn &&
		!aVerIdentifier.nBuildnumber &&
		!UniString(aVerIdentifier.strInstLanguages).Len() &&
		!UniString(aVerIdentifier.strInstMinor).Len() )
	{
		long nBestFnd = 0;
		for( USHORT i = 0; i < m_ConfigCache.Count(); ++i )
		{
			CachedConfiguration* pCCfg = m_ConfigCache.GetObject(i);
			if( pCCfg->aIdentifier.strProductKey == aVerIdentifier.strProductKey &&
				pCCfg->aIdentifier.eOSType == aVerIdentifier.eOSType &&
//				pCCfg->aIdentifier.nLanguage == aVerIdentifier.nLanguage &&
				(!nBestFnd || pCCfg->aIdentifier.nBuildnumber > nBestFnd) )
			{
				pReturn = pCCfg;
				nBestFnd = pCCfg->aIdentifier.nBuildnumber;
			}
		}
	}

	if( pReturn )
	{
		ByteString aFilename( "setupserver_" );
		aFilename += _getExtension4OS( pReturn->aIdentifier.eOSType );
		aFilename += ".ini";

		SiDirEntry aEntry( _getETCPath(m_aAppPath) );
		aEntry += aFilename;

		if( aEntry.Exists() )
		{
			FileStat aFileStat( aEntry );
			if( pReturn->aLastValidation != DateTime(aFileStat.DateModified(), aFileStat.TimeModified()) )
			{
				OSType eOS = pReturn->aIdentifier.eOSType;
				for( USHORT i = 0; i < m_ConfigCache.Count(); ++i )
				{
					CachedConfiguration* p = m_ConfigCache.GetObject(i);
					if( p->aIdentifier.eOSType == eOS )
					{
						m_ConfigCache.Remove( p );
						delete p;
						i--;
					}
				}

				fprintf( stdout, "\n\n" );
				readOSConfiguration( eOS );
				fprintf( stdout, "\n" );

				pReturn = getCachedConfig( aVerIdentifier );
				return pReturn;
			}
		}

		SiDirEntry aValidate(pReturn->aScriptLocation);
		if( !aValidate.Exists() )
		{
			m_ConfigCache.Remove( pReturn );
			delete pReturn;
			pReturn = NULL;
		}
		else if( !pReturn->pCS )
		{
			_CompileScript( pReturn );
		}
	}
	return pReturn;
}

//=============================================================================
//							INTERFACE IMPLEMENTATION
//=============================================================================

//=============================================================================
//	isVersionSupported
//=============================================================================
sal_Bool SAL_CALL SetupServiceImpl::isVersionSupported( const VersionIdentifier& aVerIdentifier )
                                                    throw (::com::sun::star::uno::RuntimeException)
{
	MutexGuard aGuard( &m_ScriptCacheMutex );

	CachedConfiguration* pCC = getCachedConfig( aVerIdentifier );
	if( pCC ) return sal_True;
	return sal_False;
}

//=============================================================================
//	getAvailableLanguages
//=============================================================================

Sequence< sal_Int16 > SAL_CALL SetupServiceImpl::getAvailableLanguages( const VersionIdentifier& aVerIdentifier )
                                                    throw (::com::sun::star::uno::RuntimeException)
{
	MutexGuard aGuard( &m_ScriptCacheMutex );

	Sequence< sal_Int16 > seqLanguages;
	CachedConfiguration* pCC = getCachedConfig( aVerIdentifier );

	if( !pCC || !pCC->pCS ) return seqLanguages;

	ByteString aInstLanguages = pCC->pCS->GetInstallation()->GetLanguages();

	USHORT nDelimTok = 0;
	USHORT nTokCount = aInstLanguages.GetTokenCount(',');
	seqLanguages.realloc( nTokCount );

	for( USHORT x = 0; x < nTokCount; ++x )
	{
		sal_Int16 n = (sal_Int16) aInstLanguages.GetToken(0, ',', nDelimTok).ToInt32();
		seqLanguages[x] = n;
	}

	return seqLanguages;
}

//=============================================================================
//	getProductname
//	getVendorname
//	getDefaultDestinationPath
//	getMirrorList
//	getStandardSizeValues
//=============================================================================
OUString SAL_CALL SetupServiceImpl::getProductname( const VersionIdentifier& aVerIdentifier )
                                                    throw (::com::sun::star::uno::RuntimeException)
{
	MutexGuard aGuard( &m_ScriptCacheMutex );

	CachedConfiguration* pCC = getCachedConfig( aVerIdentifier );
	if( !pCC || !pCC->pCS ) return OUString::createFromAscii("error: productname not found");

	OUString aProductname = OUString::createFromAscii( pCC->pCS->GetInstallation()->GetProductName().GetBuffer() );
	return aProductname;
}

OUString SAL_CALL SetupServiceImpl::getVendorname( const VersionIdentifier& aVerIdentifier )
                                                    throw (::com::sun::star::uno::RuntimeException)
{
	MutexGuard aGuard( &m_ScriptCacheMutex );

	CachedConfiguration* pCC = getCachedConfig( aVerIdentifier );
	if( !pCC || !pCC->pCS ) return OUString::createFromAscii("error: vendorname not found");

	OUString aVendorname = OUString::createFromAscii( pCC->pCS->GetInstallation()->GetVendorName().GetBuffer() );
	return aVendorname;
}

OUString SAL_CALL SetupServiceImpl::getDefaultDestinationPath( const VersionIdentifier& aVerIdentifier )
                                                    throw (::com::sun::star::uno::RuntimeException)
{
	MutexGuard aGuard( &m_ScriptCacheMutex );

	CachedConfiguration* pCC = getCachedConfig( aVerIdentifier );
	if( !pCC || !pCC->pCS ) return OUString::createFromAscii("error: default destinationpath not found");

	OUString aDefaultDestinationPath;
	if( aVerIdentifier.eOSType != OSType_WIN )
		aDefaultDestinationPath += OUString::createFromAscii( "<homedir>/" );
	aDefaultDestinationPath += OUString::createFromAscii(
		pCC->pCS->GetInstallation()->GetDefaultDestPath().GetBuffer() );

	return aDefaultDestinationPath;
}

Sequence< Any > SAL_CALL SetupServiceImpl::getMirrorList( const VersionIdentifier& aVerIdentifier )
                                                    throw (::com::sun::star::uno::RuntimeException)
{
	Sequence< Any > seqMirror;
	CachedConfiguration* pCC = getCachedConfig( aVerIdentifier );

	if( !pCC || !pCC->pCS ) return seqMirror;

	seqMirror.realloc( pCC->aMirrorList.Count() );
	for( USHORT i = 0; i < pCC->aMirrorList.Count(); ++i )
	{
		MirrorEntry aMirror;
		aMirror.strDisplayname	= pCC->aMirrorList.GetObject(i)->GetToken(0,';');
		aMirror.strPath 		= pCC->aMirrorList.GetObject(i)->GetToken(1,';');
		aMirror.nQuality 		= 0;
		seqMirror[i] <<= aMirror;
	}

	return seqMirror;
}

OUString SAL_CALL SetupServiceImpl::getNativeLocation( const VersionIdentifier& aVerIdentifier )
                                                    throw (::com::sun::star::uno::RuntimeException)
{
	CachedConfiguration* pCC = getCachedConfig( aVerIdentifier );
	if( !pCC ) return OUString();

	OUString aNative =  OUString::createFromAscii( pCC->aNativeLocation.GetBuffer() );
	return aNative;
}

SizeInfo SAL_CALL SetupServiceImpl::getStandardSizeValues(
		const VersionIdentifier& aVerIdentifier,
		const Sequence< sal_Int16 >& seqLanguages )
        throw (::com::sun::star::uno::RuntimeException)
{
	SizeInfo aSzInfo;
	CachedConfiguration* pCC = getCachedConfig( aVerIdentifier );
	if( !pCC || !pCC->pCS ) return aSzInfo;

	ULONG lCluster = 16 * 1024;

	SiEnvironment* pEnv = new SiEnvironment;

	sal_Int32 nLangNr = seqLanguages.getLength();
	for( sal_Int32 n = 0; n < nLangNr; ++n )
	{
		sal_Int16 nLanguage = seqLanguages[n];

		LanguageContext* pCtx = new LanguageContext;
		pCtx->nLanguage	= nLanguage;
		pCtx->isProg   	= TRUE;
		pCtx->isDoc		= n == 0? TRUE : FALSE;
		pEnv->AddLanguageContext( pCtx );
	}

	pCC->pCS->GetRootModule()->Select( SiModule::ALL_DEFAULT );
	aSzInfo.nNormalSizeKB		= pCC->pCS->GetRootModule()->
								  CalculateSize( *pEnv, SiModule::DEFAULT, lCluster, FALSE, FALSE, FALSE );
	aSzInfo.nNormalTempSizeKB	= aSzInfo.nNormalSizeKB + pCC->pCS->GetRootModule()->
								  CalculateSize( *pEnv, SiModule::TEMP, lCluster, FALSE, FALSE, FALSE );

	pCC->pCS->GetRootModule()->Select( SiModule::ALL_MINIMAL );
	aSzInfo.nMinimalSizeKB		= pCC->pCS->GetRootModule()->
								  CalculateSize( *pEnv, SiModule::MINIMAL, lCluster, FALSE, FALSE, FALSE );
	aSzInfo.nMinimalTempSizeKB	= aSzInfo.nMinimalSizeKB + pCC->pCS->GetRootModule()->
								  CalculateSize( *pEnv, SiModule::TEMP, lCluster, FALSE, FALSE, FALSE );

	ULONG oneMB = 1024L * 1024L;

	aSzInfo.nNormalSizeKB		/= oneMB;
	aSzInfo.nNormalTempSizeKB	/= oneMB;
	aSzInfo.nMinimalSizeKB		/= oneMB;
	aSzInfo.nMinimalTempSizeKB	/= oneMB;

	delete pEnv;

    return aSzInfo;
}

//=============================================================================
//	getReadmeText
//	getLicenseText
//=============================================================================
ByteString _getFilename4OS( OSType eOSType, USHORT nType )
{
	if( nType == 1 )
	{
		switch( eOSType )
		{
			case OSType_WIN:
			case OSType_OS2:
				return ByteString(WIN_README_FILE_NAME);
				break;
			case OSType_MAC:
				return ByteString(MAC_README_FILE_NAME);
				break;
			case OSType_UNIX_SOLS:
			case OSType_UNIX_SOLI:
			case OSType_UNIX_SOLSG:
			case OSType_UNIX_SOLIG:
			case OSType_UNIX_LINUX:
			case OSType_UNIX_HP:
			case OSType_UNIX_SCO:
				return ByteString(UNX_README_FILE_NAME);
				break;
		}
	}
	else
	{
		switch( eOSType )
		{
			case OSType_WIN:
			case OSType_OS2:
				return ByteString(WIN_LICENSE_FILE_NAME);
				break;
			case OSType_MAC:
				return ByteString(MAC_LICENSE_FILE_NAME);
				break;
			case OSType_UNIX_SOLS:
			case OSType_UNIX_SOLI:
			case OSType_UNIX_SOLSG:
			case OSType_UNIX_SOLIG:
			case OSType_UNIX_LINUX:
			case OSType_UNIX_HP:
			case OSType_UNIX_SCO:
				return ByteString(UNX_LICENSE_FILE_NAME);
				break;
		}
	}
	return ByteString();
}

UniString _getReadme( CachedConfiguration* pCC, USHORT nType )
{
	SiDirEntry aOld( "." );
	SiDirEntry aFoo( SiDirEntry("fo*") );
	SiDirEntry aTmp( aFoo.TempName() );

	aTmp.MakeDir();
	aTmp.SetCWD();

	SiDirEntry aPath( pCC->aScriptLocation );

	SiEnvironment aLocalEnv;
	aLocalEnv.SetSourcePath( ((SiDirEntry&)aPath.GetPath()).GetFull() );

	SiHelp::UnzipReadmeZIP( pCC->aIdentifier.nLanguage, pCC->pCS, &aLocalEnv );

	UniString	aReturn;
	SiDirEntry	aFilename( _getFilename4OS(pCC->aIdentifier.eOSType, nType) );

	BOOL bExtracted = TRUE;
	if( !aFilename.Exists() )
	{
		SiDirEntry aOrg( aPath.GetPath().GetFull() );
		aOrg.SetCWD();
		bExtracted = FALSE;
	}

	if( aFilename.Exists() )
	{
		SvFileStream aReadStrm( aFilename.GetFullUni(), STREAM_READ );
		if( aReadStrm.IsOpen() )
		{
			char* pBuf = new char[32000];
			ULONG nRead = aReadStrm.Read( pBuf, 32000 );
			aReadStrm.Close();
			pBuf[nRead] = 0x00;
			aReturn = UniString( pBuf, RTL_TEXTENCODING_UTF8 );
			delete pBuf;
		}
	}

	aOld.SetCWD();

	if( bExtracted )
	{
		SiDirEntry aKill( _getFilename4OS(pCC->aIdentifier.eOSType, 1) );
		aKill.Kill();

		aKill = _getFilename4OS(pCC->aIdentifier.eOSType, 2);
		aKill.Kill();
	}
	aTmp.Kill();

	return aReturn;
}

OUString SAL_CALL SetupServiceImpl::getReadmeText( const VersionIdentifier& aVerIdentifier )
                                                    throw (::com::sun::star::uno::RuntimeException)
{
	MutexGuard aGuard( &m_ScriptCacheMutex );

	CachedConfiguration* pCC = getCachedConfig( aVerIdentifier );
	if( !pCC || !pCC->pCS ) return OUString::createFromAscii("error: readme file not found");

	return _getReadme( pCC, 1 );
}

OUString SAL_CALL SetupServiceImpl::getLicenseText( const VersionIdentifier& aVerIdentifier )
                                                    throw (::com::sun::star::uno::RuntimeException)
{
	MutexGuard aGuard( &m_ScriptCacheMutex );

	CachedConfiguration* pCC = getCachedConfig( aVerIdentifier );
	if( !pCC || !pCC->pCS ) return OUString::createFromAscii("error: license file not found");

	return _getReadme( pCC, 2 );
}

OUString SAL_CALL SetupServiceImpl::getHelpText( const VersionIdentifier& aVerIdentifier,
												 const OUString& strPagename )
                                                 throw (::com::sun::star::uno::RuntimeException)
{
	MutexGuard aGuard( &m_ScriptCacheMutex );

	CachedConfiguration* pCC = getCachedConfig( aVerIdentifier );
	if( !pCC || !pCC->pCS ) return OUString::createFromAscii("error: no help text");

	UniString aThanksToOurBaseTec(strPagename);
	SiHelpText* pText = pCC->pCS->GetHelpTextForId(
							SiHelp::GetUIPageIdByName( ByteString(aThanksToOurBaseTec, osl_getThreadTextEncoding()) ),
							aVerIdentifier.nLanguage );
	if( pText )
	{
		ByteString aHelpText( pText->GetHelpText() );
		while( aHelpText.SearchAndReplace("\\n", "\n") != STRING_NOTFOUND ) {}
		UniString aHelp( aHelpText, osl_getThreadTextEncoding() );
		return aHelp;
	}

	return OUString::createFromAscii("");
}

//=============================================================================
//	setHiddenModule
//=============================================================================

void SAL_CALL SetupServiceImpl::setHiddenModule( const VersionIdentifier& aVerIdentifier,
		const OUString& strModuleID, sal_Bool bHidden )
        throw (::com::sun::star::uno::RuntimeException)
{
	CachedConfiguration* pCC = getCachedConfig( aVerIdentifier );
	if( !pCC ) return;

	UniString aThanksToOurBaseTec(strModuleID);
	ByteString aID( aThanksToOurBaseTec, osl_getThreadTextEncoding() );

	SiModule* pMod = SiHelp::FindModuleByID(pCC->pCS->GetRootModule(), aID);
	if( !pMod ) return;
	pMod->SetHiddenRecursive( bHidden );
}

//=============================================================================
//	getRootModule
//=============================================================================

ModuleInfo _recurseModuleInfo( SiModule* pMod, USHORT nLang )
{
	SiEnvironment aEmptyEnv;
	ModuleInfo aModule;

	rtl_TextEncoding eTextEncoding = Langcode2TextEncoding(nLang);
	SiModule* pLangRef = NULL;
	if( pMod->HasLangRef() )
	{
		pLangRef = (SiModule*) pMod->GetLangRef(nLang);
		if( pLangRef ) pLangRef->JoinWithParent();
	}
	if( !pLangRef )
		pLangRef = pMod;

	aModule.strID				= UniString( pMod->GetID(), eTextEncoding );
	aModule.strName				= UniString( pLangRef->GetName(), eTextEncoding );
	aModule.strDescription		= UniString( pLangRef->GetDescription(), eTextEncoding );
	aModule.strOnSelect			= UniString( pLangRef->GetOnSelect(), eTextEncoding );
	aModule.strOnDeselect		= UniString( pLangRef->GetOnDeselect(), eTextEncoding );

	aModule.isMinimal			= pLangRef->IsMinimal();
	aModule.isDefault			= pLangRef->GetParent() == NULL? TRUE : pLangRef->IsDefault();
	aModule.isHiddenRoot		= pLangRef->IsHiddenRecursive() || pLangRef->IsHidden() ? TRUE : FALSE;
	aModule.isDontSelectByUser	= pLangRef->DontSelectByUser();

	aModule.nSizeKB				= pLangRef->CalculateSize( aEmptyEnv, SiModule::ALL, 512, FALSE, FALSE) / 1024;

	const SiModuleList* pSubModLst = pMod->GetModuleList();
	aModule.seqSubModules.realloc( pSubModLst->Count() );

	for( USHORT x = 0; x < pSubModLst->Count(); x++ )
		aModule.seqSubModules[x] <<= _recurseModuleInfo( pSubModLst->GetObject(x), nLang );

	return aModule;
}

ModuleInfo SAL_CALL SetupServiceImpl::getRootModule( const VersionIdentifier& aVerIdentifier )
                                            throw (::com::sun::star::uno::RuntimeException)
{
	MutexGuard aGuard( &m_ScriptCacheMutex );

	CachedConfiguration* pCC = getCachedConfig( aVerIdentifier );
	if( !pCC || !pCC->pCS )
		return ModuleInfo();

	SiModule* pRoot = pCC->pCS->GetRootModule();
	return _recurseModuleInfo( pRoot, aVerIdentifier.nLanguage );
}

//=============================================================================
//	isUpdateAvailable
//=============================================================================
void _getVersion( ByteString& r, USHORT& n1, USHORT& n2, USHORT& n3 )
{
	n1 = (USHORT) r.GetToken( 0, '.' ).ToInt32();
	n2 = (USHORT) r.GetToken( 1, '.' ).ToInt32();
	n3 = (USHORT) r.GetToken( 2, '.' ).ToInt32();
}

UpdateType SAL_CALL SetupServiceImpl::isUpdateAvailable(
		const VersionIdentifier& aVerIdentifier,
		VersionIdentifier& aNewVerIdentifier )
        throw (::com::sun::star::uno::RuntimeException)
{
	CachedConfiguration* pCC = getCachedConfig( aVerIdentifier );
	if( !pCC || !pCC->pCS ) return UpdateType_INVALID;

	ByteString aCCVersion = pCC->pCS->GetInstallation()->GetInternalProductVersion();
	if( !aCCVersion.Len() ) return UpdateType_INVALID;

	USHORT nBestMaster, nBestMajor, nBestMinor;
	_getVersion( aCCVersion, nBestMaster, nBestMajor, nBestMinor );

	UpdateType eBestType = UpdateType_EQUAL;
	CachedConfiguration* pBestFound = NULL;
	for( USHORT i = 0; i < m_ConfigCache.Count(); ++i )
	{
		CachedConfiguration* pCache = m_ConfigCache.GetObject(i);
		if( pCache == pCC 															 ||
		    pCache->aIdentifier.eOSType 		 != pCC->aIdentifier.eOSType		 ||
		    pCache->aIdentifier.strProductKey 	 != pCC->aIdentifier.strProductKey	 ||
		    pCache->aIdentifier.strInstLanguages != pCC->aIdentifier.strInstLanguages )
			continue;

		if( !pCache->pCS ) _CompileScript( pCache );
		if( !pCache->pCS ) continue;

		ByteString aCacheVersion = pCache->pCS->GetInstallation()->GetInternalProductVersion();
		if( !aCacheVersion.Len() ) continue;

		USHORT nCacheMaster, nCacheMajor, nCacheMinor;
		_getVersion( aCacheVersion, nCacheMaster, nCacheMajor, nCacheMinor );

		if( nBestMajor < nCacheMajor )
		{
			nBestMajor = nCacheMajor;
			pBestFound = pCache;
			eBestType = UpdateType_REQUIRED;
		}
		else if( nBestMajor == nCacheMajor && nBestMinor < nCacheMinor )
		{
			nBestMinor = nCacheMinor;
			pBestFound = pCache;
			eBestType = UpdateType_OPTIONAL;
		}
	}

	if( pBestFound )
	{
		aNewVerIdentifier = pBestFound->aIdentifier;
	}

	return eBestType;
}

//=============================================================================
//	isModuleAvailable
//=============================================================================

sal_Bool SAL_CALL SetupServiceImpl::isModuleAvailable( const VersionIdentifier& aVerIdentifier,
													   const OUString& strModuleID )
                                                       throw (::com::sun::star::uno::RuntimeException)
{
	UniString aThanksToOurBaseTec(strModuleID);
	ByteString aID( aThanksToOurBaseTec, osl_getThreadTextEncoding() );

	CachedConfiguration* pCC = getCachedConfig( aVerIdentifier );
	if( !pCC ) return FALSE;

	SiModule *pMod = SiHelp::FindModuleByID(pCC->pCS->GetRootModule(), aID);
	if( !pMod || pMod->IsHidden() || pMod->IsHiddenRecursive() )
		return FALSE;

	return TRUE;
}

//=============================================================================
//	getActionListForInstall
//=============================================================================
BOOL _isInList( Sequence< sal_Int16 > list, sal_Int16 n )
{
	sal_Int32 len = list.getLength();
	for( sal_Int32 x = 0; x < len; ++x )
		if( list[x] == n ) return TRUE;
	return FALSE;
}

Sequence< Any >	SAL_CALL SetupServiceImpl::getActionListForInstall(
		const VersionIdentifier& aVerIdentifier,
		const VersionIdentifier& aOldVerIdentifier,
		const InstallEnvironment& aEnvironment,
		InstallResponse& aResponse )
        throw (::com::sun::star::uno::RuntimeException)
{
	MutexGuard aGuard( &m_ScriptCacheMutex );

	SiEnvironment* pEnv = new SiEnvironment;
	pEnv->SetDestPath		( ByteString(UniString(aEnvironment.strDestinationPath), osl_getThreadTextEncoding()) );
	pEnv->SetWebOSType		( aEnvironment.eOSType );
	pEnv->SetUserName		( ByteString(UniString(aEnvironment.strUserName), osl_getThreadTextEncoding()) );
	pEnv->SetUserFirstName	( ByteString(UniString(aEnvironment.strUserFirstName), osl_getThreadTextEncoding()) );
	pEnv->SetUserId			( ByteString(UniString(aEnvironment.strUserId), osl_getThreadTextEncoding()) );
	pEnv->SetCompanyName	( ByteString(UniString(aEnvironment.strCompanyname), osl_getThreadTextEncoding()) );
	pEnv->SetStreet		   	( ByteString(UniString(aEnvironment.strStreet), osl_getThreadTextEncoding()) );
	pEnv->SetCountry	  	( ByteString(UniString(aEnvironment.strCountry), osl_getThreadTextEncoding()) );
	pEnv->SetZip			( ByteString(UniString(aEnvironment.strZip), osl_getThreadTextEncoding()) );
	pEnv->SetCity		 	( ByteString(UniString(aEnvironment.strCity), osl_getThreadTextEncoding()) );
	pEnv->SetTitle		  	( ByteString(UniString(aEnvironment.strTitle), osl_getThreadTextEncoding()) );
	pEnv->SetPosition	   	( ByteString(UniString(aEnvironment.strPosition), osl_getThreadTextEncoding()) );
	pEnv->SetTelefonHome  	( ByteString(UniString(aEnvironment.strPhonePriv), osl_getThreadTextEncoding()) );
	pEnv->SetTelefonWork  	( ByteString(UniString(aEnvironment.strPhoneCompany), osl_getThreadTextEncoding()) );
	pEnv->SetFax		  	( ByteString(UniString(aEnvironment.strPhoneFax), osl_getThreadTextEncoding()) );
	pEnv->SetUserEMail	  	( ByteString(UniString(aEnvironment.strEmail), osl_getThreadTextEncoding()) );
	pEnv->SetState		   	( ByteString(UniString(aEnvironment.strState), osl_getThreadTextEncoding()) );
	pEnv->SetUserFatherName	( ByteString(UniString(aEnvironment.strFatherName), osl_getThreadTextEncoding()) );
	pEnv->SetApartment	   	( ByteString(UniString(aEnvironment.strApartmentNr), osl_getThreadTextEncoding()) );

	if( aEnvironment.eInstallType == InstallType_FULLDELETE || aEnvironment.eInstallType == InstallType_DELETE )
		pEnv->SetInstallType( IT_UNINSTALL );

	if( aEnvironment.eInstallType == InstallType_FULLDELETE )
		pEnv->SetTimeCheck( TRUE );

	if( aEnvironment.eInstallType == InstallType_CHANGE )
	{
		sal_Int32 nLangSwitchNr = aEnvironment.seqSwitchLanguages.getLength();
		for( sal_Int32 nn = 0; nn < nLangSwitchNr; ++nn )
		{
			sal_Int16 nLanguage = aEnvironment.seqSwitchLanguages[nn];

			LanguageContext* pCtx = new LanguageContext;
			pCtx->nLanguage	= nLanguage;
			pCtx->isProg   	= TRUE;
			pCtx->isDoc		= nn == 0? TRUE : FALSE;

			pEnv->AddLanguageContext( pCtx );

			if( !_isInList(aEnvironment.seqLanguages, nLanguage) )
			{
				LanguageContext* pSwitch = new LanguageContext;
				pSwitch->nLanguage	= nLanguage;
				pSwitch->isProg		= TRUE;
				pSwitch->isDoc		= nn == 0? TRUE : FALSE;;

				pEnv->AddSwitchContextInstall( pSwitch );
			}
		}

		sal_Int32 nLangNr = aEnvironment.seqLanguages.getLength();
		for( sal_Int32 n = 0; n < nLangNr; ++n )
		{
			sal_Int16 nLanguage = aEnvironment.seqLanguages[n];
			if( !_isInList(aEnvironment.seqSwitchLanguages, nLanguage) )
			{
				LanguageContext* pSwitch = new LanguageContext;
				pSwitch->nLanguage	= nLanguage;
				pSwitch->isProg		= TRUE;
				pSwitch->isDoc		= n == 0? TRUE : FALSE;;

				pEnv->AddSwitchContextDelete( pSwitch );
			}
		}
	}
	else
	{
		sal_Int32 nLangNr = aEnvironment.seqLanguages.getLength();
		for( sal_Int32 n = 0; n < nLangNr; ++n )
		{
			sal_Int16 nLanguage = aEnvironment.seqLanguages[n];

			LanguageContext* pCtx = new LanguageContext;
			pCtx->nLanguage	= nLanguage;
			pCtx->isProg   	= TRUE;
			pCtx->isDoc		= n == 0? TRUE : FALSE;

			pEnv->AddLanguageContext( pCtx );
		}
	}

	CachedConfiguration* pCC = getCachedConfig( aVerIdentifier );
	CachedConfiguration* pCCOld = NULL;
 	Sequence< Any > seqActionList;

	if( aEnvironment.eInstallType == InstallType_UPDATE )
	{
		pCCOld = getCachedConfig( aOldVerIdentifier );
		if( !pCCOld || !pCCOld->pCS ) return seqActionList;
	}

	if( !pCC || !pCC->pCS ) return seqActionList;

	pEnv->SetDefLanguage		( (USHORT) pCC->pCS->GetInstallation()->GetDefLanguage().ToInt32() );
	pEnv->SetSuiteName			( pCC->pCS->GetInstallation()->GetSuiteName() );
	pEnv->SetSingleProductName	( pCC->pCS->GetInstallation()->GetProductName() );
	pEnv->SetProductVersion		( pCC->pCS->GetInstallation()->GetProductVersion() );
	pEnv->SetVendorName         ( pCC->pCS->GetInstallation()->GetVendorName() );
	pEnv->SetVendorVersion      ( pCC->pCS->GetInstallation()->GetVendorVersion() );
	pEnv->SetInternalVersion	( pCC->pCS->GetInstallation()->GetInternalProductVersion() );
	pEnv->SetInstallMode        ( pCC->pCS->GetInstallation()->GetInstallMode() );

	ByteString aProductname = pEnv->GetSingleProductName();
	aProductname += ' ';
	aProductname += pEnv->GetProductVersion();

	pEnv->SetProductName		( aProductname );
	pEnv->SetProductKey			( pCC->pCS->GetInstallInfo()->GetKey() );

	pEnv->InitReplacement( IM_STANDALONE );

	SiWebAgenda aAgenda;
	aAgenda.SetAppLanguage( aEnvironment.seqLanguages[0] );
	aAgenda.SetEnvironment( pEnv );

	if( aEnvironment.eInstallType == InstallType_UPDATE )
	{
		for( sal_Int32 n = 0; n < aEnvironment.seqModuleIDList.getLength(); ++n )
			((InstallEnvironment&)aEnvironment).seqModuleIDList[n].isSelected = aEnvironment.seqModuleIDList[n].isInstalled;
		pEnv->SetInUpdate( TRUE );
	}

	ULONG nSz = aAgenda.CreateForWebInstall( pCCOld? pCCOld : pCC, aEnvironment );

	if( aEnvironment.eInstallType == InstallType_UPDATE )
	{
		InstallEnvironment aTempEnv = aEnvironment;
		aTempEnv.eInstallType = InstallType_INSTALL;
		for( sal_Int32 n = 0; n < aTempEnv.seqModuleIDList.getLength(); ++n )
			aTempEnv.seqModuleIDList[n].isInstalled = FALSE;

		aAgenda.CreateForWebInstall( pCC, aTempEnv );
	}

	nSz /= 1024;

	aAgenda.JoinActionLists();
	SiActionList& rLst = aAgenda.GetWebActionList();

	if( aEnvironment.eInstallType == InstallType_FULLINSTALL )
		for( USHORT ii = 0; ii < rLst.Count(); ++ii )
			if( ((SiWebAction*)rLst.GetObject(ii))->GetType() != ActionType_DOWNLOAD )
			{
				 SiWebAction* pAction = (SiWebAction*) rLst.Remove( rLst.GetObject(ii) );
				 delete pAction;
				 ii--;
			}

	seqActionList.realloc( rLst.Count() );

	for( USHORT i = 0; i < rLst.Count(); ++i )
	{
		SiWebAction* pAction = (SiWebAction*) rLst.GetObject(i);
		switch( pAction->GetType() )
		{
			// install
			case ActionType_DOWNLOAD :
				seqActionList[i] <<= ((SiWebDownloadAction*)pAction)->GetWebAction();
				break;

			case ActionType_MAKEDIR :
				seqActionList[i] <<= ((SiWebMakeDirAction*)pAction)->GetWebAction();
				break;

			case ActionType_COPYFILE :
				seqActionList[i] <<= ((SiWebCopyFileAction*)pAction)->GetWebAction();
				break;

			case ActionType_UNZIPFILE :
				seqActionList[i] <<= ((SiWebUnzipAction*)pAction)->GetWebAction();
				break;

			case ActionType_PROFILEITEM :
 				seqActionList[i] <<= ((SiWebProfileItemAction*)pAction)->GetWebAction();
				break;

			case ActionType_FONT :
 				seqActionList[i] <<= ((SiWebFontAction*)pAction)->GetWebAction();
				break;

			case ActionType_WINREGISTRY :
 				seqActionList[i] <<= ((SiWebWindowsRegistryAction*)pAction)->GetWebAction();
				break;

			case ActionType_MAKEFOLDER :
 				seqActionList[i] <<= ((SiWebMakeFolderAction*)pAction)->GetWebAction();
				break;

			case ActionType_MAKEFOLDERITEM :
 				seqActionList[i] <<= ((SiWebMakeFolderItemAction*)pAction)->GetWebAction();
				break;

			case ActionType_CREATESHORTCUT :
 				seqActionList[i] <<= ((SiWebMakeShortcutAction*)pAction)->GetWebAction();
				break;

			// deinstall
			case ActionType_DELETEFILE :
 				seqActionList[i] <<= ((SiWebDeleteFileAction*)pAction)->GetWebAction();
				break;

			case ActionType_DELETEDIR :
 				seqActionList[i] <<= ((SiWebDeleteDirAction*)pAction)->GetWebAction();
				break;

			case ActionType_DELETEFOLDERITEM :
 				seqActionList[i] <<= ((SiWebDeleteFolderItemAction*)pAction)->GetWebAction();
				break;

			case ActionType_DELETEFOLDER :
 				seqActionList[i] <<= ((SiWebDeleteFolderAction*)pAction)->GetWebAction();
				break;
		}
		delete pAction;
	}
	rLst.Clear();

	aResponse.nSizeNeeded = nSz;
	if( nSz < (ULONG)aEnvironment.nDriveSize )
	{
		aResponse.bSuccess = TRUE;
		aResponse.eErrorCode = ResponseErrorCode_NOERROR;
	}
	else
	{
		aResponse.bSuccess = FALSE;
		aResponse.eErrorCode = ResponseErrorCode_NOT_ENOUGH_SPACE;
	}

    aResponse.bReboot = FALSE;
    aResponse.bLogout = FALSE;

	if( pEnv->IsReboot() )
		aResponse.bReboot = TRUE;
	else if( pEnv->IsLogout() )
		aResponse.bLogout = TRUE;

	delete pEnv;
	return seqActionList;
}

