/*************************************************************************
 *
 *  $RCSfile: insrtdsk.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: lla $ $Date: 2001/09/11 08:04:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVT_FILEDLG_HXX //autogen
#include <svtools/filedlg.hxx>
#endif

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include "insrtdsk.hxx"
#include "dialog.hrc"

#define DEF_Y_OFFSET 7

// class SetupInsertDiskDialog -------------------------------------------

SetupInsertDiskDialog::SetupInsertDiskDialog( Window* pParent, Point const& aPoint,
						ByteString const& aProgramName, ByteString const& aDiskName, ByteString const& aSourcePath ) :
		ModalDialog		(pParent, ResId(DLG_INSERTDISKDLG)),
		m_aLogoImg		(this, ResId(1)),
		m_aOKButton		(this, ResId(BTN_OK)),
		m_aCancelButton	(this, ResId(BTN_CANCEL)),
		m_aIgnoreButton	(this, ResId(2)),
		m_aDirButton	(this, ResId(1)),
		m_aFileText		(this, ResId(1)),
		m_a2Text		(this, ResId(2)),
		m_aDiskNameText	(this, ResId(CNT_INSERTDISKDLG_DISKNAME)),
		m_a3Text		(this, ResId(3)),
		m_a4Text		(this, ResId(4)),
		m_aPathNameEdit	(this, ResId(CNT_INSERTDISKDLG_PATHNAME)),
		m_aUpdate1		(ResId(1)),
		m_aUpdate2		(ResId(2)),
		m_aUpdate3		(ResId(3))
{
	FreeResource();

	String aText( UniString::CreateFromAscii(aProgramName.GetBuffer()) );
	aText += String( ResId( STR_DLG_TITLE ) );
	SetText( aText );

	Point aPnt = pParent->GetPosPixel();
	Size aSiz = GetSizePixel(),
		 aWinSiz = pParent->GetSizePixel();
	long nXDelta = ( aWinSiz.Width() - aSiz.Width()  ) / 2;
	long nYDelta = ( aWinSiz.Height() - aSiz.Height()  ) / 2;
	if ( nXDelta > 0 )
		aPnt.X() += nXDelta;
	if ( nYDelta > 0 )
		aPnt.Y() += nYDelta;
	SetPosPixel( aPnt );

	Font aBold( m_aDiskNameText.GetFont() );
	aBold.SetWeight( WEIGHT_BOLD );
	m_aDiskNameText.SetFont( aBold );
	m_aFileText.SetFont( aBold );

	m_aDirButton.SetClickHdl( LINK(this, SetupInsertDiskDialog, DirHdl) );
	m_aIgnoreButton.SetClickHdl( LINK(this, SetupInsertDiskDialog, IgnoreHdl) );
	m_aOKButton.SetClickHdl( LINK(this, SetupInsertDiskDialog, OKHdl) );

	// #91499#
	// m_aDiskNameText.SetText(UniString::CreateFromAscii(aDiskName.GetBuffer()) );
	// m_aPathNameEdit.SetText(UniString::CreateFromAscii(aSourcePath.GetBuffer()) );
	m_aDiskNameText.SetText(UniString(aDiskName, osl_getThreadTextEncoding()) );
	m_aPathNameEdit.SetText(UniString(aSourcePath, osl_getThreadTextEncoding()) );

	m_sFileStr = m_aFileText.GetText();
	m_pntOKButton = m_aOKButton.GetPosPixel();

	m_aFileText.Hide();
	m_aIgnoreButton.Hide();

	// Ok- und Cancel-Button versetzen
	m_aOKButton.SetPosPixel(m_aCancelButton.GetPosPixel());
	m_aCancelButton.SetPosPixel(m_aIgnoreButton.GetPosPixel());
}

short SetupInsertDiskDialog::Execute()
{
	return ModalDialog::Execute();
}

// -----------------------------------------------------------------------

IMPL_LINK( SetupInsertDiskDialog, OKHdl, Button *, EMPTYARG )
{
	m_aSourcePath = m_aPathNameEdit.GetText();
	EndDialog( RET_OK );
	return 0;
}

// -----------------------------------------------------------------------

IMPL_LINK_INLINE_START( SetupInsertDiskDialog, IgnoreHdl, Button *, EMPTYARG )
{
	EndDialog( RET_IGNORE );
	return 0;
}
IMPL_LINK_INLINE_END( SetupInsertDiskDialog, IgnoreHdl, Button *, EMPTYARG )

// -----------------------------------------------------------------------


void SetupInsertDiskDialog::SetError()
{
	m_aFileText.Show();
	m_aIgnoreButton.Show();

/*	Point aPt;

	aPt = m_a2Text.GetPosPixel();
	aPt.Y() += DEF_Y_OFFSET;
	m_a2Text.SetPosPixel( aPt );

	aPt = m_aDiskNameText.GetPosPixel();
	aPt.Y() += DEF_Y_OFFSET;
	m_aDiskNameText.SetPosPixel( aPt );

	aPt = m_a3Text.GetPosPixel();
	aPt.Y() += DEF_Y_OFFSET;
	m_a3Text.SetPosPixel( aPt );
*/
	// Ok- und Cancel-Button versetzen
	m_aIgnoreButton.SetPosPixel(m_aCancelButton.GetPosPixel());
	m_aCancelButton.SetPosPixel(m_aOKButton.GetPosPixel());
	m_aOKButton.SetPosPixel(m_pntOKButton);
}

// -----------------------------------------------------------------------

IMPL_LINK( SetupInsertDiskDialog, DirHdl, Button *, EMPTYARG )
{
	PathDialog aDlg( this, WB_SVLOOK );

	String sPath( m_aPathNameEdit.GetText() );
	char cDrive = sPath.ToUpperAscii().GetChar(0);
	if ( cDrive != 'A' && cDrive != 'B' )
		aDlg.SetPath( sPath );

	if( aDlg.Execute() == RET_OK )
		m_aPathNameEdit.SetText( aDlg.GetPath() );

	m_aOKButton.GrabFocus();
	return 0;
}

// -----------------------------------------------------------------------

void SetupInsertDiskDialog::SetFileText( const ByteString& rNew )
{
	String sTmp( m_sFileStr );
	sTmp.SearchAndReplace( UniString::CreateFromAscii("%1"), UniString::CreateFromAscii(rNew.GetBuffer()) );
	m_aFileText.SetText( sTmp );
}

// -----------------------------------------------------------------------

void SetupInsertDiskDialog::SetUpdateMode(const ByteString& rRequiredVersion, const ByteString& rUpdateName)
{
	m_a2Text.SetText( m_aUpdate1 );
	m_a3Text.SetText( m_aUpdate2 );
	m_aDiskNameText.SetText( UniString::CreateFromAscii(rRequiredVersion.GetBuffer()) );

	m_aUpdate3.SearchAndReplace( UniString::CreateFromAscii("%1"),
			UniString::CreateFromAscii(rRequiredVersion.GetBuffer()) );

	m_a4Text.SetText( m_aUpdate3 );
}


