/*************************************************************************
 *
 *  $RCSfile: pasupath.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:51:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVT_FILEDLG_HXX //autogen
#include <svtools/filedlg.hxx>
#endif

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _SV_EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include "maindlg.hxx"
#include "environ.hxx"
#include "script.hxx"
#include "os.hxx"

#include "pasupath.hxx"
#include "pasupath.hrc"

#define PROP_OWN_ROOT		0x00000001
#define PROP_SYS_ROOT		0x00000002
#define PROP_POSTFIX		0x00000004
#define PROP_NO_POSTFIX		0x00000008

#if defined(UNX)
#define DEF_USER_PATH		"usr"
#else
#define DEF_USER_PATH		"user"
#endif

#if defined(UNX)
#define HOME_DIR_AVAILABLE	1
#endif

PageASrvUserPath::PageASrvUserPath( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aRBOwnRoot		( this, ResId(RB_OWN_ROOT, rResId.GetResMgr()) ),
	aRBSysRoot		( this, ResId(RB_SYS_ROOT, rResId.GetResMgr()) ),
	aPathED			( this, ResId(ED_ACTPATH, rResId.GetResMgr()) ),
	aSearchPB		( this, ResId(PB_SEARCH, rResId.GetResMgr()) ),
	aFTPostfix		( this, ResId(FT_POSTFIX, rResId.GetResMgr()) ),
	aPostfixCB		( this, ResId(CB_POSTFIX, rResId.GetResMgr()) ),
	aPostfixED		( this, ResId(ED_POSTFIX, rResId.GetResMgr()) ),
	aStrNeedPath	( ResId(STR_NEEDPATH, rResId.GetResMgr()) ),
	aStrCantWrite	( ResId(STR_CANT_WRITE, rResId.GetResMgr()) ),
	aUserNotFound   ( ResId(STR_USER_NOT_FOUND, rResId.GetResMgr()) )
{
	String aTitle( ResId(STR_TITLE, rResId.GetResMgr()) );
	pParent->SetTitleStr( aTitle );

	FreeResource();

	pEnv = GETDLG()->GetEnv();

#ifdef HOME_DIR_AVAILABLE
	aRBOwnRoot.SetClickHdl( LINK(this, PageASrvUserPath, ClickHdl) );
	aRBSysRoot.SetClickHdl( LINK(this, PageASrvUserPath, ClickHdl) );
	if( !UnixOS::IsRoot() )
		aRBSysRoot.Enable( FALSE );
#else
	aRBOwnRoot.Hide();
	aRBSysRoot.Hide();
#endif

	aSearchPB.SetClickHdl( LINK(this, PageASrvUserPath, ClickHdl) );
	aPostfixCB.SetClickHdl( LINK(this, PageASrvUserPath, ClickHdl) );

	////////////////////////////////////////////////////
	// postfix
	if( pEnv->GetClientPostfix().Len() )
	{
		aPostfixED.SetText( pEnv->GetClientPostfix() );
		// aPostfixCB.Check( TRUE );
	}
	else
	{
		SiCompiledScript* pCS = GETDLG()->GetCScript();
		if( pCS && pCS->GetInstallation() )
		{
			SiDirEntry aEntry( pCS->GetInstallation()->GetDefaultDestPath() );
			aEntry = aEntry[0];
			aPostfixED.SetText( aEntry.GetName() );
		}
		// aPostfixCB.Check( TRUE );
		aPostfixED.Enable( TRUE );
	}

	if( !pEnv->IsFirstInstallation() &&
		pEnv->GetClientPostfix().Len() &&
		!pEnv->GetOpenSubstituteList().Count() )
	{
		aPostfixED.Enable( FALSE );
		aPostfixCB.Enable( FALSE );
	}

	////////////////////////////////////////////////////
	// root path
	if( pEnv->GetClientROOTPath().Len() )
	{
		aPathED.SetText( pEnv->GetClientROOTPath() );
		if( !pEnv->IsFirstInstallation() &&
			!pEnv->GetOpenSubstituteList().Count() )
		{
			aPathED.Enable( FALSE );
			aSearchPB.Enable( FALSE );
		}
	}
	else
		if( pEnv->IsFirstInstallation() )
		{
			SiDirEntry aDefVol( pEnv->GetDestPath() );
			SiDirEntry aDefPath;
			aDefVol.ToAbs();

			if( aDefVol.Level() > 0 )
				aDefPath = aDefVol[aDefVol.Level()-1];
			aDefPath += ByteString(DEF_USER_PATH);
			aDefPath.ToAbs();
			aPathED.SetText( aDefPath.GetFull() );
		}
}

PageASrvUserPath::~PageASrvUserPath()
{
}

SvAgentPage* PageASrvUserPath::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageASrvUserPath( pParent, rResId );
}

BOOL PageASrvUserPath::AllowNext()
{
#ifdef HOME_DIR_AVAILABLE
	if( aRBSysRoot.IsChecked() )
	{
		BOOL 		bAllUserFound = TRUE;
		SiDirEntry	aEntry;

		for( USHORT i = 0; i < pEnv->GetClientNameList().Count(); ++i )
		{
			AppServerClient* pUser = pEnv->GetClientNameList().GetObject(i);
			if( !UnixOS::GetUserHomeDir(pUser->aName, aEntry) ||
				!aEntry.Exists() )
			{
				ByteString aMsg( aUserNotFound );
				aMsg.SearchAndReplace( UniString::CreateFromAscii("%1"), pUser->aName );

				InfoBox aBox( GetAgentDlg(), aMsg );
				aBox.Execute();

				bAllUserFound = FALSE;
				break;
			}

			SiDirEntry aTestWrite( aEntry );
			aTestWrite += ByteString( "wperm" );

			if( !aTestWrite.MakeDir() )
			{
				ByteString aMsg( aStrCantWrite );
				aMsg.SearchAndReplace( UniString::CreateFromAscii("%1"), aEntry.GetFull() );
				aMsg.SearchAndReplace( UniString::CreateFromAscii("%2"), pUser->aName );

				InfoBox aBox( GetAgentDlg(), aMsg );
				aBox.Execute();

				bAllUserFound = FALSE;
			}
			else aTestWrite.Kill();
		}
		return bAllUserFound;
	}
	else
#endif
	if( !aPathED.GetText().Len() )
	{
		InfoBox aBox(GetAgentDlg(), aStrNeedPath);
		aBox.Execute();
		return FALSE;
	}
	return TRUE;
}

BOOL PageASrvUserPath::NotifyNext() const
{
#ifndef HOME_DIR_AVAILABLE
	pEnv->SetClientROOTPath( aPathED.GetText() );
#else
	if( aRBOwnRoot.IsChecked() )
		pEnv->SetClientROOTPath( aPathED.GetText() );
	else
		pEnv->SetClientROOTPath( "" );
#endif

	if( aPostfixCB.IsChecked() )
		pEnv->SetClientPostfix( aPostfixED.GetText() );
	else
		pEnv->SetClientPostfix( "" );
	return TRUE;
}

BOOL PageASrvUserPath::NotifyBack() const
{
	return PageASrvUserPath::NotifyNext();
}

ULONG PageASrvUserPath::GetProperty()
{
	ULONG nProp = 0;

	if( aRBOwnRoot.IsChecked() )
		nProp |= PROP_OWN_ROOT;
	else
		nProp |= PROP_SYS_ROOT;

	if( aPostfixCB.IsChecked() )
		nProp |= PROP_POSTFIX;
	else
		nProp |= PROP_NO_POSTFIX;

	return nProp;
}

void PageASrvUserPath::InitProperty(ULONG nProp)
{
	if( nProp == PROP_NOTSET || nProp & PROP_OWN_ROOT )
		aRBOwnRoot.Check();
	else if( nProp & PROP_SYS_ROOT )
		aRBSysRoot.Check();
	UpdateRB();

	if( nProp == PROP_NOTSET || nProp & PROP_POSTFIX )
		aPostfixCB.Check( TRUE );
	else if( nProp & PROP_NO_POSTFIX )
	{
		aPostfixCB.Check( FALSE );
		aPostfixED.Enable( FALSE );
	}
}

void PageASrvUserPath::RecalcSizes()
{
/*	SiDirEntry aDestVol(aActPath);
	aDestVol.ToAbs();

	ULONG lClusterSize = OS::GetClusterSize(aDestVol[aDestVol.Level()-1].GetFull());
	SiModule* pModule = pCScript->GetRootModule();

	if(lClusterSize != m_lClusterSize)
	{
		m_lClusterSize = lClusterSize;
		m_lUsedSize = pModule->CalculateSize(SiModule::INSTALL, m_lClusterSize, FALSE, TRUE);
		m_lUsedSize *= nClientCnt;
	}
*/
}

void PageASrvUserPath::UpdateRB()
{
#ifdef HOME_DIR_AVAILABLE
	if( !pEnv->IsFirstInstallation() &&
		!pEnv->GetOpenSubstituteList().Count() )
	{
		if( !pEnv->GetClientROOTPath().Len() )
			aRBSysRoot.Check();
		else
			aRBOwnRoot.Check();

		aRBSysRoot.Enable( FALSE );
		aRBOwnRoot.Enable( FALSE );

		aPathED.Enable( FALSE );
		aSearchPB.Enable( FALSE );
	}
	else
	{
		if( aRBOwnRoot.IsChecked() )
		{
			aPathED.Enable( TRUE );
			aSearchPB.Enable( TRUE );
		}
		else
		{
			aPathED.Enable( FALSE );
			aSearchPB.Enable( FALSE );
		}
	}
#endif
}

IMPL_LINK(PageASrvUserPath, ClickHdl, Control*, pCtrl)
{
	if( pCtrl == &aSearchPB )
	{
		PathDialog aDlg( this, WB_SVLOOK );
		aDlg.SetPath( aPathED.GetText() );

		if( aDlg.Execute() == RET_OK )
			aPathED.SetText( aDlg.GetPath() );
	}
	else if( pCtrl == &aPostfixCB )
	{
		if( aPostfixCB.IsChecked() )
			aPostfixED.Enable( TRUE );
		else
			aPostfixED.Enable( FALSE );
	}
	else if( pCtrl == &aRBOwnRoot || pCtrl == &aRBSysRoot )
		UpdateRB();

	return 1;
}
