/*************************************************************************
 *
 *  $RCSfile: preadygo.cxx,v $
 *
 *  $Revision: 1.4.6.3 $
 *
 *  last change: $Author: mh $ $Date: 2003/03/26 11:07:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _OSL_THREAD_H_
#include <osl/thread.h>
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include "maindlg.hxx"
#include "environ.hxx"
#include "script.hxx"
#include "sihelp.hxx"

#include "preadygo.hxx"
#include "preadygo.hrc"
#include "maindlg.hrc"

void replaceSpaceWithUnbreakableSpace(String &_aString)
{
	// this small func replace all AsciiSpace with the invisible unbreakable space
	static sal_Unicode cUnbreakableSpace = 0x00a0; // Unbreakable Space Character
	static UniString sUnbreakableSpace(cUnbreakableSpace, 1);

	_aString.SearchAndReplaceAllAscii( " ", sUnbreakableSpace);
}

PageReadyGo::PageReadyGo( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aFTPatch1		( this, ResId(FT_PATCH1, rResId.GetResMgr()) ),
	aFTPatch2		( this, ResId(FT_PATCH2, rResId.GetResMgr()) ),
	aFTPatch3		( this, ResId(FT_PATCH3, rResId.GetResMgr()) ),
    aErrorMsg       ( ResId( STR_NOT_ENOUGH_SPACE, rResId.GetResMgr() ) )
{
	String aText( ResId(STR_TITLE, rResId.GetResMgr()) );
	pParent->SetTitleStr( aText );
	FreeResource();

// #89203#
	String aBack = pParent->GetBackText();
	// String aNext = pParent->GetNextText();
	String aNext;
	SiEnvironment* pEnv = GETDLG()->GetEnv();
	if( pEnv->GetInstallType() == IT_UNINSTALL )
		aNext = pParent->GetUninstallText();
	else
		aNext = pParent->GetInstallText();

	aText = aFTInfo1.GetText();
	replaceSpaceWithUnbreakableSpace(aBack);
	replaceSpaceWithUnbreakableSpace(aNext);

	aText.SearchAndReplace( UniString::CreateFromAscii("%1"), aBack );
	aText.SearchAndReplace( UniString::CreateFromAscii("%2"), aNext );
	aFTInfo1.SetText( aText );

	pParent->SetNextText( aNext );

	if( pEnv->GetInstallMode() == IM_PATCH )
	{
		Font aBold( aFTPatch2.GetFont() );
		aBold.SetWeight( WEIGHT_BOLD );
		aFTPatch2.SetFont( aBold );

		aText = aFTPatch3.GetText();
  		aText.SearchAndReplaceAll( UniString::CreateFromAscii("%1"), aNext );
  		aText.SearchAndReplaceAll( UniString::CreateFromAscii("%2"),
								UniString::CreateFromInt32(GETDLG()->GetCScript()->GetInstallation()->GetPatchLevel()) );
   		aFTPatch3.SetText( aText );

		aFTInfo1.Hide();
		aFTPatch2.SetText( UniString(pEnv->GetInstalledPath(), osl_getThreadTextEncoding()) );
	}
	else
	{
		aFTPatch1.Hide();
		aFTPatch2.Hide();
		aFTPatch3.Hide();
	}
}

PageReadyGo::~PageReadyGo()
{
}

SvAgentPage* PageReadyGo::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageReadyGo( pParent, rResId );
}

BOOL PageReadyGo::AllowNext()
{
    SiEnvironment* pEnv = GETDLG()->GetEnv();

    if ( pEnv->GetInstallMode() == IM_PATCH )
    {
        ULONG nSysVol, nDestVol;
        BOOL bEnoughSpace = SiHelp::CheckInstallationSize( GETDLG()->GetCScript(), pEnv,
                                                           pEnv->GetInstalledPath(),
                                                           &nSysVol, &nDestVol );
		if ( !bEnoughSpace )
        {
            aErrorMsg.SearchAndReplace( UniString::CreateFromAscii("%SPACE_NEEDED"),
                                   UniString::CreateFromInt32( (sal_Int32) nDestVol ) );
            ErrorBox aError( this, WB_OK, aErrorMsg );
            aError.Execute();
            return FALSE;
        }
    }

    return TRUE;
}

