/*************************************************************************
 *
 *  $RCSfile: pupdate.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:51:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "maindlg.hxx"

#include "environ.hxx"

#include "pupdate.hxx"
#include "pupdate.hrc"

PageUpdateInstall::PageUpdateInstall( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aFTInfo2		( this, ResId(FT_INFO2, rResId.GetResMgr()) ),
	aFTInfo3		( this, ResId(FT_INFO3, rResId.GetResMgr()) ),
	aFTInfo4		( this, ResId(FT_INFO4, rResId.GetResMgr()) ),
	aFTInfo5		( this, ResId(FT_INFO5, rResId.GetResMgr()) ),
	aFTInfo6		( this, ResId(FT_INFO6, rResId.GetResMgr()) ),
	aFTInfo7		( this, ResId(FT_INFO7, rResId.GetResMgr()) ),
	aFTInfo8		( this, ResId(FT_INFO8, rResId.GetResMgr()) ),
	aExpMark		( this, ResId(IMG_EXPMARK, rResId.GetResMgr()) )
{
	String aTitle( ResId(STR_TITLE, rResId.GetResMgr()) );
	aTitle.SearchAndReplace( UniString::CreateFromAscii("%1"),
			UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );

	pParent->SetTitleStr( aTitle );
	FreeResource();

#ifdef UNX
	aFTInfo7.Hide(TRUE); // bitte alle Anwendungen schliessen!
#endif

	if( GETDLG()->GetEnv()->IsUpdateNoVersion() )
	{
		aFTInfo2.Hide(TRUE);
		aFTInfo4.Hide(TRUE);
		aFTInfo5.Hide(TRUE);
		aFTInfo6.Hide(TRUE);
		aFTInfo7.Hide(TRUE);
		aExpMark.Hide(TRUE);

		aTitle = aFTInfo8.GetText();
		aTitle.SearchAndReplace( UniString::CreateFromAscii("%1"),
				UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );
		aTitle.SearchAndReplace( UniString::CreateFromAscii("%2"),
				UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );

		aFTInfo8.SetText( aTitle );
		aFTInfo8.Show();
	}
	else
	if( GETDLG()->GetEnv()->IsUpdateOldVersionWrongLanguage() )
	{
		aFTInfo4.Hide(TRUE);
		aFTInfo5.Hide(TRUE);
		aFTInfo8.Hide(TRUE);
		aTitle = aFTInfo6.GetText();
		aTitle.SearchAndReplace( UniString::CreateFromAscii("%1"),
				UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );
		aFTInfo6.SetText( aTitle );
		aFTInfo6.Show();
	}
	else
	{
		if( GETDLG()->GetEnv()->IsUpdateOldVersionNoRights() ) {
			aFTInfo4.Hide(TRUE);
			aFTInfo5.Show();
			aFTInfo6.Hide(TRUE);
			aFTInfo8.Hide(TRUE);
		} else {
			aFTInfo4.Show();
			aFTInfo5.Hide(TRUE);
			aFTInfo6.Hide(TRUE);
			aFTInfo8.Hide(TRUE);
			aExpMark.Hide(TRUE);
		}
	}

	Font aBold( aFTInfo2.GetFont() );
	aBold.SetWeight( WEIGHT_BOLD );

	aFTInfo1.SetFont( aBold );

	String aSubst( aFTInfo2.GetText() );
	aSubst.SearchAndReplace( UniString::CreateFromAscii("%1"),
			UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );
	aFTInfo2.SetText( aSubst );

	aFTInfo3.SetFont( aBold );
	aFTInfo3.SetText( UniString::CreateFromAscii(GETDLG()->GetEnv()->GetInstalledPath().GetBuffer()) );

	aSubst = aFTInfo4.GetText();
	aSubst.SearchAndReplace( UniString::CreateFromAscii("%1"), pParent->GetNextText() );
	aSubst.SearchAndReplace( UniString::CreateFromAscii("%2"), pParent->GetCancelText() );
	aFTInfo4.SetText( aSubst );
}

PageUpdateInstall::~PageUpdateInstall()
{
}

SvAgentPage* PageUpdateInstall::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageUpdateInstall( pParent, rResId );
}

