/*************************************************************************
 *
 *  $RCSfile: accelcfg.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: cd $ $Date: 2001/08/03 17:37:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
#include <com/sun/star/io/XActiveDataSource.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XPARSER_HPP_
#include <com/sun/star/xml/sax/XParser.hpp>
#endif
#ifndef _UTL_CONFIGMGR_HXX_
#include <unotools/configmgr.hxx>
#endif
#ifndef _UTL_CONFIGITEM_HXX_
#include <unotools/configitem.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#include <osl/mutex.hxx>
#include <tools/string.hxx>
#include <tools/urlobj.hxx>
#include <unotools/streamwrap.hxx>
#include <unotools/ucbstreamhelper.hxx>
#include <comphelper/processfactory.hxx>
#include <svtools/pathoptions.hxx>

#include "accelcfg.hxx"
#include "xmlaccelcfg.hxx"
#include "saxnamespacefilter.hxx"


using namespace utl;
using namespace rtl;
using namespace com::sun::star::uno;
using namespace com::sun::star::io;
using namespace com::sun::star::xml::sax;

class SfxAcceleratorConfig_Impl
{
public:

    SfxAcceleratorItemList aList;
	bool			bModified;

                    SfxAcceleratorConfig_Impl()
                        : bModified( FALSE )
                    {}
};

// -----------------------------------------------------------------------

SfxAcceleratorConfiguration::SfxAcceleratorConfiguration()
{
    pImp = new SfxAcceleratorConfig_Impl;
}

// -----------------------------------------------------------------------

SfxAcceleratorConfiguration::~SfxAcceleratorConfiguration()
{
    if ( pImp->bModified )
    {
        String aUserConfig = SvtPathOptions().GetUserConfigPath();
        INetURLObject aObj( aUserConfig );
        aObj.insertName( String::CreateFromAscii("GlobalKeyBindings.xml") );
        SvStream* pStream = ::utl::UcbStreamHelper::CreateStream( aObj.GetMainURL(), STREAM_STD_READWRITE|STREAM_TRUNC );
        Commit( *pStream );
        delete pStream;
    }

    delete pImp;
}

bool SfxAcceleratorConfiguration::Load( SvStream& rStream )
{
	bool bRet = true;
    ::utl::OInputStreamWrapper* pHelper = new ::utl::OInputStreamWrapper( rStream );
    com::sun::star::uno::Reference < ::com::sun::star::io::XInputStream > xInStream( pHelper );
    try
    {
		Reference< XParser > xParser( ::comphelper::getProcessServiceFactory()->createInstance(
										::rtl::OUString::createFromAscii( "com.sun.star.xml.sax.Parser" )),
								  	UNO_QUERY);

		// connect stream to input stream to the parser
		InputSource aInputSource;
		aInputSource.aInputStream = xInStream;

		// get filter
		Reference< XDocumentHandler > xDocHandler( new OReadAcceleratorDocumentHandler( pImp->aList ) );
		Reference< XDocumentHandler > xFilter( new SaxNamespaceFilter( xDocHandler ));

		// connect parser and filter
		xParser->setDocumentHandler( xFilter );
    	xParser->parseStream( aInputSource );
    }
    catch ( RuntimeException& )
    {
		bRet = FALSE;
    }
    catch( SAXException& )
    {
		bRet = FALSE;
    }
    catch( ::com::sun::star::io::IOException& )
    {
		bRet = FALSE;
    }

	return bRet;
}

const SfxAcceleratorItemList& SfxAcceleratorConfiguration::GetItems()
{
	return pImp->aList;
}

void SfxAcceleratorConfiguration::SetCommand( const SfxAcceleratorConfigItem& rItem )
{
    std::vector< SfxAcceleratorConfigItem>::iterator p;
	for ( p = pImp->aList.begin(); p != pImp->aList.end(); p++ )
        if ( p->nCode == rItem.nCode && p->nModifier == rItem.nModifier )
		{
            p->aCommand = rItem.aCommand;
			return;
		}

    pImp->aList.push_back( rItem );

}

void SfxAcceleratorConfiguration::SetItems( const SfxAcceleratorItemList& rItems, bool bClear )
{
	if ( bClear )
	{
		pImp->aList = rItems;
	}
	else
	{
        std::vector< SfxAcceleratorConfigItem>::const_iterator p;
        for ( p = rItems.begin(); p != rItems.end(); ++p )
            SetCommand( *p );
	}
}

bool SfxAcceleratorConfiguration::Commit( SvStream& rStream )
{
	bool bRet = true;
    ::utl::OOutputStreamWrapper* pHelper = new ::utl::OOutputStreamWrapper( rStream );
    com::sun::star::uno::Reference < ::com::sun::star::io::XOutputStream > xOutputStream( pHelper );

    Reference< XDocumentHandler > xWriter =
            Reference< XDocumentHandler >( ::comphelper::getProcessServiceFactory()->createInstance(
			::rtl::OUString::createFromAscii( "com.sun.star.xml.sax.Writer" )), UNO_QUERY) ;

	Reference< ::com::sun::star::io::XActiveDataSource> xDataSource( xWriter , UNO_QUERY );
    xDataSource->setOutputStream( xOutputStream );
	try
	{
		OWriteAcceleratorDocumentHandler aWriteHandler( pImp->aList, xWriter );
		aWriteHandler.WriteAcceleratorDocument();
        xOutputStream->flush();
	}
	catch ( RuntimeException& )
	{
		bRet = false;
	}
	catch ( SAXException& )
	{
		bRet = false;
	}
	catch ( ::com::sun::star::io::IOException& )
	{
		bRet = false;
	}

	return bRet;
}

