/*************************************************************************
 *
 *  $RCSfile: map.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:52:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
// INCLUDE ---------------------------------------------------------------
#include <stdlib.h>

#pragma hdrstop

#include "map.hxx"
#include "shell.hxx"
#include "objface.hxx"

#include "segmentc.hxx"

#include "dispatch.hxx"

// STATIC DATA -----------------------------------------------------------

DBG_NAME(SfxMap);

SEG_EOFGLOBALS()

extern "C"
#if defined( PM2 ) && !defined( CSET ) && !defined( WTC )
int _stdcall
#else
#ifdef WNT
int _cdecl
#else
int
#endif
#endif
SfxCompareMessages_Impl( const void* pSmaller, const void* pBigger );

// -----------------------------------------------------------------------
#pragma SEG_FUNCDEF(map_01)

SfxMap::SfxMap(const SfxShell &rShell, BOOL bRecursiveSearch ):
	SfxWhichMap( TRUE ),
	pInterface( rShell.GetInterface() ),
	pDispatcher( 0 ),
	bRecursive( bRecursiveSearch )
{
	DBG_CTOR(SfxMap, 0);
	DBG_ASSERT(pInterface != 0, "Interface ist NULL");
}

// -----------------------------------------------------------------------
#pragma SEG_FUNCDEF(map_02)

USHORT SfxMap::GetWhich(USHORT nSlot) const
{
	DBG_CHKTHIS(SfxMap, 0);
	const SfxSlot *pSlot = 0;

	if ( !pInterface && !pDispatcher )
		return nSlot;

	const SfxInterface *pIF = pInterface;
	USHORT nShell = 0;
	if ( pDispatcher )
		 pIF = pDispatcher->GetShell(nShell)->GetInterface();

	while ( pIF )
	{
		for ( ; !pSlot && pIF; pIF = pIF->GetGenoType() )
			pSlot = (const SfxSlot *)bsearch(
								&nSlot, pInterface->pMsgs,
								pInterface->nCount, sizeof(SfxSlot),
								SfxCompareMessages_Impl );
		if ( pSlot )
			return pSlot->GetWhich()? pSlot->GetWhich(): nSlot;
		if ( pDispatcher )
		{
			const SfxShell *pSh = pDispatcher->GetShell(++nShell);
			pIF = pSh ? pSh->GetInterface() : 0;
		}
		else
			pIF = 0;
	}

//  Aus den allgemeinen TabPages kann nach Slot-/Whichwerten
//	gefragt werden, fuer die kein Eintrag in der Map existiert,
//	da sie die Applikation nicht unterstuetzt; deshalb keine
//	Assertion.
//	Der alte Wert wird zurueckgeliefert, damit die Applikation
//	bei 1:1 Mappings keine Eintraege in der Slotmap ertellen muss.
//	(EditEngine benutzt IDs 1:1)
//	DBG_ERROR("Slot nicht gefunden");
	return nSlot;
}

// -----------------------------------------------------------------------
#pragma SEG_FUNCDEF(map_03)

USHORT SfxMap::GetSlot(USHORT nWhich) const
{
	DBG_CHKTHIS(SfxMap, 0);
	DBG_ASSERT(nWhich, "Which-Id ist 0");

	if ( !pInterface && !pDispatcher )
		return nWhich;

	const SfxSlot *pSlot = 0;
	const SfxInterface *pIF = pInterface;
	USHORT nShell = 0;
	if ( pDispatcher )
		 pIF = pDispatcher->GetShell(nShell)->GetInterface();

	while ( pIF )
	{
		for ( ; !pSlot && pIF; pIF = pIF->GetGenoType() )
		{
			const SfxSlot *pTempSlot = pInterface->pMsgs;
			for ( USHORT i = 0; i < pInterface->nCount && !pSlot; ++i )
				if ( (pTempSlot+i)->GetWhich() == nWhich )
					pSlot = pTempSlot;
		}

		if ( pSlot )
			return pSlot->GetId();

		if ( pDispatcher )
		{
			const SfxShell *pSh = pDispatcher->GetShell(++nShell);
			pIF = pSh ? pSh->GetInterface() : 0;
		}
		else
			pIF = 0;
	}

//	Kommenar s.o.
//    DBG_ERROR("Slot nicht gefunden");
	return nWhich;
}

// ------------------------------------------------------------------
#pragma SEG_FUNCDEF(map_04)

SfxWhichMap* SfxMap::Clone() const
{
	return new SfxMap(*this);
}

/*------------------------------------------------------------------------

	$Log: map.cxx,v $
	Revision 1.1.1.1  2000/09/18 16:52:29  hr
	initial import
	
	Revision 1.17  2000/09/17 16:47:20  willem.vandorp
	OpenOffice header added.
	
	Revision 1.16  2000/09/06 14:49:47  willem.vandorp
	Header and footer replaced.
	
	Revision 1.15  1995/07/06 14:07:02  OG
	segmentierung
	

	  Rev 1.14   06 Jul 1995 16:07:02   OG
   segmentierung

	  Rev 1.13   18 Jan 1995 13:03:52   TRI
   WATCOM-Anpassung

	  Rev 1.12   07 Dec 1994 12:21:34   MI
   Clone

	  Rev 1.11   17 Nov 1994 15:38:38   VB
   GetSlot()/GetWhich() ohne Map ist legal; returned Inputwert

	  Rev 1.10   02 Nov 1994 10:19:28   MI
   Bugfix: Syntaxfehler

	  Rev 1.9   02 Nov 1994 09:27:48   MI
   es gibt auch hier eine NullMap

	  Rev 1.8   01 Nov 1994 09:57:14   MI
   Bugfix: Initialisierung

	  Rev 1.7   25 Oct 1994 11:44:04   MI
   #pragma hdrstop

	  Rev 1.6   21 Oct 1994 14:31:24   MI
   Bugfixes: 0-Mapping und Schleifendende

	  Rev 1.5   17 Oct 1994 18:04:08   MI
   GetSlot via Dispatcher implementiert

	  Rev 1.4   10 Oct 1994 17:27:46   MH
   debug

	  Rev 1.3   10 Oct 1994 14:28:08   MI
   include dispatch

	  Rev 1.2   10 Oct 1994 12:46:58   MI
   ObjectBars

	  Rev 1.1   21 Sep 1994 11:31:12   MI
   pch

	  Rev 1.0   30 Aug 1994 17:36:12   VB
   Initial revision.

------------------------------------------------------------------------*/

#pragma SEG_EOFMODULE


