/*************************************************************************
 *
 *  $RCSfile: docscoll.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:52:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#include "sfxsids.hrc"
#include "shobj.hxx"
#include "sfxcoll.hxx"
#include "docscoll.hxx"
#include "objsh.hxx"
#include "app.hxx"
#include "objface.hxx"

#ifndef _SBXCLASS_HXX //autogen
#include <svtools/sbx.hxx>
#endif
//=========================================================================

#define Documents
#include "sfxslots.hxx"

//=========================================================================

TYPEINIT1(SfxDocumentsCollection, SfxCollection);

//-------------------------------------------------------------------------

SfxDocumentsCollection::SfxDocumentsCollection()
:	SfxCollection( SFX_APP(), SFX_TYPELIB_INFO(Documents),
				   DEFINE_CONST_UNICODE( "Documents" ) )
{
/*
	Make( "Open", SbxCLASS_METHOD, SbxOBJECT )->SetUserData(SID_OPENDOC);
*/
};

//-------------------------------------------------------------------------

SfxObjectShell* SfxDocumentsCollection::FindDoc( const SbxVariable &rVar ) const
{
	// String oder Zahl
	USHORT nNo;
	if ( rVar.IsString() )
	{
		String aName( rVar.GetString() );
		nNo = (USHORT) aName.ToInt32();

		// "Ubers C-Api kommen immer Strings, auch wenn ein Index
		// gemeint ist; es wird davon ausgegangen, da\s nicht mehr als
		// 1000 Dokument gleichzeitig offen sind ...

		if ( ! nNo || aName.Len() >= 4 )
		{
			// aktuellen Parameter als Dokumentnamen interpretiert suchen
			for ( SfxObjectShell *pObjSh = SfxObjectShell::GetFirst();
				pObjSh;
				pObjSh = SfxObjectShell::GetNext( *pObjSh ) )
				if ( pObjSh->SfxShell::GetName() == aName )
					return pObjSh;
			// Namen nicht gefunden
			return 0;
		}
	}
	else
	{
		// aktuellen Parameter als Dokumentnummer interpretiert suchen
		nNo = rVar.GetUShort();
	}

	for ( SfxObjectShell *pObjSh = SfxObjectShell::GetFirst();
		pObjSh && nNo > 0;
		pObjSh = SfxObjectShell::GetNext( *pObjSh ) )
            if ( !--nNo )
				return pObjSh;

	// Index nicht gefunden
	return 0;
}

//-------------------------------------------------------------------------

USHORT SfxDocumentsCollection::CollCount() const
{
	// durchz"ahlen
	USHORT nCount = 0;
	for ( SfxObjectShell *pObjSh = SfxObjectShell::GetFirst();
			pObjSh;
			pObjSh = SfxObjectShell::GetNext( *pObjSh ) )
			++nCount;
	return nCount;
}

//-------------------------------------------------------------------------

void SfxDocumentsCollection::CollAdd( SbxVariable &rRet, SbxArray* pPar )
{
	// 'Add' mit Parametern auf SID_NEWDOC, ohne nach SID_NEWDOCDIRECT abbilden
	ExecuteSlot( pPar ? SID_NEWDOC : SID_NEWDOCDIRECT, rRet, pPar );
}

//-------------------------------------------------------------------------

void SfxDocumentsCollection::CollItem( SbxVariable &rRet, SbxArray* pPar )
{
	// genau ein aktueller Parameter vorhanden?
	if ( pPar && pPar->Count() == 2 )
	{
		// passendes Dokument vorhanden
		SfxObjectShell *pObjSh = FindDoc( *pPar->Get(1) );
		if ( pObjSh )
			// Returnwert setzen
			rRet.PutObject( pObjSh->GetSbxObject() );
		else
			// kein Dokument vorhanden
			SetError( SbxERR_NO_OBJECT );
	}
	else
		// falscher Parameter
		SetError( SbxERR_WRONG_ARGS );
}

//-------------------------------------------------------------------------

void SfxDocumentsCollection::CollRemove( SbxArray* pPar )
{
	// genau ein aktueller Parameter vorhanden?
	if ( pPar && pPar->Count() == 2 )
	{
		// passendes Dokument vorhanden
		SfxObjectShell *pObjSh = FindDoc( *pPar->Get(1) );
		if ( pObjSh )
			if ( pObjSh != SfxObjectShell::GetFirst() && // !Desktop
				 pObjSh->PrepareClose(FALSE) )
			{
				// gefundenes Dokument schlie\sen
				pObjSh->DoClose();
				return;
			}
			else
				SetError( ERRCODE_SBX_BAD_ACTION );
		else
			SetError( SbxERR_NO_OBJECT );
		return;
	}

	// falscher Parameter
	SetError( SbxERR_WRONG_ARGS );
}


