/*************************************************************************
 *
 *  $RCSfile: urlframe.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: mba $ $Date: 2001/09/13 12:26:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _IPENV_HXX //autogen
#include <so3/ipenv.hxx>
#endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef _URLBMK_HXX //autogen
#include <svtools/urlbmk.hxx>
#endif
#ifndef _SPLITWIN_HXX //autogen
#include <vcl/splitwin.hxx>
#endif
#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _DOCKWIN_HXX //autogen
#include <vcl/dockwin.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXRECTITEM_HXX //autogen
#include <svtools/rectitem.hxx>
#endif
#ifndef _COM_SUN_STAR_AWT_POSSIZE_HPP_
#include <com/sun/star/awt/PosSize.hpp>
#endif
#ifndef _TOOLKIT_UNOHLP_HXX
#include <toolkit/helper/vclunohelper.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif
#ifndef _UNOTOOLS_PROCESSFACTORY_HXX
#include <comphelper/processfactory.hxx>
#endif
#ifndef _COM_SUN_STAR_AWT_POSSIZE_HPP_
#include <com/sun/star/awt/PosSize.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_XWINDOW_HPP_
#include <com/sun/star/awt/XWindow.hpp>
#endif

#pragma hdrstop

#include "urlframe.hxx"

#include "dispatch.hxx"
#include "objsh.hxx"
#include "intfrm.hxx"
#include "objitem.hxx"
#include "viewsh.hxx"
#include "fsetvwsh.hxx"
#include "fsetobsh.hxx"
#include "docfile.hxx"
#include "frmenv.hxx"
#include "sfxresid.hxx"
#include "view.hrc"
#include "mnumgr.hxx"
#include "objshimp.hxx"
#include "interno.hxx"
#include "request.hxx"
#include "topfrm.hxx"
#include "splitwin.hxx"
#include "workwin.hxx"
#include "event.hxx"
#include "genlink.hxx"
#include "helper.hxx"

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::frame;


DBG_NAME(SfxURLFrame);

#define nBorderSize (long)2;

TYPEINIT1(SfxURLFrame,SfxFrame);

class SfxURLFrameWindow_Impl : public DockingWindow
/* [Beschreibung]
	FrameWindow und Imp-Struktur zugleich. Ist ein DockingWindow, da es
	"ublicherweise in ein SplitWindow eingesetzt wird. Wenn der URLFrame
	ein FrameSetDocument enth"alt, wird es nicht eingef"ugt.
 */
{
friend class SfxURLFrame;

	SfxURLFrame* 			pFrame;
    sal_Bool                bActive;
    sal_Bool                bBorder;
    sal_Bool                bWorkWin;

public:
	SfxURLFrameWindow_Impl( SfxURLFrame* pF,
							Window *pParent,
							sal_Bool bHasBorder,
							WinBits nWinBits = 0 );

protected:
	virtual void 	Resize();
	virtual long	Notify( NotifyEvent& rEvt );

public:
	void            SetActive( sal_Bool bNewActive = sal_True );
	void            SetBorder( sal_Bool bNewBorder = sal_True );
    sal_Bool        HasBorder() const { return bBorder; }
};

class SfxExternalWindow_Impl : public DockingWindow
{
public:
    Window*         pWindow;
	virtual void 	Resize();
                    SfxExternalWindow_Impl( Window* pWin )
                        : DockingWindow( pWin )
                        , pWindow( pWin )
                        {}
};

void SfxExternalWindow_Impl::Resize()
{
    pWindow->SetSizePixel( GetOutputSizePixel() );
}

class SfxURLFrame_Impl
{
public:
	SvInPlaceEnvironment*   pObj;		// wenn es ein FloatingFrame ist
	SfxReleasableFrame*     pRel;
	SfxFrameDescriptor*		pTempDescr;
    SfxExternalWindow_Impl* pExternalWindow;
	sal_uInt32					nUserId;
	sal_Bool					bValidItem;
	sal_Bool					bFirstLoad;

							SfxURLFrame_Impl()
								: pObj(0L)
								, pRel(0L)
								, bValidItem( sal_True )
								, pTempDescr( NULL )
								, nUserId( 0 )
							{}
};

SfxURLFrameWindow_Impl::SfxURLFrameWindow_Impl( SfxURLFrame* pF,
							Window *pParent,
							sal_Bool bHasBorder,
							WinBits nWinBits )
	: DockingWindow( pParent, nWinBits | WB_CLIPCHILDREN | WB_NODIALOGCONTROL | WB_DOCKBORDER )
	, pFrame( pF )
	, bActive(sal_False)
	, bBorder(bHasBorder)
	, bWorkWin(sal_False)
{
	if ( !bHasBorder )
		SetBorderStyle( WINDOW_BORDER_NOBORDER );
	else
		SetBorderStyle( WINDOW_BORDER_NORMAL );
	SetActivateMode( ACTIVATE_MODE_GRABFOCUS );
}

long SfxURLFrameWindow_Impl::Notify( NotifyEvent& rNEvt )
{
	if ( pFrame->IsClosing_Impl() )
		return sal_False;

    if ( rNEvt.GetType() == EVENT_GETFOCUS )
	{
        SfxFrameSetViewShell *pSet = pFrame->GetFrameSet();
        if ( !pSet || !pSet->IsInEditMode() )
        {
            SfxViewFrame* pView = pFrame->GetCurrentViewFrame();
            SfxViewFrame* pCurrent = SfxViewFrame::Current();
            SfxViewFrame* pContainer = pCurrent ? pCurrent->GetParentViewFrame_Impl() : NULL;
            if ( !pContainer )
                pContainer = pCurrent;
            if ( pView && pView != pContainer )
                    pView->MakeActive_Impl( FALSE );
        }

		return sal_True;
	}

	return Window::Notify( rNEvt );
}

void SfxURLFrameWindow_Impl::SetActive( sal_Bool bNewActive )
{
	SfxFrameSetViewShell *pSet = pFrame->GetFrameSet();
	if ( !pSet || pSet->IsImplementedAsFrameset_Impl() &&
		pFrame->GetParentFrame()->GetChildFrameCount() <= 1 )
		bNewActive = sal_False;

	if ( bActive != bNewActive )
	{
		bActive = bNewActive;
		if ( bBorder && bActive )
			SetBorderStyle( WINDOW_BORDER_ACTIVE );
		else if ( bBorder )
			SetBorderStyle( WINDOW_BORDER_NORMAL );
		else
			SetBorderStyle( WINDOW_BORDER_NOBORDER );
//        if ( bBorder && IsVisible() )
//            Paint( ::com::sun::star::awt::Rectangle( Point(), GetOutputSizePixel() ) );
	}
}

void SfxURLFrameWindow_Impl::SetBorder( sal_Bool bNewBorder )
{
	if ( bBorder != bNewBorder )
	{
		bBorder = bNewBorder;
		if ( bBorder && bActive )
			SetBorderStyle( WINDOW_BORDER_ACTIVE );
		else if ( bBorder )
			SetBorderStyle( WINDOW_BORDER_NORMAL );
		else
			SetBorderStyle( WINDOW_BORDER_NOBORDER );
	}
}

void SfxURLFrameWindow_Impl::Resize()
{
    pFrame->Resize();
}

//------------------------------------------------------------------------

SfxURLFrame::SfxURLFrame
(
	SfxFrameDescriptor* pDescriptor,				// Beschreibung
	SvInPlaceEnvironment* pObj,						// das erzeugende Object
	SfxReleasableFrame* pRel,
	SfxFrame* pParentFrame						// der Frame-Parent
)
/*
	[Beschreibung]
	ctor der Klasse SfxURLFrame.
	Ein SfxURLFrame kann ein durch einen ::com::sun::star::util::URL spezifiziertes Objekt in einem
	Fenster darstellen, das in einem SplitWindow liegt. Dieses SplitWindow wird
	von einer SfxFrameSetViewShell zur Verf"ugung gestellt.
	Der SfxURLFrame meldet sein eigenes, dockbares Fenster dort an.
 */

 	: SfxFrame( pParentFrame )
	, pFrameSet( NULL )
	, pImp( new SfxURLFrame_Impl )
{
	DBG_CTOR(SfxURLFrame,0);

	SetDescriptor( pDescriptor );
	SetFrameId_Impl( pDescriptor->GetItemId() );

    Reference < XFrame > xFrame ( ::comphelper::getProcessServiceFactory()->createInstance( DEFINE_CONST_UNICODE("com.sun.star.frame.Frame") ), UNO_QUERY );
    SetFrameInterface_Impl( xFrame );

	Window *pWin = pObj->GetEditWin();
    pImp->pExternalWindow = new SfxExternalWindow_Impl( pWin );
    pWindow = new SfxURLFrameWindow_Impl( this, pImp->pExternalWindow, pDescriptor->HasFrameBorder() );
	pImp->pRel = pRel;
    pImp->pExternalWindow->SetFloatingMode( sal_False );
	pWindow->SetFloatingMode( sal_False );
    pImp->pExternalWindow->SetOutputSizePixel( pWin->GetOutputSizePixel() );
	pImp->pObj = pObj;
	pImp->bFirstLoad = sal_False;

    xFrame->initialize( VCLUnoHelper::GetInterface( pImp->pExternalWindow ) );

	SetFrameName( pDescriptor->GetName() );
	String aFileName( GetURL().GetMainURL() );

    Reference < XFramesSupplier > xParent ( pParentFrame->GetFrameInterface(), UNO_QUERY );
    if ( xParent.is() )
        xParent->getFrames()->append( xFrame );

    DBG_ASSERT( !pDescriptor->GetFrameSet() || pDescriptor->GetFrameSet()->IsRootFrameSet(),
		"Kein RootSet im URLFrame!" );

	// Dokument laden; Window mu\s selbst geshowed werden
	pWindow->Show();
    pImp->pExternalWindow->Show();
	ActivateURL();
}

//------------------------------------------------------------------------

SfxURLFrame::~SfxURLFrame()
/*
	[Beschreibung]
	dtor der Klasse SfxURLFrame. Darf nicht direkt aufgerufen werden, sondern
	immer nur "uber SfxFrame::DoClose().
 */
{
	DBG_DTOR(SfxURLFrame,0);
	if ( pImp->nUserId )
	{
		GetpApp()->RemoveUserEvent( pImp->nUserId );
		pImp->nUserId = 0;
	}

	delete pImp->pTempDescr;
	delete pWindow;
	delete pImp;
}

//------------------------------------------------------------------------

sal_Bool SfxURLFrame::Close()
/*
	[Beschreibung]
	Im Close-Handler der Klasse SfxURLFrame meldet dieser sein DockingWindow
	bei dessen SplitWindow ab, bevor er sich selbst zerst"ort.
 */
{
	if ( pFrameSet && pFrameSet->GetActiveFrame() == this )
		pFrameSet->SetActiveFrame( NULL );

	// Wenn das Dokument ein Frameset ist, kein Remove
	if ( pFrameSet )
	{
		// Item nicht removen spart Zeit beim Schlie\sen des FrameSets;
		// Voraussetzung ist aber, da\s im Close-Handler des ParentFrames
		// der UpdateMode am SplitWindow auf sal_False gesetzt wird, damit
		// nicht ein ReCalc ausgel"ost werden kann
		SfxFrame *pParent = GetParentFrame();
		if ( !pParent->IsClosing_Impl() )
		{
			SplitWindow *pSplit = pFrameSet->GetSplitWindow();
			sal_uInt16 nId = GetFrameId_Impl();
			if ( pSplit->IsItemValid( nId ) )
			{
				sal_uInt16 nSet = pSplit->GetSet( nId );
				pSplit->RemoveItem( nId );

				// Alle leeren Parent-Itemsets bis zum n"achsth"oheren Frame entfernen
				while ( pSplit->GetItemCount( nSet ) == 0 &&
					nSet && nSet != pParent->GetFrameId_Impl() )
				{
					nId = nSet;
					nSet = pSplit->GetSet( nId );
					pSplit->RemoveItem( nId );
				}
			}
		}
	}
	else if ( pImp->pObj  )
	{
		// Wenn der URLFrame von einem FrameObject erzeugt wurde, aber nicht
		// durch "oschen des Objekts, sondern durch Schlie\sen der ::com::sun::star::sdbcx::View
		// geclosed wird, nu\s er sich am Objekt abmelden, bevor er Suizid
		// begeht.
		pImp->pRel->ReleaseFrame();
	}

	delete this;
	return sal_True;
}

//------------------------------------------------------------------------

void SfxURLFrame::SFX_NOTIFY( SfxBroadcaster& rBC,
									const TypeId& rBCType,
									const SfxHint& rHint,
									const TypeId& rHintType )
/* [Beschreibung]
 */
{
}

//------------------------------------------------------------------------

IMPL_STATIC_LINK( SfxURLFrame, ActivateURL_Impl, void*, pVoid )
{
	if ( !pVoid && pThis->pImp->nUserId )
	{
		GetpApp()->RemoveUserEvent( pThis->pImp->nUserId );
		pThis->pImp->nUserId = 0;
	}

	SfxFrameDescriptor *pDescriptor = pThis->pImp->pTempDescr ?
		pThis->pImp->pTempDescr : pThis->GetDescriptor();

	// Gew"unschtes Dokument
	String aFileName( pDescriptor->GetActualURL().GetMainURL() );

	if ( !aFileName.Len() )
	{
		pThis->InsertDocument( NULL );
		return 0L;
	}
	else
	{
		// Auf Frame-Rekursionen testen.
		SfxFrame *pParent = pThis->GetParentFrame();
		while ( pParent )
		{
			// Abgeleitete Framesets tragen selbst die Verantwortung f"ur die Vermeidung von Rekursionen
			sal_Bool bSkip = pParent->GetCurrentViewFrame()->GetViewShell()->IsImplementedAsFrameset_Impl();
			if ( !bSkip )
			{
				SfxMedium *pCurrMed = pParent->GetCurrentDocument()->GetMedium();
				if ( aFileName.Len() && pCurrMed->GetName() == aFileName )
				{
					if ( pThis->GetCurrentDocument() )
					{
						pThis->UpdateDescriptor( pThis->GetCurrentDocument() );
					}
					else
					{
						pThis->GetDescriptor()->SetActualURL( String() );
						aFileName.Erase();
					}

					if ( pThis->pImp->bFirstLoad )
					{
						pThis->InsertDocument( NULL );
						pThis->LoadFinished_Impl();
					}

					return 0L;
				}
			}

			pParent = pParent->GetParentFrame();
		}
	}


	SfxStringItem aName( SID_FILE_NAME, aFileName );
	SfxFrameItem aFrame( SID_DOCFRAME, pThis );

	// Wir wollen vor dem Anlegen der ::com::sun::star::sdbcx::View vom Stack runter
	SfxLinkItem aLink( SID_DONELINK, Link() );
	SfxBoolItem aReadOnly( SID_DOC_READONLY, pDescriptor->IsReadOnly() );
	SfxBoolItem aEdit( SID_EDITDOC, pDescriptor->IsEditable() );

	SfxAllItemSet aSet( SFX_APP()->GetPool() );
	SfxItemSet* pSet = pDescriptor->GetArgs();

	// Itemset des Descriptors kopieren
	aSet.Put( *pSet );

	// Nur wenn am Descriptor explizit ReadOnly oder not-editable gesetzt sind,
	// wird das auch mitgeschickt
	if ( aReadOnly.GetValue() )
		aSet.Put( aReadOnly );

	if ( !aEdit.GetValue() )
		aSet.Put( aEdit );

	// und eigene Parameter hinzuf"ugen
	aSet.Put( SfxFrameDescriptorItem( pDescriptor, SID_FRAMEDESCRIPTOR ) );
	aSet.Put( aName, aName.Which() );
	aSet.Put( aFrame, aFrame.Which() );
	if ( pVoid )
		// wenn Activate_Impl erzwungen, soll die ::com::sun::star::sdbcx::View synchron angelegt werden
		aSet.Put( aLink, aLink.Which() );

	SfxObjectShell *pReferingDoc = pThis->GetParentFrame() ?
		pThis->GetParentFrame()->GetCurrentDocument() : pThis->GetCurrentDocument();

	if ( pThis->pImp->bFirstLoad )
	{
		pThis->pImp->bFirstLoad = sal_False;
		aSet.Put( SfxBoolItem( SID_ISCHILDFRAMELOAD, sal_True ) );
	}

	// Falls noch kein Referer gesetzt: das Frameset nehmen
	SFX_ITEMSET_ARG( &aSet, pRefererItem, SfxStringItem,
					 SID_REFERER, sal_False );
	if ( !pRefererItem || !pRefererItem->GetValue().Len() )
	{
		if ( pReferingDoc )
		{
			aSet.Put( SfxStringItem( SID_REFERER,
			pReferingDoc->GetMedium()->GetName() ) );
		}
		else
			DBG_ERROR( "Kein Referer, aber auch keine Umgebung!" );
	}

	// Falls das Frameset gerade reloaded wird, reloaden wir auch die
	// einzelnen Frames
	if ( pThis->GetTopFrame()->GetCurrentDocument()->IsReloading() )
		aSet.Put( SfxBoolItem( SID_NOCACHE, sal_True ), SID_NOCACHE );

	// Keine Aufnahme in die History, da es sich nicht um einen
	// Browse-Vorgang handelt, sondern um ein Nachladen in Frames.
	aSet.Put( SfxUInt16Item( SID_BROWSEMODE, NO_BROWSE ) );

	SfxDispatcher* pDispat = NULL;
	if( pThis->GetCurrentViewFrame() )
		pDispat = pThis->GetCurrentViewFrame()->GetDispatcher();
    if ( !pDispat )
        pDispat = SfxViewFrame::Current()->GetDispatcher();
	if ( pDispat->IsLocked() )
	{
		// Wenn mehrere Frames geladen werden, die z.T. einen Progress
		// aufsetzen, kann kein weiteres Dokument geladen werden, w"ahrend
		// der Progress l"auft
        pThis->pImp->nUserId = GetpApp()->PostUserEvent( STATIC_LINK( pThis, SfxURLFrame, ActivateURL_Impl ) );
	}
	else
	{
		pDispat->Execute( SID_OPENDOC, SFX_CALLMODE_SYNCHRON, aSet );
	}
	return 0;
}

void SfxURLFrame::CancelActivate_Impl()
{
	if ( pImp->nUserId )
	{
		GetpApp()->RemoveUserEvent( pImp->nUserId );
		pImp->nUserId = 0;
	}
}

void SfxURLFrame::ActivateURL()
/*
	[Beschreibung]
	Vergleicht den gesetzten Namen mit dem Namen des geladenen Documents und
	l"adt ggf. das gew"unschte Dokument.
*/
{
	String aFileName( GetURL().GetMainURL() );
	if ( aFileName.Len() )
	{
		// Frame soll nicht leer sein
		if( !GetCurrentDocument() || CheckContentForLoad_Impl() )
		{
            pImp->nUserId = GetpApp()->PostUserEvent( STATIC_LINK( this, SfxURLFrame, ActivateURL_Impl ) );
		}
	}
	else
	{
		InsertDocument( NULL );
	}

	if ( pWindow )
		pWindow->Invalidate();
}

//------------------------------------------------------------------------

void SfxURLFrame::ActivateWindow_Impl()
/*
	[Beschreibung]
	ActivateWindow_Impl() wird benutzt, um beim Start des FrameSetEditModes
	die Dokumente wieder zu aktivieren.
*/
{
	// Dokument aktivieren
	ActivateURL();
}

//------------------------------------------------------------------------

void SfxURLFrame::DeactivateWindow_Impl()
/*
	[Beschreibung]
	DeactivateWindow_Impl() wird benutzt, um beim Start des FrameSetEditModes
	die Dokumente zu deaktivieren.
*/
{
	if ( pWindow )
	{
		pWindow->Invalidate();
	}
}

//------------------------------------------------------------------------

Window& SfxURLFrame::GetWindow() const
/* [Beschreibung]
 */
{
    return *pWindow;
}

Window* SfxURLFrame::GetFrameWindow_Impl() const
{
    return pImp->pExternalWindow;
}

//------------------------------------------------------------------------

void SfxURLFrame::Update( SfxFrameDescriptor *pD )
/*
	[Beschreibung]
	Die Eigenschaften des SfxURLFrames wurden ge"andert und in ::com::sun::star::form eines
	ver"anderten oder neuen Descriptors "ubergeben.
	Wenn es ein neuer Descriptor ist, geht er in das Eigentum des URLFrames
	"uber.
 */
{
	SfxFrameDescriptor *pOld = GetDescriptor();
	if ( pD && pD != GetDescriptor() )
		SetDescriptor( pD );

	SfxFrameDescriptor *pDescriptor = GetDescriptor();

	// FrameName updaten
	SetFrameName( pDescriptor->GetName() );

	if ( CheckContentForLoad_Impl() )
	{
		// FileName hat sich ge"andert
		String aFileName( GetURL().GetMainURL() );
		if ( !aFileName.Len() )
		{
			// Wieder einen leeren Frame anzeigen
			SetFrameType_Impl( GetFrameType() & ~SFXFRAME_FRAMESET );
			InsertDocument( NULL );

			// Wenn bisher ein Frameset in diesem Frame war, mu\s das
			// Itemset im Splitwindow in ein Itemwindow verwandelt werden
			sal_uInt16 nId = GetFrameId_Impl();
			if ( pFrameSet &&
					pFrameSet->GetSplitWindow()->IsItemValid( nId ) &&
				!pFrameSet->GetSplitWindow()->GetItemWindow( nId ) )
					pFrameSet->UpdateFrame_Impl( this );

			// Der ::com::sun::star::sheet::Border mu\s weg
			if ( pWindow )
				pWindow->Invalidate();
		}
		else
		{
			// aktuelles Dokument laden
			ActivateURL();
			if ( pD && pOld != pD )
			{
				if ( pOld->GetFrameSet() || pD->GetFrameSet() )
				{
					delete pImp->pTempDescr;
					pImp->pTempDescr = pD->Clone( NULL );
					SfxFrameSetDescriptor *pTemp = pD->GetFrameSet();
					SfxFrameSetDescriptor *pCur = pOld->GetFrameSet();
					pD->SetFrameSet( NULL );
					pOld->SetFrameSet( pTemp );
					pD->SetFrameSet( pCur );
					pD->SetURL( pOld->GetURL() );
					pD->SetActualURL( pOld->GetActualURL() );
				}
			}
		}
	}
	else
	{
		UpdateView();
	}

	if ( pFrameSet && pFrameSet->IsInEditMode() )
		DeactivateWindow_Impl();
}

void SfxURLFrame::UpdateView()
{
	SfxFrameDescriptor *pDescriptor = GetDescriptor();

	// ScrollingMode und Margin
	ScrollingMode eMode = pDescriptor->GetScrollingMode();
	SfxScrollingMode eSfxMode;
	switch ( eMode )
	{

		case ScrollingYes :
			eSfxMode = SCROLLING_YES;
			break;
		case ScrollingNo :
			eSfxMode = SCROLLING_NO;
			break;
		case ScrollingAuto :
			eSfxMode = SCROLLING_AUTO;
			break;
		default:
			eSfxMode = SCROLLING_DEFAULT;
			break;
	}

	SfxInternalFrameData_Impl aData( eSfxMode );
	aData.bHasUI = pDescriptor->HasUI();
	aData.aMargin = pDescriptor->GetMargin();
	if ( pDescriptor->HasFrameBorder() )
		aData.aWinPos.X() = aData.aWinPos.Y() = nBorderSize;

	SfxInternalFrame *pFrame = (SfxInternalFrame*) GetCurrentViewFrame();
	if ( pFrame )
		pFrame->TakeFrameData_Impl( &aData );

	// ::com::sun::star::sheet::Border-Attribut ge"andert ?
	if ( pWindow && pDescriptor->HasFrameBorder() != pWindow->HasBorder() )
	{
		pWindow->SetBorder( pDescriptor->HasFrameBorder() );
		pWindow->Resize();
	}

	// Gr"o\se und ItemBits setzen
	if ( pFrameSet )
	{
		// ::com::sun::star::util::URL sitzt in einem SplitWindow
		SplitWindow *pSplit = pFrameSet->GetSplitWindow();
		sal_uInt16 nBits = pDescriptor->GetWinBits();
		if ( pFrameSet->IsInEditMode() )
			nBits = nBits & ~SWIB_FIXED;

		// Zuerst ItemBits setzen, dann Gr"o\se ( SV scheint das so zu wollen )
		sal_uInt16 nId = GetFrameId_Impl();
  //		if ( pDescriptor->GetSize() )
		{
			if ( pSplit->IsItemValid( nId ) )
			{
				pSplit->SetItemBits( nId, nBits );
				pSplit->SetItemSize( nId, pDescriptor->GetSize() );
			}
			else
			{
				sal_uInt16 nSet = pDescriptor->GetParent()->GetParentFrame()->GetItemId();
				pSplit->InsertItem( nId, pDescriptor->GetSize(),
					pDescriptor->GetItemPos(), nSet, nBits );
			}
		}
//		else if ( pSplit->IsItemValid( nId ) )
//			pSplit->RemoveItem( nId );
	}

	SfxObjectShell *pDoc = GetCurrentDocument();
	if ( pDoc )
	{
		SFX_ITEMSET_ARG( pDoc->GetMedium()->GetItemSet(), pViewDataItem, SfxStringItem, SID_USER_DATA, sal_False );
		if ( pViewDataItem )
		{
			if ( pDoc->Get_Impl()->nLoadedFlags & SFX_LOADED_MAINDOCUMENT )
				pFrame->GetViewShell()->ReadUserData( pViewDataItem->GetValue(), sal_True );
			else
			{
				// Daten setzen, die in FinishedLoading ausgewertet werden
				MarkData_Impl*& rpMark = pDoc->Get_Impl()->pMarkData;
				if (!rpMark)
					rpMark = new MarkData_Impl;
				rpMark->pFrame = pFrame;
				rpMark->aUserData = pViewDataItem->GetValue();
			}
		}
		else
		{
			// ggf. Mark anspringen
			INetURLObject aURL( pDoc->GetMedium()->GetName() );
			String aMark( aURL.GetMark() );
			if ( aMark.Len() )
			{
				SfxStringItem aMarkItem( SID_JUMPTOMARK, aMark );
				pFrame->GetDispatcher()->Execute( SID_JUMPTOMARK, SFX_CALLMODE_RECORD, &aMarkItem, 0L );
			}
		}
	}
}

//------------------------------------------------------------------------

DockingWindow* SfxURLFrame::GetDockingWindow() const
/* [Beschreibung]
 */
{
	return (DockingWindow*) &GetWindow();
}

//------------------------------------------------------------------------

sal_Bool SfxURLFrame::InsertDocument( SfxObjectShell* pDoc )
/* [Beschreibung]
 */
{
	// Spezielle Bedingungen testen: nicht im ModalMode!
	if ( !SfxFrame::InsertDocument( pDoc ) )
		return sal_False;

	SfxFrameDescriptor *pDescriptor = GetDescriptor();
	SfxFrameSetObjectShell *pFDoc = PTR_CAST( SfxFrameSetObjectShell, pDoc );
	if ( pDoc )
	{
		// Ggf. History auf den Stand bringen
		if ( !GetCurrentDocument() )
			pDoc->GetMedium()->GetItemSet()->Put( SfxUInt16Item( SID_BROWSEMODE, NO_BROWSE ) );

		UpdateHistory( pDoc );
		UpdateDescriptor( pDoc );

		// Bei Dokumenten in Frames soll ohne R"uckfrage auch im Alien-Format
		// gespeichert werden
		pDoc->Get_Impl()->bDidWarnFormat = sal_True;
	}

	if ( pFDoc )
		SetFrameType_Impl( GetFrameType() | SFXFRAME_FRAMESET );
	else
		SetFrameType_Impl( GetFrameType() & ~SFXFRAME_FRAMESET );

	// Eine neue interne ::com::sun::star::sdbcx::View erzeugen bzw. die alte updaten
	SfxInternalFrame *pFrame = PTR_CAST( SfxInternalFrame, GetCurrentViewFrame() );

	// Ein ViewFrame ohne Dokument darf nicht aktiv sein!
    BOOL bSetFocus = GetWindow().HasChildPathFocus( TRUE );
	if ( pFrame && pFrame == SfxViewFrame::Current() && !pDoc )
        GetParentFrame()->GetCurrentViewFrame()->MakeActive_Impl( bSetFocus );

	const SfxItemSet* pSet = GetItemSet_Impl();
	SetItemSet_Impl(0);

	// ::com::sun::star::sdbcx::View-Id
	SFX_ITEMSET_ARG(
		pSet, pViewIdItem, SfxUInt16Item, SID_VIEW_ID, sal_False );

	// ScrollingMode f"ur die ViewShell
	ScrollingMode eMode = pDescriptor->GetScrollingMode();
	SfxScrollingMode eSfxMode;
	switch ( eMode )
	{
		case ScrollingYes :
			eSfxMode = SCROLLING_YES;
			break;
		case ScrollingNo :
			eSfxMode = SCROLLING_NO;
			break;
		case ScrollingAuto :
			eSfxMode = SCROLLING_AUTO;
			break;
		default:
			eSfxMode = SCROLLING_DEFAULT;
			break;
	}

	SfxInternalFrameData_Impl aData( eSfxMode );
	aData.bHasUI = pDescriptor->HasUI();
	aData.aMargin = pDescriptor->GetMargin();
	aData.bHasToolSpace = pWindow ? pWindow->bWorkWin : sal_True;
	if ( pDescriptor->HasFrameBorder() )
		aData.aWinPos.X() = aData.aWinPos.Y() = nBorderSize;
	if ( pViewIdItem )
		aData.nViewId = pViewIdItem->GetValue();

	sal_Bool bBrowsing = sal_True;
	if ( pFrame )
	{
		if ( pFrame->GetObjectShell() )
			pFrame->ReleaseObjectShell_Impl( sal_False );
		if( pViewIdItem )
			pFrame->SetViewData_Impl( pViewIdItem->GetValue(), String() );
		if ( pDoc )
			pFrame->SetObjectShell_Impl( *pDoc );

		pFrame->TakeFrameData_Impl( &aData );
		pFrame->GetDispatcher()->LockUI_Impl( sal_False );
	}
	else
	{
		if ( pDoc )
			pFrame = new SfxInternalFrame( &GetWindow(), this, &aData, pDoc );
		bBrowsing = sal_False;
	}

	UpdateView();

	// Jetzt UpdateTitle, hidden TopFrames haben sonst keinen Namen!
	if ( pFrame )
	{
		pFrame->UpdateTitle();
	}

	if ( pFrameSet && !pFDoc )
	{
		// Wenn bisher ein Frameset in diesem Frame war und jetzt nicht mehr,
		// mu\s das Itemset im Splitwindow in ein Itemwindow verwandelt werden
		SplitWindow *pSplitWin = pFrameSet->GetSplitWindow();
		sal_uInt16 nId = GetFrameId_Impl();
		if ( pSplitWin->IsItemValid( nId ) && !pSplitWin->GetItemWindow( nId ) )
			pFrameSet->UpdateFrame_Impl( this );
	}

	// Fenster im ::com::sun::star::sheet::Border positionieren
/*
	if ( pImp->pRel && pDoc->GetInPlaceObject() )
		pImp->pRel->SetMapUnit( pDoc->GetInPlaceObject()->GetMapUnit() );
	pWindow->Resize();
*/
	// Sicherstellen, da\s beim Laden von Framesets ein Dokument aktiviert wird
	if ( pDoc )
	{
		// Wenn das Parent Frameset gerade aktiv ist und ich der aktive Frame sein soll,
		// dann wird mein ViewFrame der aktive ViewFrame, allerdings nicht, wenn ich selbst ein Frameset bin.
		SfxViewFrame *pCur = SfxViewFrame::Current();
		if ( pFrameSet && !pFrameSet->IsInEditMode() && pCur == pFrameSet->GetViewFrame() && !pFDoc &&
			( pFrameSet->GetActiveFrame() == this || !pFrameSet->GetActiveFrame() ) )
		{
            pFrame->MakeActive_Impl( pFrameSet->GetWindow()->HasFocus() );
		}
		else
		{
			// Ansonsten Dispatcher/Bindings in Ordnung bringen und vermelden, da das Laden beendet ist
			if ( OwnsBindings_Impl() )
				pFrame->GetBindings().SetDispatcher( pFrame->GetDispatcher() );

			pFrame->GetDispatcher()->Update_Impl( sal_True );

            if ( bSetFocus )
                GrabFocusOnComponent_Impl();

			if ( !pDoc->IsLoading() && !bBrowsing )
				// Wenn weitergebrowsed wurde, hat schon SetObjectShell f"ur das PostActivate_Impl gesorgt
				pDoc->PostActivateEvent_Impl();
		}
	}

	DELETEZ( pImp->pTempDescr );
	return sal_True;
}


//------------------------------------------------------------------------

void SfxURLFrame::InsertWindow( Window *pWin )
/* [Beschreibung]
 */
{
}

void SfxURLFrame::SetActive( sal_Bool bActive )
{
	if ( !IsClosing_Impl() && pWindow )
		pWindow->SetActive( bActive );
}

sal_Bool SfxURLFrame::IsEmpty() const
{
	if ( pFrameSet && pFrameSet->IsInEditMode() )
		return sal_False;
	String aFileName( GetURL().GetMainURL() );
	if ( aFileName.Len() )
		return sal_False;
	return sal_True;
}

void SfxURLFrame::ForceInit_Impl()
{
	ActivateURL_Impl( this, 0 );
}

sal_Bool SfxURLFrame::IsValidItem_Impl() const
{
	return pImp->bValidItem;
}

void SfxURLFrame::SetValidItem_Impl( sal_Bool bValid )
{
	pImp->bValidItem = bValid;
}

void SfxURLFrame::LoadFinished_Impl()
{
	SfxViewShell *pView = GetParentFrame()->GetCurrentViewFrame()->GetViewShell();
	SfxFrameSetViewShell *pSet = PTR_CAST( SfxFrameSetViewShell, pView );
	if ( pSet )
		pSet->FrameFinishedLoading_Impl( this );
}

SfxURLFrame* SfxURLFrame::GetEditFrame_Impl()
{
	// Aktiven Frame wiederherstellen, invalidiert die Slots; es mu\s auf
	// jeden Fall ein Frame aus dem h"ochstm"oglichen FrameSet sein.
	// Zun"achst erst mal auf den n"achsth"oheren Frame wechseln, der Teil
	// eines Framesets und kein FloatingFrame ist.
    SfxURLFrame *pURL = this;
    SfxURLFrame *pFrame = pURL;

	do
	{
        pFrame = PTR_CAST( SfxURLFrame, pFrame->GetParentFrame() );
        if ( pFrame && pFrame->GetParentFrame()->GetFrameType() & SFXFRAME_FRAMESET )
            pURL = pFrame;
	}
    while ( pFrame );

    return pURL ? pURL : this;
}

