/*************************************************************************
 *
 *  $RCSfile: svstor.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: mba $ $Date: 2001/03/21 13:59:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>


#include <svstor.hxx>
#include <soerr.hxx>
#include <sot/storinfo.hxx>
#include <sot/stg.hxx>
#include <tools/debug.hxx>
#pragma hdrstop

// Freigeben, wenn SD-Storages verwendet werden sollen
#define SDSTORAGES
#define SD_ERROR	DBG_ERROR( "use ole2, while SDSTORAGES defined" )

// kein Profiling
#undef DBG_PROFSTART
#define DBG_PROFSTART(John)
#undef DBG_PROFSTOP
#define DBG_PROFSTOP(John)

/************** class SvStorageStream ***********************************/
SV_OLE_FACTORY(SvStorageStreamFactory)
	{
	}
};
TYPEINIT1(SvStorageStreamFactory,SvOleFactory);

SO2_IMPL_STANDARD_CLASS2_DLL(SvStorageStream,SvStorageStreamFactory,SvObject,SotStorageStream,
							 0x89F1CAA0L, 0x7010, 0x101B,
							 0x80,0x4C,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD )

IUnknown * SvStorageStream::GetMemberInterface( const SvGlobalName & )
{
	return NULL;
}

void SvStorageStream::TestMemberObjRef( BOOL /*bFree*/ )
{
}

#ifdef TEST_INVARIANT
void SvStorageStream::TestMemberInvariant( BOOL /*bPrint*/ )
{
}
#endif


/************************************************************************
|*    SvStorageStream::SvStorageStream()
|*
|*    Beschreibung
*************************************************************************/
SvStorageStream::SvStorageStream( const String & rName, StreamMode nMode,
								  StorageMode nStorageMode)
	: SotStorageStream( rName, nMode, nStorageMode )
	, pRelease( NULL )
	, pObjI( NULL )
{
}

SvStorageStream::SvStorageStream( BaseStorageStream * pStm )
	: SotStorageStream( pStm )
	, pRelease( NULL )
	, pObjI( NULL )
{
}

SvStorageStream::SvStorageStream()
	: pRelease( NULL )
	, pObjI( NULL )
{
}

/************************************************************************
|*    SvStorageStream::~SvStorageStream()
|*
|*    Beschreibung
*************************************************************************/
SvStorageStream::~SvStorageStream()
{

	SetBufferSize( 0 );
}

/*************************************************************************
|*    SvStorageStream::GetStream()
|*
|*    Beschreibung
*************************************************************************/
USHORT SvStorageStream::IsA() const
{
	return ID_STORAGESTREAM;
}

/*************************************************************************
|*    SvStorageStream::SyncSvStream()
|*
|*    Beschreibung: Der SvStream wird auf den Zustand des Standard-Streams
|*	  				gesetzt. Der Puffer des SvStreams wird weggeworfen.
*************************************************************************/
void SvStorageStream::SyncSvStream()
{
	SotStorageStream::SyncSvStream();
}

/*************************************************************************
|*    SvStorageStream::GetData()
|*
|*    Beschreibung
*************************************************************************/
ULONG SvStorageStream::GetData( void* pData, ULONG nSize )
{
	ULONG nRet = 0;

	if( Owner() )
		nRet = SotStorageStream::GetData( pData, nSize );
	return nRet;
}

/*************************************************************************
|*    SvStorageStream::PutData()
|*
|*    Beschreibung
*************************************************************************/
ULONG SvStorageStream::PutData( const void* pData, ULONG nSize )
{
	ULONG nRet = 0;

	if( Owner() )
		nRet = SotStorageStream::PutData( pData, nSize );
	return nRet;
}

/*************************************************************************
|*    SvStorageStream::SeekPos()
|*
|*    Beschreibung
*************************************************************************/
ULONG SvStorageStream::SeekPos( ULONG nPos )
{
	ULONG nRet = 0;

	if( Owner() )
		nRet = SotStorageStream::SeekPos( nPos );
	return nRet;
}

/*************************************************************************
|*    SvStorageStream::FlushData()
|*
|*    Beschreibung
*************************************************************************/
void SvStorageStream::FlushData()
{
	if( Owner() )
		SotStorageStream::FlushData();
}

/*************************************************************************
|*    SvStorageStream::SetSize()
|*
|*    Beschreibung
*************************************************************************/
void SvStorageStream::SetSize( ULONG nNewSize )
{
	if( Owner() )
		SotStorageStream::SetSize( nNewSize );
}

/*************************************************************************
|*    SvStorageStream::Commit()
|*    SvStorageStream::Revert()
|*
|*    Beschreibung
*************************************************************************/
BOOL SvStorageStream::Commit()
{
	if( Owner() )
		SotStorageStream::Commit();
	else
		SetError( SVSTREAM_GENERALERROR );
	return GetError() == SVSTREAM_OK;
}

BOOL SvStorageStream::Revert()
{
	if( Owner() )
		SotStorageStream::Revert();
	else
		SetError( SVSTREAM_GENERALERROR );
	return GetError() == SVSTREAM_OK;
}

/************** class SvStorage ******************************************
*************************************************************************/
SV_OLE_FACTORY(SvStorageFactory)
	{
	}
};
TYPEINIT1(SvStorageFactory,SvOleFactory);

SO2_IMPL_STANDARD_CLASS2_DLL(SvStorage,SvStorageFactory,SvObject,SotStorage,
							 0xCD956821L, 0x70B5, 0x101B,
							 0x80,0x4C,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD )

IUnknown * SvStorage::GetMemberInterface( const SvGlobalName & )
{
	return NULL;
}

void SvStorage::TestMemberObjRef( BOOL /*bFree*/ )
{
}

#ifdef TEST_INVARIANT
void SvStorage::TestMemberInvariant( BOOL bPrint )
{
}
#endif

/************************************************************************
|*
|*    SvStorage::SvStorage()
|*
|*    Beschreibung      Es muss ein I... Objekt an SvObject uebergeben
|*                      werden, da es sonst selbst ein IUnknown anlegt und
|*                      festlegt, dass alle weiteren I... Objekte mit
|*                      delete zerstoert werden (Owner() == TRUE).
|*                      Es werden aber nur IStorage Objekte benutzt und nicht
|*                      selbst implementiert, deshalb wird so getan, als ob
|*                      das IStorage Objekt von aussen kam und es wird mit
|*                      Release() freigegeben.
|*                      Die CreateStorage Methoden werden benoetigt, um
|*                      ein IStorage Objekt vor dem Aufruf von SvObject
|*                      zu erzeugen (Own, !Own automatik).
|*                      Hat CreateStorage ein Objekt erzeugt, dann wurde
|*                      der RefCounter schon um 1 erhoet.
|*                      Die Uebergabe erfolgt in pStorageCTor. Die Variable
|*                      ist NULL, wenn es nicht geklappt hat.
|*    Ersterstellung    MM 23.06.94
|*    Letzte Aenderung  MM 23.06.94
|*
*************************************************************************/
#define INIT_SVSTORAGE()            		\
	, pObjI( NULL )							\
    , pRelease( NULL )

SvStorage::SvStorage()
	: SotStorage()
	INIT_SVSTORAGE()
{
}


#define ERASEMASK  ( STREAM_TRUNC | STREAM_WRITE | STREAM_SHARE_DENYALL )
SvStorage::SvStorage( const String & rName, StreamMode nMode,
					 StorageMode nStorageMode )
	: SotStorage( rName, nMode, nStorageMode )
	INIT_SVSTORAGE()
{
}

SvStorage::SvStorage( BOOL bUCBStorage, const String & rName, StreamMode nMode,
					 StorageMode nStorageMode )
	: SotStorage( bUCBStorage, rName, nMode, nStorageMode )
	INIT_SVSTORAGE()
{
}

SvStorage::SvStorage( BaseStorage * pStor )
	: SotStorage( pStor )
	INIT_SVSTORAGE()
{
}

SvStorage::SvStorage( SvStream & rStm )
	: SotStorage( rStm )
	INIT_SVSTORAGE()
{
}

SvStorage::SvStorage( BOOL bUCBStorage, SvStream & rStm )
    : SotStorage( bUCBStorage, rStm )
	INIT_SVSTORAGE()
{
}

SvStorage::SvStorage( SvStream * pStm, BOOL bDelete )
	: SotStorage( pStm, bDelete )
	INIT_SVSTORAGE()
{
}

/*************************************************************************
|*    SvStorage::~SvStorage()
|*
|*    Beschreibung
*************************************************************************/
SvStorage::~SvStorage()
{
}


/*************************************************************************
|*    SvStorage::GetStorage()
|*
|*    Beschreibung
*************************************************************************/
BOOL SvStorage::IsStorageFile( const String & rFileName )
{
	return SotStorage::IsStorageFile( rFileName );
}

/*************************************************************************
|*    SvStorage::GetStorage()
|*
|*    Beschreibung
*************************************************************************/
const String & SvStorage::GetName() const
{
	if( Owner() )
		return SotStorage::GetName();
    else
        DBG_ERROR("Should always be Owner!" );
	return aName;
}

/*************************************************************************
|*    SvStorage::SetClass()
|*    SvStorage::SetConvertClass()
|*
|*    Beschreibung
*************************************************************************/
void SvStorage::SetClass( const SvGlobalName & rName,
						  ULONG nOriginalClipFormat,
						  const String & rUserTypeName )
{
	if( Owner() )
		SotStorage::SetClass( rName, nOriginalClipFormat, rUserTypeName );
}

void SvStorage::SetConvertClass( const SvGlobalName & rName,
								 ULONG nOriginalClipFormat,
								 const String & rUserTypeName )
{
	if( Owner() )
		SotStorage::SetConvertClass( rName, nOriginalClipFormat, rUserTypeName );
}

/*************************************************************************
|*    SvStorage::GetClassName()
|*    SvStorage::GetFormat()
|*    SvStorage::GetUserName()
|*    SvStorage::ShouldConvert()
|*
|*    Beschreibung
*************************************************************************/
SvGlobalName SvStorage::GetClassName()
{
	SvGlobalName aGN;
	if( Owner() )
		aGN = SotStorage::GetClassName();
	else
		SetError( SVSTREAM_GENERALERROR );
	return aGN;
}

ULONG SvStorage::GetFormat()
{
	ULONG nFormat = 0;
	if( Owner() )
		nFormat = SotStorage::GetFormat();
	return nFormat;
}

String SvStorage::GetUserName()
{
	String aName;
	if( Owner() )
		aName = SotStorage::GetUserName();
	return aName;
}

BOOL SvStorage::ShouldConvert()
{
	if( Owner() )
		return SotStorage::ShouldConvert();
	return FALSE;
}

/*************************************************************************
|*    SvStorage::FillInfoList()
|*
|*    Beschreibung
*************************************************************************/
void SvStorage::FillInfoList( SvStorageInfoList * pFillList ) const
{
	if( Owner() )
		SotStorage::FillInfoList( pFillList );
}

/*************************************************************************
|*    SvStorage::CopyTo()
|*
|*    Beschreibung
*************************************************************************/
BOOL SvStorage::CopyTo( SotStorage * pDestStg )
{

	if( Owner() )
		return SotStorage::CopyTo( pDestStg );
	return SVSTREAM_OK == GetError();
}

/*************************************************************************
|*    SvStorage::Commit()
|*
|*    Beschreibung
*************************************************************************/
BOOL SvStorage::Commit()
{
	if( Owner() )
		return SotStorage::Commit();
	return SVSTREAM_OK == GetError();
}

/*************************************************************************
|*    SvStorage::Revert()
|*
|*    Beschreibung
*************************************************************************/
BOOL SvStorage::Revert()
{
	if( Owner() )
		return SotStorage::Revert();
	return SVSTREAM_OK == GetError();
}

/*************************************************************************
|*    SvStorage::OpenStream()
|*
|*    Beschreibung
*************************************************************************/
SotStorageStream * SvStorage::OpenSotStream( const String & rEleName,
										 StreamMode nMode,
										 StorageMode nStorageMode )
{
	DBG_ASSERT( !nStorageMode, "StorageModes ignored" )

	SvStorageStream * pStm = NULL;
	DBG_ASSERT( Owner(), "must be owner" )
	// volle Ole-Patches einschalten
	// egal was kommt, nur exclusiv gestattet
	nMode |= STREAM_SHARE_DENYALL;
	ULONG nE = pOwnStg->GetError();
    BaseStorageStream * p = pOwnStg->OpenStream( rEleName, nMode,
						(nStorageMode & STORAGE_TRANSACTED) ? FALSE : TRUE );
	pStm = new SvStorageStream( p );
	if( !nE )
		pOwnStg->ResetError(); // kein Fehler setzen
	return pStm;
}

/*************************************************************************
|*    SvStorage::OpenStorage()
|*
|*    Beschreibung
*************************************************************************/
SotStorage * SvStorage::OpenSotStorage( const String & rEleName,
									StreamMode nMode,
									StorageMode nStorageMode )
{
	SvStorage * pStor = NULL;
	DBG_ASSERT( Owner(), "must be owner" )
	nMode |= STREAM_SHARE_DENYALL;
	ULONG nE = pOwnStg->GetError();
    BaseStorage * p = pOwnStg->OpenStorage( rEleName, nMode,
					(nStorageMode & STORAGE_TRANSACTED) ? FALSE : TRUE );
	pStor = new SvStorage( p );
	if( !nE )
		pOwnStg->ResetError(); // kein Fehler setzen
	return pStor;
}

SvStorage * SvStorage::OpenUCBStorage( const String & rEleName,
									StreamMode nMode,
									StorageMode nStorageMode )
{
	SvStorage * pStor = NULL;
	DBG_ASSERT( Owner(), "must be owner" )
	nMode |= STREAM_SHARE_DENYALL;
	ULONG nE = pOwnStg->GetError();
    BaseStorage * p = pOwnStg->OpenUCBStorage( rEleName, nMode,
					(nStorageMode & STORAGE_TRANSACTED) ? FALSE : TRUE );
	pStor = new SvStorage( p );
	if( !nE )
		pOwnStg->ResetError(); // kein Fehler setzen
	return pStor;
}

SvStorage * SvStorage::OpenOLEStorage( const String & rEleName,
									StreamMode nMode,
									StorageMode nStorageMode )
{
	SvStorage * pStor = NULL;
	DBG_ASSERT( Owner(), "must be owner" )
	nMode |= STREAM_SHARE_DENYALL;
	ULONG nE = pOwnStg->GetError();
    BaseStorage * p = pOwnStg->OpenOLEStorage( rEleName, nMode,
					(nStorageMode & STORAGE_TRANSACTED) ? FALSE : TRUE );
	pStor = new SvStorage( p );
	if( !nE )
		pOwnStg->ResetError(); // kein Fehler setzen
	return pStor;
}

/*************************************************************************
|*    SvStorage::IsStream()
|*    SvStorage::IsStorage()
|*    SvStorage::IsContained()
|*
|*    Beschreibung
*************************************************************************/
BOOL SvStorage::IsStorage( const String & rEleName ) const
{
	BOOL bOk = FALSE;
	if( Owner() )
		bOk = SotStorage::IsStorage( rEleName );
	return bOk;
}

BOOL SvStorage::IsStream( const String & rEleName ) const
{
	BOOL bOk = FALSE;
	if( Owner() )
		bOk = SotStorage::IsStream( rEleName );
	return bOk;
}

BOOL SvStorage::IsContained( const String & rEleName ) const
{
	BOOL bOk = FALSE;
	if( Owner() )
		bOk = SotStorage::IsContained( rEleName );
	return bOk;
}

/*************************************************************************
|*    SvStorage::Remove()
|*
|*    Beschreibung
*************************************************************************/
BOOL SvStorage::Remove( const String & rEleName )
{
	if( Owner() )
		return SotStorage::Remove( rEleName );
	else
		SetError( SVSTREAM_GENERALERROR );
	return SVSTREAM_OK == GetError();
}

/*************************************************************************
|*    SvStorage::Rename()
|*
|*    Beschreibung
*************************************************************************/
BOOL SvStorage::Rename( const String & rEleName, const String & rNewName )
{
	if( Owner() )
		return SotStorage::Rename( rEleName, rNewName );
	else
		SetError( SVSTREAM_GENERALERROR );
	return SVSTREAM_OK == GetError();
}

/*************************************************************************
|*    SvStorage::CopyTo()
|*
|*    Beschreibung
*************************************************************************/
BOOL SvStorage::CopyTo( const String & rEleName,
						SotStorage * pNewSt, const String & rNewName )
{
	if( Owner() )
		return SotStorage::CopyTo( rEleName, pNewSt, rNewName );
	else
		SetError( SVSTREAM_GENERALERROR );
	return SVSTREAM_OK == GetError();
}

/*************************************************************************
|*    SvStorage::MoveTo()
|*
|*    Beschreibung
*************************************************************************/
BOOL SvStorage::MoveTo( const String & rEleName,
						SotStorage * pNewSt, const String & rNewName )
{
	if( Owner() )
		return SotStorage::MoveTo( rEleName, pNewSt, rNewName );
	else
		SetError( SVSTREAM_GENERALERROR );
	return SVSTREAM_OK == GetError();
}

