/*************************************************************************
 *
 *  $RCSfile: ehdl.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2000/12/07 14:00:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EHDL_HXX
#define _EHDL_HXX


#ifndef __RSC

#ifndef _EINF_HXX
#include <tools/errinf.hxx>
#endif

class Window;
class ResMgr;

class SfxErrorContext : private ErrorContext
{
public:
	SfxErrorContext(
			USHORT nCtxIdP, Window *pWin=0,
			USHORT nResIdP=USHRT_MAX, ResMgr *pMgrP=0);
	SfxErrorContext(
			USHORT nCtxIdP, const String &aArg1, Window *pWin=0,
			USHORT nResIdP=USHRT_MAX, ResMgr *pMgrP=0);
	virtual BOOL GetString(ULONG nErrId, String &rStr);

private:
	USHORT nCtxId;
	USHORT nResId;
	ResMgr *pMgr;
	String aArg1;
};

class SfxErrorHandler : private ErrorHandler
{
public:
	SfxErrorHandler(USHORT nId, ULONG lStart, ULONG lEnd, ResMgr *pMgr=0);
	~SfxErrorHandler();

protected:
	virtual BOOL     GetErrorString(ULONG lErrId, String &, USHORT&) const;
	virtual BOOL     GetMessageString(ULONG lErrId, String &, USHORT&) const;

private:

	ULONG            lStart;
	ULONG            lEnd;
	USHORT           nId;
	ResMgr          *pMgr;

#if _SOLAR__PRIVATE
	BOOL             GetClassString(ULONG lErrId, String &) const;
#endif
	virtual BOOL     CreateString(
						 const ErrorInfo *, String &, USHORT &) const;
};

#endif

#endif


