/*************************************************************************
 *
 *  $RCSfile: itempool.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: er $ $Date: 2001/05/13 03:25:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SFXITEMPOOL_HXX
#define _SFXITEMPOOL_HXX

#include <limits.h>
#include <tools/solar.h>
#include <tools/string.hxx>
#include <svarray.hxx>

#include "poolitem.hxx"

class SvStream;
class SfxBroadcaster;
struct SfxItemPool_Impl;

#define SFX_WHICH_MAX 4999

DBG_NAMEEX(SfxItemPool);

//====================================================================

#define SFX_ITEM_POOLABLE			0x0001
#define SFX_ITEM_NOT_POOLABLE		0x0002

#define SFX_ITEM_USERFLAG0  		0x0100
#define SFX_ITEM_USERFLAG1  		0x0200
#define SFX_ITEM_USERFLAG2  		0x0400
#define SFX_ITEM_USERFLAG3  		0x0800
#define SFX_ITEM_USERFLAG4  		0x1000
#define SFX_ITEM_USERFLAG5  		0x2000
#define SFX_ITEM_USERFLAG6  		0x4000
#define SFX_ITEM_USERFLAG7  		0x8000
#define SFX_ITEM_USERFLAG8  		0x0010
#define SFX_ITEM_USERFLAG9  		0x0020
#define SFX_ITEM_USERFLAGA  		0x0040
#define SFX_ITEM_USERFLAGB  		0x0080

//====================================================================

struct SfxItemInfo
{
	USHORT		_nSID;
	USHORT      _nFlags;
};

//====================================================================

class SfxStyleSheetIterator;
struct SfxPoolItemArray_Impl;

class SfxItemPool

/*	[Beschreibung]

	Die von dieser Klasse abgeleiteten Klassen dienen der Bereitstellung von
	Defaults von SfxPoolItems und halten konkrete (konstante) Instanzen, die
	dann von mehreren Stellen (i.d.R. eines Dokuments) referenziert werden
	knnen.

	Dadurch ist jeder Wert nur einmalig gespeichert, was zu wenig Konstruktor
	und Destruktor-Aufrufen fhrt, Vergleiche zwischen Items eines Dokuments
	beschleunigt und ein einfaches Laden und Speichern von Attributen
	bereitstellt.
*/

{
void readTheItems(SvStream & rStream, USHORT nCount, USHORT nVersion,
				  SfxPoolItem * pDefItem, SfxPoolItemArray_Impl ** pArr);
	UniString						aName;
	USHORT							nStart, nEnd;
	USHORT							_nFileFormatVersion;
#ifdef TF_POOLABLE
	const SfxItemInfo*				pItemInfos;
#else
	USHORT* 						pSlotIds;
#endif
	SfxItemPool_Impl*				pImp;
	SfxPoolItem**					ppStaticDefaults;
	SfxPoolItem**					ppPoolDefaults;
	SfxItemPool*					pSecondary;
	SfxItemPool*					pMaster;
	USHORT*							_pPoolRanges;
	FASTBOOL						bPersistentRefCounts;

	//---------------------------------------------------------------------
#ifndef _SFXITEMS_HXX

friend class SfxPoolWhichMap;

private:
	inline 	USHORT					GetIndex_Impl(USHORT nWhich) const;
	inline	USHORT					GetSize_Impl() const { return nEnd - nStart + 1; }
	SvStream&						Load1_Impl( SvStream &rStream );
	FASTBOOL						IsItemFlag_Impl( USHORT nWhich, USHORT nFlag ) const;

public:
	// fuer dflt. SfxItemSet::CTOR, setze dflt. WhichRanges
	void							FillItemIdRanges_Impl( USHORT*& pWhichRanges ) const;
	const USHORT*					GetFrozenIdRanges() const
									{ return _pPoolRanges; }
	FASTBOOL						IsVer2_Impl() const;

#endif
	//---------------------------------------------------------------------

protected:
	static inline void				SetRef( SfxPoolItem& rItem, USHORT n );
	static inline USHORT			AddRef( const SfxPoolItem& rItem, USHORT n = 1 );
	static inline USHORT			ReleaseRef( const SfxPoolItem& rItem, USHORT n = 1);

public:
									SfxItemPool( const SfxItemPool &rPool,
												 BOOL bCloneStaticDefaults = FALSE );
									SfxItemPool( const UniString &rName,
												 USHORT nStart, USHORT nEnd,
#ifdef TF_POOLABLE
												 const SfxItemInfo *pItemInfos,
#endif
												 SfxPoolItem **pDefaults = 0,
#ifndef TF_POOLABLE
												 USHORT *pSlotIds = 0,
#endif
												 FASTBOOL bLoadRefCounts = TRUE );
	virtual 						~SfxItemPool();

	SfxBroadcaster&					BC();

	void							SetPoolDefaultItem( const SfxPoolItem& );
	const SfxPoolItem*       		GetPoolDefaultItem( USHORT nWhich ) const;
	void                            ResetPoolDefaultItem( USHORT nWhich );

	void                            SetDefaults( SfxPoolItem **pDefaults );
	void							ReleaseDefaults( BOOL bDelete = FALSE );
	static void 					ReleaseDefaults( SfxPoolItem **pDefaults, USHORT nCount, BOOL bDelete = FALSE );

	virtual SfxMapUnit				GetMetric( USHORT nWhich ) const;
	void							SetDefaultMetric( SfxMapUnit eNewMetric );
	virtual SfxItemPresentation		GetPresentation( const SfxPoolItem&	rItem,
										SfxItemPresentation ePresentation,
										SfxMapUnit 			ePresentationMetric,
										XubString&				rText,
                                        const IntlWrapper * pIntlWrapper
										 = 0 ) const;
	virtual SfxItemPool*			Clone() const;
	UniString const &				GetName() const { return aName; }

	virtual const SfxPoolItem&		Put( const SfxPoolItem&, USHORT nWhich = 0 );
	virtual void					Remove( const SfxPoolItem& );
	virtual const SfxPoolItem&		GetDefaultItem( USHORT nWhich ) const;

	const SfxPoolItem*				LoadItem( SvStream &rStream,
											  FASTBOOL bDirect = FALSE,
											  const SfxItemPool *pRefPool = 0 );
	FASTBOOL						StoreItem( SvStream &rStream,
											   const SfxPoolItem &rItem,
											   FASTBOOL bDirect = FALSE ) const;

	USHORT							GetSurrogate(const SfxPoolItem *) const;
	const SfxPoolItem *				GetItem(USHORT nWhich, USHORT nSurrogate) const;
	USHORT							GetItemCount(USHORT nWhich) const;
	const SfxPoolItem*				LoadSurrogate(SvStream& rStream,
											USHORT &rWhich, USHORT nSlotId,
											const SfxItemPool* pRefPool = 0 );
	FASTBOOL						StoreSurrogate(SvStream& rStream,
											const SfxPoolItem *pItem ) const;

	virtual SvStream &				Load(SvStream &);
	virtual SvStream &				Store(SvStream &) const;
	int 							HasPersistentRefCounts() const {
										return bPersistentRefCounts; }
	void							LoadCompleted();

	USHORT							GetFirstWhich() const { return nStart; }
	USHORT							GetLastWhich() const { return nEnd; }
	FASTBOOL						IsInRange( USHORT nWhich ) const {
										return nWhich >= nStart &&
											   nWhich <= nEnd; }
	FASTBOOL						IsInVersionsRange( USHORT nWhich ) const;
	FASTBOOL						IsInStoringRange( USHORT nWhich ) const;
	void                			SetStoringRange( USHORT nFrom, USHORT nTo );
	void							SetSecondaryPool( SfxItemPool *pPool );
	SfxItemPool*					GetSecondaryPool() const {
										return pSecondary; }
	SfxItemPool*					GetMasterPool() const {
										return pMaster; }
	void							FreezeIdRanges();

	void							Cleanup();
	void							Delete();

#ifdef TF_POOLABLE
	FASTBOOL						IsItemFlag( USHORT nWhich, USHORT nFlag ) const;
	FASTBOOL                        IsItemFlag( const SfxPoolItem &rItem, USHORT nFlag ) const
									{ return IsItemFlag( rItem.Which(), nFlag ); }
	void                            SetItemInfos( const SfxItemInfo *pInfos )
									{ pItemInfos = pInfos; }
#else
	int 							HasMap() const { return 0 != pSlotIds; }
	void                            SetMap( USHORT *pNewSlotIds )
									{ pSlotIds = pNewSlotIds; }
#endif
	USHORT                          GetWhich( USHORT nSlot, BOOL bDeep = TRUE ) const;
	USHORT							GetSlotId( USHORT nWhich, BOOL bDeep = TRUE ) const;
	USHORT							GetTrueWhich( USHORT nSlot, BOOL bDeep = TRUE ) const;
	USHORT							GetTrueSlotId( USHORT nWhich, BOOL bDeep = TRUE ) const;

	void							SetVersionMap( USHORT nVer,
												   USHORT nOldStart, USHORT nOldEnd,
												   USHORT *pWhichIdTab );
	USHORT							GetNewWhich( USHORT nOldWhich ) const;
	USHORT							GetVersion() const;
	USHORT							GetFileFormatVersion() const
									{ return _nFileFormatVersion; }
	void    						SetFileFormatVersion( USHORT nFileFormatVersion );
	USHORT							GetLoadingVersion() const;
	FASTBOOL						IsCurrentVersionLoading() const;

	static int						IsWhich(USHORT nId) {
										return nId && nId <= SFX_WHICH_MAX; }
	static int						IsSlot(USHORT nId) {
										return nId && nId > SFX_WHICH_MAX; }

	static const SfxItemPool* 		GetStoringPool();
	static void                     SetStoringPool( const SfxItemPool * );

private:
	const SfxItemPool&				operator=(const SfxItemPool &);   // n.i.!!
};

// --------------- Inline Implementierungen ------------------------------

// nur der Pool darf den Referenz-Zaehler manipulieren !!!
inline void SfxItemPool::SetRef( SfxPoolItem& rItem, USHORT n )
{
	rItem.SetRef(n);
}

// nur der Pool darf den Referenz-Zaehler manipulieren !!!
inline USHORT SfxItemPool::AddRef( const SfxPoolItem& rItem, USHORT n )
{
	return rItem.AddRef(n);
}

// nur der Pool darf den Referenz-Zaehler manipulieren !!!
inline USHORT SfxItemPool::ReleaseRef( const SfxPoolItem& rItem, USHORT n )
{
	return rItem.ReleaseRef(n);
}


#endif

