/*************************************************************************
 *
 *  $RCSfile: editdata.hxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: mt $ $Date: 2001/11/14 11:02:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// MyEDITDATA, wegen exportiertem EditData
#ifndef _MyEDITDATA_HXX
#define _MyEDITDATA_HXX

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif

#include <svtools/svarray.hxx>

class SfxItemSet;
class SfxPoolItem;
class SvParser;

enum EETextFormat		{ EE_FORMAT_TEXT = 0x20, EE_FORMAT_RTF, EE_FORMAT_BIN = 0x31, EE_FORMAT_HTML, EE_FORMAT_XML };
enum EESelectionMode	{ EE_SELMODE_STD, EE_SELMODE_TXTONLY };
enum EESpellState		{ EE_SPELL_OK, EE_SPELL_NOLANGUAGE, EE_SPELL_LANGUAGENOTINSTALLED, EE_SPELL_NOSPELLER, EE_SPELL_ERRORFOUND };
enum EVAnchorMode		{
			ANCHOR_TOP_LEFT, 	ANCHOR_VCENTER_LEFT, 	ANCHOR_BOTTOM_LEFT,
			ANCHOR_TOP_HCENTER,	ANCHOR_VCENTER_HCENTER,	ANCHOR_BOTTOM_HCENTER,
			ANCHOR_TOP_RIGHT,	ANCHOR_VCENTER_RIGHT,	ANCHOR_BOTTOM_RIGHT };

#define EE_PARA_NOT_FOUND		0xFFFF
#define EE_PARA_APPEND			0xFFFF
#define EE_PARA_ALL				0xFFFF
#define EE_APPEND				0xFFFF

// Fehlermeldungen fuer Read/Write-Methode
#define EE_READWRITE_OK				 (SVSTREAM_OK)
#define EE_READWRITE_WRONGFORMAT	 (SVSTREAM_ERRBASE_USER+1)
#define EE_READWRITE_GENERALERROR	 (SVSTREAM_ERRBASE_USER+2)

#define EDITUNDO_START				100
#define EDITUNDO_REMOVECHARS		100
#define EDITUNDO_CONNECTPARAS		101
#define EDITUNDO_REMOVEFEATURE		102
#define EDITUNDO_MOVEPARAGRAPHS		103
#define EDITUNDO_INSERTFEATURE		104
#define EDITUNDO_SPLITPARA			105
#define EDITUNDO_INSERTCHARS		106
#define EDITUNDO_DELCONTENT			107
#define EDITUNDO_DELETE				108
#define EDITUNDO_CUT				109
#define EDITUNDO_PASTE				110
#define EDITUNDO_INSERT				111
#define EDITUNDO_SRCHANDREPL		112
#define EDITUNDO_MOVEPARAS			113
#define EDITUNDO_PARAATTRIBS		114
#define EDITUNDO_ATTRIBS			115
#define EDITUNDO_DRAGANDDROP		116
#define EDITUNDO_READ				117
#define EDITUNDO_STYLESHEET			118
#define EDITUNDO_REPLACEALL			119
#define EDITUNDO_STRETCH			120
#define EDITUNDO_RESETATTRIBS		121
#define EDITUNDO_INDENTBLOCK		122
#define EDITUNDO_UNINDENTBLOCK		123
#define EDITUNDO_MARKSELECTION		124
#define EDITUNDO_TRANSLITERATE		125
#define EDITUNDO_END				125

#define EDITUNDO_USER				200


#define EE_COMPATIBLEMODE_PARAGRAPHSPACING_SUMMATION			0x0001
#define EE_COMPATIBLEMODE_PARAGRAPHSPACING_BEFOREFIRSTPARAGRAPH	0x0002

class ImpEditView;
class ImpEditEngine;
class EditTextObject;
class SfxStyleSheet;

#define RGCHK_NONE			0	// Keine Korrektur der ViusArea beim Scrollen
#define RGCHK_NEG			1	// Keine neg. ViusArea beim Scrollen
#define RGCHK_PAPERSZ1		2	// VisArea muss in Papierbreite,Texthoehe liegen

struct ESelection
{
	USHORT		nStartPara;
	xub_StrLen	nStartPos;
	USHORT		nEndPara;
	xub_StrLen	nEndPos;

	ESelection() { nStartPara = 0; nStartPos = 0; nEndPara = 0; nEndPos = 0; }

	ESelection(	USHORT nStPara, xub_StrLen nStPos, USHORT nEPara, xub_StrLen nEPos )
	{
		nStartPara	= nStPara;
		nStartPos	= nStPos;
		nEndPara	= nEPara;
		nEndPos		= nEPos;
	}

	ESelection(	USHORT nPara, xub_StrLen nPos )
	{
		nStartPara	= nPara;
		nStartPos	= nPos;
		nEndPara	= nPara;
		nEndPos		= nPos;
	}

	ESelection(	const ESelection& r )
	{
		nStartPara	= r.nStartPara;
		nStartPos	= r.nStartPos;
		nEndPara	= r.nEndPara;
		nEndPos		= r.nEndPos;
	}

	ESelection& operator = ( const ESelection& r )
	{
		nStartPara	= r.nStartPara;
		nStartPos	= r.nStartPos;
		nEndPara	= r.nEndPara;
		nEndPos		= r.nEndPos;
		return *this;
	}

	void	Adjust();
	BOOL 	IsEqual( const ESelection& rS );
	BOOL 	IsLess( const ESelection& rS );
	BOOL 	IsGreater( const ESelection& rS );
	BOOL	IsZero();
	BOOL	HasRange() const;
};

inline BOOL ESelection::HasRange() const
{
	return ( nStartPara != nEndPara ) || ( nStartPos != nEndPos );
}

inline sal_Bool ESelection::IsZero()
{
	return ( ( nStartPara == 0 ) && ( nStartPos == 0 ) &&
			 ( nEndPara == 0 ) && ( nEndPos == 0 ) );
}

inline sal_Bool ESelection::IsEqual( const ESelection& rS )
{
	return ( ( nStartPara == rS.nStartPara ) && ( nStartPos == rS.nStartPos ) &&
			 ( nEndPara == rS.nEndPara ) && ( nEndPos == rS.nEndPos ) );
}

inline sal_Bool ESelection::IsLess( const ESelection& rS )
{
	// Selektion muss justiert sein.
	// => Nur pueffen, ob Ende von 'this' < Start von rS

	if ( ( nEndPara < rS.nStartPara ) ||
		 ( ( nEndPara == rS.nStartPara ) && ( nEndPos < rS.nStartPos ) && !IsEqual( rS ) ) )
	{
		return sal_True;
	}
	return sal_False;
}

inline sal_Bool ESelection::IsGreater( const ESelection& rS )
{
	// Selektion muss justiert sein.
	// => Nur pueffen, ob Ende von 'this' > Start von rS

	if ( ( nStartPara > rS.nEndPara ) ||
		 ( ( nStartPara == rS.nEndPara ) && ( nStartPos > rS.nEndPos ) && !IsEqual( rS ) ) )
	{
		return sal_True;
	}
	return sal_False;
}

inline void ESelection::Adjust()
{
	sal_Bool bSwap = sal_False;
	if ( nStartPara > nEndPara )
		bSwap = sal_True;
	else if ( ( nStartPara == nEndPara ) && ( nStartPos > nEndPos ) )
		bSwap = sal_True;

	if ( bSwap )
	{
		sal_uInt16 nSPar = nStartPara; sal_uInt16 nSPos = nStartPos;
		nStartPara = nEndPara; nStartPos = nEndPos;
		nEndPara = nSPar; nEndPos = nSPos;
	}
}

// -----------------------------------------------------------------------

enum ImportState {
					RTFIMP_START, RTFIMP_END, 				// nur pParser, nPara, nIndex
					RTFIMP_NEXTTOKEN, RTFIMP_UNKNOWNATTR,	// nToken+nTokenValue
					RTFIMP_SETATTR, 						// pAttrs
					RTFIMP_INSERTTEXT, 						// aText
					RTFIMP_INSERTPARA,						// -
					HTMLIMP_START, HTMLIMP_END, 			// nur pParser, nPara, nIndex
					HTMLIMP_NEXTTOKEN, HTMLIMP_UNKNOWNATTR,	// nToken
					HTMLIMP_SETATTR, 						// pAttrs
					HTMLIMP_INSERTTEXT, 					// aText
					HTMLIMP_INSERTPARA, HTMLIMP_INSERTFIELD	// -
					};

struct ImportInfo
{
	SvParser*				pParser;
	ESelection				aSelection;
	ImportState				eState;

	int 					nToken;
	short 					nTokenValue;

	String					aText;

	void*					pAttrs;	// RTF: SvxRTFItemStackType*, HTML: SfxItemSet*

	ImportInfo( ImportState eState, SvParser* pPrsrs, const ESelection& rSel );
	~ImportInfo();
};

#define EE_SEARCH_WORDONLY		0x0001
#define EE_SEARCH_EXACT			0x0002
#define EE_SEARCH_BACKWARD		0x0004
#define EE_SEARCH_INSELECTION	0x0008
#define EE_SEARCH_REGEXPR		0x0010
#define EE_SEARCH_PATTERN		0x0020

struct ParagraphInfos
{
	USHORT	nParaHeight;
	USHORT	nLines;

	USHORT	nFirstLineStartX;

	USHORT	nFirstLineOffset;
	USHORT	nFirstLineHeight;
	USHORT	nFirstLineTextHeight;
	USHORT	nFirstLineMaxAscent;

	BOOL	bValid;	// Bei einer Abfrage waehrend der Formatierung ungueltig!
};

struct EECharAttrib
{
	const SfxPoolItem*	pAttr;
	
	USHORT				nPara;
	xub_StrLen			nStart;
	xub_StrLen			nEnd;
};

SV_DECL_VARARR( EECharAttribArray, EECharAttrib, 0, 4 );

struct MoveParagraphsInfo
{
    USHORT  nStartPara;
    USHORT  nEndPara;
    USHORT  nDestPara;

    MoveParagraphsInfo( USHORT nS, USHORT nE, USHORT nD )
        { nStartPara = nS; nEndPara = nE; nDestPara = nD; }
};

#define EE_ACTION_PASTE 1
#define EE_ACTION_DROP  2

struct PasteOrDropInfos
{
    USHORT  nAction;
    USHORT  nStartPara;
    USHORT  nEndPara;
    SfxStyleSheet* pLevel0Style;
    SfxStyleSheet* pLevelNStyle;

    PasteOrDropInfos()
        {   nStartPara = 0xFFFF; nEndPara = 0xFFFF; 
            pLevel0Style = NULL; pLevelNStyle = NULL; nAction = 0; }
};

#endif // _MyEDITDATA_HXX
