/*************************************************************************
 *
 *  $RCSfile: fmprop.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: fs $ $Date: 2001/01/12 14:19:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_FMPROP_HXX
#define _SVX_FMPROP_HXX

#include <tools/string.hxx>

// struct zum mappen von PropertyNamen auf Property-Id's
struct FmPropertyInfo
{
	UniString     aName;
	UniString     aTranslation;
	sal_uInt32          nHelpId;
	sal_Int32           nId;
	sal_uInt16          nPos;
	sal_Bool            bMultiSelectable;

	FmPropertyInfo( const UniString&		rName,
					sal_Int32					_nId,
					sal_Bool					bMSel,
					const UniString&			aTranslation,
					sal_uInt16					nPosId,
					sal_uInt32					nHelpId=0);
};

// Service um Mappings aufzuloesen
class FmPropertyInfoService
{
	static sal_uInt16               nCount;
	static FmPropertyInfo*      pPropertyInfos;

public:
	static sal_Int32                getPropertyId(const UniString& sName);
	static UniString			getPropertyTranslation(sal_Int32 _nId);
	static sal_uInt32               getPropertyHelpId(sal_Int32 _nId);
	static sal_uInt16				getPropertyPos(sal_Int32 _nId);
	static sal_Bool					getPropertyMultiFlag(sal_Int32 _nId);
	static const FmPropertyInfo*	getPropertyInfo(sal_Int32 _nId);
	static const FmPropertyInfo*	getPropertyInfo(const UniString& sName);

private:
	static const FmPropertyInfo* getPropertyInfo();
};

#define PROP_NOTFOUND   -1

#define PROP_ID(string)     \
    FmPropertyInfoService::getPropertyId(string)

#define PROP_MULTI(string)      \
    FmPropertyInfoService::getPropertyMultiFlag(string)

#endif // _SVX_FMPROP_HXX


