/*************************************************************************
 *
 *  $RCSfile: sw3io.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mib $ $Date: 2001/10/12 14:07:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "core_pch.hxx"
#endif

#pragma hdrstop
#include <sot/object.hxx>
#include <stdio.h>
#define _SVSTDARR_USHORTS
#include <svtools/svstdarr.hxx>
#ifndef _SVSTOR_HXX //autogen
#include <so3/svstor.hxx>
#endif
#ifndef _ZFORLIST_HXX //autogen
#include <svtools/zforlist.hxx>
#endif

#include "doc.hxx"
#include "pam.hxx"
#include "rootfrm.hxx"
#include "swerror.h"
#include "sw3io.hxx"
#include "sw3imp.hxx"
#include "ndgrf.hxx"


Sw3Io::Sw3Io( SwDoc& r )
{
	pImp = new Sw3IoImp( *this );
	pImp->pDoc = &r;
	r.AddLink();
}


Sw3Io::~Sw3Io()
{
	delete pImp;
}


ULONG Sw3Io::Load( SvStorage* pStor, SwPaM* pPaM )
{
	// Wenn ein PaM angegeben ist, wird eingefuegt!
	// Beim Einfuegen werden vorhandene Vorlagen nicht uebergeplaettet
	pImp->pOldRoot = pImp->pRoot;
	pImp->pRoot = pStor;
	BOOL bGood = pImp->OpenStreams( FALSE );
	// Wenn die Streams nicht alle da sind, ist es KEIN FEHLER,
	// da ein OLE-Container u.U. nicht voll ist.
	if( !bGood )
	{
		pImp->pRoot = pImp->pOldRoot;
		pImp->pOldRoot.Clear();
		return pImp->nRes;
	}
	else
	{
		if ( pPaM )
		{
			pImp->bInsert = TRUE;
			pImp->bInsIntoHdrFtr = pImp->pDoc->IsInHeaderFooter(
													pPaM->GetPoint()->nNode );
		}
		else
			pImp->bInsert = pImp->bInsIntoHdrFtr = FALSE;

		if( pImp->bNormal )         		// nur setzen wenn normal gelesen wird,
			pImp->bAdditive = pImp->bInsert;// sonst ist es schon gueltig

		pImp->OutputMode( FALSE );
		// Man nehme die Doc-Groesse
		pImp->pContents->Seek( STREAM_SEEK_TO_END );
		ULONG nSize = pImp->pContents->Tell();
		pImp->pContents->Seek( 0L );
		pImp->OpenPercentBar( 0L, nSize );
		if( pImp->bNormal )
			pImp->LoadDrawingLayer();
		if( ( pImp->bNormal || pImp->bTxtColls || pImp->bCharFmts || pImp->bFrmFmts ) && !pImp->nRes )
			pImp->LoadStyleSheets( BOOL( !pImp->bAdditive ) );
		if( ( pImp->bNormal || pImp->bNumRules || pImp->bPageDescs ) && !pImp->nRes )
			pImp->LoadNumRules();
		if( ( pImp->bNormal || pImp->bPageDescs ) && !pImp->nRes )
			pImp->LoadPageStyles();
		if( pImp->bNormal && !pImp->nRes )
			pImp->LoadContents( pPaM );
		pImp->ClosePercentBar();

		//Benachrichtigungen fuer OLE-Objekte
		if ( pImp->bInsert ) //Eingefuege wurden markiert
			pImp->pDoc->PrtOLENotify( FALSE );
		else if ( pImp->pDoc->IsOLEPrtNotifyPending() ||//Drucker geaendert
				  pImp->nVersion < SWG_OLEPRTNOTIFY )	//Ruecksicht auf Math, dass
														//sowieso Hautpanwender ist.
		{
			pImp->pDoc->PrtOLENotify( TRUE );
		}

		// unbenutzte OLE-Objekte lschen, falls ein 3.0-Dok
		// geladen wird
		if( pImp->nVersion<=SWG_SHORTFIELDS &&
			pImp->bNormal && !pImp->bBlock && !pImp->bInsert && !pImp->nRes  )
			pImp->RemoveUnusedObjects();

		if( pImp->nRes )
			pImp->nRes |= ERRCODE_CLASS_READ;
		else if( pImp->bNoDrawings )
			pImp->nRes = WARN_SWG_NO_DRAWINGS;
		else if( pImp->nWarn )
			pImp->nRes = pImp->nWarn | ERRCODE_CLASS_READ;

		pImp->CloseStreams();
		if( pPaM || pImp->bBlock )
			pImp->pRoot = pImp->pOldRoot, pImp->pOldRoot.Clear();

		SvNumberFormatter* pN;
		if( pImp->bInsert &&
			0 != ( pN = pImp->pDoc->GetNumberFormatter( FALSE ) ))
			pN->ClearMergeTable();
	}
	return pImp->nRes;
}


ULONG Sw3Io::Save( SwPaM* pPaM, BOOL bSaveAll )
{
	if( !pImp->pRoot.Is() )
		pImp->pRoot = pImp->pDoc->GetPersist()->GetStorage();

	if( pImp->bNormal && pImp->IsSw31Or40Export() &&
		pImp->pDoc->GetNodes().GetEndOfContent().GetIndex() > 65200 )
	{
		// Das Dokument ist zu gross, um vom SW3.1/4.0 gelesen zu werden.
		return ERR_SWG_LARGE_DOC_ERROR;
	}

	ULONG nHiddenDraws = ULONG_MAX;
	if( pImp->bNormal && !pImp->IsSw31Or40Export() )
	{
		pImp->InsertHiddenDrawObjs();
		nHiddenDraws = pImp->nHiddenDrawObjs;
	}
	BOOL bGood = pImp->OpenStreams( TRUE );
	ASSERT( bGood, "Es fehlen leider ein paar Streams!" );
	pImp->nHiddenDrawObjs = nHiddenDraws; // OpenStreams loescht den Member!
	if( !bGood )
	{
		if( pImp->nHiddenDrawObjs != ULONG_MAX )
			pImp->RemoveHiddenDrawObjs();
		return ERR_SWG_WRITE_ERROR;
	}

	// Bookmarks sammeln: Wenn kein Inhalt geschrieben wird, nur die
	// in Seitenvorlagen
	if( pImp->bNormal || pImp->bPageDescs )
	{
		pImp->CollectMarks( pPaM, !pImp->bNormal );
		if( !pImp->IsSw31Or40Export() )
			pImp->CollectRedlines( pPaM, !pImp->bNormal );
		else
			pImp->CollectTblLineBoxFmts40();
	}


	pImp->bSaveAll = bSaveAll;
	BOOL bNewPaM = BOOL( pPaM == NULL );
	if( bNewPaM )
	{
		pImp->bSaveAll = TRUE;
		pPaM = new SwPaM( pImp->pDoc->GetNodes().GetEndOfContent() );
		pPaM->Move( fnMoveForward, fnGoDoc );
		pPaM->SetMark();
		pPaM->Move( fnMoveBackward, fnGoDoc );
	}
	// Den Doc-Hauptbereich als Mass der Dinge beim Speichern nehmen
	ULONG n1 = pImp->pDoc->GetNodes().GetEndOfExtras().GetIndex();
	ULONG n2 = pImp->pDoc->GetNodes().GetEndOfContent().GetIndex();
	USHORT nPages = pImp->pDoc->GetRootFrm() ?
					pImp->pDoc->GetRootFrm()->GetPageNum() : 0;
	// Wir nehmen einfach 10 Nodes/Page an
	n2 += nPages * 10;
	pImp->OpenPercentBar( n1, n2 );
	if( pImp->bNormal || pImp->bTxtColls )
	{
		// Stringpool fuellen, Namen im Doc erweitern
		pImp->aStringPool.Setup( *pImp->pDoc, pImp->pRoot->GetVersion(),
								 pImp->pExportInfo );
		pImp->SaveStyleSheets( FALSE );
		// Temporaere Namenserweiterungen entfernen
		pImp->aStringPool.RemoveExtensions( *pImp->pDoc );
	}
	if( ( pImp->bNormal || pImp->bNumRules ) && !pImp->nRes )
		pImp->SaveNumRules();
	if( ( pImp->bNormal || pImp->bPageDescs ) && !pImp->nRes )
		pImp->SavePageStyles();
	if( pImp->bNormal && !pImp->nRes )
		pImp->SaveDrawingLayer();
	if( pImp->bNormal && !pImp->nRes )
		pImp->SaveContents( *pPaM );
	if( bNewPaM )
		delete pPaM;

	if( pImp->nHiddenDrawObjs != ULONG_MAX )
		pImp->RemoveHiddenDrawObjs();

	if( pImp->nRes )
		pImp->nRes |= ERRCODE_CLASS_WRITE;
	else if( pImp->nWarn )
		pImp->nRes = pImp->nWarn | ERRCODE_CLASS_WRITE;

	//pImp->pRoot->Commit();

	ULONG nErr = pImp->pRoot->GetError();
	if( nErr == SVSTREAM_DISK_FULL )
		pImp->nRes = ERR_W4W_WRITE_FULL;
	else if( nErr != SVSTREAM_OK )
		pImp->nRes = ERR_SWG_WRITE_ERROR;
	pImp->ClosePercentBar();
	pImp->CloseStreams();

	return pImp->nRes;
}


// Speichern in einen frischen Storage.

ULONG Sw3Io::SaveAs( SvStorage* pStor, SwPaM* pPaM, BOOL bSaveAll )
{
	pImp->pOldRoot = pImp->pRoot;
	pImp->pRoot = pStor;
	ULONG nRet = Save( pPaM, bSaveAll );
	pImp->pRoot = pImp->pOldRoot;
	pImp->pOldRoot.Clear();
	return nRet;
}


void Sw3Io::HandsOff()
{
	pImp->pRoot.Clear();
}

// Ende eines Save/SaveAs/HandsOff.
// Falls der Storage gewechselt hat, muessen die Streams
// neu geoeffnet werden.


BOOL Sw3Io::SaveCompleted( SvStorage* pNew )
{
	BOOL bClearNm = !pNew || pNew == pImp->pRoot;

	if( pNew )
		pImp->pRoot = pNew;
	else
		pImp->pRoot = pImp->pDoc->GetDocStorage();

	// Hier muss noch ueber die Grafiknodes iteriert werden, um
	// ihnen zu sagen, wie ihr neuer Streamname lautet!
	// Da Grafiken Flys sind, liegen die Nodes im Autotext-Bereich
	SwNodes& rNds = pImp->pDoc->GetNodes();
	ULONG nEnd = rNds.GetEndOfAutotext().GetIndex();
	for( ULONG nIdx = rNds.GetEndOfInserts().GetIndex() + 1; nIdx < nEnd; ++nIdx)
	{
		SwGrfNode* pNd = rNds[ nIdx ]->GetGrfNode();
		if( pNd )
			pNd->SaveCompleted( bClearNm );
	}

	return TRUE;
}


SvStorage* Sw3Io::GetStorage()
{
	if( !pImp->pRoot.Is() )
		pImp->pRoot = pImp->pDoc->GetPersist()->GetStorage();
	return &pImp->pRoot;
}


void Sw3Io::SetDoc( SwDoc& r )
{
	pImp->SetDoc( r );
}


void Sw3Io::SetReadOptions( const SwgReaderOption& rOpt, BOOL bOverwrite )
{
	pImp->SetReadOptions( rOpt, bOverwrite );
}


void Sw3Io::SetSw31Export( BOOL b31 )
{
	pImp->SetSw31Export( b31 );
}


ULONG Sw3Io::LoadStyles( SvStorage* pStor )
{
	SvStorageRef aRoot = pImp->pRoot;
	pImp->pRoot = pStor;
	pImp->OpenStreams( FALSE );
	BOOL bGood = BOOL( pImp->pRoot.Is()
					&& pImp->pPageStyles.Is()
					&& pImp->pStyles.Is() );
	if( bGood && pImp->pRoot->GetVersion() > SOFFICE_FILEFORMAT_40 )
		bGood = pImp->pNumRules.Is();
	ASSERT( bGood, "Es fehlen leider ein paar Streams!" );

	pImp->bOrganizer = TRUE;
	if( bGood )
	{
		pImp->LoadStyleSheets( BOOL( !pImp->bAdditive ) );
		pImp->LoadNumRules();
		pImp->LoadPageStyles();
	}
	pImp->CloseStreams();
	pImp->pRoot = aRoot;

	SvNumberFormatter* pN;
	if( pImp->bInsert &&
		0 != ( pN = pImp->pDoc->GetNumberFormatter( FALSE ) ))
		pN->ClearMergeTable();

	pImp->bOrganizer = FALSE;

	if( pImp->nRes )
		pImp->nRes |= ERRCODE_CLASS_READ;
	else if( pImp->nWarn )
		pImp->nRes = pImp->nWarn | ERRCODE_CLASS_READ;
	return pImp->nRes;
}


ULONG Sw3Io::SaveStyles()
{
	BOOL bGood = pImp->OpenStreams( TRUE, FALSE );
	ASSERT( bGood, "Es fehlen leider ein paar Streams!" );
	if( !bGood )
		return pImp->nRes = ERR_SWG_WRITE_ERROR;

	pImp->bOrganizer = TRUE;

	// Nur Bookmarks aus Seiten-Vorlagen sammeln
	pImp->CollectMarks( NULL, TRUE );
	if( !pImp->IsSw31Or40Export() )
		pImp->CollectRedlines( NULL, TRUE );
	else
		pImp->CollectTblLineBoxFmts40();

	// Stringpool fuellen, Namen im Doc erweitern
	pImp->aStringPool.Setup( *pImp->pDoc, pImp->pRoot->GetVersion(),
							 pImp->pExportInfo );
	pImp->SaveStyleSheets( FALSE );
	// Temporaere Namenserweiterungen entfernen
	pImp->aStringPool.RemoveExtensions( *pImp->pDoc );
	pImp->SaveNumRules( FALSE );
	pImp->SavePageStyles();
	pImp->CloseStreams();

	pImp->bOrganizer = FALSE;

	if( pImp->nRes )
		pImp->nRes |= ERRCODE_CLASS_WRITE;
	else if( pImp->nWarn )
		pImp->nRes = pImp->nWarn | ERRCODE_CLASS_WRITE;
	return pImp->nRes;
}

// Erzeugen eines eindeutigen Stream-Namens in einem Storage


String Sw3Io::UniqueName( SvStorage* pStg, const sal_Char* p )
{
	String aName;
	sal_Char cBuf[ 32 ];

	// Man nehme die Adresse von cBuf auf dem Stack als Anfangswert
	// aber nur ein einziges mal (bug fix 20976)
#ifdef SINIX
	static ULONG nId = 0;
	if ( ! nId )
		nId = (ULONG) cBuf;
#else
	static ULONG nId = (ULONG) cBuf;
#endif

	nId++;
	for( ;; )
	{
		sprintf( cBuf, "%s%08lX", p, nId );
		aName.AssignAscii( cBuf );
		if( !pStg->IsContained( aName ) )
			break;
		nId++;
	}
	return aName;
}


ULONG Sw3Io::GetSectionList( SvStorage *pStor, SvStrings& rSectionList )
{
	ULONG nRes = pImp->OpenStreamsForScan( pStor, TRUE );
	if( nRes )
		return nRes;

	SvStringsDtor aBookmarks;

	// zuerst die Page-Styles durchsuchen
	pImp->pPageStyles->Seek( 0L );
	pImp->pPageStyles->SetBufferSize( SW3_BSR_PAGESTYLES );
	pImp->pStrm = pImp->pPageStyles;
	pImp->GetSectionList( rSectionList, aBookmarks );
	pImp->pStrm = NULL;
	pImp->CheckIoError( pImp->pPageStyles );
	pImp->pPageStyles->SetBufferSize( 0 );

	if( !pImp->nRes )
	{
		// und jetzt den Contents-Stream
		pImp->pContents->Seek( 0L );
		pImp->pContents->SetBufferSize( SW3_BSR_CONTENTS );
		pImp->pStrm = pImp->pContents;
		pImp->GetSectionList( rSectionList, aBookmarks );
		pImp->pStrm = NULL;
		pImp->CheckIoError( pImp->pContents );
		pImp->pContents->SetBufferSize( 0 );
	}

	nRes = pImp->nRes;
	if( nRes )
		nRes |= ERRCODE_CLASS_READ;
//	else if( pImp->nWarn )
//		nRes = pImp->nWarn | ERRCODE_CLASS_READ;

	pImp->CloseStreamsForScan();

	return nRes;
}

ULONG Sw3Io::GetMacroTable( SvStorage *pStor, SvxMacroTableDtor& rMacroTbl )
{
	ULONG nRes = pImp->OpenStreamsForScan( pStor, FALSE );
	if( nRes )
		return nRes;

	pImp->pContents->Seek( 0L );
	pImp->pContents->SetBufferSize( SW3_BSR_CONTENTS );
	pImp->pStrm = pImp->pContents;
	pImp->GetMacroTable( rMacroTbl );
	pImp->pStrm = NULL;
	pImp->CheckIoError( pImp->pContents );
	pImp->pContents->SetBufferSize( 0 );

	nRes = pImp->nRes;
	if( nRes )
		nRes |= ERRCODE_CLASS_READ;
//	else if( pImp->nWarn )
//		nRes = pImp->nWarn | ERRCODE_CLASS_READ;

	pImp->CloseStreamsForScan();

	return nRes;
}

