/*************************************************************************
 *
 *  $RCSfile: dmpstr.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 00:08:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SWGSTR_HXX
#define _SWGSTR_HXX

#include <iostream.h>

typedef long long3;						// Zur Dokumentation: 3-byte-Longs

#define MAX_BEGIN 64					// Maximale Blockschachtelung
#define PASSWDLEN 16					// Maximale Passwortlaenge

// Basisklasse: nur Passwort- und Codierungs-Funktionalitaet

class swstream {
protected:
	char   cPasswd[ PASSWDLEN ];		// Passwort-Puffer
	BOOL   bPasswd;						// TRUE wenn mit Passwort
	void   encode( char*, USHORT );		// Puffer codieren/decodieren
public:
	swstream();
	void setpasswd( const char* );		// Passwort setzen
	void copypasswd( const char* );		// Passwort direkt setzen
	const char* getpasswd() { return cPasswd; }
};

// Basisklasse fuer I/O: gepufferte I/O und I/O von Zahlen

class swiostream : public swstream {
protected:
	streambuf* sbuf;					// Stream-Buffer
	char*  fbuf;						// Datenpuffer
	long   fpos;						// Puffer-Start in Datei
	short  foff;						// Offset in Puffer
	short  fsiz;						// Puffergroesse
	short  fstate;						// IOS-Bits
	short  flonglen;					// Laenge eines Longs (3 oder 4)
	BOOL   fdirty;						// TRUE, wenn Puffer dirty
	swiostream( const swiostream& );
	int operator=( const swiostream& );
public:
	swiostream( streambuf* );
	~swiostream();
	void long3() 						{ flonglen = 3; }
	void long4() 						{ flonglen = 4; }
	void sync();						// Angleichen der pos nach Direktzugriff
	void sync( const swiostream& );		// Angleichen zweier Streams

	void setgood();
	void setbad();
	void seek( long );					// Positionieren/Einlesen
	long tell()							{ return fpos + foff; }
	long filesize(); 					// Dateigroesse
	void flush();						// Puffer schreiben

	int good() 							{ return !(fstate & ios::badbit); }
	int bad()  							{ return  (fstate & ios::badbit); }
	int operator!() 					{ return  (fstate & ios::badbit); }
	int eof()							{ return  (fstate & ios::eofbit); }

	BYTE get();
	void get( void*, USHORT );
	void put( BYTE );
	void put( const void*, USHORT );

	inline swiostream& operator>>( char& );
	inline swiostream& operator>>( BYTE& );
	inline swiostream& operator>>( short& );
	inline swiostream& operator>>( USHORT& );
		   swiostream& operator>>( long& );
	inline swiostream& operator>>( ULONG& );

	inline swiostream& operator<<( char );
	inline swiostream& operator<<( BYTE );
	inline swiostream& operator<<( short );
	inline swiostream& operator<<( USHORT );
		   swiostream& operator<<( long );
	inline swiostream& operator<<( ULONG );
};

// Reader/Writer-Stream-Basisklasse mit Pufferverwaltung fuer Texte

class swstreambase : public swiostream {
protected:
	char*  buf;							// Zwischenpuffer
	USHORT buflen;						// Laenge des Zwischenpuffers
	void   checkbuf( USHORT );			// Testen der Pufferlaenge
	swstreambase( streambuf* );
	swstreambase( const swstreambase& );
	int operator=( const swstreambase& );
public:
	~swstreambase();
	void clear();						// Puffer loeschen
	char* GetBuf()    					{ return buf; }
};

class swistream : public swstreambase {
	istream& s;
	BYTE   cType;						// Record-Typ
	long   offset;						// Record-Offset-Portion
	swistream( const swistream& );
	int operator=( const swistream& );
public:
	swistream( istream& );
	~swistream();
	istream& Strm();

	USHORT nCount[ 256 ];				// Anzahl Records (Statistik)
	long   nSize[ 256 ];				// Laenge Records (Statistik)

	BYTE peek();						// 1 Byte testen
	BYTE next();						// Blockstart
	BYTE cur() { return cType; }		// aktueller Block
	BYTE skipnext();					// Record ueberspringen
	void undonext();					// next() rueckgaengig machen
	long getskip()						{ return offset; }
	void skip( long = -1L );			// Block ueberspringen
	char* text();						// Textstring lesen (nach BEGIN)
	long size();						// aktuelle Record-Laenge
	void checkpos();					// Test, ob Record abgearbeitet ist

	inline swistream& operator>>( char& );
	inline swistream& operator>>( BYTE& );
	inline swistream& operator>>( short& );
	inline swistream& operator>>( USHORT& );
	inline swistream& operator>>( long& );
	inline swistream& operator>>( ULONG& );

};

class swostream : public swstreambase {
	ostream& s;
	long  offset[ MAX_BEGIN ];			// File-Offsets
	short level;						// Blockschachtelung
	BYTE  cTextType;					// Art des naechsten Text-Records
	swostream( const swostream& );
	int operator=( const swostream& );
public:
	swostream( ostream& );
	~swostream();
	ostream& Strm();

	void begin (BYTE);					// Blockstart
	void end();							// Blockende
	void push();						// Pos merken, Platz fuer USHORT
	void pop( USHORT );					// USHORT an Pos schreiben

	void SetTextType( BYTE ch )			{ cTextType = ch; }

	inline swostream& operator<<( char );
	inline swostream& operator<<( BYTE );
	inline swostream& operator<<( short );
	inline swostream& operator<<( USHORT );
	inline swostream& operator<<( long );
	inline swostream& operator<<( ULONG );
		   swostream& operator<<( const char* );
};

inline swiostream& swiostream::operator<<( char c )
{
	put( (BYTE) c ); return *this;
}

inline swiostream& swiostream::operator<<( BYTE c )
{
	put( c ); return *this;
}

inline swiostream& swiostream::operator<<( short c )
{
	put( (BYTE) c ); put( (BYTE) ( c>>8 ) ); return *this;
}

inline swiostream& swiostream::operator<<( USHORT c )
{
	put( (BYTE) c ); put( (BYTE) ( c>>8 ) ); return *this;
}

inline swiostream& swiostream::operator<<( ULONG c )
{
	return *this << (long) c;
}

inline swiostream& swiostream::operator>>( char& c )
{
	c = (char) get(); return *this;
}

inline swiostream& swiostream::operator>>( BYTE& c )
{
	c = get(); return *this;
}

inline swiostream& swiostream::operator>>( short& c )
{
	c = get(); c |= ( (short) get() << 8 ); return *this;
}

inline swiostream& swiostream::operator>>( USHORT& c )
{
	c = get(); c |= ( (short) get() << 8 ); return *this;
}

inline swiostream& swiostream::operator>>( ULONG& c )
{
	return *this >> (long&) c;
}

// Das ganze noch einmal, um Casting oder Schachtelung von
// inline-Routinen zu vermeiden

inline swostream& swostream::operator<<( char c )
{
	put( (BYTE) c ); return *this;
}

inline swostream& swostream::operator<<( BYTE c )
{
	put( c ); return *this;
}

inline swostream& swostream::operator<<( short c )
{
	put( (BYTE) c ); put( (BYTE) ( c>>8 ) ); return *this;
}

inline swostream& swostream::operator<<( USHORT c )
{
	put( (BYTE) c ); put( (BYTE) ( c>>8 ) ); return *this;
}

inline swostream& swostream::operator<<( long c )
{
	(swiostream&) *this << c; return *this;
}

inline swostream& swostream::operator<<( ULONG c )
{
	(swiostream&) *this << (long) c; return *this;
}

inline swistream& swistream::operator>>( char& c )
{
	c = (char) get(); return *this;
}

inline swistream& swistream::operator>>( BYTE& c )
{
	c = get(); return *this;
}

inline swistream& swistream::operator>>( short& c )
{
	c = get(); c |= ( (short) get() << 8 ); return *this;
}

inline swistream& swistream::operator>>( USHORT& c )
{
	c = get(); c |= ( (short) get() << 8 ); return *this;
}

inline swistream& swistream::operator>>( long& c )
{
	(swiostream&) *this >> c; return *this;
}

inline swistream& swistream::operator>>( ULONG& c )
{
	(swiostream&) *this >> (long&) c; return *this;
}


#endif
