/*************************************************************************
 *
 *  $RCSfile: rdr.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 00:08:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _RDR_HXX
#define _RDR_HXX

#define _SWGDUMPER
#include "dmpstr.hxx"
#include "swgids.hxx"
#include <iostream.h>

extern ostream_withassign list;

class SwgDumper {

	long	nDocStart;
	long	nNextDoc;

	void	LoadHeader();
	void	DumpHeader();
	void 	InTxtFmtCollParents();
	void 	InTxtFmtCollNexts();
	void 	InTxtFmtColl( USHORT nIdx );
	void 	InTxtFmtColls();
	void 	InPageFtnInfo();
	void 	InPageDesc( USHORT nIdx );
	void 	InPageDescs();
	void 	InTableBox();
	void 	InTableLine();
	void 	InTable();
	void 	InTextHints();
	void 	InNodeBookmark();
	void 	InTxtNode();
	void 	InGrfNode();
	void 	InOLENode();
	void 	InTOXBase();
	void 	InTOX();
	void 	InFlyFrames();
	void 	InDfltFmts();
	void 	InAutoFmts();
	void	InNamedFmts();
	void 	InNumFmt();
	void 	InNumRules( char* pText );
	void 	InNumRulesBlock();
	void 	InJobSetup();
	void 	InNewJobSetup();
	void 	InDocInfo();
	void 	InFtnInfo();
	void	InFieldTypes();
	void	InFieldType();
	void    InComment();

	void	InFrames();

	void	InHint();

public:
	swistream  r;
	DocHeader  aHdr;
	FileHeader aFile;

	SwgDumper( istream& );
	void	LoadFileHeader();
	BOOL	Read();
	void 	InDynDocInfo();

	void	DumpFmt( const char* pName, USHORT nId );
	void	FmtNumber( USHORT nId );
	char* 	GetText( BOOL bReq = TRUE );
	void	InNodes();
	void	InTextBlock();
	void 	InContents();
	void 	InTOXContents();
	void 	InMacroTbl();
	void 	InFormat( char* pDesc );
	void 	Error( const char* pText );
	void	InField();
	void	InColor();
	void	InPen();
	void	InBrush( char* pText );

	void	RecordStatistics();
	void 	FieldStatistics();
	void	LayoutStatistics();
};

#endif

