/*************************************************************************
 *
 *  $RCSfile: bbmgr.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:14:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// #include *****************************************************************

#ifdef PRECOMPILED
#include "ui_pch.hxx"
#endif

#pragma hdrstop

#include "errhdl.hxx"
#include "linetype.hxx"

// Globals ******************************************************************

static const SwLineType __FAR_DATA aLineTypeArr[] =
{
//  In          Out         Dist
	LIN_0,      LIN_1,      LIN_0, // Einfache Linien
	LIN_0,		LIN_2,		LIN_0,
	LIN_0,		LIN_3,	    LIN_0,
	LIN_0,		LIN_5,		LIN_0,
	LIN_1,      LIN_1,      LIN_2, // Doppelte Linien
	LIN_2,      LIN_2,      LIN_2, // Doppelte Linien
	LIN_3,		LIN_3,		LIN_3,
	LIN_3,		LIN_2, 		LIN_2,
	LIN_2,		LIN_3, 		LIN_2,
	LIN_4,		LIN_3, 		LIN_3,
	LIN_3,		LIN_4, 		LIN_3
};


// **************************************************************************



USHORT GetLineTypeCount()
{
	return (sizeof(aLineTypeArr) / sizeof(SwLineType));
}



const SwLineType& GetLineType(USHORT nIdx)
{
	ASSERT(nIdx < GetLineTypeCount(), "Ungueltiger LineTypeIndex");
	return aLineTypeArr[nIdx];
}

// **************************************************************************

/*------------------------------------------------------------------------
	$Log: bbmgr.cxx,v $
	Revision 1.1.1.1  2000/09/18 17:14:37  hr
	initial import
	
	Revision 1.69  2000/09/18 16:05:32  willem.vandorp
	OpenOffice header added.
	
	Revision 1.68  1997/11/24 16:40:08  MA
	include
	

	  Rev 1.67   24 Nov 1997 17:40:08   MA
   include

	  Rev 1.66   03 Nov 1997 13:19:48   MA
   precomp entfernt

	  Rev 1.65   15 Oct 1996 17:45:38   MA
   veraltetes entfernt

	  Rev 1.64   28 Aug 1996 11:52:44   OS
   includes

	  Rev 1.63   24 Nov 1995 16:58:08   OM
   PCH->PRECOMPILED

	  Rev 1.62   07 Nov 1995 15:52:32   MA
   chg/fix/opt: statics

	  Rev 1.61   22 Nov 1994 13:08:52   PK
   die beiden manager sind weg

	  Rev 1.60   28 Oct 1994 19:13:46   MA
   Reimport frmatr.

	  Rev 1.59   25 Oct 1994 18:14:30   ER
   add: PCH

	  Rev 1.58   11 Oct 1994 16:16:12   MS
   Reaktivierung nach Sfx-Umstellung

	  Rev 1.57   06 Oct 1994 10:18:56   MS
   Anpassung Patchlevel g

	  Rev 1.56   15 Sep 1994 16:34:56   MS
   Reanimation die 1.

	  Rev 1.55   08 Sep 1994 15:25:52   SWG
   Update Fix

	  Rev 1.54   07 Sep 1994 17:43:14   SWG
   Umstellung Attribute

------------------------------------------------------------------------*/


