/*************************************************************************
 *
 *  $RCSfile: wizmm.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: os $ $Date: 2001/09/28 07:21:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ui_pch.hxx"
#endif

#pragma hdrstop

#include "hintids.hxx"


#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SV_COMBOBOX_HXX //autogen
#include <vcl/combobox.hxx>
#endif


#include "swtypes.hxx"
#include "fldbas.hxx"  // TYP_FIXDATEFLD zum Fuellen der DateListbox
#include "wizmm.hxx"
#include "wizpage.hxx"
#include "wizard.hrc"
#include "helpid.h"
#include "numfmtlb.hxx"
#ifndef _FILEDLGHELPER_HXX
#include <sfx2/filedlghelper.hxx>
#endif

using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star;
using namespace ::rtl;
using namespace ::sfx2;
#define C2U(cChar) rtl::OUString::createFromAscii(cChar)


////////////////////////////////////////////////////////////////////////////////
//
// @@@@@ @@ @@ @@@@@ @@  @@ @@@@ @@  @@  @@@@  @@  @@ @@@@@  @@   @@@@@ @@@@@
// @@    @@ @@ @@    @@@ @@  @@  @@  @@ @@  @@ @@@ @@ @@  @@ @@   @@    @@  @@
// @@    @@ @@ @@    @@@@@@  @@  @@  @@ @@  @@ @@@@@@ @@  @@ @@   @@    @@  @@
// @@@@  @@@@@ @@@@  @@@@@@  @@  @@@@@@ @@@@@@ @@@@@@ @@  @@ @@   @@@@  @@@@@
// @@     @@@  @@    @@ @@@  @@  @@  @@ @@  @@ @@ @@@ @@  @@ @@   @@    @@  @@
// @@     @@@  @@    @@  @@  @@  @@  @@ @@  @@ @@  @@ @@  @@ @@   @@    @@  @@
// @@@@@   @   @@@@@ @@  @@  @@  @@  @@ @@  @@ @@  @@ @@@@@  @@@@ @@@@@ @@  @@
//
////////////////////////////////////////////////////////////////////////////////

IMPL_LINK_INLINE_START( MemoDialog, StyleClickHdl, RadioButton *, pBtn )
{
	BYTE nStyle=0;
	if (p1_RBtn_Stil1->IsChecked()) nStyle=0;
	if (p1_RBtn_Stil2->IsChecked()) nStyle=1;
	if (p1_RBtn_Stil3->IsChecked()) nStyle=2;
	SetStyle(nStyle);
	return 0;
}
IMPL_LINK_INLINE_END( MemoDialog, StyleClickHdl, RadioButton *, pBtn )

IMPL_LINK_INLINE_START( MemoDialog, TitlModifyHdl, Edit *, pEdt )
{
	aPage1.aTitl.SetStr(pEdt->GetText(),&aPrevWin);
	CheckTitlOnOff();
	ArrangeObjects();
	return 0;
}
IMPL_LINK_INLINE_END( MemoDialog, TitlModifyHdl, Edit *, pEdt )

IMPL_LINK_INLINE_START( MemoDialog, TitlRBtnHdl, RadioButton *, pBtn )
{
	aPage1.aTitl.SetModeGraf(&aPrevWin,p1_RBtn_TitGrf->IsChecked());
	CheckTitlOnOff();
	SetElemDisable();
	ArrangeObjects();
	return 0;
}
IMPL_LINK_INLINE_END( MemoDialog, TitlRBtnHdl, RadioButton *, pBtn )

IMPL_LINK( MemoDialog, TitlPBtnHdl, PushButton *, pBtn )
{
    FileDialogHelper* pFileDlg = new FileDialogHelper( SFXWB_GRAPHIC );
    pFileDlg->SetTitle(SW_RESSTR(STR_Mem_WTGrphic));

    if( ERRCODE_NONE == pFileDlg->Execute() )
	{
        String sPath(pFileDlg->GetPath());
        aPage1.aTitl.SetGraphic( sPath, pFileDlg->GetCurrentFilter(),
									&aPrevWin);
        FNam2FixedText( sPath, *p1_Text_TitGrf );
	}
	CheckTitlOnOff();
	ArrangeObjects();
    delete pFileDlg;
    return 0;
}


////////////////////////////////////////////////////////////////////////////////
// MemoDialog
////////////////////////////////////////////////////////////////////////////////

MemoDialog::MemoDialog(Window* pParent)
	: WizardMemoDialog(pParent)
{
	Init();
	aPrevWin.SetPage(&aPage1);
	pDoku->SetPtr(pOkayBtn);

	InitElemUI();

	GetFromDef();  // Harte Defaults setzen
	GetFromIni();  // Defaults vom Inifile holen

	SetEventHandler();

	pDoku->ToUI();
	LogoToUI();
	FillDocInfoList();
	SetElemDisable();

	CheckElements();
	CheckTitlOnOff();
	CheckKopzFusz();
	ArrangeObjects();

	Inc();
}


////////////////////////////////////////////////////////////////////////////////
//
//  @@@@  @@@@@ @@@@   @@@@@ @@@@   @@@@  @@   @@
// @@  @@ @@     @@    @@    @@ @@ @@  @@ @@@ @@@
// @@     @@     @@    @@    @@ @@ @@  @@ @@@@@@@
// @@ @@@ @@@@   @@    @@@@  @@@@  @@  @@ @@@@@@@
// @@  @@ @@     @@    @@    @@ @@ @@  @@ @@ @ @@
// @@  @@ @@     @@    @@    @@ @@ @@  @@ @@   @@  @@ @@ @@
//  @@@@@ @@@@@  @@    @@    @@ @@  @@@@  @@   @@  @@ @@ @@
//
////////////////////////////////////////////////////////////////////////////////

void MemoDialog::GetFromDef()
{
	p1_RBtn_Stil1->Check();
	aPage1.aTitl.SetStr(p1_CBox_TitTxt->GetText(),&aPrevWin);
	// p2_List_Datum->SelectEntryPos(0);  // Datum Standard kurz
	p2_CBox_Betref->Check();
	p2_CBox_MemoAn->Check();
	p2_CBox_MemoVn->Check();

	p3_CBox_KDatum->Check();
	p3_CBox_KThema->Check();
	p3_CBox_KTrnLn->Check();

	p3_CBox_FVertr->Check();
	p3_CBox_FTrnLn->Check();
}

void MemoDialog::GetFromIni()
{
	if(!aConfig.HasValuesRead())
		return;
	switch(aConfig.nTemplateStylePreferredStyle)
	{
		case 0: p1_RBtn_Stil1->Check(TRUE);break;
		case 1: p1_RBtn_Stil2->Check(TRUE);break;
		default: p1_RBtn_Stil3->Check(TRUE);
	}
	StyleClickHdl(NULL);
	aPage1.aTitl.SetStr(aConfig.sTemplateTitleText);

	aPage1.aTitl.SetModeGraf(NULL,aConfig.bTemplateTitleIsGraphic);
	aPage1.aTitl.SetGraphic(aConfig.sTemplateTitleFileName, aConfig.sTitleFileFilter);

	p2_CBox_Datum->Check(aConfig.bElementsDateValueVisible);
	p2_List_Datum->SelectEntryPos(aConfig.nElementsDateValueContent);
	p2_CBox_Betref->Check(aConfig.bElementsSubjectTextVisible);
	p2_Edit_Betref->SetText(aConfig.sElementsSubjectTextContent);
	p2_CBox_MemoAn->Check(aConfig.bElementsTo);
	p2_CBox_KopiAn->Check(aConfig.bElementsCopy);
	p2_CBox_MemoVn->Check(aConfig.bElementsFrom);
	p2_CBox_Elem1->Check(aConfig.bElementsElement1TextVisible);
	p2_Edit_Elem1->SetText(aConfig.sElementsElement1TextContent);
	p2_CBox_Elem2->Check(aConfig.bElementsElement2TextVisible);
	p2_Edit_Elem2->SetText(aConfig.sElementsElement2TextContent);
	p2_CBox_Elem3->Check(aConfig.bElementsElement3TextVisible);
	p2_Edit_Elem3->SetText(aConfig.sElementsElement3TextContent);
	p2_CBox_Elem4->Check(aConfig.bElementsElement4TextVisible);
	p2_Edit_Elem4->SetText(aConfig.sElementsElement4TextContent);

	p3_CBox_KDatum->Check(aConfig.bHeaderDate);
	p3_CBox_KThema->Check(aConfig.bHeaderTitle);
	p3_CBox_KPgNum->Check(aConfig.bHeaderPageNumber);
	p3_CBox_KTrnLn->Check(aConfig.bHeaderSeparator);
	p3_CBox_FDatum->Check(aConfig.bFooterDate);
	p3_CBox_FVertr->Check(aConfig.bFooterConfidentialLevelVisible);
	p3_Edit_FVertr->SetText(aConfig.sFooterConfidentialLevelContent);
	p3_CBox_FPgNum->Check(aConfig.bFooterPageNumber);
	p3_CBox_FTrnLn->Check(aConfig.bFooterSeparator);

	FillDocInfoList();
	aConfig.ReadDocInfo(*pDoku);
}

void MemoDialog::WriteToIni()
{
	aConfig.nTemplateStylePreferredStyle = p1_RBtn_Stil1->IsChecked() ? 0 :
		p1_RBtn_Stil2->IsChecked() ? 1 : 2;

	aConfig.sTemplateTitleText = aPage1.aTitl.GetStr();

	String aStr1,aStr2;
	aPage1.aTitl.GetGraphic(aStr1,aStr2);
	aConfig.bTemplateTitleIsGraphic = aPage1.aTitl.IsGrafLogo();
	aConfig.sTemplateTitleFileName = aStr1;
	aConfig.sTitleFileFilter = aStr2;

	aConfig.bElementsElement1TextVisible = p2_CBox_Elem1->IsChecked();
	aConfig.sElementsElement1TextContent = p2_Edit_Elem1->GetText();
	aConfig.bElementsElement2TextVisible = p2_CBox_Elem2->IsChecked();
	aConfig.sElementsElement2TextContent = p2_Edit_Elem2->GetText();
	aConfig.bElementsElement3TextVisible = p2_CBox_Elem3->IsChecked();
	aConfig.sElementsElement3TextContent = p2_Edit_Elem3->GetText();
	aConfig.bElementsElement4TextVisible = p2_CBox_Elem4->IsChecked();
	aConfig.sElementsElement4TextContent = p2_Edit_Elem4->GetText();
	aConfig.bElementsDateValueVisible = p2_CBox_Datum->IsChecked();
	aConfig.nElementsDateValueContent = p2_List_Datum->GetSelectEntryPos();
	aConfig.bElementsSubjectTextVisible = p2_CBox_Betref->IsChecked();
	aConfig.sElementsSubjectTextContent = p2_Edit_Betref->GetText();
	aConfig.bElementsTo = p2_CBox_MemoAn->IsChecked();
	aConfig.bElementsCopy = p2_CBox_KopiAn->IsChecked();
	aConfig.bElementsFrom = p2_CBox_MemoVn->IsChecked();
	aConfig.bHeaderDate = p3_CBox_KDatum->IsChecked();
	aConfig.bHeaderTitle = p3_CBox_KThema->IsChecked();
	aConfig.bHeaderPageNumber = p3_CBox_KPgNum->IsChecked();
	aConfig.bHeaderSeparator = p3_CBox_KTrnLn->IsChecked();
	aConfig.bFooterDate = p3_CBox_FDatum->IsChecked();
	aConfig.bFooterPageNumber = p3_CBox_FPgNum->IsChecked();
	aConfig.bFooterSeparator = p3_CBox_FTrnLn->IsChecked();
	aConfig.bFooterConfidentialLevelVisible = p3_CBox_FVertr->IsChecked();
	aConfig.sFooterConfidentialLevelContent = p3_Edit_FVertr->GetText();

	aConfig.WriteDocInfo(*pDoku);
	aConfig.Commit();
}

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

void MemoDialog::CheckTitlOnOff()
{
	BOOL bOn=FALSE;
	if (aPage1.aTitl.IsTextLogo()) bOn=(aPage1.aTitl.GetStr().Len()!=0);
	else bOn=aPage1.aTitl.HasGraphic();
	aPage1.aTitl.Show(&aPrevWin,bOn);
}

void MemoDialog::CheckElements()
{
	USHORT nLnAnz=0;
	if (p2_CBox_Datum ->IsChecked()) nLnAnz++;
	if (p2_CBox_Betref->IsChecked()) nLnAnz++;
	if (p2_CBox_MemoAn->IsChecked()) nLnAnz++;
	if (p2_CBox_KopiAn->IsChecked()) nLnAnz++;
	if (p2_CBox_MemoVn->IsChecked()) nLnAnz++;
	if (p2_CBox_Elem1 ->IsChecked()) nLnAnz++;
	if (p2_CBox_Elem2 ->IsChecked()) nLnAnz++;
	if (p2_CBox_Elem3 ->IsChecked()) nLnAnz++;
	if (p2_CBox_Elem4 ->IsChecked()) nLnAnz++;
	if (nLnAnz!=0) {
		aPage1.aEleZ.Show(&aPrevWin);
		aPage1.aEleZ.SetLnDazu(USHORT(nLnAnz-1),&aPrevWin); // Eine Zeile ist immer mind. da
	} else {
		aPage1.aEleZ.Hide(&aPrevWin);
	}
}

void MemoDialog::CheckKopzFusz()
{
	BOOL bDate=p2_CBox_Datum->IsChecked();
	p3_CBox_KDatum->Enable( bDate );
	p3_CBox_FDatum->Enable( bDate );

	USHORT nLnAnz=0;
	if (p3_CBox_KDatum->IsChecked() && bDate) nLnAnz++;
	if (p3_CBox_KThema->IsChecked()) nLnAnz++;
	if (p3_CBox_KPgNum->IsChecked()) nLnAnz++;
	p3_CBox_KTrnLn->Enable( nLnAnz!=0 );

	nLnAnz=0;
	if (p3_CBox_FDatum->IsChecked() && bDate) nLnAnz++;
	if (p3_CBox_FVertr->IsChecked()) nLnAnz++;
	if (p3_CBox_FPgNum->IsChecked()) nLnAnz++;

	p3_CBox_FTrnLn->Enable( nLnAnz!=0 );
	if (nLnAnz!=0) {
	   aPage1.aFusz.SetTrennlinie(p3_CBox_FTrnLn->IsChecked(),&aPrevWin);
	   aPage1.aFusz.SetHgt(nLnAnz*5*EINHEIT,&aPrevWin);
	} else
	   aPage1.aFusz.Hide(&aPrevWin);
}

#define FRAME_SPACE (6*EINHEIT)
void MemoDialog::ArrangeObjects()
{
	USHORT yPos=20*EINHEIT; // Defaultrand oben = 10mm
	if (aPage1.aTitl.IsVisible()) {
		yPos=USHORT(aPage1.aTitl.GetPosY())+aPage1.aTitl.GetHgt();
		yPos+=FRAME_SPACE;  // Abstand zwischen Titel und Elementen
	}
	if (aPage1.aEleZ.IsVisible())
	{
		aPage1.aEleZ.SetVer(yPos,&aPrevWin);
		yPos+=aPage1.aEleZ.GetHgt()+FRAME_SPACE;
	}
	aPage1.SetRandO(yPos,&aPrevWin);
}

////////////////////////////////////////////////////////////////////////////////
//
//  DocInfo ...
//
////////////////////////////////////////////////////////////////////////////////

void MemoDialog::FillDocInfoList()
{
	pDoku->MerkDocInfListSel();
	pDoku->SetDBFieldAnz(0);
	USHORT i,j;
	String aStr;
	USHORT nAnz=0;
	for (i=0; i<5; i++)
		if (GetDocInfStrOk(i))
			nAnz++;
	pDoku->SetTxFieldAnz(nAnz);
	j=0;
	for (i=0; i<8; i++) {
		if (GetDocInfStrOk(i))
		{
			aStr=GetDocInfStr(i);
			pDoku->SetTxFieldNam(j,aStr);
			j++;
		}
	}
	pDoku->RestDocInfListSel();
}

String MemoDialog::GetDocInfStr(USHORT nNum)
{
	Window* pWin;
	USHORT nId = 0;
	switch (nNum)
	{
	case 0: pWin = p2_Edit_Betref; nId = STR_Brf_DocInBtr; break;
	case 1: pWin = p2_CBox_MemoAn;		/*aStr2="Empfnger";*/ break;
	case 2: pWin = p2_CBox_KopiAn;		/*aStr2="Kopie an"; */ break;
	case 3: pWin = p2_CBox_MemoVn;		/*aStr2="Absender"; */ break;
	case 4: pWin = p2_Edit_Elem1; nId = STR_Brf_DocInEl1; break;
	case 5: pWin = p2_Edit_Elem2; nId = STR_Brf_DocInEl2; break;
	case 6: pWin = p2_Edit_Elem3; nId = STR_Brf_DocInEl3; break;
	case 7: pWin = p2_Edit_Elem4; nId = STR_Brf_DocInEl4; break;
	}

	String aStr( pWin->GetText() );

	if( aStr.GetChar( 0 ) == '~' )
		aStr.Erase(0,1);
	aStr.EraseTrailingChars();
	if( aStr.Len()==0 && nId )
		aStr = SW_RESSTR( nId );

	return aStr;
}

BOOL MemoDialog::GetDocInfOn(USHORT nNum)
{
	BOOL bOn=FALSE;
	switch (nNum) {
		case 0: bOn=p2_CBox_Betref->IsChecked(); break;
		case 1: bOn=p2_CBox_MemoAn->IsChecked(); break;
		case 2: bOn=p2_CBox_KopiAn->IsChecked(); break;
		case 3: bOn=p2_CBox_MemoVn->IsChecked(); break;
		case 4: bOn=p2_CBox_Elem1 ->IsChecked(); break;
		case 5: bOn=p2_CBox_Elem2 ->IsChecked(); break;
		case 6: bOn=p2_CBox_Elem3 ->IsChecked(); break;
		case 7: bOn=p2_CBox_Elem4 ->IsChecked(); break;
	}
	return bOn;
}

BOOL MemoDialog::GetDocInfStrOk(USHORT nNum)
{
	if (GetDocInfOn(nNum)) {
		return TRUE; //(GetDocInfStr(nNum).Len()!=0);
	} else return FALSE;
}

////////////////////////////////////////////////////////////////////////////////
// Disable
////////////////////////////////////////////////////////////////////////////////

void MemoDialog::SetElemDisable()
{
	const BOOL bEnable = p1_RBtn_TitTxt->IsChecked();
	p1_CBox_TitTxt->Enable(bEnable);
	p1_PBtn_TitGrf->Enable(!bEnable);
	p2_Edit_Elem1 ->Enable(p2_CBox_Elem1 ->IsChecked());
	p2_Edit_Elem2 ->Enable(p2_CBox_Elem2 ->IsChecked());
	p2_Edit_Elem3 ->Enable(p2_CBox_Elem3 ->IsChecked());
	p2_Edit_Elem4 ->Enable(p2_CBox_Elem4 ->IsChecked());
	p2_List_Datum ->Enable(p2_CBox_Datum ->IsChecked());
	p2_Edit_Betref->Enable(p2_CBox_Betref->IsChecked());
	p3_Edit_FVertr->Enable(p3_CBox_FVertr->IsChecked());
}

////////////////////////////////////////////////////////////////////////////////
//
// @@  @@ @@     @@@@@ @@  @@ @@@@@ @@    @@    @@  @@ @@  @@  @@@@
// @@  @@ @@     @@    @@  @@ @@    @@    @@    @@  @@ @@@ @@ @@  @@
// @@  @@ @@     @@    @@  @@ @@    @@    @@    @@  @@ @@@@@@ @@
// @@  @@ @@ @@@ @@@@  @@  @@ @@@@  @@    @@    @@  @@ @@@@@@ @@ @@@
// @@  @@ @@     @@    @@  @@ @@    @@    @@    @@  @@ @@ @@@ @@  @@
// @@  @@ @@     @@    @@  @@ @@    @@    @@    @@  @@ @@  @@ @@  @@
//  @@@@  @@     @@     @@@@  @@@@@ @@@@@ @@@@@  @@@@  @@  @@  @@@@@
//
////////////////////////////////////////////////////////////////////////////////

void MemoDialog::InitElemUI()
{
	// Datumslistbox fuellen
	FillFldListBox( *p2_List_Datum, TYP_FIXDATEFLD );
}

void MemoDialog::LogoToUI()
{
	p1_RBtn_TitTxt->Check(aPage1.aTitl.IsTextLogo());
	p1_RBtn_TitGrf->Check(!p1_RBtn_TitTxt->IsChecked());
	p1_CBox_TitTxt->SetText(aPage1.aTitl.GetStr());
	String aFNam,aFilt;

	if (aPage1.aTitl.GetGraphic(aFNam,aFilt))
		FNam2FixedText(aFNam,*p1_Text_TitGrf);
	else
		p1_Text_TitGrf->SetText(aEmptyStr);
}

////////////////////////////////////////////////////////////////////////////////

IMPL_LINK_INLINE_START( MemoDialog, DatmCheckHdl, CheckBox *, pBtn )
{
	CheckKopzFusz();
	CheckElements();
	ArrangeObjects();
	SetElemDisable();
	return 0;
}
IMPL_LINK_INLINE_END( MemoDialog, DatmCheckHdl, CheckBox *, pBtn )

IMPL_LINK_INLINE_START( MemoDialog, ElemCheckHdl, CheckBox *, pBtn )
{
	CheckElements();
	FillDocInfoList();
	ArrangeObjects();
	SetElemDisable();
	return 0;
}
IMPL_LINK_INLINE_END( MemoDialog, ElemCheckHdl, CheckBox *, pBtn )

IMPL_LINK_INLINE_START( MemoDialog, ElemModifyHdl, Edit *, pEdt )
{
	FillDocInfoList();
	return 0;
}
IMPL_LINK_INLINE_END( MemoDialog, ElemModifyHdl, Edit *, pEdt )

////////////////////////////////////////////////////////////////////////////////

IMPL_LINK_INLINE_START( MemoDialog, KopzCheckHdl, CheckBox *, pBtn )
{
	CheckKopzFusz();
	return 0;
}
IMPL_LINK_INLINE_END( MemoDialog, KopzCheckHdl, CheckBox *, pBtn )

IMPL_LINK_INLINE_START( MemoDialog, FuszCheckHdl, CheckBox *, pBtn )
{
	CheckKopzFusz();
	SetElemDisable(); // Eigentlich nur fuer Edit_Vertr.Disable()
	return 0;
}
IMPL_LINK_INLINE_END( MemoDialog, FuszCheckHdl, CheckBox *, pBtn )

////////////////////////////////////////////////////////////////////////////////
//  Set Style                                                                 //
////////////////////////////////////////////////////////////////////////////////

void MemoDialog::SetStyle(BYTE nStyle)
{
	aPage1.aTitl.SetFontStyle(nStyle,&aPrevWin);
}

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

void MemoDialog::SetEventHandler()
{
	{
		p1_CBox_TitTxt->SetModifyHdl(LINK(this,MemoDialog,TitlModifyHdl));
		p1_RBtn_TitTxt->SetClickHdl (LINK(this,MemoDialog,TitlRBtnHdl  ));
		p1_RBtn_TitGrf->SetClickHdl (LINK(this,MemoDialog,TitlRBtnHdl  ));
		p1_PBtn_TitGrf->SetClickHdl (LINK(this,MemoDialog,TitlPBtnHdl  ));
		p2_CBox_Datum ->SetClickHdl (LINK(this,MemoDialog,DatmCheckHdl ));
	}
	Link aLk = LINK(this,MemoDialog,StyleClickHdl);
	p1_RBtn_Stil1 ->SetClickHdl ( aLk );
	p1_RBtn_Stil2 ->SetClickHdl ( aLk );
	p1_RBtn_Stil3 ->SetClickHdl ( aLk );

	aLk = LINK(this,MemoDialog,ElemCheckHdl );
	p2_CBox_Betref->SetClickHdl ( aLk );
	p2_CBox_MemoAn->SetClickHdl ( aLk );
	p2_CBox_KopiAn->SetClickHdl ( aLk );
	p2_CBox_MemoVn->SetClickHdl ( aLk );
	p2_CBox_Elem1 ->SetClickHdl ( aLk );
	p2_CBox_Elem2 ->SetClickHdl ( aLk );
	p2_CBox_Elem3 ->SetClickHdl ( aLk );
	p2_CBox_Elem4 ->SetClickHdl ( aLk );

	aLk = LINK(this,MemoDialog,ElemModifyHdl);
	p2_Edit_Elem1 ->SetModifyHdl( aLk );
	p2_Edit_Elem2 ->SetModifyHdl( aLk );
	p2_Edit_Elem3 ->SetModifyHdl( aLk );
	p2_Edit_Elem4 ->SetModifyHdl( aLk );

	aLk = LINK(this,MemoDialog,KopzCheckHdl );
	p3_CBox_KDatum->SetClickHdl ( aLk );
	p3_CBox_KThema->SetClickHdl ( aLk );
	p3_CBox_KPgNum->SetClickHdl ( aLk );
	p3_CBox_KTrnLn->SetClickHdl ( aLk );

	aLk = LINK(this,MemoDialog,FuszCheckHdl );
	p3_CBox_FDatum->SetClickHdl ( aLk );
	p3_CBox_FVertr->SetClickHdl ( aLk );
	p3_CBox_FPgNum->SetClickHdl ( aLk );
	p3_CBox_FTrnLn->SetClickHdl ( aLk );
}

////////////////////////////////////////////////////////////////////////////////
//
// @@  @@ @@ @@@@@  @@@@@@ @@  @@ @@@@@ @@   @@
// @@  @@ @@ @@  @@   @@   @@  @@ @@    @@   @@
// @@  @@ @@ @@  @@   @@   @@  @@ @@    @@   @@
// @@@@@@ @@ @@@@@    @@   @@  @@ @@@@  @@   @@
//  @@@@  @@ @@  @@   @@   @@  @@ @@    @@   @@
//  @@@@  @@ @@  @@   @@   @@  @@ @@    @@   @@
//   @@   @@ @@  @@   @@    @@@@  @@@@@ @@@@ @@@@
//
////////////////////////////////////////////////////////////////////////////////

BOOL MemoDialog::Possible(USHORT StepNum)
{
	return(TRUE);
}

void MemoDialog::Enter(USHORT StepNum)
{
	if (StepNum==4) aPrevWin.Hide(); // Fuer die Fahne
	//if (StepNum==6) aPrevWin.SetPage(&aPageF);
}

void MemoDialog::Leave(USHORT StepNum)
{
	if (StepNum==4) aPrevWin.Show(); // Fuer die Fahne
	//if (StepNum==6) aPrevWin.SetPage(&aPage1);
}

void MemoDialog::Fill(USHORT StepNum, MultiOne& WinArr)
{
	switch (StepNum)
	{
		case 0:
		{
			WinArr.AddWin(p1_Text_Stil  );
			WinArr.AddWin(p1_RBtn_Stil1, TRUE );
			WinArr.AddWin(p1_RBtn_Stil2, TRUE );
			WinArr.AddWin(p1_RBtn_Stil3, TRUE );
			WinArr.AddWin(p1_Text_Titel );
			WinArr.AddWin(p1_RBtn_TitTxt, TRUE);
			WinArr.AddWin(p1_RBtn_TitGrf, TRUE);
			WinArr.AddWin(p1_CBox_TitTxt, TRUE);
			WinArr.AddWin(p1_PBtn_TitGrf, TRUE);
			WinArr.AddWin(p1_Text_TitGrf);
			WinArr.SetHelpId( HID_MEMO_PAGE1 );
		}
		break;
		case 1:
		{
			WinArr.AddWin(p2_Text_Welche);
			WinArr.AddWin(p2_CBox_Datum, TRUE );
			WinArr.AddWin(p2_List_Datum, TRUE );
			WinArr.AddWin(p2_CBox_Betref, TRUE);
			WinArr.AddWin(p2_Edit_Betref, TRUE);
			WinArr.AddWin(p2_CBox_MemoAn, TRUE);
			WinArr.AddWin(p2_CBox_KopiAn, TRUE);
			WinArr.AddWin(p2_CBox_MemoVn, TRUE);
			WinArr.AddWin(p2_CBox_Elem1, TRUE );
			WinArr.AddWin(p2_Edit_Elem1, TRUE );
			WinArr.AddWin(p2_CBox_Elem2, TRUE );
			WinArr.AddWin(p2_Edit_Elem2, TRUE );
			WinArr.AddWin(p2_CBox_Elem3, TRUE );
			WinArr.AddWin(p2_Edit_Elem3, TRUE );
			WinArr.AddWin(p2_CBox_Elem4, TRUE );
			WinArr.AddWin(p2_Edit_Elem4, TRUE );
			//WinArr.AddWin(p2_CBox_TrenLn);
			//WinArr.AddWin(p2_CBox_Anlagn);
			WinArr.SetHelpId( HID_MEMO_PAGE2 );
		}
		break;
		case 2:
		{
			WinArr.AddWin(p3_Text_KWelch);
			WinArr.AddWin(p3_CBox_KDatum, TRUE);
			WinArr.AddWin(p3_CBox_KThema, TRUE);
			WinArr.AddWin(p3_CBox_KPgNum, TRUE);
			WinArr.AddWin(p3_CBox_KTrnLn, TRUE);
			WinArr.AddWin(p3_Text_FWelch);
			WinArr.AddWin(p3_CBox_FDatum, TRUE);
			WinArr.AddWin(p3_CBox_FVertr, TRUE);
			WinArr.AddWin(p3_Edit_FVertr, TRUE);
			WinArr.AddWin(p3_CBox_FPgNum, TRUE);
			WinArr.AddWin(p3_CBox_FTrnLn, TRUE);
			WinArr.SetHelpId( HID_MEMO_PAGE3 );
		}
		break;
		case 3:
			pDoku->Fill( WinArr );
			WinArr.SetHelpId( HID_MEMO_PAGE4 );
			break;
		case 4:
		{
			WinArr.AddWin(p5_BMap_Fahne, TRUE );
			WinArr.AddWin(p5_Text_Final );
			WinArr.SetHelpId( HID_MEMO_PAGE5 );
		}
		break;
		case 0xFFFF:
			FillDefElems(WinArr); // Defaultelemente (Buttons, PrevWin)
		break;
	}
}




