#*************************************************************************
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.5.4.1 $
#
#   last change: $Author: mh $ $Date: 2002/11/01 10:10:51 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

PRJ=..$/..$/..

PRJNAME=sysui
TARGET=gnomeint

TARGETTYPE=CUI
LIBTARGET=NO
NO_DEFAULT_STL=TRUE

give_me_all_languages=yes
no_common_build_zip=yes

# --- Settings -----------------------------------------------------

.INCLUDE :  settings.mk
.INCLUDE :  locales.tab

# --- Files --------------------------------------------------------

OBJFILES= \
	$(OBJ)$/gnome-vfs-filetype-registration.obj

APP1TARGET=$(TARGET)
APP1OBJS=$(OBJFILES)
APP1LIBS=


GNOMEFILES= \
	locales.tab

LNGFILES= \
	../cde/group.lng \
    ../cde/writer.lng \
    ../cde/calc.lng \
    ../cde/draw.lng \
    ../cde/impress.lng

.IF "$(make_zip_deps)"==""

LANGLIST:=$(locales:s/locale_//)
LANGFLAGFILES:=$(foreach,i,$(LANGLIST) $(foreach,j,$(LNGFILES) $(MISC)$/gnome$(j:b).$i))
CONVFILES:=$(foreach,i,$(LANGLIST) $(foreach,j,$(locale_$i) $(foreach,k,$(LNGFILES) $(RES)$/$(k:b).$j)))
GNOMEAPPLIST:=$(foreach,i,$(LNGFILES) $(BIN)$/gnomeapp$(i:b).zip)

.ENDIF # "$(make_zip_deps)"==""

# --- Targets ------------------------------------------------------

.INCLUDE :  target.mk

.IF "$(CONVFILES)"!=""

ALLTAR : $(CONVFILES)

$(LANGFLAGFILES) : $(LNGFILES) gnomeint makefile.mk $(BIN)$/lngconv
    +@$(BIN)$/lngconv -o $(RES) ../cde/$(@:b:s/gnome//).lng $(@:e:s/.//) $(rescharset_$(@:e:s/.//)) $(locale_$(@:e:s/.//))
    +@$(PERL) gnomeint $(OUT) $(@:e:s/.//) $(@:b:s/gnome//) $(locale_$(@:e:s/.//))
    +@touch $@

$(GNOMEAPPLIST) : $(LANGFLAGFILES)
    +@cd $(RES)$/gnome$/$(@:b:s/gnomeapp//) && zip ..$/..$/..$/bin$/$(@:b:).zip -r . && cd -

$(CONVFILES) : $(LANGFLAGFILES) $(GNOMEAPPLIST)

.ENDIF # "$(CONVFILES)"!=""
