/*************************************************************************
 *
 *  $RCSfile: cprjexe.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: jmarmion $ $Date: 2000/10/20 15:02:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef WNT
#define __STDC__ 1
#ifdef BOOTSTRAPPER
#include <glibc/posix/getopt.h>
#else
#include <glibc/getopt.h>
#endif
#endif
#ifdef UNX
#ifdef BOOTSTRAPPER
#ifndef SOLARIS
#include <glibc/posix/getopt.h>
#endif
#ifdef MACOSX
#include <glibc/posix/getopt.h>
#endif
#else
#include <glibc/config.h>
#ifndef SOLARIS
#include <glibc/getopt.h>
#endif
#endif
#endif
#ifdef SOLARIS
extern "C" {
struct option
{
	char* name;
	int has_arg;
	int* flagl;
	int val;
};
extern int getopt_long( int, char* const*, const char *, const struct option*, int *);
}
#endif
#include <stdlib.h>
#include <stdio.h>
#include "string.hxx"
#include "copyprj.hxx"

//
// class CopyPrj
//

class CopyPrj : public ProjectCop
{
protected:
	virtual void PrintStatus( const char* cStatus )
		{ fprintf( stderr, "%s", cStatus ); }

public:
	CopyPrj( ByteString &rPrj, ByteString &rVer, ByteString &rDest,
			BOOL bAdd, BOOL bOutPath, BOOL bFlat, BOOL bOnlyOutPath, BOOL bUpdate )
		: ProjectCop( rPrj, rVer, rDest, bAdd, bOutPath, bFlat, bOnlyOutPath, bUpdate ) {};
};


int usage()
{
	fprintf(stderr, "copyprj\n");
	fprintf( stderr, "Syntax:    copyprj [-n[p]] [-f] [-x] [-o] [-u] Project [Stand] Pfad\n" );
	fprintf( stderr, "Beispiele: - copyprj sfx2 d:\\prj\\\n" );
	fprintf( stderr, "             kopiert sfx2 aus der Eingestellten Umgebung nach d:\\prj\\\n" );
	fprintf( stderr, "           - copyprj sfx2 vcl364 d:\\prj\\\n" );
	fprintf( stderr, "             kopiert sfx2 aus dem Stand \"vcl364\" nach d:\\prj\\\n" );
	fprintf( stderr, "Per default wird der Zielpfad um den Standnamen erweitert (z.B. vcl364).\n");
	fprintf( stderr, "Der Schalter -np (NoPath) unterdrueckt das Erweitern des Zielpfades.\n");
	fprintf( stderr, "Der Schalter -x unterdrueckt das Kopieren des Ausgabebaumes.\n");
	fprintf( stderr, "Der Schalter -o Kopiert ausschliesslich den Ausgabebaum.\n");
	fprintf( stderr, "Der Schalter -u Update: Kopiert nur neuere und neue Dateien.\n");
	fprintf( stderr, "Der Schalter -f holt den Sourcestand der letzten Minorversion (flat) vom Sourcelaufwerk.\n\n");
	exit(0);
	return 0;
}

/****************************************************************************/
int
#ifdef WNT
_cdecl
#endif
main( int argc, char *argv[] )
/****************************************************************************/
{
	fprintf( stderr, "\n\ncopyprj Version 1.4 ($Revision: 1.4 $) (c)1997-2000\nMulti Platform Enabled Edition\n" );
	fprintf( stderr, "'common' Output Tree Sensitive\n" );
	fprintf( stderr, "enhanced alien Output Tree suppression\n\n" );

	ByteString sTmp( getenv( "INPATH" ));
	if( !sTmp.Len()) {
		fprintf( stderr, "Es wurde keine Umgebung gesetzt!\nCopyprj kann nur mit einer gesetzten Umgebung ausgefhrt werden." );

		return 1;
	}

	ByteString sPrj;
	ByteString sVer;
	ByteString sDest;
	BOOL bAddVerNameAsPath = TRUE;
	BOOL bAddOutpath = TRUE;
	BOOL bOnlyOutpath = FALSE;
	BOOL bUpdate = FALSE;
	BOOL bFlat = FALSE;
	int c;
	if ( getenv("UPDMINOR") == NULL )
		bFlat = TRUE;

	if ( argc < 3 )
		usage();
	while( 1 )
	{
		int this_option_optind = optind ? optind : 1;
		int option_index = 0;

		static struct option long_options[] =
		{
			{"add", 1, 0, 0},
			{0, 0, 0, 0}
		};

		c = getopt_long( argc, argv, "npfxouNPFXOU", long_options, &option_index );
		if ( c == -1 )
			break;

		switch( c )
		{
			case 'f':
			case 'F':
				bFlat = TRUE;
				break;
			case 'n' :
			case 'N' :
				bAddVerNameAsPath = FALSE;
				break;

			case 'x' :
			case 'X' :
				bAddOutpath = FALSE;
				break;

			case 'o' :
			case 'O' :
				bOnlyOutpath = TRUE;
				break;

			case 'u' :
			case 'U' :
				bUpdate = TRUE;
				break;

			case 'p' :
			case 'P' :
				// Dummy aus kopatiblitaetsgruenden !!
				break;

			case 'h' :
			case 'H' :
			case '?' :
				usage();
				break;

			default:
#ifdef DEBUG_VERBOSE
				printf("Unknown getopt error\n");
#endif
				exit(0);
		}
	}

	if ( optind < argc )
	{
#ifdef DEBUG_VERBOSE
		printf("further arguments : ");
#endif
		// erstes Argument : Projektname
		sPrj = ByteString( argv[optind++]);
		// zweites Argument [optional] Standliste
		if ( optind ==  argc - 2)
		{
			sVer = ByteString(argv[optind++]);
		}
		else
		{
			sVer = ByteString( getenv( "WORK_STAMP" ));
			if ( !sVer.Len()) {
				fprintf( stderr, "Die Environment-Variable WORK_STAMP ist nicht gesetzt.\n");
				fprintf( stderr, "Dies kann mit setsolar geschehen.\n");
				fprintf( stderr, "Alternativ ist der Quell-Stand als zweiter Parameter anzugeben\n\n");
			}
		}
		// drittes Argument : Destination
		sDest = ByteString( argv[optind++]);

	}
	// command line ok, so start ation here
//#ifdef DEBUG
	fprintf(stderr,"copyprj Projekt %s Stand %s nach %s ", sPrj.GetBuffer(),
							sVer.GetBuffer(), sDest.GetBuffer());
	if ( bAddVerNameAsPath )
		fprintf( stderr, "mit Stand Prefix ");
	else
		fprintf( stderr, "ohne Stand Prefix ");
	if ( bOnlyOutpath )
		fprintf( stderr, "nur Ausgabeverzeichnis ");
	if ( bAddOutpath )
		fprintf( stderr, "mit Ausgabeverzeichnis ");
	else
		fprintf( stderr, "ohne Ausgabeverzeichnis ");
	if ( bFlat )
		fprintf( stderr, "aus der flachen Version ");
	else
		fprintf( stderr, "aus der Minor %s ", getenv("UPDMINOR"));
	if ( bUpdate )
		fprintf( stderr, "update\n");
	else
		fprintf( stderr, "copy\n");

//#endif
	CopyPrj aProjectCop( sPrj, sVer, sDest, bAddVerNameAsPath, bAddOutpath,	bFlat, bOnlyOutpath, bUpdate );

	USHORT nRet;
	if ( nRet = aProjectCop.IsValid()) {
		// not valid params!
		if ( nRet & PC_PROJECT_NOT_VALID ) {
			fprintf( stderr, "Projekt-Angabe fehlerhaft!\n" );
			fprintf( stderr, "Das angegebene Projekt kann nicht in der Datenbasis gefunden werden.\n" );
			fprintf( stderr, "Entweder ist die Datenbasis nicht auf dem neuesten Stand, oder das Projekt\n" );
			fprintf( stderr, "ist auf dem angegebenen Stand nicht existent.\n\n" );
		}
		else if ( nRet & PC_VERSION_NOT_VALID ) {
			fprintf( stderr, "Stand-Angabe fehlerhaft!\n" );
			fprintf( stderr, "Dar angegebene Stand kann nicht in der Datenbasis gefunden werden.\n" );
			fprintf( stderr, "Entweder ist die Datenbasis nicht auf dem neuesten Stand, oder der Stand\n" );
			fprintf( stderr, "ist nicht existent.\n\n" );
		}
		else if ( nRet & PC_DESTINATIONPATH_NOT_EXIST ) {
			fprintf( stderr, "Pfad-Angabe fehlerhaft!\n" );
			fprintf( stderr, "Der angegebene Pfad kann nicht erzeugt werden bzw. ist evtl. bereits als\n" );
			fprintf( stderr, "Datei vorhanden\n\n" );
		}

		return 1;
	}

	if ( aProjectCop.Copy()) {
		fprintf( stderr, "\n\nERROR: Beim Kopieren sind Fehler aufgetreten!\n" );
		fprintf( stderr,      "       Evtl. ist auf dem Ziellaufwerk kein Speicherplatz mehr vorhanden\n" );
		fprintf( stderr,      "       oder es fehlen zum Erzeugen von Dateien notwendige Benutzerrechte.\n" );
	}
	else
		fprintf( stderr, "\n\nProjekt wurde erfolgreich kopiert !\n\n" );

	return 0;
}
