/*************************************************************************
 *
 *  $RCSfile: intnos2.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: th $ $Date: 2001/06/15 13:11:58 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVPM_H
#define INCL_DOSNLS
#include <svpm.h>
#endif

#ifndef _INTNTAB_HXX
#include <intntab.hxx>
#endif

// =======================================================================

// System-Sprache
static LanguageType eImplSystemLanguage = LANGUAGE_DONTKNOW;

// String und Defines fuer Profile-Abfragen
static char aAppName[] =    "PM_National";
#define NOVAL_INI           0xFFFF

// =======================================================================

void SetSystemLanguage( LanguageType eLang )
{
    eImplSystemLanguage = eLang;
}

// =======================================================================

USHORT ImplGetSystemLanguageCount()
{
    return 0;
}

// -----------------------------------------------------------------------

LanguageType GetSystemLanguage( USHORT nIndex )
{
    // Soll die im System eingestellte Sprache ermittelt werden
    if ( nIndex == INTERNATIONAL_SYSTEM_DEFAULT )
    {
        if ( eImplSystemLanguage == LANGUAGE_DONTKNOW )
        {
            LONG nVal;

            // Sprache abfragen (wir nehmen Land, da Sprache nicht vorhanden)
            nVal = PrfQueryProfileInt( HINI_PROFILE, aAppName, "iCountry", 0 );
            switch ( nVal )
            {
                case 1:
                    eImplSystemLanguage = LANGUAGE_ENGLISH_US;
                    break;
                case 2:
                    eImplSystemLanguage = LANGUAGE_FRENCH_CANADIAN;
                    break;
                case 3:
                    eImplSystemLanguage = LANGUAGE_PORTUGUESE_BRAZILIAN;
                    break;
                case 31:
                    eImplSystemLanguage = LANGUAGE_DUTCH;
                    break;
                case 32:
                    eImplSystemLanguage = LANGUAGE_FRENCH_BELGIAN;
                    break;
                case 33:
                    eImplSystemLanguage = LANGUAGE_FRENCH;
                    break;
                case 34:
                    eImplSystemLanguage = LANGUAGE_SPANISH;
                    break;
                case 36:
                    eImplSystemLanguage = LANGUAGE_HUNGARIAN;
                    break;
                case 39:
                    eImplSystemLanguage = LANGUAGE_ITALIAN;
                    break;
                case 41:    // Swiss
                    eImplSystemLanguage = LANGUAGE_GERMAN_SWISS;
                    break;
                case 44:
                    eImplSystemLanguage = LANGUAGE_ENGLISH_UK;
                    break;
                case 45:
                    eImplSystemLanguage = LANGUAGE_DANISH;
                    break;
                case 46:
                    eImplSystemLanguage = LANGUAGE_SWEDISH;
                    break;
                case 47:
                    eImplSystemLanguage = LANGUAGE_NORWEGIAN;
                    break;
                case 48:
                    eImplSystemLanguage = LANGUAGE_POLISH;
                    break;
                case 49:
                    eImplSystemLanguage = LANGUAGE_GERMAN;
                    break;
                case 61:
                    eImplSystemLanguage = LANGUAGE_ENGLISH_AUS;
                    break;
                case 82:
                    eImplSystemLanguage = LANGUAGE_KOREAN;
                    break;
                case 88:
                    eImplSystemLanguage = LANGUAGE_CHINESE;
                    break;
                case 90:
                    eImplSystemLanguage = LANGUAGE_TURKISH;
                    break;
                case 351:
                    eImplSystemLanguage = LANGUAGE_PORTUGUESE;
                    break;
                case 354:
                    eImplSystemLanguage = LANGUAGE_ICELANDIC;
                    break;
                case 358:
                    eImplSystemLanguage = LANGUAGE_FINNISH;
                    break;
                case 785:
                    eImplSystemLanguage = LANGUAGE_ARABIC;
                    break;
                case 972:
                    eImplSystemLanguage = LANGUAGE_HEBREW;
                    break;
                default:
                    eImplSystemLanguage = LANGUAGE_DONTKNOW;
                    break;
            }
        }

        return eImplSystemLanguage;
    }
    else
        return LANGUAGE_DONTKNOW;
}

// =======================================================================

void ImplUpdateSystemLanguage( LanguageType, LanguageTable* )
{
}

// =======================================================================

USHORT ImplGetSystemFormatCount()
{
    return 0;
}

// -----------------------------------------------------------------------

LanguageType GetSystemFormatLanguage( USHORT nIndex )
{
    return GetSystemLanguage( nIndex );
}

// -----------------------------------------------------------------------

void ImplUpdateSystemFormat( LanguageType, FormatTable* )
{
}
