/*************************************************************************
 *
 *  $RCSfile: shortcut.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef __TOOLS_SHORTCUT_HXX
#define __TOOLS_SHORTCUT_HXX

#include <vos/macros.hxx>
#include <osl/mutex.hxx>
#include <list.hxx>
#include <fastfsunx.hxx>

#include <stdio.h>

struct ShortcutEntry
{
	String aName;
	String aValue;

	ShortcutEntry( const String& rName, const String& rValue ) :
			aName( rName ), aValue( rValue ) {}
	ShortcutEntry( const ShortcutEntry& rEntry ) :
			aName( rEntry.aName ), aValue( rEntry.aValue ) {}
};

DECLARE_LIST( ShortcutEntryList, ShortcutEntry* );

class ShortcutGroup
{
	String									m_aGroupname;
	ShortcutEntryList						m_aEntries;
public:
	ShortcutGroup( const String& rName ) : m_aGroupname( rName ) {}
	~ShortcutGroup();

	const String& getName() const { return m_aGroupname; }
	const String& getKeyName( UINT32 nIndex ) const;
	UINT32 getKeyCount() const { return m_aEntries.Count(); }
	const String& getValue( const String& rKey ) const;
	void setValue( const String& rKey, const String& rValue );
	void writeEntries( FILE* fp, BOOL bUnixLineEnds = FALSE ) const;
};

DECLARE_LIST( ShortcutGroupList, ShortcutGroup* );

class UnxShortcut : public IfcShortcut
{
protected:
	::osl::Mutex							m_aMutex;

	ShortcutFormat							m_eOldFormat;
	ItemIDPath								m_aFolderPath;
	String									m_aFilename;
	String									m_aQualifier;
	ShortcutGroup*							m_pQualGroup;
	ShortcutGroupList						m_aGroups;
	
#ifdef DEBUG
	void printGroups();
#endif

public:
	UnxShortcut( const ItemIDPath& rFolderPath, const String rQualifier);
	virtual ~UnxShortcut();

	virtual UINT32 GetValueNameCount() const;
	virtual const String& GetValueName( UINT32 nIndex ) const;
	virtual const String& GetValueContent( const String & crValueName ) const;

	virtual void SetValueContent( const String & crValueName, const String & crValueContent );

	virtual FSysError Load( const ItemIDPath & crIDPath );
	virtual FSysError Store( const String & crTitle, ItemIDPath & crNewIDPath,
		ShortcutFormat ePreferred = SHORTCUT_FORMAT_BESTFIT );
};

#endif // __TOOLS_SHORTCUT_HXX
