/*************************************************************************
 *
 *  $RCSfile: outfont.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: th $ $Date: 2001/07/02 20:37:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_OUTFONT_HXX
#define _SV_OUTFONT_HXX

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif
#ifndef _LANG_HXX
#include <tools/lang.hxx>
#endif

#ifndef _SV_SV_H
#include <sv.h>
#endif

#include <vclenum.hxx>

struct ImplDevFontListData;

// ----------------
// - ImplFontData -
// ----------------

struct ImplFontData
{
    ImplFontData*       mpNext;                     // Pointer to next FontData (only VCL)
    void*               mpSysData;                  // System-Data (only GSL)
    XubString           maName;                     // Name
    XubString           maStyleName;                // StyleName
    XubString           maMapNames;                 // List of alias/alternate Names with ';' separated
    long                mnWidth;                    // Widht (in pixel)
    long                mnHeight;                   // Height (in pixel)
    FontFamily          meFamily;                   // Family
    CharSet             meCharSet;                  // CharSet
    FontPitch           mePitch;                    // Pitch
    FontWidth           meWidthType;                // WidthType
    FontWeight          meWeight;                   // Weight
    FontItalic          meItalic;                   // Italic
    FontType            meType;                     // Type vom Font
    short               mnVerticalOrientation;      // For asian fonts, the orientation in 10th of degree, for vertical writing
    BOOL                mbOrientation;              // TRUE: font can be rotate
    BOOL                mbDevice;                   // TRUE: Device-Font (build in font)
    ULONG               mnQuality;                  // Quality (used for to decide which font should be used when they have the same attributes - the higher value win)
};


// ----------------------
// - ImplFontSelectData -
// ----------------------

struct ImplFontSelectData
{
    ImplFontData*       mpFontData;                 // Font-Data (FontData from DevFontList and mapped from VCL)
    void*               mpSysSelData;               // System-Select-Data (only GSL)
    XubString           maName;                     // Name vom Font
    XubString           maStyleName;                // StyleName vom Font
    long                mnWidth;                    // Breite vom Font in Pixeln
    long                mnHeight;                   // Heoehe vom Font in Pixeln
    FontFamily          meFamily;                   // Family vom Font
    CharSet             meCharSet;                  // CharSet vom Font
    LanguageType        meLanguage;                 // Sprache vom Font
    FontWidth           meWidthType;                // WidthType vom Font
    FontWeight          meWeight;                   // Weight vom Font
    FontItalic          meItalic;                   // Italic vom Font
    FontPitch           mePitch;                    // Pitch vom Font
    short               mnOrientation;              // Rotation
    BOOL                mbVertical;                 // Vertical writing
    BOOL                mbNonAntialiased;           // Antialiasied disabled
};


// -------------------
// - ImplDevFontList -
// -------------------

class ImplDevFontList : private List
{
    BOOL                    mbMatchData;    // TRUE - MatchData is set
    BOOL                    mbMapNames;     // TRUE - MapNames are available

public:
                            ImplDevFontList();
                            ~ImplDevFontList();

    void                    Add( ImplFontData* pData );
    ImplDevFontListData*    Get( ULONG nIndex ) const
                                { return (ImplDevFontListData*)List::GetObject( nIndex ); }
    ImplDevFontListData*    ImplFind( const XubString& rFontName, ULONG* pIndex = NULL ) const;
    ULONG                   Count() const { return List::Count(); }
    void                    ImplClear();
    void                    Clear();
    void                    InitMatchData();
    BOOL                    AreMapNamesAvailable() const { return mbMapNames; }

    ImplDevFontListData*    FindFont( const XubString& rFontName ) const;
    ImplDevFontListData*    ImplFindFontFromToken( const char* pStr ) const;

    ImplDevFontListData*    First() { return (ImplDevFontListData*)List::First(); }
    ImplDevFontListData*    Next() { return (ImplDevFontListData*)List::Next(); }
};


// --------------------
// - ImplKernPairData -
// --------------------

struct ImplKernPairData
{
    USHORT              mnChar1;
    USHORT              mnChar2;
    long                mnKern;
};


// -----------------------
// - ImplFontMetricData -
// -----------------------

struct ImplFontMetricData
{
    // this data must be set
    long                mnWidth;                    // Durchschnittsbreite vom Font in Pixeln (must same as by SetFont)
    long                mnAscent;                   // Ascent
    long                mnDescent;                  // Descent
    long                mnLeading;                  // Internal-Leading
    long                mnSlant;                    // Schraegstellung (bei Italic)
    USHORT              mnFirstChar;                // Erstes druckbare Zeichen im Font
    USHORT              mnLastChar;                 // Letztes druckbare Zeichen im Font
    // this data should/could be overwrite
    XubString           maName;                     // Fontname
    XubString           maStyleName;                // Stylename
    short               mnOrientation;              // Rotation
    FontFamily          meFamily;                   // Family vom Font
    CharSet             meCharSet;                  // CharSet vom Font
    FontWeight          meWeight;                   // Weight vom Font
    FontItalic          meItalic;                   // Italic vom Font
    FontPitch           mePitch;                    // Pitch vom Font
    FontType            meType;                     // Type vom Font
    BOOL                mbDevice;                   // Ist es ein Device-Font
    long                mnUnderlineSize;            // Hoehe von einfacher Unterstreichung
    long                mnUnderlineOffset;          // Offset von einfacher Unterstreichung zur Baseline
    long                mnBUnderlineSize;           // Hoehe von fetter Unterstreichung
    long                mnBUnderlineOffset;         // Offset von fetter Unterstreichung zur Baseline
    long                mnDUnderlineSize;           // Hoehe von doppelter Unterstreichung
    long                mnDUnderlineOffset1;        // Offset von doppelter Unterstreichung zur Baseline
    long                mnDUnderlineOffset2;        // Offset von doppelter Unterstreichung zur Baseline
    long                mnWUnderlineSize;           // Hoehe von WaveLine-Unterstreichung
    long                mnWUnderlineOffset;         // Offset von WaveLine-Unterstreichung zur Baseline, jedoch zentriert zur WaveLine
    long                mnAboveUnderlineSize;       // Hoehe von einfacher Unterstreichung (for Vertical Right)
    long                mnAboveUnderlineOffset;     // Offset von einfacher Unterstreichung zur Baseline (for Vertical Right)
    long                mnAboveBUnderlineSize;      // Hoehe von fetter Unterstreichung (for Vertical Right)
    long                mnAboveBUnderlineOffset;    // Offset von fetter Unterstreichung zur Baseline (for Vertical Right)
    long                mnAboveDUnderlineSize;      // Hoehe von doppelter Unterstreichung (for Vertical Right)
    long                mnAboveDUnderlineOffset1;   // Offset von doppelter Unterstreichung zur Baseline (for Vertical Right)
    long                mnAboveDUnderlineOffset2;   // Offset von doppelter Unterstreichung zur Baseline (for Vertical Right)
    long                mnAboveWUnderlineSize;      // Hoehe von WaveLine-Unterstreichung (for Vertical Right)
    long                mnAboveWUnderlineOffset;    // Offset von WaveLine-Unterstreichung zur Baseline, jedoch zentriert zur WaveLine (for Vertical Right)
    long                mnStrikeoutSize;            // Hoehe von einfacher Durchstreichung
    long                mnStrikeoutOffset;          // Offset von einfacher Durchstreichung zur Baseline
    long                mnBStrikeoutSize;           // Hoehe von fetter Durchstreichung
    long                mnBStrikeoutOffset;         // Offset von fetter Durchstreichung zur Baseline
    long                mnDStrikeoutSize;           // Hoehe von doppelter Durchstreichung
    long                mnDStrikeoutOffset1;        // Offset von doppelter Durchstreichung zur Baseline
    long                mnDStrikeoutOffset2;        // Offset von doppelter Durchstreichung zur Baseline
};

#endif // _SV_OUTFONT_HXX
